<?php
/**
 *	Oxygen WordPress Theme
 *
 *	Laborator.co
 *	www.laborator.co
 */

# Constants
define('THEMEDIR', 		get_template_directory() . '/');
define('THEMEURL', 		get_template_directory_uri() . '/');
define('THEMEASSETS',	THEMEURL . 'assets/');
define('TD', 			'oxygen');
define('STIME',			microtime(true));


# Theme Content Width
$content_width = ! isset($content_width) ? 1170 : $content_width;


# Initial Actions
add_action('after_setup_theme', 	'laborator_after_setup_theme', 100);
add_action('init', 					'laborator_init');
add_action('init', 					'laborator_testimonials_postype');
add_action('widgets_init', 			'laborator_widgets_init');

add_action('wp_enqueue_scripts', 	'laborator_wp_head');
add_action('wp_enqueue_scripts', 	'laborator_wp_enqueue_scripts');
add_action('wp_print_scripts', 		'laborator_wp_print_scripts');
add_action('wp_head', 				'laborator_favicon');
add_action('wp_footer', 			'laborator_wp_footer');

add_action('admin_menu', 			'laborator_menu_page');
add_action('admin_menu', 			'laborator_menu_documentation', 100);
add_action('admin_print_styles', 	'laborator_admin_print_styles');
add_action('admin_enqueue_scripts', 'laborator_admin_enqueue_scripts');

add_action('tgmpa_register', 		'oxygen_register_required_plugins');

if(file_exists(dirname(__FILE__) . "/theme-demo/theme-demo.php"))
{
	require "theme-demo/theme-demo.php";
}


# Core Files
require 'inc/lib/smof/smof.php';
require 'inc/laborator_functions.php';
require 'inc/laborator_classes.php';
require 'inc/laborator_actions.php';
require 'inc/laborator_filters.php';

if(in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins'))) || class_exists( 'WooCommerce' ))
	require THEMEDIR . 'inc/laborator_woocommerce.php';


# Library Files
require 'inc/lib/zebra.php';
require 'inc/lib/phpthumb/ThumbLib.inc.php';
require 'inc/lib/class-tgm-plugin-activation.php';
require 'inc/lib/laborator/laborator_image_resizer.php';
require 'inc/lib/laborator/laborator_dataopt.php';
require 'inc/lib/laborator/laborator_tgs.php';
require 'inc/lib/laborator/laborator_gallerybox.php';
require 'inc/lib/laborator/laborator_custom_css.php'; # New in v2.6
require 'inc/lib/laborator/laborator-demo-content-importer/laborator_demo_content_importer.php'; # New in v2.6

if(in_array('js_composer/js_composer.php', apply_filters('active_plugins', get_option('active_plugins'))) && function_exists('vc_add_params'))
{
	require 'inc/lib/visual-composer/config.php';
	#require 'inc/lib/visual-composer/vc-modify.php';
}

require 'inc/lib/widgets/laborator_subscribe.php';


# Advanced Custom Fields
if(function_exists("register_field_group"))
{
	if(in_array('revslider/revslider.php', apply_filters('active_plugins', get_option( 'active_plugins'))))
		require 'inc/lib/acf-revslider/acf-revslider.php';

	require 'inc/acf-fields.php';
}

require 'inc/laborator_data_blocks.php';

# Laborator SEO
if( ! defined("WPSEO_PATH"))
	require 'inc/lib/laborator/laborator_seo.php';


# Thumbnail Sizes
$blog_thumb_height = get_data('blog_thumbnail_height');

laborator_img_add_size('blog-thumb-1', 410, 410, 1);
laborator_img_add_size('blog-thumb-3', 300, 200, 1);
laborator_img_add_size('shop-thumb-1', 325, 390, 4);
laborator_img_add_size('shop-thumb-1-large', 500, 596, 4);
laborator_img_add_size('shop-thumb-2', 90, 110, 4);
laborator_img_add_size('shop-thumb-3', 105, 135, 4);
laborator_img_add_size('shop-thumb-4', 580, 0, 0);
laborator_img_add_size('shop-thumb-5', 135, 160, 4);
laborator_img_add_size('shop-thumb-6', 500, 500, 3);

add_image_size('blog-thumb-1', 410, 410, true);
add_image_size('blog-thumb-3', 300, 200, true);

add_image_size('shop-thumb-1', 325, 390, true);
add_image_size('shop-thumb-1-large', 500, 596, true);
add_image_size('shop-thumb-2', 90, 110, true);
add_image_size('shop-thumb-3', 105, 135, true);
add_image_size('shop-thumb-4', 580, 0);
add_image_size('shop-thumb-5', 135, 160, true);
add_image_size('shop-thumb-6', 500, 500, true);


if($blog_thumb_height)
	laborator_img_add_size('blog-thumb-2', 870, $blog_thumb_height, 1);
else
	laborator_img_add_size('blog-thumb-2', 870, 0, 0);


// Setup Menu Locations Notification
$nav_menu_locations = get_theme_mod('nav_menu_locations');

if( ! isset($nav_menu_locations['main-menu']) || $nav_menu_locations['main-menu'] == 0)
	add_action('admin_notices', 'laborator_setup_menus_notice');

// ================================================================
//  Hide The Max Price of Products
//=================================================================================
add_filter('woocommerce_variable_price_html', 'custom_variation_price', 10, 2);
function custom_variation_price( $price, $product ) {
$price = '';
if ( !$product->min_variation_price || $product->min_variation_price !== $product->max_variation_price ) $price .= '<span class="from">' . _x('', 'min_price', 'woocommerce') . ' </span>';
$price .= woocommerce_price($product->min_variation_price);
return $price;
}

// ================================================================
//  Disable rewview tab in product page
//=================================================================================
add_filter( 'woocommerce_product_tabs', 'sb_woo_remove_reviews_tab', 98);
function sb_woo_remove_reviews_tab($tabs) {

 unset($tabs['reviews']);

 return $tabs;
}


function wpb_move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;
return $fields;
}

add_filter( 'comment_form_fields', 'wpb_move_comment_field_to_bottom' );



remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
remove_action( 'woocommerce_simple_add_to_cart', 'woocommerce_simple_add_to_cart', 30 );
remove_action( 'woocommerce_grouped_add_to_cart', 'woocommerce_grouped_add_to_cart', 30 );


// Remove prices everywhere
 
add_filter( 'woocommerce_variable_sale_price_html', 'businessbloomer_remove_prices', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'businessbloomer_remove_prices', 10, 2 );
add_filter( 'woocommerce_get_price_html', 'businessbloomer_remove_prices', 10, 2 );

 
function businessbloomer_remove_prices( $price ) {
$price = '';
return $price;
}
add_action( 'add_meta_boxes', 'add_upload_file_metaboxes' );
function add_upload_file_metaboxes()
{
add_meta_box('pdf_upload', 'PDF Name', 'pdf_name', 'product', 'normal', 'default');
add_meta_box('pdf_upload', 'PDF Upload', 'pdf_upload', 'product', 'normal', 'default');
}

function pdf_name() {
	global $post;
	
	// Noncename needed to verify where the data originated
	echo '<input type="hidden" name="pdf_upload_noncename" id="pdf_upload_noncename" value="' . 
	wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
	
	// Get the location data if its already been entered
	$pdfname = get_post_meta($post->ID, 'pdf-name', true);
	
	

}



function pdf_upload()
{
global $post;
// Noncename needed to verify where the data originated
echo '<input type="hidden" name="pdf_upload_noncename" id="pdf_upload_noncename" value="' .
wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
global $wpdb;
$strFile = get_post_meta( $post->ID, $key = 'pdf_upload_file', true );
$pname = get_post_meta( $post->ID, $key = 'pdf-name', true );
$media_file = get_post_meta( $post->ID, $key = '_wp_attached_file', true );
if(!empty($media_file)) { $strFile = $media_file; }
?>


<script type="text/javascript">

// Uploading files
var file_frame;
jQuery('#upload_image_button').live('click', function( podcast ){

podcast.preventDefault();

// If the media frame already exists, reopen it.
if ( file_frame ) {
file_frame.open();
return;
}

// Create the media frame.
file_frame = wp.media.frames.file_frame = wp.media({
title: jQuery( this ).data( 'uploader_title' ),
button: {
text: jQuery( this ).data( 'uploader_button_text' ),
},
multiple: false // Set to true to allow multiple files to be selected
});

// When a file is selected, run a callback.
file_frame.on( 'select', function() {
// We set multiple to false so only get one image from the uploader
attachment = file_frame.state().get('selection').first().toJSON();

// here are some of the variables you could use for the attachment;
var url = attachment.url;

var field = document.getElementById("pdf_upload_file");

field.value =url;   //set which variable you want the field to have
});

// Finally, open the modal
file_frame.open();
});

</script>



<div>

<table>
<tr valign="top">
<td>
<input type="text" name="pdf-name" value="<?php echo $pname;?>" class="widefat" />
<input type="text" name="pdf_upload_file" id="pdf_upload_file" size="70" value="<?php echo $strFile; ?>" />
<input id="upload_image_button" type="button" value="Upload">
</td>
</tr>
</table>
<input type="hidden" name="img_txt_id" id="img_txt_id" value="" />
</div>    
<?php function admin_scripts()
{
wp_enqueue_script('media-upload');
wp_enqueue_script('thickbox');
}
function admin_styles()
{
wp_enqueue_style('thickbox');
}
add_action('admin_print_scripts', 'admin_scripts');
add_action('admin_print_styles', 'admin_styles');
}


 //Saving the file
function save_podcasts_meta($post_id, $post)
{
// verify this came from the our screen and with proper authorization,
// because save_post can be triggered at other times
if ( !wp_verify_nonce( $_POST['pdf_upload_noncename'], plugin_basename(__FILE__) )) {
return $post->ID;
}
// Is the user allowed to edit the post?
if ( !current_user_can( 'edit_post', $post->ID ))
return $post->ID;
// We need to find and save the data
// We'll put it into an array to make it easier to loop though.
$podcasts_meta['pdf_upload_file'] = $_POST['pdf_upload_file'];
$podcasts_meta['pdf-name'] = $_POST['pdf-name'];
// Add values of $podcasts_meta as custom fields

foreach ($podcasts_meta as $key => $value)
{
if( $post->post_type == 'revision' ) return;
$value = implode(',', (array)$value);
if(get_post_meta($post->ID, $key, FALSE))
{ // If the custom field already has a value it will update
update_post_meta($post->ID, $key, $value);
}
else
{ // If the custom field doesn't have a value it will add
add_post_meta($post->ID, $key, $value);
}
if(!$value) delete_post_meta($post->ID, $key); // Delete if blank value
}
}
add_action('save_post', 'save_podcasts_meta', 1, 2); // save the custom fields

add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 18;' ), 20 );
