<?php
/**
 * Pay for order form
 *
 * @author   WooThemes
 * @package  WooCommerce/Templates
 * @version  2.4.7
 */

/* Note: This file has been altered by Laborator */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

# start: modified by Arlind Nushi
wp_enqueue_script(array('icheck'));
wp_enqueue_style(array('icheck'));

do_action('laborator_woocommerce_before_wrapper');
# end: modified by Arlind Nushi

?>

<form id="order_review" method="post" class="cart-env checkout-cart-env">
	
<div class="row">
	
	<div class="col-md-6">
		
		<div class="white-block block-pad">
			
			<h4 id="order_review_heading" class="with-divider"><?php _e( 'Your order', 'oxygen' ); ?></h4>
			
			<table class="shop_table">
				<thead>
					<tr>
						<th class="product-name"><?php _e( 'Product', 'woocommerce' ); ?></th>
						<th class="product-quantity"><?php _e( 'Qty', 'woocommerce' ); ?></th>
						<th class="product-total"><?php _e( 'Totals', 'woocommerce' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php
					if ( sizeof( $order->get_items() ) > 0 ) :
						foreach ( $order->get_items() as $item ) :
							echo '
								<tr>
									<td class="product-name">' . $item['name'].'</td>
									<td class="product-quantity">' . $item['qty'].'</td>
									<td class="product-subtotal">' . $order->get_formatted_line_subtotal( $item ) . '</td>
								</tr>';
						endforeach;
					endif;
					?>
				</tbody>
				<tfoot>
				<?php
					if ( $totals = $order->get_order_item_totals() ) foreach ( $totals as $total ) :
						?>
						<tr>
							<th scope="row" colspan="2"><?php echo $total['label']; ?></th>
							<td class="product-total"><?php echo $total['value']; ?></td>
						</tr>
						<?php
					endforeach;
				?>
				</tfoot>
			</table>
			
		</div>
		
	</div>
	
	<div class="col-md-6">
	
		<div class="white-block block-pad">
			
			<div id="payment">
				
				<?php if ( $order->needs_payment() ) : ?>
				<h4 class="with-divider"><?php _e( 'Payment', 'oxygen' ); ?></h4>
				
				<ul class="payment_methods methods">
					<?php
						if ( $available_gateways = WC()->payment_gateways->get_available_payment_gateways() ) {
							// Chosen Method
							if ( sizeof( $available_gateways ) ) {
								current( $available_gateways )->set_current();
							}
		
							foreach ( $available_gateways as $gateway ) {
								?>
								<li class="payment_method_<?php echo $gateway->id; ?>">
									<input id="payment_method_<?php echo $gateway->id; ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?> data-order_button_text="<?php echo esc_attr( $gateway->order_button_text ); ?>" />
									<label for="payment_method_<?php echo $gateway->id; ?>"><?php echo $gateway->get_title(); ?> <?php echo $gateway->get_icon(); ?></label>
									<?php
										if ( $gateway->has_fields() || $gateway->get_description() ) {
											echo '<div class="payment_box payment_method_' . $gateway->id . '" style="display:none;">';
											$gateway->payment_fields();
											echo '</div>';
										}
									?>
								</li>
								<?php
							}
						} else {
		
							echo '<p>' . __( 'Sorry, it seems that there are no available payment methods for your location. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) . '</p>';
		
						}
					?>
				</ul>
				<?php endif; ?>
		
			</div>
			
		</div>
	
		<div class="form-row">
			<?php wp_nonce_field( 'woocommerce-pay' ); ?>
			<?php
				$pay_order_button_text = apply_filters( 'woocommerce_pay_order_button_text', __( 'Pay for order', 'woocommerce' ) );

				echo apply_filters( 'woocommerce_pay_order_button_html', '<input type="submit" class="button alt fluid-dark-button" id="place_order" value="' . esc_attr( $pay_order_button_text ) . '" data-value="' . esc_attr( $pay_order_button_text ) . '" />' );
			?>
			<input type="hidden" name="woocommerce_pay" value="1" />
		</div>
		
	</div>
	
</div>
	
</form>

<script type="text/javascript">
	jQuery(document).ready(function($)
	{
		var $payments = $(".payment_methods.methods input");
		
		$payments.on('ifChecked', function()
		{
			var $this = $(this);
			
			$payments.not($this).each(function(i, el)
			{
				var $pb = $(el).closest('li').find('.payment_box');
				
				$pb.slideUp(350);
			});
			
			$this.closest('li').find('.payment_box').slideDown(350);
		});
	});
</script>
</form>
<?php
# start: modified by Arlind Nushi
do_action('laborator_woocommerce_after_wrapper');
# end: modified by Arlind Nushi
?>