<?php
/**
 * Related Products
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product, $woocommerce_loop;

if ( empty( $product ) || ! $product->exists() ) {
	return;
}

$related = $product->get_related( $posts_per_page );

if ( sizeof( $related ) == 0 ) return;

$args = apply_filters( 'woocommerce_related_products_args', array(
	'post_type'            => 'product',
	'ignore_sticky_posts'  => 1,
	'no_found_rows'        => 1,
	'posts_per_page'       => $posts_per_page,
	'orderby'              => $orderby,
	'post__in'             => $related,
	'post__not_in'         => array( $product->id )
) );

$products = new WP_Query( $args );

$woocommerce_loop['columns'] = $columns;

if ( $products->have_posts() ) : ?>

	<div class="related products">

		<div class="row">
			<div class="col-md-12">
				<h2 class="middle-title"><?php _e( 'Related Products', 'woocommerce' ); ?></h2>
			</div>
		</div>

		<?php woocommerce_product_loop_start(); ?>

<div id="related-owl-carousel" class="related-carousel">

			<?php $i = 1; $shop_columns = SHOPSINGLESIDEBAR ? 3 : 4; ?>
			<?php while ( $products->have_posts() ) : $products->the_post(); ?>

				<?php wc_get_template_part( 'content', 'product' ); ?>
				
				<?php
				# start: modified by Arlind Nushi
				echo $i % $shop_columns == 0 ? '<div class="clear"></div>' : '';
				# end: modified by Arlind Nushi
				?>

			<?php endwhile; // end of the loop. ?>
</div>


		<?php woocommerce_product_loop_end(); ?>

	</div>

<?php endif;

wp_reset_postdata(); 


