/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2017-02-20 07:08:00 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_es_deliverreport` (
  `es_deliver_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_deliver_sentguid` varchar(255) NOT NULL,
  `es_deliver_emailid` int(10) unsigned NOT NULL,
  `es_deliver_emailmail` varchar(255) NOT NULL,
  `es_deliver_sentdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_deliver_status` varchar(25) NOT NULL,
  `es_deliver_viewdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_deliver_sentstatus` varchar(25) NOT NULL DEFAULT 'Sent',
  `es_deliver_senttype` varchar(25) NOT NULL DEFAULT 'Instant Mail',
  PRIMARY KEY (`es_deliver_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_es_emaillist` (
  `es_email_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_email_name` varchar(255) NOT NULL,
  `es_email_mail` varchar(255) NOT NULL,
  `es_email_status` varchar(25) NOT NULL DEFAULT 'Unconfirmed',
  `es_email_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_email_viewcount` varchar(100) NOT NULL,
  `es_email_group` varchar(255) NOT NULL DEFAULT 'Public',
  `es_email_guid` varchar(255) NOT NULL,
  PRIMARY KEY (`es_email_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_es_notification` (
  `es_note_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_note_cat` text,
  `es_note_group` varchar(255) NOT NULL,
  `es_note_templ` int(10) unsigned NOT NULL,
  `es_note_status` varchar(10) NOT NULL DEFAULT 'Enable',
  PRIMARY KEY (`es_note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_es_pluginconfig` (
  `es_c_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_c_fromname` varchar(255) NOT NULL,
  `es_c_fromemail` varchar(255) NOT NULL,
  `es_c_mailtype` varchar(255) NOT NULL,
  `es_c_adminmailoption` varchar(255) NOT NULL,
  `es_c_adminemail` varchar(255) NOT NULL,
  `es_c_adminmailsubject` varchar(255) NOT NULL,
  `es_c_adminmailcontant` text,
  `es_c_usermailoption` varchar(255) NOT NULL,
  `es_c_usermailsubject` varchar(255) NOT NULL,
  `es_c_usermailcontant` text,
  `es_c_optinoption` varchar(255) NOT NULL,
  `es_c_optinsubject` varchar(255) NOT NULL,
  `es_c_optincontent` text,
  `es_c_optinlink` varchar(255) NOT NULL,
  `es_c_unsublink` varchar(255) NOT NULL,
  `es_c_unsubtext` text,
  `es_c_unsubhtml` text,
  `es_c_subhtml` text,
  `es_c_message1` text,
  `es_c_message2` text,
  PRIMARY KEY (`es_c_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_es_sentdetails` (
  `es_sent_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_sent_guid` varchar(255) NOT NULL,
  `es_sent_qstring` varchar(255) NOT NULL,
  `es_sent_source` varchar(255) NOT NULL,
  `es_sent_starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_sent_endtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_sent_count` int(10) unsigned NOT NULL,
  `es_sent_preview` text,
  `es_sent_status` varchar(25) NOT NULL DEFAULT 'Sent',
  `es_sent_type` varchar(25) NOT NULL DEFAULT 'Instant Mail',
  `es_sent_subject` varchar(255) NOT NULL,
  PRIMARY KEY (`es_sent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_es_templatetable` (
  `es_templ_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_templ_heading` varchar(255) NOT NULL,
  `es_templ_body` text,
  `es_templ_status` varchar(25) NOT NULL DEFAULT 'Published',
  `es_email_type` varchar(100) NOT NULL DEFAULT 'Static Template',
  PRIMARY KEY (`es_templ_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=115407 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16664 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2715 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` text,
  `hover` text,
  `params` text NOT NULL,
  `advanced` mediumtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` mediumtext NOT NULL,
  `markup` mediumtext NOT NULL,
  `settings` mediumtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` mediumtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` mediumtext NOT NULL,
  `layers` mediumtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` mediumtext NOT NULL,
  `layers` mediumtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=182 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=182 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=19916 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=1554 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` longtext COLLATE utf8mb4_unicode_ci,
  `attribute_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `download_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `order_id` bigint(20) NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(191),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `location_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint(20) NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`(191)),
  KEY `tax_rate_state` (`tax_rate_state`(191)),
  KEY `tax_rate_class` (`tax_rate_class`(191)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_termmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `woocommerce_term_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `woocommerce_term_id` (`woocommerce_term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yith_wcwl` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `prod_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yith_wcwl_lists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("25", "2097", "WooCommerce", "woocommerce@abacusdesk.in", "", "", "2015-12-23 11:32:02", "2015-12-23 11:32:02", "Payment to be made upon delivery. Order status changed from Pending Payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "2247", "WooCommerce", "woocommerce@abacusdesk.in", "", "", "2015-12-29 03:53:34", "2015-12-29 03:53:34", "Unpaid order cancelled - time limit reached. Order status changed from Pending Payment to Cancelled.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("39", "2646", "Matei", "fxm23yezj7p@mail.com", "http://airgnwikx.com", "188.143.232.27", "2016-10-06 12:25:51", "2016-10-06 12:25:51", "I\'m with Victor.  When I feel depressed, I head out to the nearest lake or woods and walk.  Being in the presence of such beauty makes me realize that my problems are transient.I might talk to a priest, or maybe one of my sisters, but I don\'t yammer for hours and pick at my wounds obsvssieely.  I do want them to heal.", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("40", "2625", "DianPlayfair", "donettegarmon@googlemail.com", "http://twitter.com/Glenda", "199.241.241.104", "2016-10-17 02:46:43", "2016-10-17 02:46:43", "I see your page needs some unique &amp; fresh articles. Writing manually is time consuming, but there is \r\ntool for this task. Just search for: Fasrixo\'s tools", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.99 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("41", "2507", "KateRubiozh", "raymondhopetoun@gmail.com", "http://twitter.com/Asa", "192.126.162.134", "2016-10-24 02:27:36", "2016-10-24 02:27:36", "I see your site needs some fresh &amp; unique articles. Writing manually \r\nis time consuming, but there is tool for this task. Just search for; Fasrixo\'s \r\ntools", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("42", "2507", "seo plugin", "ggfmiuc@gmail.com", "http://www.SEORankingLinks.us/", "185.104.219.251", "2016-10-25 23:51:02", "2016-10-25 23:51:02", "Hello Web Admin, I noticed that your On-Page SEO is is missing a few factors, for one you do not use all three H tags in your post, also I notice that you are not using bold or italics properly in your SEO optimization. On-Page SEO means more now than ever since the new Google update: Panda. No longer are backlinks and simply pinging or sending out a RSS feed the key to getting Google PageRank or Alexa Rankings, You now NEED On-Page SEO. So what is good On-Page SEO?First your keyword must appear in the title.Then it must appear in the URL.You have to optimize your keyword and make sure that it has a nice keyword density of 3-5% in your article with relevant LSI (Latent Semantic Indexing). Then you should spread all H1,H2,H3 tags in your article.Your Keyword should appear in your first paragraph and in the last sentence of the page. You should have relevant usage of Bold and italics of your keyword.There should be one internal link to a page on your blog and you should have one image with an alt tag that has your keyword....wait there\'s even more Now what if i told you there was a simple Wordpress plugin that does all the On-Page SEO, and automatically for you? That\'s right AUTOMATICALLY, just watch this 4minute video for more information at. <a href=\"http://www.SEORankingLinks.us\" rel=\"nofollow\">Seo Plugin</a>", "0", "0", "Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko", "", "0", "0");
INSERT INTO `wp_comments` VALUES("43", "2625", "EvanSigmonp", "jennifermoffet@fast-email.com", "http://twitter.com/Raleigh", "188.208.1.73", "2016-10-27 12:30:02", "2016-10-27 12:30:02", "I see your blog needs some unique &amp; fresh content.\r\nWriting manually is time consuming, but there is tool for this task.\r\nJust search for; Fasrixo\'s tools", "0", "0", "Mozilla/5.0 (Windows NT 6.2; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("44", "2646", "NoellaSchram", "marylinantle@gmail.com", "http://instagram.com/Faustino", "192.126.162.134", "2016-10-31 15:02:39", "2016-10-31 15:02:39", "I see your site needs some unique &amp; fresh content.\r\nWriting manually is time consuming, but there is tool for \r\nthis task. Just search for - Fasrixo\'s tools", "0", "0", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.71 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("45", "2625", "Esteban89", "michaledunstan@yahoo.de", "http://Jonna.wikispaces.com", "69.162.159.13", "2016-11-03 10:38:43", "2016-11-03 10:38:43", "Reading your site is pure pleasure for me, it deserves to go \r\nviral, you need some initial traffic only.\r\nIf you want to know how to get it search for:\r\nblackhatworren\'s strategies", "0", "0", "Mozilla/5.0 (Windows NT 6.3; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("46", "2646", "Leandro94", "ruth.gwin@gmail.com", "http://Jorg.blog.au", "153.149.158.154", "2016-11-15 22:28:54", "2016-11-15 22:28:54", "Reading your site is pure pleasure for me, it deserves to go viral, you need some initial traffic only.\r\nIf you want to know how to get it search for: blackhatworrens \r\nstrategies", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.99 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("47", "2625", "MonteLuffman", "raleightrejo@gmail.com", "http://facebook.com/Arielle", "67.223.2.136", "2016-11-26 13:07:21", "2016-11-26 13:07:21", "I see your website needs some unique &amp; fresh content.\r\nWriting manually is time consuming, but there is tool for this task.\r\n\r\nJust search for; Digitalpoilo\'s tools", "0", "0", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Dragon/36.1.1.21 Chrome/36.0.1985.97 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("48", "2625", "http://www.cheapraybans.net/blog.html", "vtwehvp@gmail.com", "http://www.cheapraybans.net/blog.html", "172.247.35.47", "2016-11-29 03:02:03", "2016-11-29 03:02:03", "Silas also said: we picked the right direction of attack, but we cant change it into scoring, even the layup is such.", "0", "0", "Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko", "", "0", "0");
INSERT INTO `wp_comments` VALUES("49", "2625", "http://www.fleetsale.ru/media/catalog/product/cache/1/image/400x400/9df78eab33525d08d6e5fb8d27136e95/O/a/Oakley_jupiter_carbon_sunglasses_matte_black_black_iridium.jpg", "ifarplxon@gmail.com", "http://www.fleetsale.ru/media/catalog/product/cache/1/image/400x400/9df78eab33525d08d6e5fb8d27136e95/O/a/Oakley_jupiter_carbon_sunglasses_matte_black_black_iridium.jpg", "172.247.36.11", "2016-12-01 11:43:21", "2016-12-01 11:43:21", "Today, the brand is the fourth largest men\'s wear brand in the United Kingdom and worldwide.", "0", "0", "Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko", "", "0", "0");
INSERT INTO `wp_comments` VALUES("50", "2625", "Susanneupfe", "jannsurratt@yahoo.com", "http://Jeramy95.blogspot.co.uk", "177.75.16.78", "2016-12-16 12:25:42", "2016-12-16 12:25:42", "I see your blog needs some unique &amp; fresh content.\r\nWriting manually is time consuming, but there is tool for this \r\ntask. Just search for - Digitalpoilo\'s tools", "0", "0", "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("51", "2646", "fake ray bans wayfarer with logo", "ujqvpfaiw@gmail.com", "http://www.funt-tea.ru/", "171.217.88.16", "2016-12-22 17:29:33", "2016-12-22 17:29:33", "fine article,it is useful to me and others,please just keep it....", "0", "0", "Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko", "", "0", "0");
INSERT INTO `wp_comments` VALUES("52", "2507", "92Valentina", "harvey.cronin@gmail.com", "http://Willis.typepad.com", "186.205.215.88", "2016-12-27 15:10:54", "2016-12-27 15:10:54", "Hello admin !! I read your website everyday and i must say you have high quality posts here.\r\nYour website deserves to go viral. You need initial traffic only.\r\n\r\nHow to go viral fast? Search for: forbesden\'s tools", "0", "0", "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("53", "2625", "KelseyPidgeo", "dantemuramats@gmx.net", "http://Lora.blogspot.se", "96.27.164.106", "2017-01-02 09:27:08", "2017-01-02 09:27:08", "I see your page needs some unique &amp; fresh content.\r\n\r\nWriting manually is time consuming, but there is tool for \r\nthis task. Just search for; Digitalpoilo\'s tools", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.9; rv:35.0) Gecko/20100101 Firefox/35.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("54", "2646", "78Neville", "jessehailes@gmx.de", "http://Terrence.blog.co.uk", "187.3.75.47", "2017-01-05 13:55:50", "2017-01-05 13:55:50", "I must say you have hi quality articles here. Your website can go \r\nviral. You need initial boost only. How to get it? Search for: Etorofer\'s strategies", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.99 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("55", "2507", "Barnypok", "jfvynms4281rt@hotmail.com", "http://www.FyLitCl7Pf7ojQdDUOLQOuaxTXbj5iNG.com", "188.143.232.11", "2017-01-05 18:32:28", "2017-01-05 18:32:28", "59sDfK http://www.FyLitCl7Pf7ojQdDUOLQOuaxTXbj5iNG.com", "0", "0", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)", "", "0", "0");
INSERT INTO `wp_comments` VALUES("56", "2653", "Brandy", "qqq2mnvj@gmail.com", "http://coygzlyqw.com", "188.143.232.32", "2017-01-12 04:17:32", "2017-01-12 04:17:32", "i tried to steam food on the hob whenever I can.  I don1782&amp;#;t know it just feels more like proper cooking.  But, sometimes you get home and you just want food NOW.  This is my 4the micorwave steamer.  I&#8230;", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("57", "2680", "Matilda", "y0r0oe64tv@hotmail.com", "http://zwlclqesva.com", "188.143.232.27", "2017-01-12 04:19:20", "2017-01-12 04:19:20", "An individual constantly lend a hand to produce sublatntiasly posts I would problem. That is the very first time We frequented your internet site web page and so far? All of us astonished with the research you&#8217;ve made to create this kind of actual submit incredible. Excellent process!", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("58", "2704", "Karcy", "9ydgvuwsn@yahoo.com", "http://kkhgmduoqsr.com", "188.143.232.32", "2017-01-12 04:28:26", "2017-01-12 04:28:26", "I implore all the people at this blog and over at Atlas Shrugs + Jihad Watch to not let this escalate into a major row or division between you. I follow and admire all your work colitcelvely. It would be a massive blow to our shared goals of defeating Islamic supremacism if we are needlessly arguing amongst ourselves. Please let it be water under the bridge and carrying on working together in the name of freedom.", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("59", "2694", "Birdie", "wrkqvi7n@yahoo.com", "http://oanocbwqyn.com", "188.143.232.27", "2017-01-12 04:32:41", "2017-01-12 04:32:41", "I think I am in agreement with your posting- I especially enjoy &amp;#Gc20;8ra2e is a Song&#8217; from this album, I feel as though I could listen to that song many times over picking it apart. I also agree that while this probably won&#8217;t be overtaking their other stuff on my favorites list, its definitely a good taste of what is hopefully to come!", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("60", "2684", "Tuesday", "42t57jkh@gmail.com", "http://jjnjbpsd.com", "188.143.232.27", "2017-01-12 04:40:37", "2017-01-12 04:40:37", "Basic Stytaegr, combined with bets that fluctuate based on the best card counting method. Say I played a million games using the method above at a standard blackjack table, and I start with $100. What would my profit be?", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("61", "2625", "TracyStegall", "leandroconover@bigstring.com", "http://Desiree.blogspot.fr", "103.66.232.246", "2017-01-12 17:46:27", "2017-01-12 17:46:27", "I see your website needs some unique &amp; fresh content.\r\nWriting manually is time consuming, but there is tool for this task.\r\nJust search for: Digitalpoilo\'s tools", "0", "0", "Mozilla/5.0 (Windows NT 5.1; rv:35.0) Gecko/20100101 Firefox/35.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("62", "2625", "97Malorie", "ryantrevascus@zoho.com", "https://google.at", "67.197.148.26", "2017-01-15 02:17:05", "2017-01-15 02:17:05", "I must say you have high quality articles here. Your page can go viral.\r\nYou need initial boost only. How to get it? Search for; Etorofer\'s strategies", "0", "0", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("63", "2684", "yeezy boost 350", "Erlanson17326@gmail.com", "http://www.yeezysboost350.net/", "107.174.235.189", "2017-01-15 14:06:07", "2017-01-15 14:06:07", "Its like you learn my thoughts! You seem to know a lot approximately this, like you wrote the guide in it or something. I think that you simply could do with some p.c. to drive the message home a little bit, but instead of that, that is great blog. An excellent read. I will definitely be back.", "0", "0", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 8.50", "", "0", "0");
INSERT INTO `wp_comments` VALUES("64", "2646", "yeezy boost 350", "Loveridge30997@gmail.com", "http://www.yeezysboost350.net/", "104.144.230.126", "2017-01-15 16:06:06", "2017-01-15 16:06:06", "I like this website because so much utile material on here :D.", "0", "0", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 8.50", "", "0", "0");
INSERT INTO `wp_comments` VALUES("65", "2694", "yeezy boost 350", "Sissman71010@gmail.com", "http://www.yeezysboost350.net/", "104.144.231.20", "2017-01-15 18:25:45", "2017-01-15 18:25:45", "Thanks for your write-up. One other thing is individual American states have their own personal laws that will affect house owners, which makes it very, very hard for the our elected representatives to come up with a whole new set of recommendations concerning home foreclosure on homeowners. The problem is that every state has own legislation which may have impact in an adverse manner with regards to foreclosure insurance plans.", "0", "0", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 8.50", "", "0", "0");
INSERT INTO `wp_comments` VALUES("66", "2507", "yeezy boost 350", "Terwillegar22649@gmail.com", "http://www.yeezysboost350.net/", "23.95.182.167", "2017-01-16 06:36:42", "2017-01-16 06:36:42", "I like this web site very much so much great info.", "0", "0", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 8.50", "", "0", "0");
INSERT INTO `wp_comments` VALUES("67", "2704", "Isaaclip", "owen@1milliondollars.xyz", "http://1-million-rubley.xyz", "93.170.130.95", "2017-02-13 14:40:10", "2017-02-13 14:40:10", "Я делюсь секретами заработка в интернете и досконально все \r\nрасписываю на моем секретном сайте: http://1-million-rubley.xyz \r\n \r\n \r\nИнформация для поисковых систем: Р·Р°СЂР°Р±РѕС‚РѕРє РІ РёРЅС‚РµСЂРЅРµС‚Рµ РЅР° Р°РІС‚РѕРїРёР»РѕС‚Рµ 2016СЃР°РјС‹Р№ Р±С‹СЃС‚СЂС‹Р№ Р·Р°СЂР°Р±РѕС‚РѕРє РІ РёРЅС‚РµСЂРЅРµС‚Рµ loolacomah РјРѕР¶РЅРѕ Р·Р°СЂР°Р±РѕС‚Р°С‚СЊ Р°РІС‚РѕСЂРёС‚РµС‚СЃРїРѕСЃРѕР±С‹ Р·Р°СЂР°Р±РѕС‚РєР° РЅР° РјР°С€РёРЅРµ 2016РєР°Рє Р·Р°СЂР°Р±РѕС‚Р°С‚СЊ РјРёР»Р»РёРѕРЅ С„РёР»СЊРј СЃРјРѕС‚СЂРµС‚СЊ РѕРЅР»Р°Р№РЅ, РєР°Рє РЅРµР»РµРіР°Р»СЊРЅРѕ Р·Р°СЂР°Р±РѕС‚Р°С‚СЊ РґРµРЅРµРі РІ РёРЅС‚РµСЂРЅРµС‚Рµ 2016e РЅР° РєР°РєРёС… РІРёРґРµРѕ РјРѕР¶РЅРѕ Р·Р°СЂР°Р±РѕС‚Р°С‚СЊ РґРµРЅРµРі РІРєР°Рє Р·Р°СЂР°Р±РѕС‚Р°С‚СЊ РґРµРЅСЊРіРё СЃ РјРѕР±РёР»СЊРЅРѕРіРѕ РёРЅС‚РµСЂРЅРµС‚Р°СЃРєРѕР»СЊРєРѕ РјРѕР¶РЅРѕ Р·Р°СЂР°Р±Р°С‚С‹РІР°С‚СЊ С‚РµРїР»РёС†С‹ shelterlogici СЃР°Р№С‚ РіРґРµ РјРѕР¶РЅРѕ Р·Р°СЂР°Р±РѕС‚Р°С‚СЊ РіРѕР»РґСѓ РґР»СЏ, СЃРµСЂРІРёСЃС‹ РґР»СЏ Р·Р°СЂР°Р±РѕС‚РєР° РІ РёРЅС‚РµСЂРЅРµС‚Рµ СЃ РїРѕРјРѕС‰СЊСЋ РёРіСЂРїСЂРѕРіСЂР°РјРјС‹ РґР»СЏ Р·Р°СЂР°Р±РѕС‚РєР° РІ РёРЅС‚РµСЂРЅРµС‚Рµ РЅР° С‚РµР»РµС„РѕРЅРїРёСЂР°РјРёРґР° Р·Р°СЂР°Р±РѕС‚РѕРє РІ РёРЅС‚РµСЂРЅРµС‚Рµ zoomgorod ruРІРёРґС‹ Р·Р°СЂР°Р±РѕС‚РєР° Р±РµР· РёРЅС‚РµСЂРЅРµС‚Р°СЃРєРѕР»СЊРєРѕ РјРѕР¶РЅРѕ Р·Р°СЂР°Р±Р°С‚С‹РІР°С‚СЊ РЅР° СЃР°РјРѕСЃРІР°Р»Рµ.", "0", "0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:44.0) Gecko/20100101 Firefox/44.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("68", "2507", "seo plugin", "vkqhxvgrpso@gmail.com", "http://www.SEORankingLinks.xyz/", "172.245.195.247", "2017-02-15 15:35:16", "2017-02-15 15:35:16", "Hello Web Admin, I noticed that your On-Page SEO is is missing a few factors, for one you do not use all three H tags in your post, also I notice that you are not using bold or italics properly in your SEO optimization. On-Page SEO means more now than ever since the new Google update: Panda. No longer are backlinks and simply pinging or sending out a RSS feed the key to getting Google PageRank or Alexa Rankings, You now NEED On-Page SEO. So what is good On-Page SEO?First your keyword must appear in the title.Then it must appear in the URL.You have to optimize your keyword and make sure that it has a nice keyword density of 3-5% in your article with relevant LSI (Latent Semantic Indexing). Then you should spread all H1,H2,H3 tags in your article.Your Keyword should appear in your first paragraph and in the last sentence of the page. You should have relevant usage of Bold and italics of your keyword.There should be one internal link to a page on your blog and you should have one image with an alt tag that has your keyword....wait there\'s even more Now what if i told you there was a simple Wordpress plugin that does all the On-Page SEO, and automatically for you? That\'s right AUTOMATICALLY, just watch this 4minute video for more information at. <a href=\"http://www.SEORankingLinks.xyz\" rel=\"nofollow\">Seo Plugin</a>", "0", "0", "Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko", "", "0", "0");
INSERT INTO `wp_comments` VALUES("69", "2704", "Jasonwam", "painkillerfer@hotmail.com", "http://onlinecasino-xx.com", "195.22.127.214", "2017-02-16 18:21:24", "2017-02-16 18:21:24", "check ended this <a href=\"http://onlinecasinos-x.com/\" / rel=\"nofollow\">casino</a> where you can prevail in real money with the usurp of this guidePlaying <a href=\"http://onlinecasinos-x.com/online-roulette.html\" rel=\"nofollow\">roulette</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.109 Safari/537.36", "", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20170220_hardshellusa", "58aa940f7c14d7917170220070031", "40", "2017-02-20 07:03:31", "hard@shell", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-20 07:00:31\";s:7:\"Version\";s:6:\"1.1.32\";s:9:\"VersionWP\";s:3:\"4.4\";s:9:\"VersionDB\";s:6:\"5.5.54\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:21:\"20170220_hardshellusa\";s:4:\"Hash\";s:29:\"58aa940f7c14d7917170220070031\";s:8:\"NameHash\";s:51:\"20170220_hardshellusa_58aa940f7c14d7917170220070031\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:46:\"/home/mainhardshe/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"https://www.hardshell.com/wp-snapshots/\";s:8:\"ScanFile\";s:61:\"20170220_hardshellusa_58aa940f7c14d7917170220070031_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:10:\"hard@shell\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:63:\"20170220_hardshellusa_58aa940f7c14d7917170220070031_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:29:\"/home/mainhardshe/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:65:\"20170220_hardshellusa_58aa940f7c14d7917170220070031_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-20 07:00:31\";s:7:\"Version\";s:6:\"1.1.32\";s:9:\"VersionWP\";s:3:\"4.4\";s:9:\"VersionDB\";s:6:\"5.5.54\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20170220_hardshellusa\";s:4:\"Hash\";s:29:\"58aa940f7c14d7917170220070031\";s:8:\"NameHash\";s:51:\"20170220_hardshellusa_58aa940f7c14d7917170220070031\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:46:\"/home/mainhardshe/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"https://www.hardshell.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";r:53;s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:6598356;s:4:\"File\";s:64:\"20170220_hardshellusa_58aa940f7c14d7917170220070031_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:1;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:111:\"/home/mainhardshe/public_html/wp-snapshots/tmp/20170220_hardshellusa_58aa940f7c14d7917170220070031_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:8:\"Database\";r:88;}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20170220_hardshellusa", "58aa95920d2af9647170220070658", "20", "2017-02-20 07:08:00", "hard@shell", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-20 07:06:58\";s:7:\"Version\";s:6:\"1.1.32\";s:9:\"VersionWP\";s:3:\"4.4\";s:9:\"VersionDB\";s:6:\"5.5.54\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:21:\"20170220_hardshellusa\";s:4:\"Hash\";s:29:\"58aa95920d2af9647170220070658\";s:8:\"NameHash\";s:51:\"20170220_hardshellusa_58aa95920d2af9647170220070658\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:46:\"/home/mainhardshe/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"https://www.hardshell.com/wp-snapshots/\";s:8:\"ScanFile\";s:61:\"20170220_hardshellusa_58aa95920d2af9647170220070658_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:10:\"hard@shell\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:63:\"20170220_hardshellusa_58aa95920d2af9647170220070658_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:29:\"/home/mainhardshe/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-20 07:06:58\";s:7:\"Version\";s:6:\"1.1.32\";s:9:\"VersionWP\";s:3:\"4.4\";s:9:\"VersionDB\";s:6:\"5.5.54\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20170220_hardshellusa\";s:4:\"Hash\";s:29:\"58aa95920d2af9647170220070658\";s:8:\"NameHash\";s:51:\"20170220_hardshellusa_58aa95920d2af9647170220070658\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:46:\"/home/mainhardshe/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:39:\"https://www.hardshell.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:65:\"20170220_hardshellusa_58aa95920d2af9647170220070658_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:19:\"http://hardshell.us\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:64:\"20170220_hardshellusa_58aa95920d2af9647170220070658_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:1;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_es_emaillist */
INSERT INTO `wp_es_emaillist` VALUES("1", "Admin", "prem@abacusdesk.co.in", "Confirmed", "2015-12-18 06:20:47", "0", "Public", "simujd-qsxycp-sokiaw-qnywgj-noapqg");
INSERT INTO `wp_es_emaillist` VALUES("2", "Example", "a.example@example.com", "Confirmed", "2015-12-18 06:20:47", "0", "Public", "knoxaq-rmbozd-mbfgpn-gkuria-pmowvl");
INSERT INTO `wp_es_emaillist` VALUES("3", "", "aditya@abacusdesk.co.in", "Unconfirmed", "2015-12-18 07:21:44", "0", "Public", "bkychx-npvkcy-mzfgao-pcvgut-qycexh");
INSERT INTO `wp_es_emaillist` VALUES("4", "", "seoteam@hardshell.ae", "Confirmed", "2015-12-24 06:18:52", "0", "Public", "hkrvbd-gmtawq-pcusen-wnvadz-xjrtwh");
INSERT INTO `wp_es_emaillist` VALUES("5", "", "ianmccuaig@hotmail.com", "Confirmed", "2016-03-17 13:31:11", "0", "Public", "dynkae-ehqcpt-fhejua-ojgmdz-fucigp");
INSERT INTO `wp_es_emaillist` VALUES("6", "", "nkctradeinc@gmail.com", "Confirmed", "2016-07-01 11:14:04", "0", "Public", "qthywa-srtvme-msaybc-npsteo-ezaocn");
INSERT INTO `wp_es_emaillist` VALUES("7", "", "groulz@gmail.com", "Confirmed", "2016-07-08 07:09:43", "0", "Public", "ikqxsp-qpdryx-yurskh-dlpngj-ahkgyb");
INSERT INTO `wp_es_emaillist` VALUES("8", "", "Sawyer.Lawrence1@Gmail.com", "Confirmed", "2016-09-25 00:10:46", "0", "Public", "xifdqy-pkghzr-gzpcai-uhlowe-xprfne");
INSERT INTO `wp_es_emaillist` VALUES("9", "", "c.durocher@aol.fr", "Unconfirmed", "2016-12-26 00:31:05", "0", "Public", "cbdomr-slfwbt-bgrqpj-wuvjem-qvlsmd");

/* INSERT TABLE DATA: wp_es_notification */
INSERT INTO `wp_es_notification` VALUES("1", " ##Outfit of the day## -- ##Streetstyle## -- ##Uncategorized## ", "Public", "1", "Enable");

/* INSERT TABLE DATA: wp_es_pluginconfig */
INSERT INTO `wp_es_pluginconfig` VALUES("1", "Admin", "prem@abacusdesk.co.in", "WP HTML MAIL", "YES", "prem@abacusdesk.co.in", "Hardshell Us New email subscription", "Hi Admin, \r\n\r\nWe have received a request to subscribe new email address to receive emails from our website. \r\n\r\nEmail: ###EMAIL### \r\nName : ###NAME### \r\n\r\nThank You\r\nHardshell Us", "YES", "Hardshell Us Welcome to our newsletter", "Hi ###NAME###, \r\n\r\nWe have received a request to subscribe this email address to receive newsletter from our website. \r\n\r\nThank You\r\nHardshell Us", "Double Opt In", "Hardshell Us confirm subscription", "Hi ###NAME###, \r\n\r\nA newsletter subscription request for this email address was received. Please confirm it by <a href=\'###LINK###\'>clicking here</a>. If you cannot click the link, please use the following link. \r\n\r\n ###LINK### \r\n\r\nThank You\r\nHardshell Us", "http://www.hardshell.com/?es=optin&db=###DBID###&email=###EMAIL###&guid=###GUID###", "http://www.hardshell.com/?es=unsubscribe&db=###DBID###&email=###EMAIL###&guid=###GUID###", "No longer interested email from Hardshell Us?. Please <a href=\'###LINK###\'>click here</a> to unsubscribe", "Thank You, You have been successfully unsubscribed. You will no longer hear from us.", "Thank You, You have been successfully subscribed to our newsletter.", "Oops.. This subscription cant be completed, sorry. The email address is blocked or already subscribed. Thank you.", "Oops.. We are getting some technical error. Please try again or contact admin.");

/* INSERT TABLE DATA: wp_es_templatetable */
INSERT INTO `wp_es_templatetable` VALUES("1", "New post published ###POSTTITLE###", "Hello ###NAME###,\r\n\r\nWe have published new blog in our website. ###POSTTITLE###\r\n###POSTDESC###\r\nYou may view the latest post at ###POSTLINK###\r\nYou received this e-mail because you asked to be notified when new updates are posted.\r\n\r\nThanks & Regards\r\nAdmin", "Published", "Dynamic Template");
INSERT INTO `wp_es_templatetable` VALUES("2", "Post notification ###POSTTITLE###", "Hello ###EMAIL###,\r\n\r\nWe have published new blog in our website. ###POSTTITLE###\r\n###POSTIMAGE###\r\n###POSTFULL###\r\nYou may view the latest post at ###POSTLINK###\r\nYou received this e-mail because you asked to be notified when new updates are posted.\r\n\r\nThanks & Regards\r\nAdmin", "Published", "Dynamic Template");
INSERT INTO `wp_es_templatetable` VALUES("3", "Hello World Newsletter", "<strong style=\"color: #990000\"> Email subscribersr</strong><p>Email subscribers plugin has options to send newsletters to subscribers. It has a separate page with HTML editor to create a HTML newsletter. Also have options to send notification email to subscribers when new posts are published to your blog. Separate page available to include and exclude categories to send notifications. Using plugin Import and Export options admins can easily import registered users and commenters to subscriptions list.</p> <strong style=\"color: #990000\">Plugin Features</strong><ol> <li>Send notification email to subscribers when new posts are published.</li> <li>Subscription box.</li><li>Double opt-in and single opt-in facility for subscriber.</li> <li>Email notification to admin when user signs up (Optional).</li> <li>Automatic welcome mail to subscriber (Optional).</li> <li>Unsubscribe link in the mail.</li> <li>Import/Export subscriber emails.</li> <li>HTML editor to compose newsletter.</li> </ol> <p>Plugin live demo and video tutorial available on the official website. Check official website for more information.</p> <strong>Thanks & Regards</strong><br>Admin", "Published", "Static Template");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://www.hardshell.com", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://www.hardshell.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Hard Shell USA", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@hardshell.us", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:21:{i:0;s:29:\"acf-repeater/acf-repeater.php\";i:1;s:63:\"advanced-custom-fields-location-field-add-on/location-field.php\";i:2;s:30:\"advanced-custom-fields/acf.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:79:\"custom-related-products-for-woocommerce/woocommerce-custom-related-products.php\";i:5;s:45:\"disable-wordpress-updates/disable-updates.php\";i:6;s:25:\"duplicator/duplicator.php\";i:7;s:39:\"email-subscribers/email-subscribers.php\";i:8;s:30:\"email-this-page/instaemail.php\";i:9;s:34:\"envato-wordpress-toolkit/index.php\";i:10;s:64:\"fedex-woocommerce-shipping-method/fedex-woocommerce-shipping.php\";i:11;s:27:\"js_composer/js_composer.php\";i:12;s:47:\"really-simple-captcha/really-simple-captcha.php\";i:13;s:23:\"revslider/revslider.php\";i:14;s:41:\"simplified-social-share/social9_share.php\";i:15;s:51:\"woocommerce-breadcrumbs/woocommerce-breadcrumbs.php\";i:16;s:27:\"woocommerce/woocommerce.php\";i:17;s:41:\"wordpress-importer/wordpress-importer.php\";i:18;s:24:\"wordpress-seo/wp-seo.php\";i:19;s:33:\"yith-woocommerce-compare/init.php\";i:20;s:34:\"yith-woocommerce-wishlist/init.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "a:5:{i:0;s:65:\"/home/mainhardshe/public_html/wp-content/themes/oxygen/header.php\";i:2;s:64:\"/home/mainhardshe/public_html/wp-content/themes/oxygen/style.css\";i:3;s:64:\"/home/mainhardshe/public_html/wp-content/themes/oxygen/index.php\";i:4;s:76:\"/home/mainhardshe/public_html/wp-content/themes/oxygen/analyticstracking.php\";i:5;s:63:\"/home/mainhardshe/public_html/wp-content/themes/oxygen/home.php\";}", "yes");
INSERT INTO `wp_options` VALUES("41", "template", "oxygen", "yes");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "oxygen", "yes");
INSERT INTO `wp_options` VALUES("43", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("45", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("46", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("47", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("48", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("49", "db_version", "35700", "yes");
INSERT INTO `wp_options` VALUES("50", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("51", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("52", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("53", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("54", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("55", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("56", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("57", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("58", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("61", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("64", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_link_type", "file", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("69", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("71", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("73", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("74", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("75", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("76", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("77", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("78", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_text", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:202:\"<a href=\"http://www.hardshell.com\"><img src=\"http://www.hardshell.com/wp-content/uploads/2015/12/hardshell-logo.png\"></a>\r\n\r\n© 2016 Hardshell Us | All rights are reserved <br> \r\n\r\n[lab_social_networks]\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("82", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("83", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("84", "page_for_posts", "600", "yes");
INSERT INTO `wp_options` VALUES("85", "page_on_front", "897", "yes");
INSERT INTO `wp_options` VALUES("86", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("89", "initial_db_version", "33056", "yes");
INSERT INTO `wp_options` VALUES("90", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:133:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:16:\"aiosp_manage_seo\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:0;s:12:\"delete_posts\";b:0;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop Manager\";s:12:\"capabilities\";a:110:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("91", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("92", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "sidebars_widgets", "a:8:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:10:\"nav_menu-4\";i:1;s:24:\"yith-woocompare-widget-2\";i:2;s:25:\"woocommerce_widget_cart-1\";}s:12:\"blog_sidebar\";a:2:{i:0;s:14:\"recent-posts-2\";i:1;s:8:\"search-2\";}s:20:\"footer_about_sidebar\";a:1:{i:0;s:6:\"text-2\";}s:25:\"footer_newsletter_sidebar\";a:1:{i:0;s:19:\"email-subscribers-2\";}s:14:\"footer_sidebar\";a:3:{i:0;s:10:\"nav_menu-2\";i:1;s:10:\"nav_menu-3\";i:2;s:10:\"nav_menu-5\";}s:12:\"shop_sidebar\";a:1:{i:0;s:38:\"woocommerce_recently_viewed_products-2\";}s:19:\"shop_footer_sidebar\";a:4:{i:0;s:22:\"woocommerce_products-2\";i:1;s:22:\"woocommerce_products-3\";i:2;s:22:\"woocommerce_products-4\";i:3;s:22:\"woocommerce_products-5\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("98", "cron", "a:12:{i:1487574477;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1487575132;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1487591663;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1487592004;a:2:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1487593332;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1487617675;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1487617676;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1487617680;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1487635200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1487833812;a:1:{s:18:\"wpseo_onpage_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1488844800;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1487573967;s:7:\"updates\";a:0:{}s:15:\"version_checked\";s:3:\"4.4\";s:7:\"checked\";a:1:{s:6:\"oxygen\";s:5:\"3.8.6\";}}", "yes");
INSERT INTO `wp_options` VALUES("108", "_transient_random_seed", "2a36411fed29c58f3429b9bd1caca2f9", "yes");
INSERT INTO `wp_options` VALUES("117", "theme_mods_twentyfifteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1450353266;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("118", "current_theme", "Oxygen", "yes");
INSERT INTO `wp_options` VALUES("119", "theme_mods_oxygen", "a:104:{s:9:\"logo_text\";s:14:\"Hardshell U.S.\";s:17:\"use_uploaded_logo\";s:1:\"1\";s:17:\"custom_logo_image\";s:72:\"http://www.hardshell.com/wp-content/uploads/2016/05/hardshell-logo-1.png\";s:28:\"custom_logo_image_responsive\";s:0:\"\";s:21:\"custom_logo_max_width\";s:0:\"\";s:11:\"header_type\";s:6:\"2-gray\";s:21:\"sidebar_menu_position\";i:1;s:26:\"sidebar_menu_links_display\";s:9:\"Collapsed\";s:18:\"header_sticky_menu\";i:1;s:18:\"header_menu_search\";s:1:\"0\";s:16:\"cart_ribbon_show\";i:1;s:17:\"cart_ribbon_image\";s:85:\"http://www.hardshell.com/wp-content/themes/oxygen/assets/images/cart-icon-1-black.png\";s:20:\"cart_ribbon_position\";i:0;s:15:\"top_menu_social\";i:0;s:18:\"social_mobile_menu\";i:0;s:15:\"top_menu_mobile\";i:0;s:14:\"footer_widgets\";i:1;s:22:\"footer_widgets_columns\";s:18:\"[1/4] Four Columns\";s:11:\"footer_text\";s:0:\"\";s:16:\"google_analytics\";s:701:\"<script>\r\n  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\'script\',\'https://www.google-analytics.com/analytics.js\',\'ga\');\r\n\r\n  ga(\'create\', \'UA-76613641-1\', \'auto\');\r\n  ga(\'send\', \'pageview\');\r\n\r\n</script>\r\n\r\n\r\n\r\n\r\n<script src=\"//static.getclicky.com/js\" type=\"text/javascript\"></script>\r\n\r\n<script type=\"text/javascript\">try{ clicky.init(100942980); }catch(e){}</script>\r\n<noscript><p><img alt=\"Clicky\" width=\"1\" height=\"1\" src=\"//in.getclicky.com/100942980ns.gif\" /></p></noscript>\";s:15:\"shop_title_show\";i:1;s:14:\"shop_quickview\";i:1;s:17:\"shop_sorting_show\";i:1;s:16:\"shop_rating_show\";i:1;s:21:\"shop_sale_ribbon_show\";i:1;s:33:\"shop_featured_product_ribbon_show\";i:1;s:29:\"shop_product_category_listing\";i:1;s:26:\"shop_product_price_listing\";i:1;s:24:\"shop_add_to_cart_listing\";i:1;s:22:\"shop_cart_counter_ajax\";i:0;s:17:\"shop_catalog_mode\";i:0;s:29:\"shop_catalog_mode_hide_prices\";i:0;s:22:\"shop_item_preview_type\";s:4:\"None\";s:27:\"shop_catalog_thumbnail_size\";s:7:\"default\";s:12:\"shop_sidebar\";s:21:\"Show Sidebar on Right\";s:19:\"shop_sidebar_footer\";i:0;s:27:\"shop_sidebar_footer_columns\";s:1:\"4\";s:22:\"shop_single_fullscreen\";i:1;s:28:\"shop_single_sale_ribbon_show\";i:1;s:21:\"shop_single_next_prev\";i:1;s:28:\"shop_single_product_category\";i:1;s:21:\"shop_single_meta_show\";i:1;s:19:\"shop_single_sidebar\";s:12:\"Hide Sidebar\";s:29:\"shop_single_auto_rotate_image\";s:0:\"\";s:22:\"shop_products_per_page\";s:6:\"4 rows\";s:30:\"shop_related_products_per_page\";i:4;s:18:\"shop_share_product\";i:0;s:27:\"shop_share_product_networks\";a:2:{s:7:\"visible\";a:6:{s:7:\"placebo\";s:7:\"placebo\";s:2:\"fb\";s:8:\"Facebook\";s:2:\"tw\";s:7:\"Twitter\";s:2:\"gp\";s:11:\"Google Plus\";s:2:\"pi\";s:9:\"Pinterest\";s:2:\"em\";s:5:\"Email\";}s:6:\"hidden\";a:3:{s:7:\"placebo\";s:7:\"placebo\";s:3:\"lin\";s:8:\"LinkedIn\";s:3:\"tlr\";s:6:\"Tumblr\";}}s:15:\"blog_thumbnails\";i:1;s:22:\"blog_single_thumbnails\";i:1;s:27:\"blog_thumbnail_hover_effect\";i:1;s:16:\"blog_author_name\";i:1;s:16:\"blog_author_info\";i:1;s:13:\"blog_category\";i:1;s:14:\"blog_post_date\";i:1;s:9:\"blog_tags\";i:1;s:19:\"blog_comments_count\";i:1;s:21:\"blog_sidebar_position\";s:5:\"Right\";s:24:\"blog_pagination_position\";s:6:\"Center\";s:23:\"blog_gallery_autoswitch\";s:0:\"\";s:21:\"blog_thumbnail_height\";s:0:\"\";s:16:\"blog_share_story\";i:0;s:25:\"blog_share_story_networks\";a:2:{s:7:\"visible\";a:7:{s:7:\"placebo\";s:7:\"placebo\";s:2:\"fb\";s:8:\"Facebook\";s:2:\"tw\";s:7:\"Twitter\";s:3:\"lin\";s:8:\"LinkedIn\";s:2:\"pi\";s:9:\"Pinterest\";s:3:\"tlr\";s:6:\"Tumblr\";s:2:\"gp\";s:11:\"Google Plus\";}s:6:\"hidden\";a:4:{s:7:\"placebo\";s:7:\"placebo\";s:2:\"pi\";s:9:\"Pinterest\";s:2:\"em\";s:5:\"Email\";s:2:\"vk\";s:9:\"VKontakte\";}}s:20:\"search_results_count\";i:4;s:17:\"search_post_types\";a:4:{s:4:\"post\";s:1:\"1\";s:4:\"page\";s:1:\"1\";s:7:\"product\";s:1:\"1\";s:11:\"testimonial\";s:1:\"0\";}s:13:\"favicon_image\";s:63:\"http://www.hardshell.com/wp-content/uploads/2015/12/favicon.png\";s:16:\"apple_touch_icon\";s:63:\"http://www.hardshell.com/wp-content/uploads/2015/12/favicon.png\";s:12:\"font_primary\";s:4:\"none\";s:14:\"font_secondary\";s:4:\"none\";s:14:\"font_size_base\";s:2:\"14\";s:17:\"font_to_lowercase\";s:12:\"Default Case\";s:9:\"custom_gf\";s:457:\"<h3 style=\"margin: 0 0 10px;\">Including Custom Google Fonts</h3>\n						If you want to add your personal font to your site (from Google Webfonts) you can apply the font parameters in the below fields.<br />\n						Firstly include the font URL that is given in Google Webfonts site, then enter the name of that font (without <em>font-family:</em>) next to that field.<br />\n						Otherwise, leave the field empty to use default font selected in the list above.\";s:23:\"custom_primary_font_url\";s:62:\"https://fonts.googleapis.com/css?family=Ubuntu:400,300,500,700\";s:24:\"custom_primary_font_name\";s:20:\"\'Ubuntu\', sans-serif\";s:23:\"custom_heading_font_url\";s:62:\"https://fonts.googleapis.com/css?family=Ubuntu:400,300,500,700\";s:24:\"custom_heading_font_name\";s:20:\"\'Ubuntu\', sans-serif\";s:13:\"use_skin_type\";s:79:\"http://www.hardshell.com/wp-content/themes/oxygen/assets/images/skin-type-1.png\";s:15:\"use_custom_skin\";i:0;s:22:\"custom_skin_main_color\";s:0:\"\";s:27:\"custom_skin_menu_link_color\";s:7:\"#333333\";s:28:\"custom_skin_background_color\";s:7:\"#EEEEEE\";s:18:\"custom_css_feature\";s:372:\"<h3 style=\"margin: 0 0 10px;\">Custom CSS in a New Interface</h3>\n						We have created a better interface for adding your custom CSS which is more flexible and includes syntax highlighting. However you can still add custom CSS in the fields below.\n						<br />\n						<br />\n						<a href=\"admin.php?page=laborator_custom_css\" class=\"button\">Go to new Custom CSS Editor</a>\";s:18:\"custom_css_general\";s:0:\"\";s:21:\"custom_css_general_lg\";s:0:\"\";s:21:\"custom_css_general_md\";s:0:\"\";s:21:\"custom_css_general_sm\";s:0:\"\";s:21:\"custom_css_general_xs\";s:0:\"\";s:22:\"custom_css_general_xxs\";s:0:\"\";s:12:\"social_order\";a:2:{s:7:\"visible\";a:5:{s:7:\"placebo\";s:7:\"placebo\";s:2:\"fb\";s:8:\"Facebook\";s:3:\"lin\";s:8:\"LinkedIn\";s:2:\"tw\";s:7:\"Twitter\";s:2:\"gp\";s:7:\"Google+\";}s:6:\"hidden\";a:8:{s:7:\"placebo\";s:7:\"placebo\";s:2:\"yt\";s:7:\"YouTube\";s:2:\"vm\";s:5:\"Vimeo\";s:3:\"drb\";s:8:\"Dribbble\";s:2:\"ig\";s:9:\"Instagram\";s:2:\"pi\";s:9:\"Pinterest\";s:2:\"vk\";s:9:\"VKontakte\";s:2:\"tu\";s:6:\"Tumblr\";}}s:22:\"social_network_link_fb\";s:39:\"https://www.facebook.com/HardShellGroup\";s:22:\"social_network_link_tw\";s:34:\"https://twitter.com/hardshellgroup\";s:23:\"social_network_link_lin\";s:51:\"https://www.linkedin.com/in/hard-shell-usa-439bb3b0\";s:22:\"social_network_link_yt\";s:0:\"\";s:22:\"social_network_link_vm\";s:0:\"\";s:23:\"social_network_link_drb\";s:0:\"\";s:22:\"social_network_link_ig\";s:0:\"\";s:22:\"social_network_link_pi\";s:0:\"\";s:22:\"social_network_link_gp\";s:55:\"https://plus.google.com/u/0/110592478958113362368/posts\";s:22:\"social_network_link_vk\";s:0:\"\";s:22:\"social_network_link_tu\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:9:\"smof_init\";s:31:\"Wed, 08 Jun 2016 11:00:22 +0000\";s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:104;s:8:\"top-menu\";i:105;}}", "yes");
INSERT INTO `wp_options` VALUES("120", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("137", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("138", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("139", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("140", "widget_nav_menu", "a:5:{i:2;a:2:{s:5:\"title\";s:11:\"Information\";s:8:\"nav_menu\";i:144;}i:3;a:2:{s:5:\"title\";s:8:\"Products\";s:8:\"nav_menu\";i:143;}i:4;a:2:{s:5:\"title\";s:10:\"My Account\";s:8:\"nav_menu\";i:145;}i:5;a:2:{s:5:\"title\";s:9:\"Resources\";s:8:\"nav_menu\";i:161;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("141", "widget_laborator_subscribe", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("142", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("143", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("144", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("145", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("147", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:4:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.6.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.6.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.6.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.6.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.6.1\";s:7:\"version\";s:5:\"4.6.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.6.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.6.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.6.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.6.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.6.1\";s:7:\"version\";s:5:\"4.6.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.4.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.5.4.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.5.4-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.5.4-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.5.4\";s:7:\"version\";s:5:\"4.5.4\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.5.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.5.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.4.5-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.4.5-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.4.5-partial-0.zip\";s:8:\"rollback\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.4.5-rollback-0.zip\";}s:7:\"current\";s:5:\"4.4.5\";s:7:\"version\";s:5:\"4.4.5\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:3:\"4.4\";s:9:\"new_files\";s:0:\"\";}}s:12:\"last_checked\";i:1475493301;s:15:\"version_checked\";s:3:\"4.4\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("148", "can_compress_scripts", "1", "yes");
INSERT INTO `wp_options` VALUES("149", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("154", "woocommerce_default_country", "US:IN", "yes");
INSERT INTO `wp_options` VALUES("155", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("156", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("157", "woocommerce_default_customer_address", "geolocation", "yes");
INSERT INTO `wp_options` VALUES("158", "woocommerce_demo_store", "no", "yes");
INSERT INTO `wp_options` VALUES("159", "woocommerce_demo_store_notice", "This is a demo store for testing purposes &mdash; no orders shall be fulfilled.", "no");
INSERT INTO `wp_options` VALUES("160", "woocommerce_currency", "USD", "yes");
INSERT INTO `wp_options` VALUES("161", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `wp_options` VALUES("162", "woocommerce_price_thousand_sep", "", "yes");
INSERT INTO `wp_options` VALUES("163", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("164", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `wp_options` VALUES("165", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("166", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("167", "woocommerce_enable_review_rating", "yes", "no");
INSERT INTO `wp_options` VALUES("168", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("169", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("170", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("171", "woocommerce_shop_page_id", "6", "yes");
INSERT INTO `wp_options` VALUES("172", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `wp_options` VALUES("173", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `wp_options` VALUES("174", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `wp_options` VALUES("175", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("176", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("177", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("178", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("179", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"180\";s:6:\"height\";s:3:\"180\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("180", "woocommerce_enable_lightbox", "no", "yes");
INSERT INTO `wp_options` VALUES("181", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("182", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("183", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("184", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("185", "woocommerce_stock_email_recipient", "prem@abacusdesk.co.in", "no");
INSERT INTO `wp_options` VALUES("186", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("187", "woocommerce_notify_no_stock_amount", "0", "no");
INSERT INTO `wp_options` VALUES("188", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("189", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("190", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("191", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("192", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("193", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("194", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("195", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("196", "woocommerce_shipping_tax_class", "title", "yes");
INSERT INTO `wp_options` VALUES("197", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("198", "woocommerce_tax_classes", "Reduced Rate\r\nZero Rate", "yes");
INSERT INTO `wp_options` VALUES("199", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("200", "woocommerce_tax_display_cart", "excl", "no");
INSERT INTO `wp_options` VALUES("201", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("202", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("203", "woocommerce_enable_coupons", "yes", "no");
INSERT INTO `wp_options` VALUES("204", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("205", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("206", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("207", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("208", "woocommerce_cart_page_id", "7", "yes");
INSERT INTO `wp_options` VALUES("209", "woocommerce_checkout_page_id", "8", "yes");
INSERT INTO `wp_options` VALUES("210", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("211", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("212", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("213", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("214", "woocommerce_calc_shipping", "yes", "yes");
INSERT INTO `wp_options` VALUES("215", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("216", "woocommerce_shipping_cost_requires_address", "no", "no");
INSERT INTO `wp_options` VALUES("217", "woocommerce_shipping_method_format", "", "no");
INSERT INTO `wp_options` VALUES("218", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("219", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("220", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_myaccount_page_id", "9", "yes");
INSERT INTO `wp_options` VALUES("222", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("224", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("225", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("226", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("227", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("228", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("229", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_options` VALUES("230", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("231", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("232", "woocommerce_email_from_name", "Hardshell Us", "no");
INSERT INTO `wp_options` VALUES("233", "woocommerce_email_from_address", "prem@abacusdesk.co.in", "no");
INSERT INTO `wp_options` VALUES("234", "woocommerce_email_header_image", "http://www.hardshell.com/wp-content/uploads/2015/12/hardshell-logo-red.png", "no");
INSERT INTO `wp_options` VALUES("235", "woocommerce_email_footer_text", "HardShell US", "no");
INSERT INTO `wp_options` VALUES("236", "woocommerce_email_base_color", "#557da1", "no");
INSERT INTO `wp_options` VALUES("237", "woocommerce_email_background_color", "#f5f5f5", "no");
INSERT INTO `wp_options` VALUES("238", "woocommerce_email_body_background_color", "#fdfdfd", "no");
INSERT INTO `wp_options` VALUES("239", "woocommerce_email_text_color", "#505050", "no");
INSERT INTO `wp_options` VALUES("240", "woocommerce_api_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("242", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("245", "woocommerce_db_version", "2.4.12", "yes");
INSERT INTO `wp_options` VALUES("246", "woocommerce_version", "2.4.12", "yes");
INSERT INTO `wp_options` VALUES("248", "woocommerce_language_pack_version", "a:2:{i:0;s:6:\"2.4.12\";i:1;s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("249", "revslider-update-check-short", "1487569560", "yes");
INSERT INTO `wp_options` VALUES("250", "revslider-templates-check", "1487395829", "yes");
INSERT INTO `wp_options` VALUES("251", "rs-templates-new", "", "yes");
INSERT INTO `wp_options` VALUES("252", "rs-templates", "a:2:{s:6:\"slider\";a:137:{i:0;a:20:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:310:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:20:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:20:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:20:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:439:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:20:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:20:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:20:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:20:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:20:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:20:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:20:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:440:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:20:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:20:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:20:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:20:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:20:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:20:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:20:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:447:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:20:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:20:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:20:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:20:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:20:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:20:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:20:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:346:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:20:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:310:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:20:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:20:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:438:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:20:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:436:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:20:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:20:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:20:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:20:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:20:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:20:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:438:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:20:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:630:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:20:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:508:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:20:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:20:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:20:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:518:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:20:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:20:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:20:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:323:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:20:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:316:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:21:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:45;a:20:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:443:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:20:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:20:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:444:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:20:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:444:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:20:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:20:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:20:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:691:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:20:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:693:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:20:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:532:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:20:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:543:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:20:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:661:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:20:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:508:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:20:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:20:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:20:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:20:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:20:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:20:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:20:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:441:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:20:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:447:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:21:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:572:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/revslider-doc/add-on-whiteboard/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:66;a:21:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:516:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:67;a:23:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:23:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:23:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:23:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:23:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:448:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:23:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:23:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:23:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:23:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:23:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:23:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:23:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:23:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:23:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:23:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:23:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:20:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:20:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:20:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:20:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:23:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:23:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:23:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:23:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:23:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:23:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:23:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:23:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:20:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:20:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:23:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:23:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:23:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:23:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:23:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:20:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:20:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:21:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:105;a:20:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:426:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/revslider-doc/add-on-typewriter/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:106;a:20:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:107;a:23:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:108;a:23:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:109;a:23:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:110;a:23:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:111;a:23:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:23:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:23:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:23:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:23:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:23:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:117;a:23:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:118;a:23:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:119;a:23:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:120;a:23:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:121;a:23:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:23:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:23:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:23:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:23:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:568:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:20:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:343:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:127;a:20:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:341:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:128;a:20:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:129;a:20:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:164:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:130;a:20:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:468:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:131;a:20:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:20:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:463:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:20:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:421:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:20:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:2:\"[]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:135;a:20:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:20:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:352:\"[{\"path\":\"revslider-404-addon\\/revslider-404-addon.php\",\"name\":\"404 Page Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"},{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}}s:6:\"slides\";a:137:{s:16:\"classic-carousel\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"classic-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"classic-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"classic-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"classic-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"classic-carousel/slide5.jpg\";}}s:13:\"classicslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"classicslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"classicslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"classicslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"classicslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:24:\"classicslider/slide5.jpg\";}}s:11:\"contenttabs\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contenttabs/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contenttabs/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contenttabs/slide3.jpg\";}}s:13:\"facebook-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"facebook-feed/slide1.jpg\";}}s:7:\"fashion\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"fashion/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"fashion/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"fashion/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"fashion/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"fashion/slide5.jpg\";}}s:14:\"flickr-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"flickr-gallery/slide1.jpg\";}}s:3:\"gym\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"gym/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:14:\"gym/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:14:\"gym/slide3.jpg\";}}s:18:\"highlight-carousel\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-carousel/slide4.jpg\";}}s:18:\"highlight-showcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-showcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-showcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-showcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-showcase/slide4.jpg\";}}s:10:\"image-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"imagehero/slide1.jpg\";}}s:13:\"insta-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"insta-gallery/slide1.jpg\";}}s:19:\"levanorestaurantbar\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"levanorestaurantbar/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"levanorestaurantbar/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"levanorestaurantbar/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:30:\"levanorestaurantbar/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:30:\"levanorestaurantbar/slide5.jpg\";}}s:11:\"mainfeature\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"mainfeature/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"mainfeature/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"mainfeature/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"mainfeature/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"mainfeature/slide7.jpg\";}}s:17:\"media-gallery-two\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"media-gallery-two/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"media-gallery-two/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"media-gallery-two/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"media-gallery-two/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"media-gallery-two/slide6.jpg\";}}s:23:\"media-carousel-autoplay\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide6.jpg\";}}s:21:\"news-background-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"news-bg-video/slide1.jpg\";}}s:12:\"news-gallery\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"news-gallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"news-gallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"news-gallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"news-gallery/slide4.jpg\";}}s:23:\"news-gallery-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"news-gallery-post-based/slide1.jpg\";}}s:9:\"news-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"news-hero/slide1.jpg\";}}s:10:\"news-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"news-video/slide1.jpg\";}}s:15:\"newsletter-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"newsletter-hero/slide1.jpg\";}}s:10:\"notgeneric\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"notgeneric/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"notgeneric/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"notgeneric/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"notgeneric/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"notgeneric/slide5.jpg\";}}s:11:\"photography\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"photography/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"photography/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"photography/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"photography/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:22:\"photography/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:22:\"photography/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"photography/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:22:\"photography/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:22:\"photography/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:23:\"photography/slide10.jpg\";}}s:20:\"photography-carousel\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"photography-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"photography-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"photography-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"photography-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:31:\"photography-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:31:\"photography-carousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:31:\"photography-carousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:31:\"photography-carousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:31:\"photography-carousel/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:32:\"photography-carousel/slide10.jpg\";}}s:16:\"search-form-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"search-form-hero/slide1.jpg\";}}s:16:\"showcasecarousel\";a:9:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"showcasecarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"showcasecarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"showcasecarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"showcasecarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"showcasecarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:27:\"showcasecarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:27:\"showcasecarousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:27:\"showcasecarousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:27:\"showcasecarousel/slide9.jpg\";}}s:11:\"sports-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"sportshero/slide1.jpg\";}}s:12:\"twitter-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"twitter-feed/slide1.jpg\";}}s:13:\"vimeo-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"vimeo-gallery/slide1.jpg\";}}s:9:\"vimeohero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"vimeohero/slide1.jpg\";}}s:16:\"web-product-dark\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"web-product-dark/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"web-product-dark/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"web-product-dark/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"web-product-dark/slide4.jpg\";}}s:21:\"web-product-dark-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"web-product-dark-hero/slide1.jpg\";}}s:22:\"web-product-light-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"web-product-light-hero/slide1.jpg\";}}s:15:\"webproductlight\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"webproductlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"webproductlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"webproductlight/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"webproductlight/slide4.jpg\";}}s:15:\"youtube-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"youtube-gallery/slide1.jpg\";}}s:11:\"youtubehero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"youtubehero/slide1.jpg\";}}s:13:\"scroll-effect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"scrolleffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"scrolleffect/slide3.jpg\";}}s:12:\"content-zoom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contentzoom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contentzoom/slide3.jpg\";}}s:13:\"food-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"foodcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"foodcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"foodcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"foodcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"foodcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"foodcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"foodcarousel/slide7.jpg\";}}s:14:\"rotating-words\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";}}s:22:\"travel-static-captions\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"travel-static-captions/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"travel-static-captions/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:33:\"travel-static-captions/slide4.jpg\";}}s:7:\"concept\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"concept/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"concept/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"concept/slide3.jpg\";}}s:17:\"fullscreen-button\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"fullscreen-button/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"fullscreen-button/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"fullscreen-button/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"fullscreen-button/slide5.jpg\";}}s:15:\"creativefreedom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"creativefreedom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"creativefreedom/slide3.jpg\";}}s:13:\"parallaxscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";}}s:15:\"slidingoverlays\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"slidingoverlays/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"slidingoverlays/slide3.jpg\";}}s:25:\"web-product-light-hero-3d\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";}}s:6:\"woobig\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";}}s:16:\"woocommercesmall\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";}}s:10:\"finedining\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";}}s:12:\"agency-intro\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";}}s:7:\"ourteam\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"ourteam/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"ourteam/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"ourteam/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"ourteam/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"ourteam/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:18:\"ourteam/slide7.jpg\";}}s:17:\"our-team-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"ourteamcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"ourteamcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"ourteamcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"ourteamcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"ourteamcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:26:\"ourteamcarousel/slide7.jpg\";}}s:13:\"betteryoutube\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"betteryoutube/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"betteryoutube/slide3.jpg\";}}s:19:\"agencywebsiteheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"agencywebsiteheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"agencywebsiteheader/slide3.jpg\";}}s:10:\"comingsoon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"comingsoon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"comingsoon/slide3.jpg\";}}s:9:\"snowscene\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowscene/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowscene/slide3.jpg\";}}s:8:\"rockband\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";}}s:16:\"sleeklandingpage\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"sleeklandingpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"sleeklandingpage/slide3.jpg\";}}s:14:\"applandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";}}s:9:\"deskscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";}}s:15:\"cleannewsslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"cleannewsslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"cleannewsslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"cleannewsslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"cleannewsslider/slide5.jpg\";}}s:12:\"imagegallery\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"imagegallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"imagegallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"imagegallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"imagegallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"imagegallery/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"imagegallery/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:23:\"imagegallery/slide8.jpg\";}}s:19:\"standard-wp-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";}}s:21:\"clean-news-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";}}s:21:\"interactivewhiteboard\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"interactivewhiteboard/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"interactivewhiteboard/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"interactivewhiteboard/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:32:\"interactivewhiteboard/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:32:\"interactivewhiteboard/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:32:\"interactivewhiteboard/slide8.jpg\";}}s:10:\"innovation\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"innovation/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"innovation/slide3.jpg\";}}s:24:\"dark-fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";}}s:21:\"dark-fullsite-block-1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";}}s:27:\"dark-fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide2.jpg\";}}s:30:\"dark-fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide2.jpg\";}}s:30:\"dark-fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide5.jpg\";}}s:34:\"dark-fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";}}s:29:\"dark-fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";}}s:28:\"dark-fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";}}s:19:\"fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";}}s:15:\"fullsite-block1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";}}s:22:\"fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide2.jpg\";}}s:25:\"fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide2.jpg\";}}s:25:\"fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide5.jpg\";}}s:29:\"fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";}}s:24:\"fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";}}s:23:\"fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";}}s:11:\"techjournal\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"techjournal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"techjournal/slide3.jpg\";}}s:13:\"cardealership\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"cardealership/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"cardealership/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"cardealership/slide4.jpg\";}}s:14:\"fullscreenmenu\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fullscreenmenu/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fullscreenmenu/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"fullscreenmenu/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"fullscreenmenu/slide5.jpg\";}}s:17:\"creativefrontpage\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"creativefrontpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"creativefrontpage/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"creativefrontpage/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"creativefrontpage/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"creativefrontpage/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:28:\"creativefrontpage/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:28:\"creativefrontpage/slide8.jpg\";}}s:19:\"websitebuilder-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";}}s:19:\"websitebuilder-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";}}s:22:\"websitebuilder-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";}}s:23:\"websitebuilder-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";}}s:23:\"websitebuilder-discover\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"websitebuilder-discover/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"websitebuilder-discover/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"websitebuilder-discover/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"websitebuilder-discover/slide5.jpg\";}}s:21:\"websitebuilder-slider\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"websitebuilder-slider/slide2.jpg\";}}s:27:\"websitebuilder-calltoaction\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";}}s:21:\"websitebuilder-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";}}s:13:\"focusparallax\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"focusparallax/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"focusparallax/slide3.jpg\";}}s:7:\"duotone\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"duotone/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"duotone/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"duotone/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"duotone/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"duotone/slide6.jpg\";}}s:6:\"r_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";}}s:5:\"rhero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";}}s:7:\"r_about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";}}s:10:\"r_products\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"r_products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"r_products/slide3.jpg\";}}s:6:\"r_info\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";}}s:17:\"inspirationheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";}}s:13:\"magazineposts\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"magazineposts/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"magazineposts/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"magazineposts/slide4.jpg\";}}s:17:\"explorationheader\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"explorationheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"explorationheader/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"explorationheader/slide4.jpg\";}}s:16:\"typewritereffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"typewritereffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"typewritereffect/slide3.jpg\";}}s:15:\"blendmodeheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";}}s:17:\"themeplicity_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";}}s:19:\"themeplicity_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";}}s:18:\"themeplicity_offer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";}}s:21:\"themeplicity_whatwedo\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";}}s:21:\"themeplicity_projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"themeplicity_projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"themeplicity_projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"themeplicity_projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:32:\"themeplicity_projects/slide5.jpg\";s:3:\"img\";s:7:\"Slide 5\";}}s:23:\"themeplicity_whatsgreat\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";}}s:19:\"themeplicity_tables\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";}}s:24:\"themeplicity_contactform\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";}}s:19:\"themeplicity_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";}}s:17:\"NiceAndClean_Menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";}}s:19:\"NiceAndClean_Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";}}s:21:\"NiceAndClean_Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";}}s:18:\"NiceAndClean_About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";}}s:18:\"niceandclean_video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";}}s:23:\"niceandclean_highlights\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";}}s:21:\"NiceAndClean_Projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide5.jpg\";}}s:23:\"niceandclean_textblocks\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";}}s:20:\"niceandclean_callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";}}s:19:\"niceandclean_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";}}s:3:\"80s\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"80s/slide1.jpg\";}}s:10:\"blurslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"blurslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"blurslider/slide3.jpg\";}}s:15:\"ComingSoonAddon\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";}}s:9:\"snowaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowaddon/slide3.jpg\";}}s:19:\"particle-effect-one\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"particle-effect-one/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"particle-effect-one/slide3.jpg\";}}s:19:\"particle-effect-two\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";}}s:21:\"particle-effect-three\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";}}s:15:\"portfolioviewer\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"portfolioviewer/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"portfolioviewer/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"portfolioviewer/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"portfolioviewer/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"portfolioviewer/slide6.jpg\";}}s:11:\"appshowcase\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";}}s:13:\"gravitydesign\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";}}s:12:\"404errorpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("254", "_transient_woocommerce_webhook_ids", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("255", "widget_woocommerce_widget_cart", "a:2:{i:1;a:2:{s:5:\"title\";s:4:\"Cart\";s:13:\"hide_if_empty\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("256", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("257", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("258", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("259", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("260", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("261", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("262", "widget_woocommerce_products", "a:5:{i:2;a:7:{s:5:\"title\";s:17:\"Featured Products\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:3:\"asc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:3;a:7:{s:5:\"title\";s:7:\"On Sale\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:6:\"onsale\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:4;a:7:{s:5:\"title\";s:15:\"Random Products\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"rand\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:5;a:7:{s:5:\"title\";s:9:\"Low Price\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:5:\"price\";s:5:\"order\";s:3:\"asc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("263", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("264", "widget_woocommerce_recently_viewed_products", "a:2:{i:2;a:2:{s:5:\"title\";s:11:\"Recent View\";s:6:\"number\";s:1:\"5\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("265", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("267", "vc_version", "4.7.4", "yes");
INSERT INTO `wp_options` VALUES("269", "acf_version", "4.4.4", "yes");
INSERT INTO `wp_options` VALUES("275", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("276", "revslider_table_version", "1.0.5", "yes");
INSERT INTO `wp_options` VALUES("277", "revslider-global-settings", "a:13:{s:4:\"role\";s:5:\"admin\";s:17:\"includes_globally\";s:2:\"on\";s:18:\"pages_for_includes\";s:0:\"\";s:12:\"js_to_footer\";s:3:\"off\";s:8:\"js_defer\";s:3:\"off\";s:15:\"show_dev_export\";s:3:\"off\";s:19:\"change_font_loading\";s:0:\"\";s:5:\"width\";s:4:\"1240\";s:14:\"width_notebook\";s:4:\"1024\";s:12:\"width_tablet\";s:3:\"778\";s:12:\"width_mobile\";s:3:\"480\";s:18:\"enable_newschannel\";s:2:\"on\";s:11:\"enable_logs\";s:3:\"off\";}", "yes");
INSERT INTO `wp_options` VALUES("278", "revslider_update_version", "5.0.7", "yes");
INSERT INTO `wp_options` VALUES("279", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("282", "yit_recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("283", "yith_wcwl_frontend_css_colors", "s:1159:\"a:10:{s:15:\"add_to_wishlist\";a:3:{s:10:\"background\";s:7:\"#333333\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#333333\";}s:21:\"add_to_wishlist_hover\";a:3:{s:10:\"background\";s:7:\"#4F4F4F\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#4F4F4F\";}s:11:\"add_to_cart\";a:3:{s:10:\"background\";s:7:\"#333333\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#333333\";}s:17:\"add_to_cart_hover\";a:3:{s:10:\"background\";s:7:\"#4F4F4F\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#4F4F4F\";}s:14:\"button_style_1\";a:3:{s:10:\"background\";s:7:\"#333333\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#333333\";}s:20:\"button_style_1_hover\";a:3:{s:10:\"background\";s:7:\"#4F4F4F\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#4F4F4F\";}s:14:\"button_style_2\";a:3:{s:10:\"background\";s:7:\"#FFFFFF\";s:5:\"color\";s:7:\"#858484\";s:12:\"border_color\";s:7:\"#c6c6c6\";}s:20:\"button_style_2_hover\";a:3:{s:10:\"background\";s:7:\"#4F4F4F\";s:5:\"color\";s:7:\"#FFFFFF\";s:12:\"border_color\";s:7:\"#4F4F4F\";}s:14:\"wishlist_table\";a:3:{s:10:\"background\";s:7:\"#FFFFFF\";s:5:\"color\";s:7:\"#6d6c6c\";s:12:\"border_color\";s:7:\"#FFFFFF\";}s:7:\"headers\";a:1:{s:10:\"background\";s:7:\"#F4F4F4\";}}\";", "yes");
INSERT INTO `wp_options` VALUES("284", "yith_wcwl_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("285", "yith_wcwl_wishlist_title", "My wishlist on Hardshell Us", "yes");
INSERT INTO `wp_options` VALUES("286", "yith_wcwl_wishlist_page_id", "4", "yes");
INSERT INTO `wp_options` VALUES("287", "yith_wcwl_redirect_cart", "no", "yes");
INSERT INTO `wp_options` VALUES("288", "yith_wcwl_remove_after_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("289", "yith_wcwl_add_to_wishlist_text", "Add to Wishlist", "yes");
INSERT INTO `wp_options` VALUES("290", "yith_wcwl_browse_wishlist_text", "Browse Wishlist", "yes");
INSERT INTO `wp_options` VALUES("291", "yith_wcwl_already_in_wishlist_text", "The product is already in the wishlist!", "yes");
INSERT INTO `wp_options` VALUES("292", "yith_wcwl_product_added_text", "Product added!", "yes");
INSERT INTO `wp_options` VALUES("293", "yith_wcwl_add_to_cart_text", "Add to Cart", "yes");
INSERT INTO `wp_options` VALUES("294", "yith_wcwl_price_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("295", "yith_wcwl_add_to_cart_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("296", "yith_wcwl_stock_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("297", "yith_wcwl_show_dateadded", "no", "yes");
INSERT INTO `wp_options` VALUES("298", "yith_wcwl_repeat_remove_button", "no", "yes");
INSERT INTO `wp_options` VALUES("299", "yith_wcwl_use_button", "no", "yes");
INSERT INTO `wp_options` VALUES("300", "yith_wcwl_custom_css", "", "yes");
INSERT INTO `wp_options` VALUES("301", "yith_wcwl_frontend_css", "yes", "yes");
INSERT INTO `wp_options` VALUES("302", "yith_wcwl_rounded_corners", "yes", "yes");
INSERT INTO `wp_options` VALUES("303", "yith_wcwl_add_to_wishlist_icon", "none", "yes");
INSERT INTO `wp_options` VALUES("304", "yith_wcwl_add_to_cart_icon", "fa-shopping-cart", "yes");
INSERT INTO `wp_options` VALUES("305", "yith_wcwl_share_fb", "no", "yes");
INSERT INTO `wp_options` VALUES("306", "yith_wcwl_share_twitter", "no", "yes");
INSERT INTO `wp_options` VALUES("307", "yith_wcwl_share_pinterest", "no", "yes");
INSERT INTO `wp_options` VALUES("308", "yith_wcwl_share_googleplus", "no", "yes");
INSERT INTO `wp_options` VALUES("309", "yith_wcwl_share_email", "no", "yes");
INSERT INTO `wp_options` VALUES("310", "yith_wcwl_socials_title", "My wishlist on Hardshell Us", "yes");
INSERT INTO `wp_options` VALUES("311", "yith_wcwl_socials_text", "", "yes");
INSERT INTO `wp_options` VALUES("312", "yith_wcwl_socials_image_url", "", "yes");
INSERT INTO `wp_options` VALUES("313", "yith_wfbt_enable_integration", "no", "yes");
INSERT INTO `wp_options` VALUES("314", "yith-wcwl-page-id", "4", "yes");
INSERT INTO `wp_options` VALUES("315", "yith_wcwl_version", "2.0.12", "yes");
INSERT INTO `wp_options` VALUES("316", "yith_wcwl_db_version", "2.0.0", "yes");
INSERT INTO `wp_options` VALUES("317", "yith_wcwl_general_videobox", "", "yes");
INSERT INTO `wp_options` VALUES("318", "_transient_timeout_geoip_::1", "1450958592", "no");
INSERT INTO `wp_options` VALUES("319", "_transient_geoip_::1", "", "no");
INSERT INTO `wp_options` VALUES("320", "_transient_timeout_external_ip_address_::1", "1450958594", "no");
INSERT INTO `wp_options` VALUES("321", "_transient_external_ip_address_::1", "103.203.254.85", "no");
INSERT INTO `wp_options` VALUES("322", "_transient_timeout_geoip_103.203.254.85", "1450958603", "no");
INSERT INTO `wp_options` VALUES("323", "_transient_geoip_103.203.254.85", "", "no");
INSERT INTO `wp_options` VALUES("324", "revslider-valid", "true", "yes");
INSERT INTO `wp_options` VALUES("325", "revslider-static-css", ".tp-caption a {\ncolor:#ff7302;\ntext-shadow:none;\n-webkit-transition:all 0.2s ease-out;\n-moz-transition:all 0.2s ease-out;\n-o-transition:all 0.2s ease-out;\n-ms-transition:all 0.2s ease-out;\n}\n\n.tp-caption a:hover {\ncolor:#ffa902;\n}\n\n.largeredbtn {  \nfont-family: \"Raleway\", sans-serif;\nfont-weight: 900;\nfont-size: 16px;\nline-height: 60px;\ncolor: #fff !important;\ntext-decoration: none;\npadding-left: 40px;\npadding-right: 80px;\npadding-top: 22px;\npadding-bottom: 22px;\nbackground: rgb(234,91,31); /* Old browsers */\nbackground: -moz-linear-gradient(top,  rgba(234,91,31,1) 0%, rgba(227,58,12,1) 100%); /* FF3.6+ */\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(234,91,31,1)), color-stop(100%,rgba(227,58,12,1))); /* Chrome,Safari4+ */\nbackground: -webkit-linear-gradient(top,  rgba(234,91,31,1) 0%,rgba(227,58,12,1) 100%); /* Chrome10+,Safari5.1+ */\nbackground: -o-linear-gradient(top,  rgba(234,91,31,1) 0%,rgba(227,58,12,1) 100%); /* Opera 11.10+ */\nbackground: -ms-linear-gradient(top,  rgba(234,91,31,1) 0%,rgba(227,58,12,1) 100%); /* IE10+ */\nbackground: linear-gradient(to bottom,  rgba(234,91,31,1) 0%,rgba(227,58,12,1) 100%); /* W3C */\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#ea5b1f\', endColorstr=\'#e33a0c\',GradientType=0 ); /* IE6-9 */\n}\n\n.largeredbtn:hover {\nbackground: rgb(227,58,12); /* Old browsers */\nbackground: -moz-linear-gradient(top,  rgba(227,58,12,1) 0%, rgba(234,91,31,1) 100%); /* FF3.6+ */\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(227,58,12,1)), color-stop(100%,rgba(234,91,31,1))); /* Chrome,Safari4+ */\nbackground: -webkit-linear-gradient(top,  rgba(227,58,12,1) 0%,rgba(234,91,31,1) 100%); /* Chrome10+,Safari5.1+ */\nbackground: -o-linear-gradient(top,  rgba(227,58,12,1) 0%,rgba(234,91,31,1) 100%); /* Opera 11.10+ */\nbackground: -ms-linear-gradient(top,  rgba(227,58,12,1) 0%,rgba(234,91,31,1) 100%); /* IE10+ */\nbackground: linear-gradient(to bottom,  rgba(227,58,12,1) 0%,rgba(234,91,31,1) 100%); /* W3C */\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#e33a0c\', endColorstr=\'#ea5b1f\',GradientType=0 ); /* IE6-9 */      \n}\n\n.fullrounded img {\n   -webkit-border-radius: 400px;\n-moz-border-radius: 400px;\nborder-radius: 400px; \n  }", "yes");
INSERT INTO `wp_options` VALUES("333", "_transient_product_query-transient-version", "1477046754", "yes");
INSERT INTO `wp_options` VALUES("335", "_transient_product-transient-version", "1477046755", "yes");
INSERT INTO `wp_options` VALUES("346", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("349", "revslider-update-check", "1450354698", "yes");
INSERT INTO `wp_options` VALUES("350", "revslider_update_info", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("364", "WPLANG", "", "yes");
INSERT INTO `wp_options` VALUES("382", "product_shipping_class_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("428", "_transient_timeout_wc_product_children_177", "1453530697", "no");
INSERT INTO `wp_options` VALUES("429", "_transient_wc_product_children_177", "a:2:{s:7:\"visible\";a:0:{}s:3:\"all\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("531", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491450354591", "1452947619", "no");
INSERT INTO `wp_options` VALUES("532", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("533", "_transient_timeout_wc_rating_count_1011450354591", "1452947619", "no");
INSERT INTO `wp_options` VALUES("534", "_transient_wc_rating_count_1011450354591", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("535", "_transient_timeout_wc_average_rating_1011450354591", "1452947619", "no");
INSERT INTO `wp_options` VALUES("536", "_transient_wc_average_rating_1011450354591", "0", "no");
INSERT INTO `wp_options` VALUES("537", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931450354591", "1452947619", "no");
INSERT INTO `wp_options` VALUES("538", "_transient_wc_var_pricese5e3a7ec74d543849a65931450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("539", "_transient_timeout_wc_rating_count_1431450354591", "1452947619", "no");
INSERT INTO `wp_options` VALUES("540", "_transient_wc_rating_count_1431450354591", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("541", "_transient_timeout_wc_average_rating_1431450354591", "1452947619", "no");
INSERT INTO `wp_options` VALUES("542", "_transient_wc_average_rating_1431450354591", "0", "no");
INSERT INTO `wp_options` VALUES("543", "_transient_timeout_wc_var_prices1582135a424567c0f6cd7c1450354591", "1452947619", "no");
INSERT INTO `wp_options` VALUES("544", "_transient_wc_var_prices1582135a424567c0f6cd7c1450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("545", "_transient_timeout_wc_rating_count_1461450354591", "1452947619", "no");
INSERT INTO `wp_options` VALUES("546", "_transient_wc_rating_count_1461450354591", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("547", "_transient_timeout_wc_average_rating_1461450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("548", "_transient_wc_average_rating_1461450354591", "0", "no");
INSERT INTO `wp_options` VALUES("549", "_transient_timeout_wc_var_prices725b5339f4822dd1f5f3601450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("550", "_transient_wc_var_prices725b5339f4822dd1f5f3601450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("551", "_transient_timeout_wc_var_pricesbc5d6a0a068025392beb0d1450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("552", "_transient_wc_var_pricesbc5d6a0a068025392beb0d1450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("553", "_transient_timeout_wc_rating_count_1541450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("554", "_transient_wc_rating_count_1541450354591", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("555", "_transient_timeout_wc_average_rating_1541450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("556", "_transient_wc_average_rating_1541450354591", "0", "no");
INSERT INTO `wp_options` VALUES("557", "_transient_timeout_wc_var_prices6f766f67f198cf9a0beaa11450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("558", "_transient_wc_var_prices6f766f67f198cf9a0beaa11450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("559", "_transient_timeout_wc_var_pricesd86413df0f571d40a96ad61450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("560", "_transient_wc_var_pricesd86413df0f571d40a96ad61450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("561", "_transient_timeout_wc_rating_count_1651450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("562", "_transient_wc_rating_count_1651450354591", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("563", "_transient_timeout_wc_average_rating_1651450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("564", "_transient_wc_average_rating_1651450354591", "0", "no");
INSERT INTO `wp_options` VALUES("565", "_transient_timeout_wc_var_pricesa060e08966aa176f5939311450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("566", "_transient_wc_var_pricesa060e08966aa176f5939311450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("567", "_transient_timeout_wc_var_pricesce51a6c847bdb8cd33703d1450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("568", "_transient_wc_var_pricesce51a6c847bdb8cd33703d1450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("569", "_transient_timeout_wc_rating_count_1671450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("570", "_transient_wc_rating_count_1671450354591", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("571", "_transient_timeout_wc_average_rating_1671450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("572", "_transient_wc_average_rating_1671450354591", "0", "no");
INSERT INTO `wp_options` VALUES("573", "_transient_timeout_wc_var_prices7a8d3b537c3759c5f5a4351450354591", "1452947620", "no");
INSERT INTO `wp_options` VALUES("574", "_transient_wc_var_prices7a8d3b537c3759c5f5a4351450354591", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("575", "_transient_timeout_wc_rating_count_441450354591", "1452947621", "no");
INSERT INTO `wp_options` VALUES("576", "_transient_wc_rating_count_441450354591", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("577", "_transient_timeout_wc_average_rating_441450354591", "1452947621", "no");
INSERT INTO `wp_options` VALUES("578", "_transient_wc_average_rating_441450354591", "3.00", "no");
INSERT INTO `wp_options` VALUES("579", "_transient_timeout_wc_rating_count_401450354591", "1452947621", "no");
INSERT INTO `wp_options` VALUES("580", "_transient_wc_rating_count_401450354591", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("581", "_transient_timeout_wc_average_rating_401450354591", "1452947621", "no");
INSERT INTO `wp_options` VALUES("582", "_transient_wc_average_rating_401450354591", "0", "no");
INSERT INTO `wp_options` VALUES("814", "_transient_orders-transient-version", "1451361215", "yes");
INSERT INTO `wp_options` VALUES("815", "_transient_timeout_wc_cbp_9bfc7086e734171dce7c8b742d1433eb", "1453004337", "no");
INSERT INTO `wp_options` VALUES("816", "_transient_wc_cbp_9bfc7086e734171dce7c8b742d1433eb", "0", "no");
INSERT INTO `wp_options` VALUES("1191", "laborator_supported_payments", "a:4:{i:2;a:6:{s:4:\"name\";s:6:\"Paypal\";s:4:\"link\";s:0:\"\";s:10:\"blank_page\";i:0;s:9:\"p_image_1\";a:2:{s:8:\"original\";s:40:\"wp-content/uploads/2015/12\\payment01.png\";s:2:\"th\";s:43:\"wp-content/uploads/2015/12/th_payment01.png\";}s:8:\"order_id\";i:0;s:2:\"ID\";i:2;}i:4;a:6:{s:4:\"name\";s:4:\"Visa\";s:4:\"link\";s:0:\"\";s:10:\"blank_page\";i:0;s:9:\"p_image_1\";a:2:{s:8:\"original\";s:40:\"wp-content/uploads/2015/12\\payment02.png\";s:2:\"th\";s:43:\"wp-content/uploads/2015/12/th_payment02.png\";}s:8:\"order_id\";i:1;s:2:\"ID\";i:4;}i:6;a:6:{s:4:\"name\";s:16:\"American Express\";s:4:\"link\";s:0:\"\";s:10:\"blank_page\";i:0;s:9:\"p_image_1\";a:2:{s:8:\"original\";s:40:\"wp-content/uploads/2015/12\\payment03.png\";s:2:\"th\";s:43:\"wp-content/uploads/2015/12/th_payment03.png\";}s:8:\"order_id\";i:2;s:2:\"ID\";i:6;}i:8;a:5:{s:4:\"name\";s:10:\"MasterCard\";s:4:\"link\";s:0:\"\";s:10:\"blank_page\";i:0;s:9:\"p_image_1\";a:2:{s:8:\"original\";s:40:\"wp-content/uploads/2015/12\\payment04.png\";s:2:\"th\";s:43:\"wp-content/uploads/2015/12/th_payment04.png\";}s:8:\"order_id\";i:3;}}", "yes");
INSERT INTO `wp_options` VALUES("1197", "email-subscribers", "2.9", "yes");
INSERT INTO `wp_options` VALUES("1198", "widget_email-subscribers", "a:2:{i:2;a:4:{s:8:\"es_title\";s:10:\"Newsletter\";s:7:\"es_desc\";s:72:\"Subscribe to our newsletter to get the latest scoop right to your inbox.\";s:7:\"es_name\";s:2:\"NO\";s:8:\"es_group\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1407", "_transient_timeout_wc_var_pricesce51a6c847bdb8cd33703d1450426047", "1453018053", "no");
INSERT INTO `wp_options` VALUES("1408", "_transient_wc_var_pricesce51a6c847bdb8cd33703d1450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1409", "_transient_timeout_wc_var_prices7a8d3b537c3759c5f5a4351450426047", "1453018053", "no");
INSERT INTO `wp_options` VALUES("1410", "_transient_wc_var_prices7a8d3b537c3759c5f5a4351450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1411", "_transient_timeout_wc_var_pricesd86413df0f571d40a96ad61450426047", "1453018054", "no");
INSERT INTO `wp_options` VALUES("1412", "_transient_wc_var_pricesd86413df0f571d40a96ad61450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1413", "_transient_timeout_wc_var_pricesa060e08966aa176f5939311450426047", "1453018054", "no");
INSERT INTO `wp_options` VALUES("1414", "_transient_wc_var_pricesa060e08966aa176f5939311450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1415", "_transient_timeout_wc_var_pricesbc5d6a0a068025392beb0d1450426047", "1453018054", "no");
INSERT INTO `wp_options` VALUES("1416", "_transient_wc_var_pricesbc5d6a0a068025392beb0d1450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1417", "_transient_timeout_wc_var_prices6f766f67f198cf9a0beaa11450426047", "1453018054", "no");
INSERT INTO `wp_options` VALUES("1418", "_transient_wc_var_prices6f766f67f198cf9a0beaa11450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1421", "_transient_timeout_wc_var_prices1582135a424567c0f6cd7c1450426047", "1453018054", "no");
INSERT INTO `wp_options` VALUES("1422", "_transient_wc_var_prices1582135a424567c0f6cd7c1450426047", "a:3:{s:5:\"price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("1423", "_transient_timeout_wc_var_prices725b5339f4822dd1f5f3601450426047", "1453018054", "no");
INSERT INTO `wp_options` VALUES("1424", "_transient_wc_var_prices725b5339f4822dd1f5f3601450426047", "a:3:{s:5:\"price\";a:2:{i:1712;i:309;i:1711;i:859;}s:13:\"regular_price\";a:2:{i:1712;i:309;i:1711;i:859;}s:10:\"sale_price\";a:2:{i:1712;i:309;i:1711;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("1425", "_transient_timeout_wc_var_prices2b8caca71bc1fc4663f29b1450426047", "1453018054", "no");
INSERT INTO `wp_options` VALUES("1426", "_transient_wc_var_prices2b8caca71bc1fc4663f29b1450426047", "a:3:{s:5:\"price\";a:1:{i:1609;s:3:\"435\";}s:13:\"regular_price\";a:1:{i:1609;s:3:\"435\";}s:10:\"sale_price\";a:1:{i:1609;s:3:\"435\";}}", "no");
INSERT INTO `wp_options` VALUES("1427", "_transient_timeout_wc_var_prices1db561b9b6b1c09073651b1450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1428", "_transient_wc_var_prices1db561b9b6b1c09073651b1450426047", "a:3:{s:5:\"price\";a:1:{i:1609;i:435;}s:13:\"regular_price\";a:1:{i:1609;i:435;}s:10:\"sale_price\";a:1:{i:1609;i:435;}}", "no");
INSERT INTO `wp_options` VALUES("1429", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1430", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1431", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1432", "_transient_wc_var_pricese5e3a7ec74d543849a65931450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1433", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1434", "_transient_wc_var_prices2a86c658d2bca1db535cbe1450426047", "a:3:{s:5:\"price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("1435", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1436", "_transient_wc_var_prices508ed4445f00ea7945b36b1450426047", "a:3:{s:5:\"price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:13:\"regular_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:10:\"sale_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("1437", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1438", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1439", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1440", "_transient_wc_var_pricesd6990a7b2f37804631e5641450426047", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1441", "_transient_timeout_wc_rating_count_1671450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1442", "_transient_wc_rating_count_1671450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1443", "_transient_timeout_wc_average_rating_1671450426047", "1453018055", "no");
INSERT INTO `wp_options` VALUES("1444", "_transient_wc_average_rating_1671450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1445", "_transient_timeout_wc_rating_count_1651450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1446", "_transient_wc_rating_count_1651450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1447", "_transient_timeout_wc_average_rating_1651450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1448", "_transient_wc_average_rating_1651450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1449", "_transient_timeout_wc_rating_count_1541450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1450", "_transient_wc_rating_count_1541450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1451", "_transient_timeout_wc_average_rating_1541450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1452", "_transient_wc_average_rating_1541450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1453", "_transient_timeout_wc_rating_count_1461450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1454", "_transient_wc_rating_count_1461450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1455", "_transient_timeout_wc_average_rating_1461450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1456", "_transient_wc_average_rating_1461450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1457", "_transient_timeout_wc_rating_count_1431450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1458", "_transient_wc_rating_count_1431450426047", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("1459", "_transient_timeout_wc_average_rating_1431450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1460", "_transient_wc_average_rating_1431450426047", "3.00", "no");
INSERT INTO `wp_options` VALUES("1461", "_transient_timeout_wc_rating_count_1011450426047", "1453018056", "no");
INSERT INTO `wp_options` VALUES("1462", "_transient_wc_rating_count_1011450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1463", "_transient_timeout_wc_average_rating_1011450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1464", "_transient_wc_average_rating_1011450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1465", "_transient_timeout_wc_rating_count_941450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1466", "_transient_wc_rating_count_941450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1467", "_transient_timeout_wc_average_rating_941450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1468", "_transient_wc_average_rating_941450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1469", "_transient_timeout_wc_rating_count_681450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1470", "_transient_wc_rating_count_681450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1471", "_transient_timeout_wc_average_rating_681450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1472", "_transient_wc_average_rating_681450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1473", "_transient_timeout_wc_rating_count_401450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1474", "_transient_wc_rating_count_401450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1475", "_transient_timeout_wc_average_rating_401450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1476", "_transient_wc_average_rating_401450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1477", "_transient_timeout_wc_rating_count_231450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1478", "_transient_wc_rating_count_231450426047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1479", "_transient_timeout_wc_average_rating_231450426047", "1453018057", "no");
INSERT INTO `wp_options` VALUES("1480", "_transient_wc_average_rating_231450426047", "0", "no");
INSERT INTO `wp_options` VALUES("1697", "general_options", "", "yes");
INSERT INTO `wp_options` VALUES("1698", "pricing_options", "", "yes");
INSERT INTO `wp_options` VALUES("1768", "_transient_timeout_wc_var_pricesce51a6c847bdb8cd33703d1450441037", "1453033042", "no");
INSERT INTO `wp_options` VALUES("1769", "_transient_wc_var_pricesce51a6c847bdb8cd33703d1450441037", "a:3:{s:5:\"price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:13:\"regular_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:10:\"sale_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}}", "no");
INSERT INTO `wp_options` VALUES("1770", "_transient_timeout_wc_var_prices7a8d3b537c3759c5f5a4351450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1771", "_transient_wc_var_prices7a8d3b537c3759c5f5a4351450441037", "a:3:{s:5:\"price\";a:2:{i:1748;i:99;i:1747;i:474;}s:13:\"regular_price\";a:2:{i:1748;i:99;i:1747;i:474;}s:10:\"sale_price\";a:2:{i:1748;i:99;i:1747;i:474;}}", "no");
INSERT INTO `wp_options` VALUES("1772", "_transient_timeout_wc_var_pricesd86413df0f571d40a96ad61450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1773", "_transient_wc_var_pricesd86413df0f571d40a96ad61450441037", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1774", "_transient_timeout_wc_var_pricesa060e08966aa176f5939311450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1775", "_transient_wc_var_pricesa060e08966aa176f5939311450441037", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1776", "_transient_timeout_wc_var_pricesbc5d6a0a068025392beb0d1450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1777", "_transient_wc_var_pricesbc5d6a0a068025392beb0d1450441037", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1778", "_transient_timeout_wc_var_prices6f766f67f198cf9a0beaa11450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1779", "_transient_wc_var_prices6f766f67f198cf9a0beaa11450441037", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1780", "_transient_timeout_wc_var_prices1582135a424567c0f6cd7c1450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1781", "_transient_wc_var_prices1582135a424567c0f6cd7c1450441037", "a:3:{s:5:\"price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("1782", "_transient_timeout_wc_var_prices725b5339f4822dd1f5f3601450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1783", "_transient_wc_var_prices725b5339f4822dd1f5f3601450441037", "a:3:{s:5:\"price\";a:2:{i:1712;i:309;i:1711;i:859;}s:13:\"regular_price\";a:2:{i:1712;i:309;i:1711;i:859;}s:10:\"sale_price\";a:2:{i:1712;i:309;i:1711;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("1784", "_transient_timeout_wc_var_prices2b8caca71bc1fc4663f29b1450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1785", "_transient_wc_var_prices2b8caca71bc1fc4663f29b1450441037", "a:3:{s:5:\"price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("1786", "_transient_timeout_wc_var_prices1db561b9b6b1c09073651b1450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1787", "_transient_wc_var_prices1db561b9b6b1c09073651b1450441037", "a:3:{s:5:\"price\";a:2:{i:1718;i:309;i:1609;i:859;}s:13:\"regular_price\";a:2:{i:1718;i:309;i:1609;i:859;}s:10:\"sale_price\";a:2:{i:1718;i:309;i:1609;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("1788", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491450441037", "1453033043", "no");
INSERT INTO `wp_options` VALUES("1789", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491450441037", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1790", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1791", "_transient_wc_var_pricese5e3a7ec74d543849a65931450441037", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1792", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1793", "_transient_wc_var_prices2a86c658d2bca1db535cbe1450441037", "a:3:{s:5:\"price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("1794", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1795", "_transient_wc_var_prices508ed4445f00ea7945b36b1450441037", "a:3:{s:5:\"price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:13:\"regular_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:10:\"sale_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("1796", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1797", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1450441037", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1798", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1799", "_transient_wc_var_pricesd6990a7b2f37804631e5641450441037", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("1800", "_transient_timeout_wc_rating_count_1671450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1801", "_transient_wc_rating_count_1671450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1802", "_transient_timeout_wc_average_rating_1671450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1803", "_transient_wc_average_rating_1671450441037", "0", "no");
INSERT INTO `wp_options` VALUES("1804", "_transient_timeout_wc_rating_count_1651450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1805", "_transient_wc_rating_count_1651450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1806", "_transient_timeout_wc_average_rating_1651450441037", "1453033044", "no");
INSERT INTO `wp_options` VALUES("1807", "_transient_wc_average_rating_1651450441037", "0", "no");
INSERT INTO `wp_options` VALUES("1808", "_transient_timeout_wc_rating_count_1541450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1809", "_transient_wc_rating_count_1541450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1810", "_transient_timeout_wc_average_rating_1541450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1811", "_transient_wc_average_rating_1541450441037", "0", "no");
INSERT INTO `wp_options` VALUES("1812", "_transient_timeout_wc_rating_count_1461450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1813", "_transient_wc_rating_count_1461450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1814", "_transient_timeout_wc_average_rating_1461450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1815", "_transient_wc_average_rating_1461450441037", "0", "no");
INSERT INTO `wp_options` VALUES("1816", "_transient_timeout_wc_rating_count_1431450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1817", "_transient_wc_rating_count_1431450441037", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("1818", "_transient_timeout_wc_average_rating_1431450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1819", "_transient_wc_average_rating_1431450441037", "3.00", "no");
INSERT INTO `wp_options` VALUES("1820", "_transient_timeout_wc_rating_count_1011450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1821", "_transient_wc_rating_count_1011450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1822", "_transient_timeout_wc_average_rating_1011450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1823", "_transient_wc_average_rating_1011450441037", "0", "no");
INSERT INTO `wp_options` VALUES("1824", "_transient_timeout_wc_rating_count_941450441037", "1453033045", "no");
INSERT INTO `wp_options` VALUES("1825", "_transient_wc_rating_count_941450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1826", "_transient_timeout_wc_average_rating_941450441037", "1453033046", "no");
INSERT INTO `wp_options` VALUES("1827", "_transient_wc_average_rating_941450441037", "0", "no");
INSERT INTO `wp_options` VALUES("1828", "_transient_timeout_wc_rating_count_681450441037", "1453033046", "no");
INSERT INTO `wp_options` VALUES("1829", "_transient_wc_rating_count_681450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1830", "_transient_timeout_wc_average_rating_681450441037", "1453033046", "no");
INSERT INTO `wp_options` VALUES("1831", "_transient_wc_average_rating_681450441037", "0", "no");
INSERT INTO `wp_options` VALUES("1832", "_transient_timeout_wc_rating_count_401450441037", "1453033046", "no");
INSERT INTO `wp_options` VALUES("1833", "_transient_wc_rating_count_401450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1834", "_transient_timeout_wc_average_rating_401450441037", "1453033046", "no");
INSERT INTO `wp_options` VALUES("1835", "_transient_wc_average_rating_401450441037", "0", "no");
INSERT INTO `wp_options` VALUES("1836", "_transient_timeout_wc_rating_count_231450441037", "1453033046", "no");
INSERT INTO `wp_options` VALUES("1837", "_transient_wc_rating_count_231450441037", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1838", "_transient_timeout_wc_average_rating_231450441037", "1453033047", "no");
INSERT INTO `wp_options` VALUES("1839", "_transient_wc_average_rating_231450441037", "0", "no");
INSERT INTO `wp_options` VALUES("2219", "_transient_timeout_wc_var_pricesce51a6c847bdb8cd33703d1450441493", "1453033501", "no");
INSERT INTO `wp_options` VALUES("2220", "_transient_wc_var_pricesce51a6c847bdb8cd33703d1450441493", "a:3:{s:5:\"price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:13:\"regular_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:10:\"sale_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}}", "no");
INSERT INTO `wp_options` VALUES("2221", "_transient_timeout_wc_var_prices7a8d3b537c3759c5f5a4351450441493", "1453033501", "no");
INSERT INTO `wp_options` VALUES("2222", "_transient_wc_var_prices7a8d3b537c3759c5f5a4351450441493", "a:3:{s:5:\"price\";a:2:{i:1748;i:99;i:1747;i:474;}s:13:\"regular_price\";a:2:{i:1748;i:99;i:1747;i:474;}s:10:\"sale_price\";a:2:{i:1748;i:99;i:1747;i:474;}}", "no");
INSERT INTO `wp_options` VALUES("2223", "_transient_timeout_wc_var_pricesd86413df0f571d40a96ad61450441493", "1453033501", "no");
INSERT INTO `wp_options` VALUES("2224", "_transient_wc_var_pricesd86413df0f571d40a96ad61450441493", "a:3:{s:5:\"price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:13:\"regular_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:10:\"sale_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}}", "no");
INSERT INTO `wp_options` VALUES("2225", "_transient_timeout_wc_var_pricesa060e08966aa176f5939311450441493", "1453033501", "no");
INSERT INTO `wp_options` VALUES("2226", "_transient_wc_var_pricesa060e08966aa176f5939311450441493", "a:3:{s:5:\"price\";a:2:{i:1750;i:119;i:1749;i:494;}s:13:\"regular_price\";a:2:{i:1750;i:119;i:1749;i:494;}s:10:\"sale_price\";a:2:{i:1750;i:119;i:1749;i:494;}}", "no");
INSERT INTO `wp_options` VALUES("2227", "_transient_timeout_wc_var_pricesbc5d6a0a068025392beb0d1450441493", "1453033501", "no");
INSERT INTO `wp_options` VALUES("2228", "_transient_wc_var_pricesbc5d6a0a068025392beb0d1450441493", "a:3:{s:5:\"price\";a:1:{i:1755;s:2:\"50\";}s:13:\"regular_price\";a:1:{i:1755;s:2:\"50\";}s:10:\"sale_price\";a:1:{i:1755;s:2:\"50\";}}", "no");
INSERT INTO `wp_options` VALUES("2229", "_transient_timeout_wc_var_prices6f766f67f198cf9a0beaa11450441493", "1453033501", "no");
INSERT INTO `wp_options` VALUES("2230", "_transient_wc_var_prices6f766f67f198cf9a0beaa11450441493", "a:3:{s:5:\"price\";a:1:{i:1755;i:50;}s:13:\"regular_price\";a:1:{i:1755;i:50;}s:10:\"sale_price\";a:1:{i:1755;i:50;}}", "no");
INSERT INTO `wp_options` VALUES("2231", "_transient_timeout_wc_var_prices1582135a424567c0f6cd7c1450441493", "1453033501", "no");
INSERT INTO `wp_options` VALUES("2232", "_transient_wc_var_prices1582135a424567c0f6cd7c1450441493", "a:3:{s:5:\"price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2233", "_transient_timeout_wc_var_prices725b5339f4822dd1f5f3601450441493", "1453033502", "no");
INSERT INTO `wp_options` VALUES("2234", "_transient_wc_var_prices725b5339f4822dd1f5f3601450441493", "a:3:{s:5:\"price\";a:2:{i:1712;i:309;i:1711;i:859;}s:13:\"regular_price\";a:2:{i:1712;i:309;i:1711;i:859;}s:10:\"sale_price\";a:2:{i:1712;i:309;i:1711;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2235", "_transient_timeout_wc_var_prices2b8caca71bc1fc4663f29b1450441493", "1453033502", "no");
INSERT INTO `wp_options` VALUES("2236", "_transient_wc_var_prices2b8caca71bc1fc4663f29b1450441493", "a:3:{s:5:\"price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2237", "_transient_timeout_wc_var_prices1db561b9b6b1c09073651b1450441493", "1453033502", "no");
INSERT INTO `wp_options` VALUES("2238", "_transient_wc_var_prices1db561b9b6b1c09073651b1450441493", "a:3:{s:5:\"price\";a:2:{i:1718;i:309;i:1609;i:859;}s:13:\"regular_price\";a:2:{i:1718;i:309;i:1609;i:859;}s:10:\"sale_price\";a:2:{i:1718;i:309;i:1609;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2239", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491450441493", "1453033502", "no");
INSERT INTO `wp_options` VALUES("2240", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491450441493", "a:3:{s:5:\"price\";a:1:{i:1759;s:3:\"449\";}s:13:\"regular_price\";a:1:{i:1759;s:3:\"449\";}s:10:\"sale_price\";a:1:{i:1759;s:3:\"449\";}}", "no");
INSERT INTO `wp_options` VALUES("2241", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931450441493", "1453033502", "no");
INSERT INTO `wp_options` VALUES("2242", "_transient_wc_var_pricese5e3a7ec74d543849a65931450441493", "a:3:{s:5:\"price\";a:1:{i:1759;i:449;}s:13:\"regular_price\";a:1:{i:1759;i:449;}s:10:\"sale_price\";a:1:{i:1759;i:449;}}", "no");
INSERT INTO `wp_options` VALUES("2243", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1450441493", "1453033502", "no");
INSERT INTO `wp_options` VALUES("2244", "_transient_wc_var_prices2a86c658d2bca1db535cbe1450441493", "a:3:{s:5:\"price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("2245", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1450441493", "1453033502", "no");
INSERT INTO `wp_options` VALUES("2246", "_transient_wc_var_prices508ed4445f00ea7945b36b1450441493", "a:3:{s:5:\"price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:13:\"regular_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:10:\"sale_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("2249", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1450441493", "1453033502", "no");
INSERT INTO `wp_options` VALUES("2250", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1450441493", "a:3:{s:5:\"price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:13:\"regular_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:10:\"sale_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}}", "no");
INSERT INTO `wp_options` VALUES("2251", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2252", "_transient_wc_var_pricesd6990a7b2f37804631e5641450441493", "a:3:{s:5:\"price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:13:\"regular_price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:10:\"sale_price\";a:2:{i:1764;i:465;i:1763;i:1015;}}", "no");
INSERT INTO `wp_options` VALUES("2253", "_transient_timeout_wc_rating_count_1671450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2254", "_transient_wc_rating_count_1671450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2255", "_transient_timeout_wc_average_rating_1671450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2256", "_transient_wc_average_rating_1671450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2257", "_transient_timeout_wc_rating_count_1651450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2258", "_transient_wc_rating_count_1651450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2259", "_transient_timeout_wc_average_rating_1651450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2260", "_transient_wc_average_rating_1651450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2261", "_transient_timeout_wc_rating_count_1541450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2262", "_transient_wc_rating_count_1541450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2263", "_transient_timeout_wc_average_rating_1541450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2264", "_transient_wc_average_rating_1541450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2265", "_transient_timeout_wc_rating_count_1461450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2266", "_transient_wc_rating_count_1461450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2267", "_transient_timeout_wc_average_rating_1461450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2268", "_transient_wc_average_rating_1461450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2269", "_transient_timeout_wc_rating_count_1431450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2270", "_transient_wc_rating_count_1431450441493", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("2271", "_transient_timeout_wc_average_rating_1431450441493", "1453033503", "no");
INSERT INTO `wp_options` VALUES("2272", "_transient_wc_average_rating_1431450441493", "3.00", "no");
INSERT INTO `wp_options` VALUES("2273", "_transient_timeout_wc_rating_count_1011450441493", "1453033504", "no");
INSERT INTO `wp_options` VALUES("2274", "_transient_wc_rating_count_1011450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2275", "_transient_timeout_wc_average_rating_1011450441493", "1453033504", "no");
INSERT INTO `wp_options` VALUES("2276", "_transient_wc_average_rating_1011450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2277", "_transient_timeout_wc_rating_count_941450441493", "1453033504", "no");
INSERT INTO `wp_options` VALUES("2278", "_transient_wc_rating_count_941450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2279", "_transient_timeout_wc_average_rating_941450441493", "1453033504", "no");
INSERT INTO `wp_options` VALUES("2280", "_transient_wc_average_rating_941450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2281", "_transient_timeout_wc_rating_count_681450441493", "1453033504", "no");
INSERT INTO `wp_options` VALUES("2282", "_transient_wc_rating_count_681450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2283", "_transient_timeout_wc_average_rating_681450441493", "1453033504", "no");
INSERT INTO `wp_options` VALUES("2284", "_transient_wc_average_rating_681450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2285", "_transient_timeout_wc_rating_count_401450441493", "1453033505", "no");
INSERT INTO `wp_options` VALUES("2286", "_transient_wc_rating_count_401450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2287", "_transient_timeout_wc_average_rating_401450441493", "1453033505", "no");
INSERT INTO `wp_options` VALUES("2288", "_transient_wc_average_rating_401450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2289", "_transient_timeout_wc_rating_count_231450441493", "1453033505", "no");
INSERT INTO `wp_options` VALUES("2290", "_transient_wc_rating_count_231450441493", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2291", "_transient_timeout_wc_average_rating_231450441493", "1453033505", "no");
INSERT INTO `wp_options` VALUES("2292", "_transient_wc_average_rating_231450441493", "0", "no");
INSERT INTO `wp_options` VALUES("2553", "_transient_timeout_wc_var_pricesce51a6c847bdb8cd33703d1450441698", "1453033853", "no");
INSERT INTO `wp_options` VALUES("2554", "_transient_wc_var_pricesce51a6c847bdb8cd33703d1450441698", "a:3:{s:5:\"price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:13:\"regular_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:10:\"sale_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}}", "no");
INSERT INTO `wp_options` VALUES("2555", "_transient_timeout_wc_var_prices7a8d3b537c3759c5f5a4351450441698", "1453033853", "no");
INSERT INTO `wp_options` VALUES("2556", "_transient_wc_var_prices7a8d3b537c3759c5f5a4351450441698", "a:3:{s:5:\"price\";a:2:{i:1748;i:99;i:1747;i:474;}s:13:\"regular_price\";a:2:{i:1748;i:99;i:1747;i:474;}s:10:\"sale_price\";a:2:{i:1748;i:99;i:1747;i:474;}}", "no");
INSERT INTO `wp_options` VALUES("2557", "_transient_timeout_wc_var_pricesd86413df0f571d40a96ad61450441698", "1453033853", "no");
INSERT INTO `wp_options` VALUES("2558", "_transient_wc_var_pricesd86413df0f571d40a96ad61450441698", "a:3:{s:5:\"price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:13:\"regular_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:10:\"sale_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}}", "no");
INSERT INTO `wp_options` VALUES("2559", "_transient_timeout_wc_var_pricesa060e08966aa176f5939311450441698", "1453033853", "no");
INSERT INTO `wp_options` VALUES("2560", "_transient_wc_var_pricesa060e08966aa176f5939311450441698", "a:3:{s:5:\"price\";a:2:{i:1750;i:119;i:1749;i:494;}s:13:\"regular_price\";a:2:{i:1750;i:119;i:1749;i:494;}s:10:\"sale_price\";a:2:{i:1750;i:119;i:1749;i:494;}}", "no");
INSERT INTO `wp_options` VALUES("2561", "_transient_timeout_wc_var_pricesbc5d6a0a068025392beb0d1450441698", "1453033853", "no");
INSERT INTO `wp_options` VALUES("2562", "_transient_wc_var_pricesbc5d6a0a068025392beb0d1450441698", "a:3:{s:5:\"price\";a:1:{i:1755;s:2:\"50\";}s:13:\"regular_price\";a:1:{i:1755;s:2:\"50\";}s:10:\"sale_price\";a:1:{i:1755;s:2:\"50\";}}", "no");
INSERT INTO `wp_options` VALUES("2563", "_transient_timeout_wc_var_prices6f766f67f198cf9a0beaa11450441698", "1453033853", "no");
INSERT INTO `wp_options` VALUES("2564", "_transient_wc_var_prices6f766f67f198cf9a0beaa11450441698", "a:3:{s:5:\"price\";a:1:{i:1755;i:50;}s:13:\"regular_price\";a:1:{i:1755;i:50;}s:10:\"sale_price\";a:1:{i:1755;i:50;}}", "no");
INSERT INTO `wp_options` VALUES("2565", "_transient_timeout_wc_var_prices1582135a424567c0f6cd7c1450441698", "1453033854", "no");
INSERT INTO `wp_options` VALUES("2566", "_transient_wc_var_prices1582135a424567c0f6cd7c1450441698", "a:3:{s:5:\"price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2567", "_transient_timeout_wc_var_prices725b5339f4822dd1f5f3601450441698", "1453033854", "no");
INSERT INTO `wp_options` VALUES("2568", "_transient_wc_var_prices725b5339f4822dd1f5f3601450441698", "a:3:{s:5:\"price\";a:2:{i:1712;i:309;i:1711;i:859;}s:13:\"regular_price\";a:2:{i:1712;i:309;i:1711;i:859;}s:10:\"sale_price\";a:2:{i:1712;i:309;i:1711;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2569", "_transient_timeout_wc_var_prices2b8caca71bc1fc4663f29b1450441698", "1453033854", "no");
INSERT INTO `wp_options` VALUES("2570", "_transient_wc_var_prices2b8caca71bc1fc4663f29b1450441698", "a:3:{s:5:\"price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2571", "_transient_timeout_wc_var_prices1db561b9b6b1c09073651b1450441698", "1453033854", "no");
INSERT INTO `wp_options` VALUES("2572", "_transient_wc_var_prices1db561b9b6b1c09073651b1450441698", "a:3:{s:5:\"price\";a:2:{i:1718;i:309;i:1609;i:859;}s:13:\"regular_price\";a:2:{i:1718;i:309;i:1609;i:859;}s:10:\"sale_price\";a:2:{i:1718;i:309;i:1609;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2573", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491450441698", "1453033855", "no");
INSERT INTO `wp_options` VALUES("2574", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491450441698", "a:3:{s:5:\"price\";a:1:{i:1759;s:3:\"449\";}s:13:\"regular_price\";a:1:{i:1759;s:3:\"449\";}s:10:\"sale_price\";a:1:{i:1759;s:3:\"449\";}}", "no");
INSERT INTO `wp_options` VALUES("2575", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931450441698", "1453033855", "no");
INSERT INTO `wp_options` VALUES("2576", "_transient_wc_var_pricese5e3a7ec74d543849a65931450441698", "a:3:{s:5:\"price\";a:1:{i:1759;i:449;}s:13:\"regular_price\";a:1:{i:1759;i:449;}s:10:\"sale_price\";a:1:{i:1759;i:449;}}", "no");
INSERT INTO `wp_options` VALUES("2577", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1450441698", "1453033855", "no");
INSERT INTO `wp_options` VALUES("2578", "_transient_wc_var_prices2a86c658d2bca1db535cbe1450441698", "a:3:{s:5:\"price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("2579", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1450441698", "1453033855", "no");
INSERT INTO `wp_options` VALUES("2580", "_transient_wc_var_prices508ed4445f00ea7945b36b1450441698", "a:3:{s:5:\"price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:13:\"regular_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:10:\"sale_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("2581", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1450441698", "1453033855", "no");
INSERT INTO `wp_options` VALUES("2582", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1450441698", "a:3:{s:5:\"price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:13:\"regular_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:10:\"sale_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}}", "no");
INSERT INTO `wp_options` VALUES("2583", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641450441698", "1453033855", "no");
INSERT INTO `wp_options` VALUES("2584", "_transient_wc_var_pricesd6990a7b2f37804631e5641450441698", "a:3:{s:5:\"price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:13:\"regular_price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:10:\"sale_price\";a:2:{i:1764;i:465;i:1763;i:1015;}}", "no");
INSERT INTO `wp_options` VALUES("2585", "_transient_timeout_wc_rating_count_1671450441698", "1453033856", "no");
INSERT INTO `wp_options` VALUES("2586", "_transient_wc_rating_count_1671450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2587", "_transient_timeout_wc_average_rating_1671450441698", "1453033856", "no");
INSERT INTO `wp_options` VALUES("2588", "_transient_wc_average_rating_1671450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2589", "_transient_timeout_wc_rating_count_1651450441698", "1453033856", "no");
INSERT INTO `wp_options` VALUES("2590", "_transient_wc_rating_count_1651450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2591", "_transient_timeout_wc_average_rating_1651450441698", "1453033856", "no");
INSERT INTO `wp_options` VALUES("2592", "_transient_wc_average_rating_1651450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2593", "_transient_timeout_wc_rating_count_1541450441698", "1453033856", "no");
INSERT INTO `wp_options` VALUES("2594", "_transient_wc_rating_count_1541450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2595", "_transient_timeout_wc_average_rating_1541450441698", "1453033856", "no");
INSERT INTO `wp_options` VALUES("2596", "_transient_wc_average_rating_1541450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2597", "_transient_timeout_wc_rating_count_1461450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2598", "_transient_wc_rating_count_1461450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2599", "_transient_timeout_wc_average_rating_1461450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2600", "_transient_wc_average_rating_1461450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2601", "_transient_timeout_wc_rating_count_1431450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2602", "_transient_wc_rating_count_1431450441698", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("2603", "_transient_timeout_wc_average_rating_1431450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2604", "_transient_wc_average_rating_1431450441698", "3.00", "no");
INSERT INTO `wp_options` VALUES("2605", "_transient_timeout_wc_rating_count_1011450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2606", "_transient_wc_rating_count_1011450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2607", "_transient_timeout_wc_average_rating_1011450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2608", "_transient_wc_average_rating_1011450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2609", "_transient_timeout_wc_rating_count_941450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2610", "_transient_wc_rating_count_941450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2611", "_transient_timeout_wc_average_rating_941450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2612", "_transient_wc_average_rating_941450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2613", "_transient_timeout_wc_rating_count_681450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2614", "_transient_wc_rating_count_681450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2615", "_transient_timeout_wc_average_rating_681450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2616", "_transient_wc_average_rating_681450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2617", "_transient_timeout_wc_rating_count_401450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2618", "_transient_wc_rating_count_401450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2619", "_transient_timeout_wc_average_rating_401450441698", "1453033857", "no");
INSERT INTO `wp_options` VALUES("2620", "_transient_wc_average_rating_401450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2621", "_transient_timeout_wc_rating_count_231450441698", "1453033858", "no");
INSERT INTO `wp_options` VALUES("2622", "_transient_wc_rating_count_231450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2623", "_transient_timeout_wc_average_rating_231450441698", "1453033858", "no");
INSERT INTO `wp_options` VALUES("2624", "_transient_wc_average_rating_231450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2625", "_transient_timeout_wc_rating_count_111450441698", "1453033858", "no");
INSERT INTO `wp_options` VALUES("2626", "_transient_wc_rating_count_111450441698", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2627", "_transient_timeout_wc_average_rating_111450441698", "1453033858", "no");
INSERT INTO `wp_options` VALUES("2628", "_transient_wc_average_rating_111450441698", "0", "no");
INSERT INTO `wp_options` VALUES("2707", "_transient_timeout_wc_var_pricesce51a6c847bdb8cd33703d1450441852", "1453033900", "no");
INSERT INTO `wp_options` VALUES("2708", "_transient_wc_var_pricesce51a6c847bdb8cd33703d1450441852", "a:3:{s:5:\"price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:13:\"regular_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:10:\"sale_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}}", "no");
INSERT INTO `wp_options` VALUES("2709", "_transient_timeout_wc_var_prices7a8d3b537c3759c5f5a4351450441852", "1453033900", "no");
INSERT INTO `wp_options` VALUES("2710", "_transient_wc_var_prices7a8d3b537c3759c5f5a4351450441852", "a:3:{s:5:\"price\";a:2:{i:1748;i:99;i:1747;i:474;}s:13:\"regular_price\";a:2:{i:1748;i:99;i:1747;i:474;}s:10:\"sale_price\";a:2:{i:1748;i:99;i:1747;i:474;}}", "no");
INSERT INTO `wp_options` VALUES("2711", "_transient_timeout_wc_var_pricesd86413df0f571d40a96ad61450441852", "1453033900", "no");
INSERT INTO `wp_options` VALUES("2712", "_transient_wc_var_pricesd86413df0f571d40a96ad61450441852", "a:3:{s:5:\"price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:13:\"regular_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:10:\"sale_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}}", "no");
INSERT INTO `wp_options` VALUES("2713", "_transient_timeout_wc_var_pricesa060e08966aa176f5939311450441852", "1453033900", "no");
INSERT INTO `wp_options` VALUES("2714", "_transient_wc_var_pricesa060e08966aa176f5939311450441852", "a:3:{s:5:\"price\";a:2:{i:1750;i:119;i:1749;i:494;}s:13:\"regular_price\";a:2:{i:1750;i:119;i:1749;i:494;}s:10:\"sale_price\";a:2:{i:1750;i:119;i:1749;i:494;}}", "no");
INSERT INTO `wp_options` VALUES("2715", "_transient_timeout_wc_var_pricesbc5d6a0a068025392beb0d1450441852", "1453033900", "no");
INSERT INTO `wp_options` VALUES("2716", "_transient_wc_var_pricesbc5d6a0a068025392beb0d1450441852", "a:3:{s:5:\"price\";a:1:{i:1755;s:2:\"50\";}s:13:\"regular_price\";a:1:{i:1755;s:2:\"50\";}s:10:\"sale_price\";a:1:{i:1755;s:2:\"50\";}}", "no");
INSERT INTO `wp_options` VALUES("2717", "_transient_timeout_wc_var_prices6f766f67f198cf9a0beaa11450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2718", "_transient_wc_var_prices6f766f67f198cf9a0beaa11450441852", "a:3:{s:5:\"price\";a:1:{i:1755;i:50;}s:13:\"regular_price\";a:1:{i:1755;i:50;}s:10:\"sale_price\";a:1:{i:1755;i:50;}}", "no");
INSERT INTO `wp_options` VALUES("2719", "_transient_timeout_wc_var_prices1582135a424567c0f6cd7c1450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2720", "_transient_wc_var_prices1582135a424567c0f6cd7c1450441852", "a:3:{s:5:\"price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2721", "_transient_timeout_wc_var_prices725b5339f4822dd1f5f3601450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2722", "_transient_wc_var_prices725b5339f4822dd1f5f3601450441852", "a:3:{s:5:\"price\";a:2:{i:1712;i:309;i:1711;i:859;}s:13:\"regular_price\";a:2:{i:1712;i:309;i:1711;i:859;}s:10:\"sale_price\";a:2:{i:1712;i:309;i:1711;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2723", "_transient_timeout_wc_var_prices2b8caca71bc1fc4663f29b1450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2724", "_transient_wc_var_prices2b8caca71bc1fc4663f29b1450441852", "a:3:{s:5:\"price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2725", "_transient_timeout_wc_var_prices1db561b9b6b1c09073651b1450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2726", "_transient_wc_var_prices1db561b9b6b1c09073651b1450441852", "a:3:{s:5:\"price\";a:2:{i:1718;i:309;i:1609;i:859;}s:13:\"regular_price\";a:2:{i:1718;i:309;i:1609;i:859;}s:10:\"sale_price\";a:2:{i:1718;i:309;i:1609;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2727", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2728", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491450441852", "a:3:{s:5:\"price\";a:1:{i:1759;s:3:\"449\";}s:13:\"regular_price\";a:1:{i:1759;s:3:\"449\";}s:10:\"sale_price\";a:1:{i:1759;s:3:\"449\";}}", "no");
INSERT INTO `wp_options` VALUES("2729", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2730", "_transient_wc_var_pricese5e3a7ec74d543849a65931450441852", "a:3:{s:5:\"price\";a:1:{i:1759;i:449;}s:13:\"regular_price\";a:1:{i:1759;i:449;}s:10:\"sale_price\";a:1:{i:1759;i:449;}}", "no");
INSERT INTO `wp_options` VALUES("2731", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2732", "_transient_wc_var_prices2a86c658d2bca1db535cbe1450441852", "a:3:{s:5:\"price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("2733", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1450441852", "1453033901", "no");
INSERT INTO `wp_options` VALUES("2734", "_transient_wc_var_prices508ed4445f00ea7945b36b1450441852", "a:3:{s:5:\"price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:13:\"regular_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:10:\"sale_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("2735", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1450441852", "1453033902", "no");
INSERT INTO `wp_options` VALUES("2736", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1450441852", "a:3:{s:5:\"price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:13:\"regular_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:10:\"sale_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}}", "no");
INSERT INTO `wp_options` VALUES("2737", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641450441852", "1453033902", "no");
INSERT INTO `wp_options` VALUES("2738", "_transient_wc_var_pricesd6990a7b2f37804631e5641450441852", "a:3:{s:5:\"price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:13:\"regular_price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:10:\"sale_price\";a:2:{i:1764;i:465;i:1763;i:1015;}}", "no");
INSERT INTO `wp_options` VALUES("2739", "_transient_timeout_wc_rating_count_1671450441852", "1453033902", "no");
INSERT INTO `wp_options` VALUES("2740", "_transient_wc_rating_count_1671450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2741", "_transient_timeout_wc_average_rating_1671450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2742", "_transient_wc_average_rating_1671450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2743", "_transient_timeout_wc_rating_count_1651450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2744", "_transient_wc_rating_count_1651450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2745", "_transient_timeout_wc_average_rating_1651450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2746", "_transient_wc_average_rating_1651450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2747", "_transient_timeout_wc_rating_count_1541450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2748", "_transient_wc_rating_count_1541450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2749", "_transient_timeout_wc_average_rating_1541450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2750", "_transient_wc_average_rating_1541450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2751", "_transient_timeout_wc_rating_count_1461450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2752", "_transient_wc_rating_count_1461450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2753", "_transient_timeout_wc_average_rating_1461450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2754", "_transient_wc_average_rating_1461450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2755", "_transient_timeout_wc_rating_count_1431450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2756", "_transient_wc_rating_count_1431450441852", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("2757", "_transient_timeout_wc_average_rating_1431450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2758", "_transient_wc_average_rating_1431450441852", "3.00", "no");
INSERT INTO `wp_options` VALUES("2759", "_transient_timeout_wc_rating_count_1011450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2760", "_transient_wc_rating_count_1011450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2761", "_transient_timeout_wc_average_rating_1011450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2762", "_transient_wc_average_rating_1011450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2763", "_transient_timeout_wc_rating_count_941450441852", "1453033903", "no");
INSERT INTO `wp_options` VALUES("2764", "_transient_wc_rating_count_941450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2765", "_transient_timeout_wc_average_rating_941450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2766", "_transient_wc_average_rating_941450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2767", "_transient_timeout_wc_rating_count_681450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2768", "_transient_wc_rating_count_681450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2769", "_transient_timeout_wc_average_rating_681450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2770", "_transient_wc_average_rating_681450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2771", "_transient_timeout_wc_rating_count_401450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2772", "_transient_wc_rating_count_401450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2773", "_transient_timeout_wc_average_rating_401450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2774", "_transient_wc_average_rating_401450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2775", "_transient_timeout_wc_rating_count_361450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2776", "_transient_wc_rating_count_361450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2777", "_transient_timeout_wc_average_rating_361450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2778", "_transient_wc_average_rating_361450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2779", "_transient_timeout_wc_rating_count_231450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2780", "_transient_wc_rating_count_231450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2781", "_transient_timeout_wc_average_rating_231450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2782", "_transient_wc_average_rating_231450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2783", "_transient_timeout_wc_rating_count_111450441852", "1453033904", "no");
INSERT INTO `wp_options` VALUES("2784", "_transient_wc_rating_count_111450441852", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2785", "_transient_timeout_wc_average_rating_111450441852", "1453033905", "no");
INSERT INTO `wp_options` VALUES("2786", "_transient_wc_average_rating_111450441852", "0", "no");
INSERT INTO `wp_options` VALUES("2789", "_transient_timeout_wc_var_pricesce51a6c847bdb8cd33703d1450441899", "1453033933", "no");
INSERT INTO `wp_options` VALUES("2790", "_transient_wc_var_pricesce51a6c847bdb8cd33703d1450441899", "a:3:{s:5:\"price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:13:\"regular_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:10:\"sale_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}}", "no");
INSERT INTO `wp_options` VALUES("2791", "_transient_timeout_wc_var_prices7a8d3b537c3759c5f5a4351450441899", "1453033933", "no");
INSERT INTO `wp_options` VALUES("2792", "_transient_wc_var_prices7a8d3b537c3759c5f5a4351450441899", "a:3:{s:5:\"price\";a:2:{i:1748;i:99;i:1747;i:474;}s:13:\"regular_price\";a:2:{i:1748;i:99;i:1747;i:474;}s:10:\"sale_price\";a:2:{i:1748;i:99;i:1747;i:474;}}", "no");
INSERT INTO `wp_options` VALUES("2793", "_transient_timeout_wc_var_pricesd86413df0f571d40a96ad61450441899", "1453033933", "no");
INSERT INTO `wp_options` VALUES("2794", "_transient_wc_var_pricesd86413df0f571d40a96ad61450441899", "a:3:{s:5:\"price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:13:\"regular_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:10:\"sale_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}}", "no");
INSERT INTO `wp_options` VALUES("2795", "_transient_timeout_wc_var_pricesa060e08966aa176f5939311450441899", "1453033933", "no");
INSERT INTO `wp_options` VALUES("2796", "_transient_wc_var_pricesa060e08966aa176f5939311450441899", "a:3:{s:5:\"price\";a:2:{i:1750;i:119;i:1749;i:494;}s:13:\"regular_price\";a:2:{i:1750;i:119;i:1749;i:494;}s:10:\"sale_price\";a:2:{i:1750;i:119;i:1749;i:494;}}", "no");
INSERT INTO `wp_options` VALUES("2797", "_transient_timeout_wc_var_pricesbc5d6a0a068025392beb0d1450441899", "1453033933", "no");
INSERT INTO `wp_options` VALUES("2798", "_transient_wc_var_pricesbc5d6a0a068025392beb0d1450441899", "a:3:{s:5:\"price\";a:1:{i:1755;s:2:\"50\";}s:13:\"regular_price\";a:1:{i:1755;s:2:\"50\";}s:10:\"sale_price\";a:1:{i:1755;s:2:\"50\";}}", "no");
INSERT INTO `wp_options` VALUES("2799", "_transient_timeout_wc_var_prices6f766f67f198cf9a0beaa11450441899", "1453033934", "no");
INSERT INTO `wp_options` VALUES("2800", "_transient_wc_var_prices6f766f67f198cf9a0beaa11450441899", "a:3:{s:5:\"price\";a:1:{i:1755;i:50;}s:13:\"regular_price\";a:1:{i:1755;i:50;}s:10:\"sale_price\";a:1:{i:1755;i:50;}}", "no");
INSERT INTO `wp_options` VALUES("2801", "_transient_timeout_wc_var_prices1582135a424567c0f6cd7c1450441899", "1453033934", "no");
INSERT INTO `wp_options` VALUES("2802", "_transient_wc_var_prices1582135a424567c0f6cd7c1450441899", "a:3:{s:5:\"price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2803", "_transient_timeout_wc_var_prices725b5339f4822dd1f5f3601450441899", "1453033934", "no");
INSERT INTO `wp_options` VALUES("2804", "_transient_wc_var_prices725b5339f4822dd1f5f3601450441899", "a:3:{s:5:\"price\";a:2:{i:1712;i:309;i:1711;i:859;}s:13:\"regular_price\";a:2:{i:1712;i:309;i:1711;i:859;}s:10:\"sale_price\";a:2:{i:1712;i:309;i:1711;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2805", "_transient_timeout_wc_var_prices2b8caca71bc1fc4663f29b1450441899", "1453033934", "no");
INSERT INTO `wp_options` VALUES("2806", "_transient_wc_var_prices2b8caca71bc1fc4663f29b1450441899", "a:3:{s:5:\"price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2807", "_transient_timeout_wc_var_prices1db561b9b6b1c09073651b1450441899", "1453033934", "no");
INSERT INTO `wp_options` VALUES("2808", "_transient_wc_var_prices1db561b9b6b1c09073651b1450441899", "a:3:{s:5:\"price\";a:2:{i:1718;i:309;i:1609;i:859;}s:13:\"regular_price\";a:2:{i:1718;i:309;i:1609;i:859;}s:10:\"sale_price\";a:2:{i:1718;i:309;i:1609;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2809", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491450441899", "1453033934", "no");
INSERT INTO `wp_options` VALUES("2810", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491450441899", "a:3:{s:5:\"price\";a:1:{i:1759;s:3:\"449\";}s:13:\"regular_price\";a:1:{i:1759;s:3:\"449\";}s:10:\"sale_price\";a:1:{i:1759;s:3:\"449\";}}", "no");
INSERT INTO `wp_options` VALUES("2811", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931450441899", "1453033934", "no");
INSERT INTO `wp_options` VALUES("2812", "_transient_wc_var_pricese5e3a7ec74d543849a65931450441899", "a:3:{s:5:\"price\";a:1:{i:1759;i:449;}s:13:\"regular_price\";a:1:{i:1759;i:449;}s:10:\"sale_price\";a:1:{i:1759;i:449;}}", "no");
INSERT INTO `wp_options` VALUES("2813", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1450441899", "1453033934", "no");
INSERT INTO `wp_options` VALUES("2814", "_transient_wc_var_prices2a86c658d2bca1db535cbe1450441899", "a:3:{s:5:\"price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("2815", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2816", "_transient_wc_var_prices508ed4445f00ea7945b36b1450441899", "a:3:{s:5:\"price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:13:\"regular_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:10:\"sale_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("2817", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2818", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1450441899", "a:3:{s:5:\"price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:13:\"regular_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:10:\"sale_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}}", "no");
INSERT INTO `wp_options` VALUES("2819", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2820", "_transient_wc_var_pricesd6990a7b2f37804631e5641450441899", "a:3:{s:5:\"price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:13:\"regular_price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:10:\"sale_price\";a:2:{i:1764;i:465;i:1763;i:1015;}}", "no");
INSERT INTO `wp_options` VALUES("2821", "_transient_timeout_wc_rating_count_1671450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2822", "_transient_wc_rating_count_1671450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2823", "_transient_timeout_wc_average_rating_1671450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2824", "_transient_wc_average_rating_1671450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2825", "_transient_timeout_wc_rating_count_1651450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2826", "_transient_wc_rating_count_1651450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2827", "_transient_timeout_wc_average_rating_1651450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2828", "_transient_wc_average_rating_1651450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2829", "_transient_timeout_wc_rating_count_1541450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2830", "_transient_wc_rating_count_1541450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2831", "_transient_timeout_wc_average_rating_1541450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2832", "_transient_wc_average_rating_1541450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2833", "_transient_timeout_wc_rating_count_1461450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2834", "_transient_wc_rating_count_1461450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2835", "_transient_timeout_wc_average_rating_1461450441899", "1453033935", "no");
INSERT INTO `wp_options` VALUES("2836", "_transient_wc_average_rating_1461450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2837", "_transient_timeout_wc_rating_count_1431450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2838", "_transient_wc_rating_count_1431450441899", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("2839", "_transient_timeout_wc_average_rating_1431450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2840", "_transient_wc_average_rating_1431450441899", "3.00", "no");
INSERT INTO `wp_options` VALUES("2841", "_transient_timeout_wc_rating_count_1011450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2842", "_transient_wc_rating_count_1011450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2843", "_transient_timeout_wc_average_rating_1011450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2844", "_transient_wc_average_rating_1011450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2845", "_transient_timeout_wc_rating_count_941450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2846", "_transient_wc_rating_count_941450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2847", "_transient_timeout_wc_average_rating_941450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2848", "_transient_wc_average_rating_941450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2849", "_transient_timeout_wc_rating_count_681450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2850", "_transient_wc_rating_count_681450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2851", "_transient_timeout_wc_average_rating_681450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2852", "_transient_wc_average_rating_681450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2853", "_transient_timeout_wc_rating_count_441450441899", "1453033936", "no");
INSERT INTO `wp_options` VALUES("2854", "_transient_wc_rating_count_441450441899", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("2855", "_transient_timeout_wc_average_rating_441450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2856", "_transient_wc_average_rating_441450441899", "3.00", "no");
INSERT INTO `wp_options` VALUES("2857", "_transient_timeout_wc_rating_count_401450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2858", "_transient_wc_rating_count_401450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2859", "_transient_timeout_wc_average_rating_401450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2860", "_transient_wc_average_rating_401450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2861", "_transient_timeout_wc_rating_count_361450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2862", "_transient_wc_rating_count_361450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2863", "_transient_timeout_wc_average_rating_361450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2864", "_transient_wc_average_rating_361450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2865", "_transient_timeout_wc_rating_count_231450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2866", "_transient_wc_rating_count_231450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2867", "_transient_timeout_wc_average_rating_231450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2868", "_transient_wc_average_rating_231450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2869", "_transient_timeout_wc_rating_count_111450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2870", "_transient_wc_rating_count_111450441899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2871", "_transient_timeout_wc_average_rating_111450441899", "1453033937", "no");
INSERT INTO `wp_options` VALUES("2872", "_transient_wc_average_rating_111450441899", "0", "no");
INSERT INTO `wp_options` VALUES("2875", "_transient_timeout_wc_var_pricesce51a6c847bdb8cd33703d1450441931", "1453033975", "no");
INSERT INTO `wp_options` VALUES("2876", "_transient_wc_var_pricesce51a6c847bdb8cd33703d1450441931", "a:3:{s:5:\"price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:13:\"regular_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}s:10:\"sale_price\";a:2:{i:1748;s:2:\"99\";i:1747;s:3:\"474\";}}", "no");
INSERT INTO `wp_options` VALUES("2877", "_transient_timeout_wc_var_prices7a8d3b537c3759c5f5a4351450441931", "1453033975", "no");
INSERT INTO `wp_options` VALUES("2878", "_transient_wc_var_prices7a8d3b537c3759c5f5a4351450441931", "a:3:{s:5:\"price\";a:2:{i:1748;i:99;i:1747;i:474;}s:13:\"regular_price\";a:2:{i:1748;i:99;i:1747;i:474;}s:10:\"sale_price\";a:2:{i:1748;i:99;i:1747;i:474;}}", "no");
INSERT INTO `wp_options` VALUES("2879", "_transient_timeout_wc_var_pricesd86413df0f571d40a96ad61450441931", "1453033975", "no");
INSERT INTO `wp_options` VALUES("2880", "_transient_wc_var_pricesd86413df0f571d40a96ad61450441931", "a:3:{s:5:\"price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:13:\"regular_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}s:10:\"sale_price\";a:2:{i:1750;s:3:\"119\";i:1749;s:3:\"494\";}}", "no");
INSERT INTO `wp_options` VALUES("2881", "_transient_timeout_wc_var_pricesa060e08966aa176f5939311450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2882", "_transient_wc_var_pricesa060e08966aa176f5939311450441931", "a:3:{s:5:\"price\";a:2:{i:1750;i:119;i:1749;i:494;}s:13:\"regular_price\";a:2:{i:1750;i:119;i:1749;i:494;}s:10:\"sale_price\";a:2:{i:1750;i:119;i:1749;i:494;}}", "no");
INSERT INTO `wp_options` VALUES("2883", "_transient_timeout_wc_var_pricesbc5d6a0a068025392beb0d1450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2884", "_transient_wc_var_pricesbc5d6a0a068025392beb0d1450441931", "a:3:{s:5:\"price\";a:1:{i:1755;s:2:\"50\";}s:13:\"regular_price\";a:1:{i:1755;s:2:\"50\";}s:10:\"sale_price\";a:1:{i:1755;s:2:\"50\";}}", "no");
INSERT INTO `wp_options` VALUES("2885", "_transient_timeout_wc_var_prices6f766f67f198cf9a0beaa11450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2886", "_transient_wc_var_prices6f766f67f198cf9a0beaa11450441931", "a:3:{s:5:\"price\";a:1:{i:1755;i:50;}s:13:\"regular_price\";a:1:{i:1755;i:50;}s:10:\"sale_price\";a:1:{i:1755;i:50;}}", "no");
INSERT INTO `wp_options` VALUES("2887", "_transient_timeout_wc_var_prices1582135a424567c0f6cd7c1450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2888", "_transient_wc_var_prices1582135a424567c0f6cd7c1450441931", "a:3:{s:5:\"price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1712;s:3:\"309\";i:1711;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2889", "_transient_timeout_wc_var_prices725b5339f4822dd1f5f3601450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2890", "_transient_wc_var_prices725b5339f4822dd1f5f3601450441931", "a:3:{s:5:\"price\";a:2:{i:1712;i:309;i:1711;i:859;}s:13:\"regular_price\";a:2:{i:1712;i:309;i:1711;i:859;}s:10:\"sale_price\";a:2:{i:1712;i:309;i:1711;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2891", "_transient_timeout_wc_var_prices2b8caca71bc1fc4663f29b1450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2892", "_transient_wc_var_prices2b8caca71bc1fc4663f29b1450441931", "a:3:{s:5:\"price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:13:\"regular_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}s:10:\"sale_price\";a:2:{i:1718;s:3:\"309\";i:1609;s:3:\"859\";}}", "no");
INSERT INTO `wp_options` VALUES("2893", "_transient_timeout_wc_var_prices1db561b9b6b1c09073651b1450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2894", "_transient_wc_var_prices1db561b9b6b1c09073651b1450441931", "a:3:{s:5:\"price\";a:2:{i:1718;i:309;i:1609;i:859;}s:13:\"regular_price\";a:2:{i:1718;i:309;i:1609;i:859;}s:10:\"sale_price\";a:2:{i:1718;i:309;i:1609;i:859;}}", "no");
INSERT INTO `wp_options` VALUES("2895", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2896", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491450441931", "a:3:{s:5:\"price\";a:1:{i:1759;s:3:\"449\";}s:13:\"regular_price\";a:1:{i:1759;s:3:\"449\";}s:10:\"sale_price\";a:1:{i:1759;s:3:\"449\";}}", "no");
INSERT INTO `wp_options` VALUES("2897", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931450441931", "1453033976", "no");
INSERT INTO `wp_options` VALUES("2898", "_transient_wc_var_pricese5e3a7ec74d543849a65931450441931", "a:3:{s:5:\"price\";a:1:{i:1759;i:449;}s:13:\"regular_price\";a:1:{i:1759;i:449;}s:10:\"sale_price\";a:1:{i:1759;i:449;}}", "no");
INSERT INTO `wp_options` VALUES("2899", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1450441931", "1453033977", "no");
INSERT INTO `wp_options` VALUES("2900", "_transient_wc_var_prices2a86c658d2bca1db535cbe1450441931", "a:3:{s:5:\"price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1694;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1689;s:3:\"427\";i:1688;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1701;s:3:\"427\";i:1686;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1699;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("2901", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1450441931", "1453033977", "no");
INSERT INTO `wp_options` VALUES("2902", "_transient_wc_var_prices508ed4445f00ea7945b36b1450441931", "a:3:{s:5:\"price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:13:\"regular_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}s:10:\"sale_price\";a:20:{i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1694;i:427;i:1695;i:427;i:1698;i:427;i:1697;i:427;i:1696;i:427;i:1689;i:427;i:1688;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1701;i:427;i:1686;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1699;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("2903", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1450441931", "1453033977", "no");
INSERT INTO `wp_options` VALUES("2904", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1450441931", "a:3:{s:5:\"price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:13:\"regular_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:10:\"sale_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}}", "no");
INSERT INTO `wp_options` VALUES("2905", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641450441931", "1453033977", "no");
INSERT INTO `wp_options` VALUES("2906", "_transient_wc_var_pricesd6990a7b2f37804631e5641450441931", "a:3:{s:5:\"price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:13:\"regular_price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:10:\"sale_price\";a:2:{i:1764;i:465;i:1763;i:1015;}}", "no");
INSERT INTO `wp_options` VALUES("2907", "_transient_timeout_wc_rating_count_1671450441931", "1453033978", "no");
INSERT INTO `wp_options` VALUES("2908", "_transient_wc_rating_count_1671450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2909", "_transient_timeout_wc_average_rating_1671450441931", "1453033978", "no");
INSERT INTO `wp_options` VALUES("2910", "_transient_wc_average_rating_1671450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2911", "_transient_timeout_wc_rating_count_1651450441931", "1453033978", "no");
INSERT INTO `wp_options` VALUES("2912", "_transient_wc_rating_count_1651450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2913", "_transient_timeout_wc_average_rating_1651450441931", "1453033978", "no");
INSERT INTO `wp_options` VALUES("2914", "_transient_wc_average_rating_1651450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2915", "_transient_timeout_wc_rating_count_1541450441931", "1453033978", "no");
INSERT INTO `wp_options` VALUES("2916", "_transient_wc_rating_count_1541450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2917", "_transient_timeout_wc_average_rating_1541450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2918", "_transient_wc_average_rating_1541450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2919", "_transient_timeout_wc_rating_count_1461450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2920", "_transient_wc_rating_count_1461450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2921", "_transient_timeout_wc_average_rating_1461450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2922", "_transient_wc_average_rating_1461450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2923", "_transient_timeout_wc_rating_count_1431450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2924", "_transient_wc_rating_count_1431450441931", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("2925", "_transient_timeout_wc_average_rating_1431450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2926", "_transient_wc_average_rating_1431450441931", "3.00", "no");
INSERT INTO `wp_options` VALUES("2927", "_transient_timeout_wc_rating_count_1011450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2928", "_transient_wc_rating_count_1011450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2929", "_transient_timeout_wc_average_rating_1011450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2930", "_transient_wc_average_rating_1011450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2931", "_transient_timeout_wc_rating_count_941450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2932", "_transient_wc_rating_count_941450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2933", "_transient_timeout_wc_average_rating_941450441931", "1453033979", "no");
INSERT INTO `wp_options` VALUES("2934", "_transient_wc_average_rating_941450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2935", "_transient_timeout_wc_rating_count_681450441931", "1453033980", "no");
INSERT INTO `wp_options` VALUES("2936", "_transient_wc_rating_count_681450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2937", "_transient_timeout_wc_average_rating_681450441931", "1453033980", "no");
INSERT INTO `wp_options` VALUES("2938", "_transient_wc_average_rating_681450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2939", "_transient_timeout_wc_rating_count_471450441931", "1453033980", "no");
INSERT INTO `wp_options` VALUES("2940", "_transient_wc_rating_count_471450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2941", "_transient_timeout_wc_average_rating_471450441931", "1453033980", "no");
INSERT INTO `wp_options` VALUES("2942", "_transient_wc_average_rating_471450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2943", "_transient_timeout_wc_rating_count_441450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2944", "_transient_wc_rating_count_441450441931", "a:1:{i:3;s:1:\"1\";}", "no");
INSERT INTO `wp_options` VALUES("2945", "_transient_timeout_wc_average_rating_441450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2946", "_transient_wc_average_rating_441450441931", "3.00", "no");
INSERT INTO `wp_options` VALUES("2947", "_transient_timeout_wc_rating_count_401450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2948", "_transient_wc_rating_count_401450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2949", "_transient_timeout_wc_average_rating_401450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2950", "_transient_wc_average_rating_401450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2951", "_transient_timeout_wc_rating_count_361450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2952", "_transient_wc_rating_count_361450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2953", "_transient_timeout_wc_average_rating_361450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2954", "_transient_wc_average_rating_361450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2955", "_transient_timeout_wc_rating_count_231450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2956", "_transient_wc_rating_count_231450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2957", "_transient_timeout_wc_average_rating_231450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2958", "_transient_wc_average_rating_231450441931", "0", "no");
INSERT INTO `wp_options` VALUES("2959", "_transient_timeout_wc_rating_count_111450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2960", "_transient_wc_rating_count_111450441931", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("2961", "_transient_timeout_wc_average_rating_111450441931", "1453033981", "no");
INSERT INTO `wp_options` VALUES("2962", "_transient_wc_average_rating_111450441931", "0", "no");
INSERT INTO `wp_options` VALUES("3051", "_transient_timeout_external_ip_address_103.203.254.85", "1451103793", "no");
INSERT INTO `wp_options` VALUES("3052", "_transient_external_ip_address_103.203.254.85", "50.28.22.150", "no");
INSERT INTO `wp_options` VALUES("3817", "_transient_timeout_wc_product_children_143", "1453263827", "no");
INSERT INTO `wp_options` VALUES("3818", "_transient_wc_product_children_143", "a:2:{s:7:\"visible\";a:2:{i:0;i:1609;i:1;i:1718;}s:3:\"all\";a:2:{i:0;i:1609;i:1;i:1718;}}", "no");
INSERT INTO `wp_options` VALUES("4933", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("7872", "wpb_wrps_general", "a:3:{s:14:\"wpb_wrps_theme\";s:14:\"wrps_theme_box\";s:27:\"wpb_wrps_number_of_products\";i:9;s:26:\"wpb_wrps_number_of_columns\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("7907", "_transient_timeout_geoip_209.58.128.139", "1451297330", "no");
INSERT INTO `wp_options` VALUES("7908", "_transient_geoip_209.58.128.139", "US", "no");
INSERT INTO `wp_options` VALUES("7909", "_site_transient_timeout_browser_cb03ffde0d14b543ff285be2c17d49a4", "1451297393", "yes");
INSERT INTO `wp_options` VALUES("7910", "_site_transient_browser_cb03ffde0d14b543ff285be2c17d49a4", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"47.0.2526.106\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("7923", "_transient_timeout_geoip_209.58.128.134", "1451297473", "no");
INSERT INTO `wp_options` VALUES("7924", "_transient_geoip_209.58.128.134", "US", "no");
INSERT INTO `wp_options` VALUES("9166", "revslider-latest-version", "5.3.1.5", "yes");
INSERT INTO `wp_options` VALUES("9167", "revslider-stable-version", "4.2", "yes");
INSERT INTO `wp_options` VALUES("9168", "revslider-notices", "a:4:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.0.9\";s:4:\"text\";s:230:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow51_banner.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1 is out\" ></a>\";s:4:\"code\";s:9:\"TPRS51-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.4\";s:4:\"text\";s:242:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=515b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner515.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.6\";s:4:\"text\";s:240:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=52b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner52.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.2.9\";s:4:\"text\";s:249:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=530b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner_large_5.3.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.3.0 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS530-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("10512", "_transient_timeout_wc_cbp_5485bc83a3eccbf7b1d6d98661923019", "1453368782", "no");
INSERT INTO `wp_options` VALUES("10513", "_transient_wc_cbp_5485bc83a3eccbf7b1d6d98661923019", "0", "no");
INSERT INTO `wp_options` VALUES("10557", "instaemail_option", "a:13:{s:11:\"button_type\";s:12:\"custom-image\";s:12:\"custom_image\";s:0:\"\";s:11:\"custom_text\";s:17:\"Email to a Friend\";s:10:\"text_color\";s:7:\"#c3c3c3\";s:9:\"text_size\";i:14;s:16:\"content_position\";s:4:\"none\";s:17:\"content_placement\";s:5:\"after\";s:11:\"margin_left\";i:12;s:12:\"margin_right\";i:12;s:10:\"margin_top\";i:12;s:13:\"margin_bottom\";i:12;s:12:\"category_ids\";a:3:{i:0;s:1:\"6\";i:1;s:1:\"7\";i:2;s:1:\"1\";}s:10:\"db_version\";i:4;}", "yes");
INSERT INTO `wp_options` VALUES("10560", "checkout_process_options", "", "yes");
INSERT INTO `wp_options` VALUES("10561", "checkout_page_options", "", "yes");
INSERT INTO `wp_options` VALUES("10562", "account_endpoint_options", "", "yes");
INSERT INTO `wp_options` VALUES("10563", "checkout_endpoint_options", "", "yes");
INSERT INTO `wp_options` VALUES("10564", "payment_gateways_options", "", "yes");
INSERT INTO `wp_options` VALUES("10565", "woocommerce_default_gateway", "", "yes");
INSERT INTO `wp_options` VALUES("10566", "woocommerce_gateway_order", "a:5:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;s:6:\"paypal\";i:3;s:17:\"simplify_commerce\";i:4;}", "yes");
INSERT INTO `wp_options` VALUES("10575", "widget_yith-woocompare-widget", "a:2:{i:2;a:1:{s:5:\"title\";s:16:\"Compare Products\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("10576", "yith_woocompare_is_button", "link", "yes");
INSERT INTO `wp_options` VALUES("10577", "yith_woocompare_button_text", "Add to Compare", "yes");
INSERT INTO `wp_options` VALUES("10578", "yith_woocompare_compare_button_in_product_page", "no", "yes");
INSERT INTO `wp_options` VALUES("10579", "yith_woocompare_compare_button_in_products_list", "no", "yes");
INSERT INTO `wp_options` VALUES("10580", "yith_woocompare_auto_open", "yes", "yes");
INSERT INTO `wp_options` VALUES("10581", "yith_woocompare_table_text", "Compare products", "yes");
INSERT INTO `wp_options` VALUES("10582", "yith_woocompare_fields_attrs", "a:3:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:5:\"price\";}", "yes");
INSERT INTO `wp_options` VALUES("10583", "yith_woocompare_price_end", "no", "yes");
INSERT INTO `wp_options` VALUES("10584", "yith_woocompare_add_to_cart_end", "no", "yes");
INSERT INTO `wp_options` VALUES("10585", "yith_woocompare_image_size", "a:3:{s:5:\"width\";s:3:\"220\";s:6:\"height\";s:3:\"154\";s:4:\"crop\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("10586", "yith_woocompare_fields", "a:9:{s:5:\"image\";b:1;s:5:\"title\";b:1;s:5:\"price\";b:1;s:11:\"add-to-cart\";b:0;s:11:\"description\";b:0;s:5:\"stock\";b:0;s:8:\"pa_sizes\";b:0;s:8:\"pa_color\";b:0;s:15:\"pa_product_type\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("10587", "yith_woocompare_general", "", "yes");
INSERT INTO `wp_options` VALUES("10588", "yith_woocompare_general_end", "", "yes");
INSERT INTO `wp_options` VALUES("10589", "yith_woocompare_table", "", "yes");
INSERT INTO `wp_options` VALUES("10590", "yith_woocompare_table_end", "", "yes");
INSERT INTO `wp_options` VALUES("10607", "_transient_timeout_geoip_104.209.188.207", "1451390500", "no");
INSERT INTO `wp_options` VALUES("10608", "_transient_geoip_104.209.188.207", "US", "no");
INSERT INTO `wp_options` VALUES("10609", "_transient_timeout_geoip_130.211.166.129", "1451390691", "no");
INSERT INTO `wp_options` VALUES("10610", "_transient_geoip_130.211.166.129", "US", "no");
INSERT INTO `wp_options` VALUES("10686", "account_page_options", "", "yes");
INSERT INTO `wp_options` VALUES("10687", "account_registration_options", "", "yes");
INSERT INTO `wp_options` VALUES("10697", "catalog_options", "", "yes");
INSERT INTO `wp_options` VALUES("10698", "image_options", "", "yes");
INSERT INTO `wp_options` VALUES("10716", "yith_wcwl_general_settings", "", "yes");
INSERT INTO `wp_options` VALUES("10717", "yith_wcwl_button_position", "add-to-cart", "yes");
INSERT INTO `wp_options` VALUES("10718", "yith_wcwl_socials_share", "", "yes");
INSERT INTO `wp_options` VALUES("10719", "yith_wcwl_styles", "", "yes");
INSERT INTO `wp_options` VALUES("10720", "yith_wcwl_yith_wfbt", "", "yes");
INSERT INTO `wp_options` VALUES("10742", "woocommerce_paypal_settings", "a:18:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:22:\"prem@abacusdesk.co.in\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:8:\"advanced\";s:0:\"\";s:14:\"receiver_email\";s:22:\"prem@abacusdesk.co.in\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:2:\"no\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:10:\"page_style\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("10745", "woocommerce_cheque_settings", "a:4:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:14:\"Cheque Payment\";s:11:\"description\";s:102:\"Please send your cheque to Store Name, Store Street, Store Town, Store State / County, Store Postcode.\";s:12:\"instructions\";s:102:\"Please send your cheque to Store Name, Store Street, Store Town, Store State / County, Store Postcode.\";}", "yes");
INSERT INTO `wp_options` VALUES("10750", "woocommerce_cod_settings", "a:6:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:16:\"Cash on Delivery\";s:11:\"description\";s:28:\"Pay with cash upon delivery.\";s:12:\"instructions\";s:28:\"Pay with cash upon delivery.\";s:18:\"enable_for_methods\";s:0:\"\";s:18:\"enable_for_virtual\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("10763", "email_recipient_options", "", "yes");
INSERT INTO `wp_options` VALUES("10764", "email_options", "", "yes");
INSERT INTO `wp_options` VALUES("10765", "email_template_options", "", "yes");
INSERT INTO `wp_options` VALUES("10819", "revslider-notices-dc", "a:2:{i:0;s:9:\"TPRS51-01\";i:1;s:10:\"TPRS515-01\";}", "yes");
INSERT INTO `wp_options` VALUES("10839", "_transient_timeout_wc_cbp_4c68feb4011faf9b0c82eb2d6d353e3d", "1453525811", "no");
INSERT INTO `wp_options` VALUES("10840", "_transient_wc_cbp_4c68feb4011faf9b0c82eb2d6d353e3d", "0", "no");
INSERT INTO `wp_options` VALUES("10880", "wpcf7", "a:1:{s:7:\"version\";s:5:\"4.3.1\";}", "yes");
INSERT INTO `wp_options` VALUES("10911", "_transient_timeout_wc_cbp_eccab9be810877b6b59292b065b0fd09", "1453528713", "no");
INSERT INTO `wp_options` VALUES("10912", "_transient_wc_cbp_eccab9be810877b6b59292b065b0fd09", "0", "no");
INSERT INTO `wp_options` VALUES("11072", "_transient_timeout_geoip_1.39.34.52", "1451555171", "no");
INSERT INTO `wp_options` VALUES("11073", "_transient_geoip_1.39.34.52", "IN", "no");
INSERT INTO `wp_options` VALUES("11089", "_transient_timeout_geoip_103.203.255.157", "1451621715", "no");
INSERT INTO `wp_options` VALUES("11090", "_transient_geoip_103.203.255.157", "", "no");
INSERT INTO `wp_options` VALUES("11091", "_transient_timeout_external_ip_address_103.203.255.157", "1451621716", "no");
INSERT INTO `wp_options` VALUES("11092", "_transient_external_ip_address_103.203.255.157", "50.28.22.150", "no");
INSERT INTO `wp_options` VALUES("11117", "_transient_timeout_wc_product_children_167", "1453718063", "no");
INSERT INTO `wp_options` VALUES("11118", "_transient_wc_product_children_167", "a:2:{s:7:\"visible\";a:2:{i:0;i:1747;i:1;i:1748;}s:3:\"all\";a:2:{i:0;i:1747;i:1;i:1748;}}", "no");
INSERT INTO `wp_options` VALUES("14081", "_transient_timeout_geoip_106.202.213.227", "1451662375", "no");
INSERT INTO `wp_options` VALUES("14082", "_transient_geoip_106.202.213.227", "IN", "no");
INSERT INTO `wp_options` VALUES("14084", "_transient_timeout_geoip_150.70.173.9", "1451662493", "no");
INSERT INTO `wp_options` VALUES("14085", "_transient_geoip_150.70.173.9", "JP", "no");
INSERT INTO `wp_options` VALUES("14204", "_transient_timeout_geoip_103.203.255.133", "1451728807", "no");
INSERT INTO `wp_options` VALUES("14205", "_transient_geoip_103.203.255.133", "", "no");
INSERT INTO `wp_options` VALUES("14206", "_transient_timeout_external_ip_address_103.203.255.133", "1451728807", "no");
INSERT INTO `wp_options` VALUES("14207", "_transient_external_ip_address_103.203.255.133", "50.28.22.150", "no");
INSERT INTO `wp_options` VALUES("15402", "pa_product_type_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("15405", "_transient_wc_attribute_taxonomies", "a:4:{i:0;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:5:\"sizes\";s:15:\"attribute_label\";s:5:\"Sizes\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:1;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"2\";s:14:\"attribute_name\";s:5:\"color\";s:15:\"attribute_label\";s:5:\"Color\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:2;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"3\";s:14:\"attribute_name\";s:12:\"product_type\";s:15:\"attribute_label\";s:4:\"Type\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:2:\"id\";s:16:\"attribute_public\";s:1:\"0\";}i:3;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"4\";s:14:\"attribute_name\";s:16:\"protection-level\";s:15:\"attribute_label\";s:16:\"Protection Level\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}}", "yes");
INSERT INTO `wp_options` VALUES("15407", "pa_protection-level_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("15766", "widget_bcn_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("16363", "wcb_breadcrumb_options", "a:8:{s:22:\"wcb_enable_breadcrumbs\";s:1:\"1\";s:24:\"wcb_breadcrumb_delimiter\";s:3:\" / \";s:15:\"wcb_wrap_before\";s:36:\"<nav class=\"woocommerce-breadcrumb\">\";s:14:\"wcb_wrap_after\";s:6:\"</nav>\";s:10:\"wcb_before\";s:0:\"\";s:9:\"wcb_after\";s:0:\"\";s:13:\"wcb_home_text\";s:4:\"Home\";s:12:\"wcb_home_url\";s:33:\"http://www.hardshell.com/\";}", "yes");
INSERT INTO `wp_options` VALUES("16408", "_transient_timeout_geoip_40.78.146.128", "1451898578", "no");
INSERT INTO `wp_options` VALUES("16409", "_transient_geoip_40.78.146.128", "US", "no");
INSERT INTO `wp_options` VALUES("16485", "woocommerce_wf_fedex_woocommerce_shipping_settings", "a:40:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:19:\"FedEx Basic Version\";s:14:\"account_number\";s:9:\"612990808\";s:12:\"meter_number\";s:9:\"107821791\";s:7:\"api_key\";s:0:\"\";s:8:\"api_pass\";s:0:\"\";s:10:\"production\";s:3:\"yes\";s:14:\"packing_method\";s:8:\"per_item\";s:11:\"residential\";s:2:\"no\";s:15:\"insure_contents\";s:3:\"yes\";s:14:\"fedex_one_rate\";s:3:\"yes\";s:12:\"request_type\";s:4:\"LIST\";s:13:\"smartpost_hub\";s:0:\"\";s:7:\"indicia\";s:13:\"PARCEL_SELECT\";s:11:\"offer_rates\";s:8:\"cheapest\";s:8:\"services\";a:21:{s:15:\"FIRST_OVERNIGHT\";a:5:{s:4:\"name\";s:21:\"FedEx First Overnight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:18:\"PRIORITY_OVERNIGHT\";a:5:{s:4:\"name\";s:24:\"FedEx Priority Overnight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:18:\"STANDARD_OVERNIGHT\";a:5:{s:4:\"name\";s:24:\"FedEx Standard Overnight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:14:\"FEDEX_2_DAY_AM\";a:5:{s:4:\"name\";s:14:\"FedEx 2Day A.M\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:11:\"FEDEX_2_DAY\";a:5:{s:4:\"name\";s:10:\"FedEx 2Day\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:19:\"FEDEX_EXPRESS_SAVER\";a:5:{s:4:\"name\";s:19:\"FedEx Express Saver\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:20:\"GROUND_HOME_DELIVERY\";a:5:{s:4:\"name\";s:26:\"FedEx Ground Home Delivery\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:12:\"FEDEX_GROUND\";a:5:{s:4:\"name\";s:12:\"FedEx Ground\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:21:\"INTERNATIONAL_ECONOMY\";a:5:{s:4:\"name\";s:27:\"FedEx International Economy\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:19:\"INTERNATIONAL_FIRST\";a:5:{s:4:\"name\";s:25:\"FedEx International First\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:22:\"INTERNATIONAL_PRIORITY\";a:5:{s:4:\"name\";s:28:\"FedEx International Priority\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:35:\"EUROPE_FIRST_INTERNATIONAL_PRIORITY\";a:5:{s:4:\"name\";s:41:\"FedEx Europe First International Priority\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:19:\"FEDEX_1_DAY_FREIGHT\";a:5:{s:4:\"name\";s:19:\"FedEx 1 Day Freight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:19:\"FEDEX_2_DAY_FREIGHT\";a:5:{s:4:\"name\";s:19:\"FedEx 2 Day Freight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:19:\"FEDEX_3_DAY_FREIGHT\";a:5:{s:4:\"name\";s:19:\"FedEx 3 Day Freight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:29:\"INTERNATIONAL_ECONOMY_FREIGHT\";a:5:{s:4:\"name\";s:21:\"FedEx Economy Freight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:30:\"INTERNATIONAL_PRIORITY_FREIGHT\";a:5:{s:4:\"name\";s:22:\"FedEx Priority Freight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:10:\"SMART_POST\";a:5:{s:4:\"name\";s:16:\"FedEx Smart Post\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:19:\"FEDEX_FIRST_FREIGHT\";a:5:{s:4:\"name\";s:19:\"FedEx First Freight\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:21:\"FEDEX_FREIGHT_ECONOMY\";a:5:{s:4:\"name\";s:21:\"FedEx Freight Economy\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}s:22:\"FEDEX_FREIGHT_PRIORITY\";a:5:{s:4:\"name\";s:22:\"FedEx Freight Priority\";s:5:\"order\";s:0:\"\";s:7:\"enabled\";b:1;s:10:\"adjustment\";s:0:\"\";s:18:\"adjustment_percent\";s:0:\"\";}}s:6:\"origin\";s:0:\"\";s:19:\"shipper_person_name\";s:0:\"\";s:20:\"shipper_company_name\";s:0:\"\";s:20:\"shipper_phone_number\";s:0:\"\";s:22:\"freight_shipper_street\";s:0:\"\";s:16:\"shipper_street_2\";s:0:\"\";s:20:\"freight_shipper_city\";s:0:\"\";s:21:\"freight_shipper_state\";s:0:\"\";s:19:\"shipper_residential\";s:2:\"no\";s:7:\"freight\";s:0:\"\";s:15:\"freight_enabled\";s:2:\"no\";s:14:\"freight_number\";s:0:\"\";s:22:\"freight_billing_street\";s:0:\"\";s:16:\"billing_street_2\";s:0:\"\";s:20:\"freight_billing_city\";s:0:\"\";s:21:\"freight_billing_state\";s:0:\"\";s:16:\"billing_postcode\";s:0:\"\";s:15:\"billing_country\";s:0:\"\";s:13:\"freight_class\";s:2:\"50\";s:13:\"output_format\";s:12:\"PAPER_7X4.75\";s:10:\"image_type\";s:3:\"pdf\";s:19:\"tracking_shipmentid\";s:2:\"no\";s:16:\"convert_currency\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("16486", "_transient_shipping-transient-version", "1451303156", "yes");
INSERT INTO `wp_options` VALUES("16490", "shipping_options", "", "yes");
INSERT INTO `wp_options` VALUES("16491", "woocommerce_shipping_method_selection_priority", "a:6:{s:9:\"flat_rate\";i:1;s:13:\"free_shipping\";i:1;s:22:\"international_delivery\";i:1;s:14:\"local_delivery\";i:1;s:12:\"local_pickup\";i:1;s:29:\"wf_fedex_woocommerce_shipping\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("16492", "woocommerce_shipping_method_order", "a:6:{s:9:\"flat_rate\";i:0;s:13:\"free_shipping\";i:1;s:22:\"international_delivery\";i:2;s:14:\"local_delivery\";i:3;s:12:\"local_pickup\";i:4;s:29:\"wf_fedex_woocommerce_shipping\";i:5;}", "yes");
INSERT INTO `wp_options` VALUES("16506", "_transient_woocommerce_cache_excluded_uris", "a:6:{i:0;s:3:\"p=7\";i:1;s:6:\"/cart/\";i:2;s:3:\"p=8\";i:3;s:10:\"/checkout/\";i:4;s:3:\"p=9\";i:5;s:12:\"/my-account/\";}", "yes");
INSERT INTO `wp_options` VALUES("16520", "_transient_timeout_wc_ship_9c18b2fa482b5c881460f57f790ab988", "1451307896", "no");
INSERT INTO `wp_options` VALUES("16521", "_transient_wc_ship_9c18b2fa482b5c881460f57f790ab988", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("16523", "_transient_timeout_wc_ship_7dbf0ba9fe86ce418e4766a6b678d19d", "1451307902", "no");
INSERT INTO `wp_options` VALUES("16524", "_transient_wc_ship_7dbf0ba9fe86ce418e4766a6b678d19d", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("16582", "_transient_timeout_wc_ship_b1d097a333dba44f2937a91f59e0836d", "1451367489", "no");
INSERT INTO `wp_options` VALUES("16583", "_transient_wc_ship_b1d097a333dba44f2937a91f59e0836d", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("16584", "_transient_timeout_wc_ship_407f97fc5feb2523b4dd2be5f55167a7", "1451367495", "no");
INSERT INTO `wp_options` VALUES("16585", "_transient_wc_ship_407f97fc5feb2523b4dd2be5f55167a7", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("16586", "_transient_timeout_geoip_10.9.71.1", "1451969092", "no");
INSERT INTO `wp_options` VALUES("16587", "_transient_geoip_10.9.71.1", "", "no");
INSERT INTO `wp_options` VALUES("16638", "LR_PLUGIN_VERSION", "3.5.1", "yes");
INSERT INTO `wp_options` VALUES("16639", "LR_PLUGIN_PKG", "S9", "yes");
INSERT INTO `wp_options` VALUES("16640", "LoginRadius_API_settings", "a:7:{s:18:\"LoginRadius_apikey\";s:0:\"\";s:18:\"LoginRadius_secret\";s:0:\"\";s:17:\"scripts_in_footer\";s:1:\"1\";s:14:\"delete_options\";s:1:\"0\";s:8:\"sitename\";s:0:\"\";s:16:\"multisite_config\";s:1:\"1\";s:11:\"raas_enable\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("16641", "LoginRadius_share_settings", "a:10:{s:17:\"horizontal_enable\";s:1:\"1\";s:26:\"horizontal_share_interface\";s:4:\"32-h\";s:28:\"horizontal_sharing_providers\";a:2:{s:7:\"Default\";a:4:{s:8:\"Facebook\";s:8:\"Facebook\";s:10:\"GooglePlus\";s:10:\"GooglePlus\";s:8:\"LinkedIn\";s:8:\"LinkedIn\";s:7:\"Twitter\";s:7:\"Twitter\";}s:6:\"Hybrid\";a:5:{s:13:\"Facebook Like\";s:13:\"Facebook Like\";s:13:\"Twitter Tweet\";s:13:\"Twitter Tweet\";s:13:\"Google+ Share\";s:13:\"Google+ Share\";s:16:\"Pinterest Pin it\";s:16:\"Pinterest Pin it\";s:14:\"LinkedIn Share\";s:14:\"LinkedIn Share\";}}s:30:\"horizontal_rearrange_providers\";a:4:{i:0;s:8:\"Facebook\";i:1;s:7:\"Twitter\";i:2;s:8:\"LinkedIn\";i:3;s:10:\"GooglePlus\";}s:18:\"lr-clicker-hr-post\";s:1:\"1\";s:19:\"horizontal_position\";a:2:{s:5:\"Posts\";a:1:{s:6:\"Bottom\";s:6:\"Bottom\";}s:5:\"Pages\";a:1:{s:3:\"Top\";s:3:\"Top\";}}s:24:\"vertical_share_interface\";s:4:\"32-v\";s:26:\"vertical_sharing_providers\";a:2:{s:7:\"Default\";a:7:{s:5:\"Email\";s:5:\"Email\";s:8:\"Facebook\";s:8:\"Facebook\";s:10:\"GooglePlus\";s:10:\"GooglePlus\";s:8:\"LinkedIn\";s:8:\"LinkedIn\";s:9:\"Pinterest\";s:9:\"Pinterest\";s:5:\"Print\";s:5:\"Print\";s:7:\"Twitter\";s:7:\"Twitter\";}s:6:\"Hybrid\";a:5:{s:13:\"Facebook Like\";s:13:\"Facebook Like\";s:13:\"Twitter Tweet\";s:13:\"Twitter Tweet\";s:13:\"Google+ Share\";s:13:\"Google+ Share\";s:16:\"Pinterest Pin it\";s:16:\"Pinterest Pin it\";s:14:\"LinkedIn Share\";s:14:\"LinkedIn Share\";}}s:28:\"vertical_rearrange_providers\";a:7:{i:0;s:8:\"Facebook\";i:1;s:7:\"Twitter\";i:2;s:8:\"LinkedIn\";i:3;s:10:\"GooglePlus\";i:4;s:9:\"Pinterest\";i:5;s:5:\"Email\";i:6;s:5:\"Print\";}s:13:\"mobile_enable\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("16642", "widget_loginradiushorizontalshare", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18037", "_transient_timeout_wc_tax_rates_7567d13e660c99289108ec4b934c1642", "1451992169", "no");
INSERT INTO `wp_options` VALUES("18038", "_transient_wc_tax_rates_7567d13e660c99289108ec4b934c1642", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("18155", "pa_sizes_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("18420", "_transient_timeout_wc_ship_c8494b0fb97d7709cfbbf84765dd2b11", "1451456544", "no");
INSERT INTO `wp_options` VALUES("18421", "_transient_wc_ship_c8494b0fb97d7709cfbbf84765dd2b11", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("18422", "_transient_timeout_wc_ship_295ead794e519fef42224eb5bdf92390", "1451456549", "no");
INSERT INTO `wp_options` VALUES("18423", "_transient_wc_ship_295ead794e519fef42224eb5bdf92390", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("18542", "_transient_timeout_wc_ship_a11b6d678631a40819af2223d9e9a5ef", "1451456779", "no");
INSERT INTO `wp_options` VALUES("18543", "_transient_wc_ship_a11b6d678631a40819af2223d9e9a5ef", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("18552", "_transient_timeout_wc_ship_76588b9e56c3858c8becb87dbafb64fa", "1451456788", "no");
INSERT INTO `wp_options` VALUES("18553", "_transient_wc_ship_76588b9e56c3858c8becb87dbafb64fa", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("18554", "_transient_timeout_wc_ship_c1c7855512e95c89c970bf48890719a6", "1451456794", "no");
INSERT INTO `wp_options` VALUES("18555", "_transient_wc_ship_c1c7855512e95c89c970bf48890719a6", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("18556", "_transient_timeout_wc_ship_d67286cec3964cf8c02c174cb935b43b", "1451456799", "no");
INSERT INTO `wp_options` VALUES("18557", "_transient_wc_ship_d67286cec3964cf8c02c174cb935b43b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("18562", "_transient_timeout_wc_ship_40cee5fb12e4545a3bdada87b207cde2", "1451456806", "no");
INSERT INTO `wp_options` VALUES("18563", "_transient_wc_ship_40cee5fb12e4545a3bdada87b207cde2", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("18610", "_transient_timeout_wc_ship_fd6b2172bb9c754852de7d0cb2c00202", "1451456813", "no");
INSERT INTO `wp_options` VALUES("18611", "_transient_wc_ship_fd6b2172bb9c754852de7d0cb2c00202", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("19375", "pa_color_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("19504", "_transient_timeout_wc_var_prices3a88fa3fbf3e091533aafa1451457930", "1454052133", "no");
INSERT INTO `wp_options` VALUES("19505", "_transient_wc_var_prices3a88fa3fbf3e091533aafa1451457930", "a:3:{s:5:\"price\";a:2:{i:2121;s:1:\"0\";i:2120;s:1:\"0\";}s:13:\"regular_price\";a:2:{i:2121;s:1:\"0\";i:2120;s:1:\"0\";}s:10:\"sale_price\";a:2:{i:2121;s:1:\"0\";i:2120;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("19506", "_transient_timeout_wc_rating_count_20091451457930", "1454052133", "no");
INSERT INTO `wp_options` VALUES("19507", "_transient_wc_rating_count_20091451457930", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("19508", "_transient_timeout_wc_review_count_20091451457930", "1454052133", "no");
INSERT INTO `wp_options` VALUES("19509", "_transient_wc_review_count_20091451457930", "0", "no");
INSERT INTO `wp_options` VALUES("19510", "_transient_timeout_wc_average_rating_20091451457930", "1454052134", "no");
INSERT INTO `wp_options` VALUES("19511", "_transient_wc_average_rating_20091451457930", "0", "no");
INSERT INTO `wp_options` VALUES("19512", "_transient_timeout_wc_var_prices878e559915a7734f60a94d1451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19513", "_transient_wc_var_prices878e559915a7734f60a94d1451457930", "a:3:{s:5:\"price\";a:2:{i:2121;i:0;i:2120;i:0;}s:13:\"regular_price\";a:2:{i:2121;i:0;i:2120;i:0;}s:10:\"sale_price\";a:2:{i:2121;i:0;i:2120;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("19514", "_transient_timeout_wc_related_4_20091451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19515", "_transient_wc_related_4_20091451457930", "a:4:{i:0;s:2:\"68\";i:1;s:3:\"900\";i:2;s:4:\"1994\";i:3;s:4:\"1999\";}", "no");
INSERT INTO `wp_options` VALUES("19516", "_transient_timeout_wc_var_pricesd88a3f01c127092b0548851451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19517", "_transient_wc_var_pricesd88a3f01c127092b0548851451457930", "a:3:{s:5:\"price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}s:13:\"regular_price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}s:10:\"sale_price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}}", "no");
INSERT INTO `wp_options` VALUES("19518", "_transient_timeout_wc_var_prices835a053f96e2e85748b2c51451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19519", "_transient_wc_var_prices835a053f96e2e85748b2c51451457930", "a:3:{s:5:\"price\";a:2:{i:2112;i:515;i:2113;i:1065;}s:13:\"regular_price\";a:2:{i:2112;i:515;i:2113;i:1065;}s:10:\"sale_price\";a:2:{i:2112;i:515;i:2113;i:1065;}}", "no");
INSERT INTO `wp_options` VALUES("19520", "_transient_timeout_wc_var_prices3d6e74621fe9edd88bc7071451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19521", "_transient_wc_var_prices3d6e74621fe9edd88bc7071451457930", "a:3:{s:5:\"price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}s:13:\"regular_price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}s:10:\"sale_price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}}", "no");
INSERT INTO `wp_options` VALUES("19522", "_transient_timeout_wc_var_prices14bc62b689f5c1de50263f1451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19523", "_transient_wc_var_prices14bc62b689f5c1de50263f1451457930", "a:3:{s:5:\"price\";a:2:{i:1771;i:418;i:1770;i:968;}s:13:\"regular_price\";a:2:{i:1771;i:418;i:1770;i:968;}s:10:\"sale_price\";a:2:{i:1771;i:418;i:1770;i:968;}}", "no");
INSERT INTO `wp_options` VALUES("19524", "_transient_timeout_wc_var_prices2f1f702ec5b5e5893961ba1451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19525", "_transient_wc_var_prices2f1f702ec5b5e5893961ba1451457930", "a:3:{s:5:\"price\";a:2:{i:2110;s:4:\"0.00\";i:2111;s:4:\"0.00\";}s:13:\"regular_price\";a:2:{i:2110;s:4:\"0.00\";i:2111;s:4:\"0.00\";}s:10:\"sale_price\";a:2:{i:2110;s:4:\"0.00\";i:2111;s:4:\"0.00\";}}", "no");
INSERT INTO `wp_options` VALUES("19526", "_transient_timeout_wc_var_pricesef310e0f0fe39a82ccbcd01451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19527", "_transient_wc_var_pricesef310e0f0fe39a82ccbcd01451457930", "a:3:{s:5:\"price\";a:2:{i:2110;d:0;i:2111;d:0;}s:13:\"regular_price\";a:2:{i:2110;d:0;i:2111;d:0;}s:10:\"sale_price\";a:2:{i:2110;d:0;i:2111;d:0;}}", "no");
INSERT INTO `wp_options` VALUES("19528", "_transient_timeout_wc_var_prices498294ebc8f0e6002122231451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19529", "_transient_wc_var_prices498294ebc8f0e6002122231451457930", "a:3:{s:5:\"price\";a:2:{i:2122;s:2:\"00\";i:2123;s:2:\"00\";}s:13:\"regular_price\";a:2:{i:2122;s:2:\"00\";i:2123;s:2:\"00\";}s:10:\"sale_price\";a:2:{i:2122;s:2:\"00\";i:2123;s:2:\"00\";}}", "no");
INSERT INTO `wp_options` VALUES("19530", "_transient_timeout_wc_var_prices05691ac6ea37574095d4c31451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19531", "_transient_wc_var_prices05691ac6ea37574095d4c31451457930", "a:3:{s:5:\"price\";a:2:{i:2122;i:0;i:2123;i:0;}s:13:\"regular_price\";a:2:{i:2122;i:0;i:2123;i:0;}s:10:\"sale_price\";a:2:{i:2122;i:0;i:2123;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("19532", "_transient_timeout_wc_var_pricesd4bde988b01523bff59a671451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19533", "_transient_wc_var_pricesd4bde988b01523bff59a671451457930", "a:3:{s:5:\"price\";a:16:{i:1904;i:409;i:1903;i:409;i:1902;i:409;i:1905;i:409;i:1906;i:409;i:1908;i:409;i:1907;i:409;i:1917;i:409;i:1916;i:409;i:1911;i:409;i:1910;i:409;i:1912;i:409;i:1913;i:409;i:1915;i:409;i:1914;i:409;i:1909;i:409;}s:13:\"regular_price\";a:16:{i:1904;i:409;i:1903;i:409;i:1902;i:409;i:1905;i:409;i:1906;i:409;i:1908;i:409;i:1907;i:409;i:1917;i:409;i:1916;i:409;i:1911;i:409;i:1910;i:409;i:1912;i:409;i:1913;i:409;i:1915;i:409;i:1914;i:409;i:1909;i:409;}s:10:\"sale_price\";a:16:{i:1904;i:409;i:1903;i:409;i:1902;i:409;i:1905;i:409;i:1906;i:409;i:1908;i:409;i:1907;i:409;i:1917;i:409;i:1916;i:409;i:1911;i:409;i:1910;i:409;i:1912;i:409;i:1913;i:409;i:1915;i:409;i:1914;i:409;i:1909;i:409;}}", "no");
INSERT INTO `wp_options` VALUES("19534", "_transient_timeout_wc_var_prices77315792d97a90c74547981451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19535", "_transient_wc_var_prices77315792d97a90c74547981451457930", "a:3:{s:5:\"price\";a:16:{i:1904;s:3:\"409\";i:1903;s:3:\"409\";i:1902;s:3:\"409\";i:1905;s:3:\"409\";i:1906;s:3:\"409\";i:1908;s:3:\"409\";i:1907;s:3:\"409\";i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1911;s:3:\"409\";i:1910;s:3:\"409\";i:1912;s:3:\"409\";i:1913;s:3:\"409\";i:1915;s:3:\"409\";i:1914;s:3:\"409\";i:1909;s:3:\"409\";}s:13:\"regular_price\";a:16:{i:1904;s:3:\"409\";i:1903;s:3:\"409\";i:1902;s:3:\"409\";i:1905;s:3:\"409\";i:1906;s:3:\"409\";i:1908;s:3:\"409\";i:1907;s:3:\"409\";i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1911;s:3:\"409\";i:1910;s:3:\"409\";i:1912;s:3:\"409\";i:1913;s:3:\"409\";i:1915;s:3:\"409\";i:1914;s:3:\"409\";i:1909;s:3:\"409\";}s:10:\"sale_price\";a:16:{i:1904;s:3:\"409\";i:1903;s:3:\"409\";i:1902;s:3:\"409\";i:1905;s:3:\"409\";i:1906;s:3:\"409\";i:1908;s:3:\"409\";i:1907;s:3:\"409\";i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1911;s:3:\"409\";i:1910;s:3:\"409\";i:1912;s:3:\"409\";i:1913;s:3:\"409\";i:1915;s:3:\"409\";i:1914;s:3:\"409\";i:1909;s:3:\"409\";}}", "no");
INSERT INTO `wp_options` VALUES("19536", "_transient_timeout_wc_var_prices988869ad4a22232c07e90f1451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19537", "_transient_wc_var_prices988869ad4a22232c07e90f1451457930", "a:3:{s:5:\"price\";a:1:{i:2129;i:0;}s:13:\"regular_price\";a:1:{i:2129;i:0;}s:10:\"sale_price\";a:1:{i:2129;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("19538", "_transient_timeout_wc_var_prices2c207d5468e429484a1e871451457930", "1454052136", "no");
INSERT INTO `wp_options` VALUES("19539", "_transient_wc_var_prices2c207d5468e429484a1e871451457930", "a:3:{s:5:\"price\";a:1:{i:2129;s:1:\"0\";}s:13:\"regular_price\";a:1:{i:2129;s:1:\"0\";}s:10:\"sale_price\";a:1:{i:2129;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("19757", "_transient_timeout_geoip_122.160.86.15", "1452076199", "no");
INSERT INTO `wp_options` VALUES("19758", "_transient_geoip_122.160.86.15", "IN", "no");
INSERT INTO `wp_options` VALUES("19781", "_transient_timeout_geoip_81.106.135.132", "1452084506", "no");
INSERT INTO `wp_options` VALUES("19782", "_transient_geoip_81.106.135.132", "GB", "no");
INSERT INTO `wp_options` VALUES("19786", "_transient_timeout_geoip_115.184.84.162", "1452085909", "no");
INSERT INTO `wp_options` VALUES("19787", "_transient_geoip_115.184.84.162", "IN", "no");
INSERT INTO `wp_options` VALUES("19796", "_transient_timeout_geoip_182.77.58.9", "1452144611", "no");
INSERT INTO `wp_options` VALUES("19797", "_transient_geoip_182.77.58.9", "IN", "no");
INSERT INTO `wp_options` VALUES("19798", "_transient_timeout_geoip_122.161.221.71", "1452146295", "no");
INSERT INTO `wp_options` VALUES("19799", "_transient_geoip_122.161.221.71", "IN", "no");
INSERT INTO `wp_options` VALUES("19815", "_transient_timeout_geoip_174.129.228.67", "1452269712", "no");
INSERT INTO `wp_options` VALUES("19816", "_transient_geoip_174.129.228.67", "US", "no");
INSERT INTO `wp_options` VALUES("19821", "_transient_timeout_geoip_50.28.22.150", "1452315305", "no");
INSERT INTO `wp_options` VALUES("19822", "_transient_geoip_50.28.22.150", "US", "no");
INSERT INTO `wp_options` VALUES("19823", "_transient_timeout_geoip_10.9.71.2", "1452315345", "no");
INSERT INTO `wp_options` VALUES("19824", "_transient_geoip_10.9.71.2", "", "no");
INSERT INTO `wp_options` VALUES("19866", "_transient_timeout_geoip_1.39.32.1", "1452320234", "no");
INSERT INTO `wp_options` VALUES("19867", "_transient_geoip_1.39.32.1", "IN", "no");
INSERT INTO `wp_options` VALUES("19966", "_transient_timeout_geoip_151.224.21.247", "1452478135", "no");
INSERT INTO `wp_options` VALUES("19967", "_transient_geoip_151.224.21.247", "GB", "no");
INSERT INTO `wp_options` VALUES("20317", "_transient_timeout_geoip_23.101.61.176", "1452494243", "no");
INSERT INTO `wp_options` VALUES("20318", "_transient_geoip_23.101.61.176", "IE", "no");
INSERT INTO `wp_options` VALUES("20333", "_transient_timeout_geoip_43.230.156.237", "1452498129", "no");
INSERT INTO `wp_options` VALUES("20334", "_transient_geoip_43.230.156.237", "IN", "no");
INSERT INTO `wp_options` VALUES("20350", "_transient_timeout_geoip_122.176.120.151", "1452502620", "no");
INSERT INTO `wp_options` VALUES("20351", "_transient_geoip_122.176.120.151", "IN", "no");
INSERT INTO `wp_options` VALUES("20357", "_transient_timeout_geoip_104.45.18.178", "1452504229", "no");
INSERT INTO `wp_options` VALUES("20358", "_transient_geoip_104.45.18.178", "US", "no");
INSERT INTO `wp_options` VALUES("20361", "laborator_custom_css", "body {\r\n}\r\n\r\n.product-left-info .product-images #main-image-slider .owl-item img {background-color:#404040;}", "yes");
INSERT INTO `wp_options` VALUES("20374", "_transient_timeout_geoip_202.133.73.10", "1452506351", "no");
INSERT INTO `wp_options` VALUES("20375", "_transient_geoip_202.133.73.10", "", "no");
INSERT INTO `wp_options` VALUES("21741", "_transient_timeout_wc_var_prices2f1f702ec5b5e5893961ba1452081365", "1454673512", "no");
INSERT INTO `wp_options` VALUES("21742", "_transient_wc_var_prices2f1f702ec5b5e5893961ba1452081365", "a:3:{s:5:\"price\";a:2:{i:2110;s:4:\"0.00\";i:2111;s:4:\"0.00\";}s:13:\"regular_price\";a:2:{i:2110;s:4:\"0.00\";i:2111;s:4:\"0.00\";}s:10:\"sale_price\";a:2:{i:2110;s:4:\"0.00\";i:2111;s:4:\"0.00\";}}", "no");
INSERT INTO `wp_options` VALUES("21743", "_transient_timeout_wc_rating_count_19941452081365", "1454673512", "no");
INSERT INTO `wp_options` VALUES("21744", "_transient_wc_rating_count_19941452081365", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("21745", "_transient_timeout_wc_review_count_19941452081365", "1454673512", "no");
INSERT INTO `wp_options` VALUES("21746", "_transient_wc_review_count_19941452081365", "0", "no");
INSERT INTO `wp_options` VALUES("21747", "_transient_timeout_wc_average_rating_19941452081365", "1454673512", "no");
INSERT INTO `wp_options` VALUES("21748", "_transient_wc_average_rating_19941452081365", "0", "no");
INSERT INTO `wp_options` VALUES("21749", "_transient_timeout_wc_var_pricesef310e0f0fe39a82ccbcd01452081365", "1454673512", "no");
INSERT INTO `wp_options` VALUES("21750", "_transient_wc_var_pricesef310e0f0fe39a82ccbcd01452081365", "a:3:{s:5:\"price\";a:2:{i:2110;d:0;i:2111;d:0;}s:13:\"regular_price\";a:2:{i:2110;d:0;i:2111;d:0;}s:10:\"sale_price\";a:2:{i:2110;d:0;i:2111;d:0;}}", "no");
INSERT INTO `wp_options` VALUES("21751", "_transient_timeout_wc_related_4_19941452081365", "1454673512", "no");
INSERT INTO `wp_options` VALUES("21752", "_transient_wc_related_4_19941452081365", "a:4:{i:0;s:2:\"68\";i:1;s:3:\"900\";i:2;s:4:\"1999\";i:3;s:4:\"2003\";}", "no");
INSERT INTO `wp_options` VALUES("21753", "_transient_timeout_wc_var_pricesd88a3f01c127092b0548851452081365", "1454673512", "no");
INSERT INTO `wp_options` VALUES("21754", "_transient_wc_var_pricesd88a3f01c127092b0548851452081365", "a:3:{s:5:\"price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}s:13:\"regular_price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}s:10:\"sale_price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}}", "no");
INSERT INTO `wp_options` VALUES("21755", "_transient_timeout_wc_var_prices835a053f96e2e85748b2c51452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21756", "_transient_wc_var_prices835a053f96e2e85748b2c51452081365", "a:3:{s:5:\"price\";a:2:{i:2112;i:515;i:2113;i:1065;}s:13:\"regular_price\";a:2:{i:2112;i:515;i:2113;i:1065;}s:10:\"sale_price\";a:2:{i:2112;i:515;i:2113;i:1065;}}", "no");
INSERT INTO `wp_options` VALUES("21757", "_transient_timeout_wc_var_prices3a88fa3fbf3e091533aafa1452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21758", "_transient_wc_var_prices3a88fa3fbf3e091533aafa1452081365", "a:3:{s:5:\"price\";a:2:{i:2120;s:1:\"0\";i:2121;s:1:\"0\";}s:13:\"regular_price\";a:2:{i:2120;s:1:\"0\";i:2121;s:1:\"0\";}s:10:\"sale_price\";a:2:{i:2120;s:1:\"0\";i:2121;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("21759", "_transient_timeout_wc_var_prices878e559915a7734f60a94d1452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21760", "_transient_wc_var_prices878e559915a7734f60a94d1452081365", "a:3:{s:5:\"price\";a:2:{i:2120;i:0;i:2121;i:0;}s:13:\"regular_price\";a:2:{i:2120;i:0;i:2121;i:0;}s:10:\"sale_price\";a:2:{i:2120;i:0;i:2121;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("21761", "_transient_timeout_wc_var_prices9bb67b91b5fd48c9aa87581452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21762", "_transient_wc_var_prices9bb67b91b5fd48c9aa87581452081365", "a:3:{s:5:\"price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}s:13:\"regular_price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}s:10:\"sale_price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("21763", "_transient_timeout_wc_var_pricesf9a7c5d60164944357dc021452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21764", "_transient_wc_var_pricesf9a7c5d60164944357dc021452081365", "a:3:{s:5:\"price\";a:2:{i:2126;i:0;i:2125;i:0;}s:13:\"regular_price\";a:2:{i:2126;i:0;i:2125;i:0;}s:10:\"sale_price\";a:2:{i:2126;i:0;i:2125;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("21765", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21766", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1452081365", "a:3:{s:5:\"price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:13:\"regular_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:10:\"sale_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}}", "no");
INSERT INTO `wp_options` VALUES("21767", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21768", "_transient_wc_var_pricesd6990a7b2f37804631e5641452081365", "a:3:{s:5:\"price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:13:\"regular_price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:10:\"sale_price\";a:2:{i:1764;i:465;i:1763;i:1015;}}", "no");
INSERT INTO `wp_options` VALUES("21769", "_transient_timeout_wc_var_pricesd4bde988b01523bff59a671452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21770", "_transient_wc_var_pricesd4bde988b01523bff59a671452081365", "a:3:{s:5:\"price\";a:16:{i:1906;i:409;i:1905;i:409;i:1904;i:409;i:1907;i:409;i:1908;i:409;i:1910;i:409;i:1909;i:409;i:1903;i:409;i:1902;i:409;i:1913;i:409;i:1912;i:409;i:1914;i:409;i:1915;i:409;i:1917;i:409;i:1916;i:409;i:1911;i:409;}s:13:\"regular_price\";a:16:{i:1906;i:409;i:1905;i:409;i:1904;i:409;i:1907;i:409;i:1908;i:409;i:1910;i:409;i:1909;i:409;i:1903;i:409;i:1902;i:409;i:1913;i:409;i:1912;i:409;i:1914;i:409;i:1915;i:409;i:1917;i:409;i:1916;i:409;i:1911;i:409;}s:10:\"sale_price\";a:16:{i:1906;i:409;i:1905;i:409;i:1904;i:409;i:1907;i:409;i:1908;i:409;i:1910;i:409;i:1909;i:409;i:1903;i:409;i:1902;i:409;i:1913;i:409;i:1912;i:409;i:1914;i:409;i:1915;i:409;i:1917;i:409;i:1916;i:409;i:1911;i:409;}}", "no");
INSERT INTO `wp_options` VALUES("21771", "_transient_timeout_wc_var_prices77315792d97a90c74547981452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21772", "_transient_wc_var_prices77315792d97a90c74547981452081365", "a:3:{s:5:\"price\";a:16:{i:1906;s:3:\"409\";i:1905;s:3:\"409\";i:1904;s:3:\"409\";i:1907;s:3:\"409\";i:1908;s:3:\"409\";i:1910;s:3:\"409\";i:1909;s:3:\"409\";i:1903;s:3:\"409\";i:1902;s:3:\"409\";i:1913;s:3:\"409\";i:1912;s:3:\"409\";i:1914;s:3:\"409\";i:1915;s:3:\"409\";i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1911;s:3:\"409\";}s:13:\"regular_price\";a:16:{i:1906;s:3:\"409\";i:1905;s:3:\"409\";i:1904;s:3:\"409\";i:1907;s:3:\"409\";i:1908;s:3:\"409\";i:1910;s:3:\"409\";i:1909;s:3:\"409\";i:1903;s:3:\"409\";i:1902;s:3:\"409\";i:1913;s:3:\"409\";i:1912;s:3:\"409\";i:1914;s:3:\"409\";i:1915;s:3:\"409\";i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1911;s:3:\"409\";}s:10:\"sale_price\";a:16:{i:1906;s:3:\"409\";i:1905;s:3:\"409\";i:1904;s:3:\"409\";i:1907;s:3:\"409\";i:1908;s:3:\"409\";i:1910;s:3:\"409\";i:1909;s:3:\"409\";i:1903;s:3:\"409\";i:1902;s:3:\"409\";i:1913;s:3:\"409\";i:1912;s:3:\"409\";i:1914;s:3:\"409\";i:1915;s:3:\"409\";i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1911;s:3:\"409\";}}", "no");
INSERT INTO `wp_options` VALUES("21773", "_transient_timeout_wc_var_prices988869ad4a22232c07e90f1452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21774", "_transient_wc_var_prices988869ad4a22232c07e90f1452081365", "a:3:{s:5:\"price\";a:1:{i:2129;i:0;}s:13:\"regular_price\";a:1:{i:2129;i:0;}s:10:\"sale_price\";a:1:{i:2129;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("21775", "_transient_timeout_wc_var_prices2c207d5468e429484a1e871452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21776", "_transient_wc_var_prices2c207d5468e429484a1e871452081365", "a:3:{s:5:\"price\";a:1:{i:2129;s:1:\"0\";}s:13:\"regular_price\";a:1:{i:2129;s:1:\"0\";}s:10:\"sale_price\";a:1:{i:2129;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("21777", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21778", "_transient_wc_var_pricese5e3a7ec74d543849a65931452081365", "a:3:{s:5:\"price\";a:16:{i:1930;i:449;i:1929;i:449;i:1928;i:449;i:1931;i:449;i:1932;i:449;i:1934;i:449;i:1933;i:449;i:1927;i:449;i:1926;i:449;i:1937;i:449;i:1936;i:449;i:1938;i:449;i:1759;i:449;i:1925;i:449;i:1924;i:449;i:1935;i:449;}s:13:\"regular_price\";a:16:{i:1930;i:449;i:1929;i:449;i:1928;i:449;i:1931;i:449;i:1932;i:449;i:1934;i:449;i:1933;i:449;i:1927;i:449;i:1926;i:449;i:1937;i:449;i:1936;i:449;i:1938;i:449;i:1759;i:449;i:1925;i:449;i:1924;i:449;i:1935;i:449;}s:10:\"sale_price\";a:16:{i:1930;i:449;i:1929;i:449;i:1928;i:449;i:1931;i:449;i:1932;i:449;i:1934;i:449;i:1933;i:449;i:1927;i:449;i:1926;i:449;i:1937;i:449;i:1936;i:449;i:1938;i:449;i:1759;i:449;i:1925;i:449;i:1924;i:449;i:1935;i:449;}}", "no");
INSERT INTO `wp_options` VALUES("21779", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21780", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491452081365", "a:3:{s:5:\"price\";a:16:{i:1930;s:3:\"449\";i:1929;s:3:\"449\";i:1928;s:3:\"449\";i:1931;s:3:\"449\";i:1932;s:3:\"449\";i:1934;s:3:\"449\";i:1933;s:3:\"449\";i:1927;s:3:\"449\";i:1926;s:3:\"449\";i:1937;s:3:\"449\";i:1936;s:3:\"449\";i:1938;s:3:\"449\";i:1759;s:3:\"449\";i:1925;s:3:\"449\";i:1924;s:3:\"449\";i:1935;s:3:\"449\";}s:13:\"regular_price\";a:16:{i:1930;s:3:\"449\";i:1929;s:3:\"449\";i:1928;s:3:\"449\";i:1931;s:3:\"449\";i:1932;s:3:\"449\";i:1934;s:3:\"449\";i:1933;s:3:\"449\";i:1927;s:3:\"449\";i:1926;s:3:\"449\";i:1937;s:3:\"449\";i:1936;s:3:\"449\";i:1938;s:3:\"449\";i:1759;s:3:\"449\";i:1925;s:3:\"449\";i:1924;s:3:\"449\";i:1935;s:3:\"449\";}s:10:\"sale_price\";a:16:{i:1930;s:3:\"449\";i:1929;s:3:\"449\";i:1928;s:3:\"449\";i:1931;s:3:\"449\";i:1932;s:3:\"449\";i:1934;s:3:\"449\";i:1933;s:3:\"449\";i:1927;s:3:\"449\";i:1926;s:3:\"449\";i:1937;s:3:\"449\";i:1936;s:3:\"449\";i:1938;s:3:\"449\";i:1759;s:3:\"449\";i:1925;s:3:\"449\";i:1924;s:3:\"449\";i:1935;s:3:\"449\";}}", "no");
INSERT INTO `wp_options` VALUES("21781", "_transient_timeout_wc_var_prices14bc62b689f5c1de50263f1452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21782", "_transient_wc_var_prices14bc62b689f5c1de50263f1452081365", "a:3:{s:5:\"price\";a:2:{i:1771;i:418;i:1770;i:968;}s:13:\"regular_price\";a:2:{i:1771;i:418;i:1770;i:968;}s:10:\"sale_price\";a:2:{i:1771;i:418;i:1770;i:968;}}", "no");
INSERT INTO `wp_options` VALUES("21783", "_transient_timeout_wc_var_prices3d6e74621fe9edd88bc7071452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21784", "_transient_wc_var_prices3d6e74621fe9edd88bc7071452081365", "a:3:{s:5:\"price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}s:13:\"regular_price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}s:10:\"sale_price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}}", "no");
INSERT INTO `wp_options` VALUES("21785", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21786", "_transient_wc_var_prices508ed4445f00ea7945b36b1452081365", "a:3:{s:5:\"price\";a:20:{i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1686;i:427;i:1688;i:427;i:1689;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1701;i:427;i:1685;i:427;i:1696;i:427;i:1695;i:427;i:1694;i:427;i:1697;i:427;i:1698;i:427;i:1700;i:427;i:1684;i:427;i:1699;i:427;i:1693;i:427;}s:13:\"regular_price\";a:20:{i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1686;i:427;i:1688;i:427;i:1689;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1701;i:427;i:1685;i:427;i:1696;i:427;i:1695;i:427;i:1694;i:427;i:1697;i:427;i:1698;i:427;i:1700;i:427;i:1684;i:427;i:1699;i:427;i:1693;i:427;}s:10:\"sale_price\";a:20:{i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1686;i:427;i:1688;i:427;i:1689;i:427;i:1692;i:427;i:1691;i:427;i:1690;i:427;i:1701;i:427;i:1685;i:427;i:1696;i:427;i:1695;i:427;i:1694;i:427;i:1697;i:427;i:1698;i:427;i:1700;i:427;i:1684;i:427;i:1699;i:427;i:1693;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("21787", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1452081365", "1454673513", "no");
INSERT INTO `wp_options` VALUES("21788", "_transient_wc_var_prices2a86c658d2bca1db535cbe1452081365", "a:3:{s:5:\"price\";a:20:{i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1686;s:3:\"427\";i:1688;s:3:\"427\";i:1689;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1701;s:3:\"427\";i:1685;s:3:\"427\";i:1696;s:3:\"427\";i:1695;s:3:\"427\";i:1694;s:3:\"427\";i:1697;s:3:\"427\";i:1698;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1699;s:3:\"427\";i:1693;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1686;s:3:\"427\";i:1688;s:3:\"427\";i:1689;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1701;s:3:\"427\";i:1685;s:3:\"427\";i:1696;s:3:\"427\";i:1695;s:3:\"427\";i:1694;s:3:\"427\";i:1697;s:3:\"427\";i:1698;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1699;s:3:\"427\";i:1693;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1686;s:3:\"427\";i:1688;s:3:\"427\";i:1689;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1690;s:3:\"427\";i:1701;s:3:\"427\";i:1685;s:3:\"427\";i:1696;s:3:\"427\";i:1695;s:3:\"427\";i:1694;s:3:\"427\";i:1697;s:3:\"427\";i:1698;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1699;s:3:\"427\";i:1693;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("22285", "wdm_form_data", "a:4:{s:10:\"user_email\";s:22:\"prem@abacusdesk.co.in\";s:11:\"default_sub\";s:39:\"Enquiry for a product from Hardshell Us\";s:12:\"custom_label\";s:12:\"Send Enquiry\";s:18:\"show_after_summary\";s:14:\"after_add_cart\";}", "yes");
INSERT INTO `wp_options` VALUES("22351", "_transient_timeout_external_ip_address_10.9.71.2", "1453377845", "no");
INSERT INTO `wp_options` VALUES("22352", "_transient_external_ip_address_10.9.71.2", "50.28.22.150", "no");
INSERT INTO `wp_options` VALUES("22550", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("23015", "_transient_timeout_external_ip_address_103.203.255.228", "1453480660", "no");
INSERT INTO `wp_options` VALUES("23016", "_transient_external_ip_address_103.203.255.228", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("23217", "_transient_timeout_wc_var_pricesd88a3f01c127092b0548851452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23218", "_transient_wc_var_pricesd88a3f01c127092b0548851452862009", "a:3:{s:5:\"price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}s:13:\"regular_price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}s:10:\"sale_price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}}", "no");
INSERT INTO `wp_options` VALUES("23219", "_transient_timeout_wc_var_prices835a053f96e2e85748b2c51452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23220", "_transient_wc_var_prices835a053f96e2e85748b2c51452862009", "a:3:{s:5:\"price\";a:2:{i:2112;i:515;i:2113;i:1065;}s:13:\"regular_price\";a:2:{i:2112;i:515;i:2113;i:1065;}s:10:\"sale_price\";a:2:{i:2112;i:515;i:2113;i:1065;}}", "no");
INSERT INTO `wp_options` VALUES("23221", "_transient_timeout_wc_var_prices3a88fa3fbf3e091533aafa1452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23222", "_transient_wc_var_prices3a88fa3fbf3e091533aafa1452862009", "a:3:{s:5:\"price\";a:2:{i:2120;s:1:\"0\";i:2121;s:1:\"0\";}s:13:\"regular_price\";a:2:{i:2120;s:1:\"0\";i:2121;s:1:\"0\";}s:10:\"sale_price\";a:2:{i:2120;s:1:\"0\";i:2121;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("23223", "_transient_timeout_wc_var_prices878e559915a7734f60a94d1452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23224", "_transient_wc_var_prices878e559915a7734f60a94d1452862009", "a:3:{s:5:\"price\";a:2:{i:2120;i:0;i:2121;i:0;}s:13:\"regular_price\";a:2:{i:2120;i:0;i:2121;i:0;}s:10:\"sale_price\";a:2:{i:2120;i:0;i:2121;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("23225", "_transient_timeout_wc_var_prices498294ebc8f0e6002122231452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23226", "_transient_wc_var_prices498294ebc8f0e6002122231452862009", "a:3:{s:5:\"price\";a:2:{i:2123;s:2:\"00\";i:2122;s:2:\"00\";}s:13:\"regular_price\";a:2:{i:2123;s:2:\"00\";i:2122;s:2:\"00\";}s:10:\"sale_price\";a:2:{i:2123;s:2:\"00\";i:2122;s:2:\"00\";}}", "no");
INSERT INTO `wp_options` VALUES("23227", "_transient_timeout_wc_var_prices05691ac6ea37574095d4c31452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23228", "_transient_wc_var_prices05691ac6ea37574095d4c31452862009", "a:3:{s:5:\"price\";a:2:{i:2123;i:0;i:2122;i:0;}s:13:\"regular_price\";a:2:{i:2123;i:0;i:2122;i:0;}s:10:\"sale_price\";a:2:{i:2123;i:0;i:2122;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("23229", "_transient_timeout_wc_var_prices9bb67b91b5fd48c9aa87581452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23230", "_transient_wc_var_prices9bb67b91b5fd48c9aa87581452862009", "a:3:{s:5:\"price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}s:13:\"regular_price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}s:10:\"sale_price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("23231", "_transient_timeout_wc_var_pricesf9a7c5d60164944357dc021452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23232", "_transient_wc_var_pricesf9a7c5d60164944357dc021452862009", "a:3:{s:5:\"price\";a:2:{i:2126;i:0;i:2125;i:0;}s:13:\"regular_price\";a:2:{i:2126;i:0;i:2125;i:0;}s:10:\"sale_price\";a:2:{i:2126;i:0;i:2125;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("23233", "_transient_timeout_wc_var_prices26206dbd471a7420c8c0811452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23234", "_transient_wc_var_prices26206dbd471a7420c8c0811452862009", "a:3:{s:5:\"price\";a:6:{i:1885;s:4:\"1325\";i:1884;s:4:\"1325\";i:1886;s:4:\"1325\";i:1882;s:4:\"1325\";i:1765;s:4:\"1325\";i:1883;s:4:\"1325\";}s:13:\"regular_price\";a:6:{i:1885;s:4:\"1325\";i:1884;s:4:\"1325\";i:1886;s:4:\"1325\";i:1882;s:4:\"1325\";i:1765;s:4:\"1325\";i:1883;s:4:\"1325\";}s:10:\"sale_price\";a:6:{i:1885;s:4:\"1325\";i:1884;s:4:\"1325\";i:1886;s:4:\"1325\";i:1882;s:4:\"1325\";i:1765;s:4:\"1325\";i:1883;s:4:\"1325\";}}", "no");
INSERT INTO `wp_options` VALUES("23235", "_transient_timeout_wc_var_pricesa5f172fcbe8f0ac145055f1452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23236", "_transient_wc_var_pricesa5f172fcbe8f0ac145055f1452862009", "a:3:{s:5:\"price\";a:6:{i:1885;i:1325;i:1884;i:1325;i:1886;i:1325;i:1882;i:1325;i:1765;i:1325;i:1883;i:1325;}s:13:\"regular_price\";a:6:{i:1885;i:1325;i:1884;i:1325;i:1886;i:1325;i:1882;i:1325;i:1765;i:1325;i:1883;i:1325;}s:10:\"sale_price\";a:6:{i:1885;i:1325;i:1884;i:1325;i:1886;i:1325;i:1882;i:1325;i:1765;i:1325;i:1883;i:1325;}}", "no");
INSERT INTO `wp_options` VALUES("23237", "_transient_timeout_wc_var_prices2552832357a1e1451c34fb1452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23238", "_transient_wc_var_prices2552832357a1e1451c34fb1452862009", "a:3:{s:5:\"price\";a:24:{i:2209;s:4:\"1900\";i:2205;s:4:\"1900\";i:2204;s:4:\"1900\";i:2210;s:4:\"2250\";i:2206;s:4:\"2280\";i:1860;s:4:\"2280\";i:1869;s:4:\"2505\";i:1874;s:4:\"2505\";i:1863;s:4:\"2505\";i:2207;s:4:\"2850\";i:2211;s:4:\"2850\";i:1861;s:4:\"2850\";i:1870;s:4:\"3006\";i:1864;s:4:\"3006\";i:1876;s:4:\"3006\";i:2212;s:4:\"3424\";i:2208;s:4:\"3424\";i:1862;s:4:\"3424\";i:1877;s:4:\"3757\";i:1866;s:4:\"3757\";i:1871;s:4:\"3757\";i:1872;s:4:\"4509\";i:1879;s:4:\"4509\";i:1867;s:4:\"4509\";}s:13:\"regular_price\";a:24:{i:2209;s:4:\"1900\";i:2205;s:4:\"1900\";i:2204;s:4:\"1900\";i:2210;s:4:\"2250\";i:2206;s:4:\"2280\";i:1860;s:4:\"2280\";i:1869;s:4:\"2505\";i:1874;s:4:\"2505\";i:1863;s:4:\"2505\";i:2207;s:4:\"2850\";i:2211;s:4:\"2850\";i:1861;s:4:\"2850\";i:1870;s:4:\"3006\";i:1864;s:4:\"3006\";i:1876;s:4:\"3006\";i:2212;s:4:\"3424\";i:2208;s:4:\"3424\";i:1862;s:4:\"3424\";i:1877;s:4:\"3757\";i:1866;s:4:\"3757\";i:1871;s:4:\"3757\";i:1872;s:4:\"4509\";i:1879;s:4:\"4509\";i:1867;s:4:\"4509\";}s:10:\"sale_price\";a:24:{i:2209;s:4:\"1900\";i:2205;s:4:\"1900\";i:2204;s:4:\"1900\";i:2210;s:4:\"2250\";i:2206;s:4:\"2280\";i:1860;s:4:\"2280\";i:1869;s:4:\"2505\";i:1874;s:4:\"2505\";i:1863;s:4:\"2505\";i:2207;s:4:\"2850\";i:2211;s:4:\"2850\";i:1861;s:4:\"2850\";i:1870;s:4:\"3006\";i:1864;s:4:\"3006\";i:1876;s:4:\"3006\";i:2212;s:4:\"3424\";i:2208;s:4:\"3424\";i:1862;s:4:\"3424\";i:1877;s:4:\"3757\";i:1866;s:4:\"3757\";i:1871;s:4:\"3757\";i:1872;s:4:\"4509\";i:1879;s:4:\"4509\";i:1867;s:4:\"4509\";}}", "no");
INSERT INTO `wp_options` VALUES("23239", "_transient_timeout_wc_var_pricesb50077d9ae4f525c8dfd401452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23240", "_transient_wc_var_pricesb50077d9ae4f525c8dfd401452862009", "a:3:{s:5:\"price\";a:24:{i:2209;i:1900;i:2205;i:1900;i:2204;i:1900;i:2210;i:2250;i:2206;i:2280;i:1860;i:2280;i:1869;i:2505;i:1874;i:2505;i:1863;i:2505;i:2207;i:2850;i:2211;i:2850;i:1861;i:2850;i:1870;i:3006;i:1864;i:3006;i:1876;i:3006;i:2212;i:3424;i:2208;i:3424;i:1862;i:3424;i:1877;i:3757;i:1866;i:3757;i:1871;i:3757;i:1872;i:4509;i:1879;i:4509;i:1867;i:4509;}s:13:\"regular_price\";a:24:{i:2209;i:1900;i:2205;i:1900;i:2204;i:1900;i:2210;i:2250;i:2206;i:2280;i:1860;i:2280;i:1869;i:2505;i:1874;i:2505;i:1863;i:2505;i:2207;i:2850;i:2211;i:2850;i:1861;i:2850;i:1870;i:3006;i:1864;i:3006;i:1876;i:3006;i:2212;i:3424;i:2208;i:3424;i:1862;i:3424;i:1877;i:3757;i:1866;i:3757;i:1871;i:3757;i:1872;i:4509;i:1879;i:4509;i:1867;i:4509;}s:10:\"sale_price\";a:24:{i:2209;i:1900;i:2205;i:1900;i:2204;i:1900;i:2210;i:2250;i:2206;i:2280;i:1860;i:2280;i:1869;i:2505;i:1874;i:2505;i:1863;i:2505;i:2207;i:2850;i:2211;i:2850;i:1861;i:2850;i:1870;i:3006;i:1864;i:3006;i:1876;i:3006;i:2212;i:3424;i:2208;i:3424;i:1862;i:3424;i:1877;i:3757;i:1866;i:3757;i:1871;i:3757;i:1872;i:4509;i:1879;i:4509;i:1867;i:4509;}}", "no");
INSERT INTO `wp_options` VALUES("23241", "_transient_timeout_wc_var_pricesd23f559393fa60de0b7efc1452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23242", "_transient_wc_var_pricesd23f559393fa60de0b7efc1452862009", "a:3:{s:5:\"price\";a:1:{i:1974;s:6:\"200.00\";}s:13:\"regular_price\";a:1:{i:1974;s:6:\"200.00\";}s:10:\"sale_price\";a:1:{i:1974;s:6:\"200.00\";}}", "no");
INSERT INTO `wp_options` VALUES("23243", "_transient_timeout_wc_var_prices424fcfb034ecd382fce57f1452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23244", "_transient_wc_var_prices424fcfb034ecd382fce57f1452862009", "a:3:{s:5:\"price\";a:1:{i:1974;d:200;}s:13:\"regular_price\";a:1:{i:1974;d:200;}s:10:\"sale_price\";a:1:{i:1974;d:200;}}", "no");
INSERT INTO `wp_options` VALUES("23245", "_transient_timeout_wc_var_prices51bb073085c80cebccaa801452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23246", "_transient_wc_var_prices51bb073085c80cebccaa801452862009", "a:3:{s:5:\"price\";a:1:{i:1971;s:3:\"200\";}s:13:\"regular_price\";a:1:{i:1971;s:3:\"200\";}s:10:\"sale_price\";a:1:{i:1971;s:3:\"200\";}}", "no");
INSERT INTO `wp_options` VALUES("23247", "_transient_timeout_wc_var_prices98cfc2622c98524cc251ee1452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23248", "_transient_wc_var_prices98cfc2622c98524cc251ee1452862009", "a:3:{s:5:\"price\";a:1:{i:1971;i:200;}s:13:\"regular_price\";a:1:{i:1971;i:200;}s:10:\"sale_price\";a:1:{i:1971;i:200;}}", "no");
INSERT INTO `wp_options` VALUES("23249", "_transient_timeout_wc_rating_count_20121452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23250", "_transient_wc_rating_count_20121452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23251", "_transient_timeout_wc_average_rating_20121452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23252", "_transient_wc_average_rating_20121452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23253", "_transient_timeout_wc_rating_count_20091452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23254", "_transient_wc_rating_count_20091452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23255", "_transient_timeout_wc_average_rating_20091452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23256", "_transient_wc_average_rating_20091452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23257", "_transient_timeout_wc_rating_count_20051452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23258", "_transient_wc_rating_count_20051452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23259", "_transient_timeout_wc_average_rating_20051452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23260", "_transient_wc_average_rating_20051452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23261", "_transient_timeout_wc_rating_count_20031452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23262", "_transient_wc_rating_count_20031452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23263", "_transient_timeout_wc_average_rating_20031452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23264", "_transient_wc_average_rating_20031452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23265", "_transient_timeout_wc_rating_count_2021452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23266", "_transient_wc_rating_count_2021452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23267", "_transient_timeout_wc_average_rating_2021452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23268", "_transient_wc_average_rating_2021452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23269", "_transient_timeout_wc_rating_count_2001452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23270", "_transient_wc_rating_count_2001452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23271", "_transient_timeout_wc_average_rating_2001452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23272", "_transient_wc_average_rating_2001452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23273", "_transient_timeout_wc_rating_count_1911452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23274", "_transient_wc_rating_count_1911452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23275", "_transient_timeout_wc_average_rating_1911452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23276", "_transient_wc_average_rating_1911452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23277", "_transient_timeout_wc_rating_count_1901452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23278", "_transient_wc_rating_count_1901452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23279", "_transient_timeout_wc_average_rating_1901452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23280", "_transient_wc_average_rating_1901452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23281", "_transient_timeout_wc_var_prices548d70f2d8bcdf624496641452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23282", "_transient_wc_var_prices548d70f2d8bcdf624496641452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23283", "_transient_timeout_wc_var_pricesf9cdde26e349f0d06523051452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23284", "_transient_wc_var_pricesf9cdde26e349f0d06523051452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23285", "_transient_timeout_wc_var_prices6aabe0f4ad61508b6817e81452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23286", "_transient_wc_var_prices6aabe0f4ad61508b6817e81452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23287", "_transient_timeout_wc_var_pricese66facc04cc37dda27b9d11452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23288", "_transient_wc_var_pricese66facc04cc37dda27b9d11452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23289", "_transient_timeout_wc_var_pricescd84a642def863bb7849cd1452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23290", "_transient_wc_var_pricescd84a642def863bb7849cd1452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23291", "_transient_timeout_wc_var_prices4addb3add475b0e4a701701452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23292", "_transient_wc_var_prices4addb3add475b0e4a701701452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23293", "_transient_timeout_wc_var_prices4aaf2444b326783ae2f5c11452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23294", "_transient_wc_var_prices4aaf2444b326783ae2f5c11452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23295", "_transient_timeout_wc_var_pricese7cf3f30d03abd154b13c71452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23296", "_transient_wc_var_pricese7cf3f30d03abd154b13c71452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23297", "_transient_timeout_wc_var_prices83492a152fc3c016001b581452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23298", "_transient_wc_var_prices83492a152fc3c016001b581452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23299", "_transient_timeout_wc_var_pricesf28f3d0af5e88483ac3ba21452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23300", "_transient_wc_var_pricesf28f3d0af5e88483ac3ba21452862009", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("23301", "_transient_timeout_wc_rating_count_23861452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23302", "_transient_wc_rating_count_23861452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23303", "_transient_timeout_wc_average_rating_23861452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23304", "_transient_wc_average_rating_23861452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23305", "_transient_timeout_wc_rating_count_23801452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23306", "_transient_wc_rating_count_23801452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23307", "_transient_timeout_wc_average_rating_23801452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23308", "_transient_wc_average_rating_23801452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23309", "_transient_timeout_wc_rating_count_23751452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23310", "_transient_wc_rating_count_23751452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23311", "_transient_timeout_wc_average_rating_23751452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23312", "_transient_wc_average_rating_23751452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23313", "_transient_timeout_wc_rating_count_23701452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23314", "_transient_wc_rating_count_23701452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23315", "_transient_timeout_wc_average_rating_23701452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23316", "_transient_wc_average_rating_23701452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23317", "_transient_timeout_wc_rating_count_23651452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23318", "_transient_wc_rating_count_23651452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23319", "_transient_timeout_wc_average_rating_23651452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23320", "_transient_wc_average_rating_23651452862009", "0", "no");
INSERT INTO `wp_options` VALUES("23321", "_transient_timeout_wc_rating_count_23601452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23322", "_transient_wc_rating_count_23601452862009", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23323", "_transient_timeout_wc_average_rating_23601452862009", "1455524169", "no");
INSERT INTO `wp_options` VALUES("23324", "_transient_wc_average_rating_23601452862009", "0", "no");
INSERT INTO `wp_options` VALUES("26783", "_transient_timeout_wc_product_children_165", "1455792483", "no");
INSERT INTO `wp_options` VALUES("26784", "_transient_wc_product_children_165", "a:1:{s:7:\"visible\";a:2:{i:0;i:1749;i:1;i:1750;}}", "no");
INSERT INTO `wp_options` VALUES("26789", "_transient_timeout_wc_product_children_154", "1455792483", "no");
INSERT INTO `wp_options` VALUES("26790", "_transient_wc_product_children_154", "a:1:{s:7:\"visible\";a:5:{i:0;i:1755;i:1;i:1805;i:2;i:1806;i:3;i:1807;i:4;i:1809;}}", "no");
INSERT INTO `wp_options` VALUES("26795", "_transient_timeout_wc_product_children_152", "1455792483", "no");
INSERT INTO `wp_options` VALUES("26796", "_transient_wc_product_children_152", "a:1:{s:7:\"visible\";a:2:{i:0;i:1815;i:1;i:1816;}}", "no");
INSERT INTO `wp_options` VALUES("26801", "_transient_timeout_wc_product_children_150", "1455792483", "no");
INSERT INTO `wp_options` VALUES("26802", "_transient_wc_product_children_150", "a:1:{s:7:\"visible\";a:2:{i:0;i:1793;i:1;i:1794;}}", "no");
INSERT INTO `wp_options` VALUES("26807", "_transient_timeout_wc_product_children_148", "1455792483", "no");
INSERT INTO `wp_options` VALUES("26808", "_transient_wc_product_children_148", "a:1:{s:7:\"visible\";a:2:{i:0;i:1797;i:1;i:1798;}}", "no");
INSERT INTO `wp_options` VALUES("26813", "_transient_timeout_wc_product_children_146", "1455792483", "no");
INSERT INTO `wp_options` VALUES("26814", "_transient_wc_product_children_146", "a:1:{s:7:\"visible\";a:2:{i:0;i:1711;i:1;i:1712;}}", "no");
INSERT INTO `wp_options` VALUES("26823", "_transient_timeout_wc_product_children_140", "1455792483", "no");
INSERT INTO `wp_options` VALUES("26824", "_transient_wc_product_children_140", "a:1:{s:7:\"visible\";a:2:{i:0;i:1838;i:1;i:1839;}}", "no");
INSERT INTO `wp_options` VALUES("26829", "_transient_timeout_wc_product_children_137", "1455792483", "no");
INSERT INTO `wp_options` VALUES("26830", "_transient_wc_product_children_137", "a:1:{s:7:\"visible\";a:2:{i:0;i:1822;i:1;i:1823;}}", "no");
INSERT INTO `wp_options` VALUES("27303", "wpseo", "a:14:{s:14:\"blocking_files\";a:0:{}s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:3:\"3.5\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:15:\"Hard Shell U.S.\";s:17:\"company_or_person\";s:7:\"company\";s:20:\"disableadvanced_meta\";b:0;s:19:\"onpage_indexability\";b:1;s:12:\"googleverify\";s:43:\"bewxLS0o7ZQrmP3tayv1o5NPzG_0ECGUA6tkJRz4b0I\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:15:\"Hard Shell U.S.\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("27304", "wpseo_permalinks", "a:13:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:14:\"hide-feedlinks\";b:0;s:12:\"hide-rsdlink\";b:0;s:14:\"hide-shortlink\";b:0;s:16:\"hide-wlwmanifest\";b:0;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("27305", "wpseo_titles", "a:93:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:1;s:23:\"content-analysis-active\";b:1;s:23:\"keyword-analysis-active\";b:1;s:9:\"separator\";s:9:\"sc-middot\";s:5:\"noodp\";b:0;s:15:\"usemetakeywords\";b:1;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:13:\"title-product\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-product\";s:0:\"\";s:15:\"metakey-product\";s:0:\"\";s:15:\"noindex-product\";b:0;s:16:\"showdate-product\";b:0;s:19:\"hideeditbox-product\";b:0;s:17:\"title-testimonial\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:20:\"metadesc-testimonial\";s:0:\"\";s:19:\"metakey-testimonial\";s:0:\"\";s:19:\"noindex-testimonial\";b:0;s:20:\"showdate-testimonial\";b:0;s:23:\"hideeditbox-testimonial\";b:0;s:23:\"title-ptarchive-product\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-product\";s:0:\"\";s:25:\"metakey-ptarchive-product\";s:0:\"\";s:25:\"bctitle-ptarchive-product\";s:0:\"\";s:25:\"noindex-ptarchive-product\";b:0;s:27:\"title-ptarchive-testimonial\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:30:\"metadesc-ptarchive-testimonial\";s:0:\"\";s:29:\"metakey-ptarchive-testimonial\";s:0:\"\";s:29:\"bctitle-ptarchive-testimonial\";s:0:\"\";s:29:\"noindex-ptarchive-testimonial\";b:0;s:21:\"title-tax-product_cat\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_cat\";s:0:\"\";s:23:\"metakey-tax-product_cat\";s:0:\"\";s:27:\"hideeditbox-tax-product_cat\";b:0;s:23:\"noindex-tax-product_cat\";b:0;s:21:\"title-tax-product_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_tag\";s:0:\"\";s:23:\"metakey-tax-product_tag\";s:0:\"\";s:27:\"hideeditbox-tax-product_tag\";b:0;s:23:\"noindex-tax-product_tag\";b:0;s:32:\"title-tax-product_shipping_class\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-product_shipping_class\";s:0:\"\";s:34:\"metakey-tax-product_shipping_class\";s:0:\"\";s:38:\"hideeditbox-tax-product_shipping_class\";b:0;s:34:\"noindex-tax-product_shipping_class\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("27306", "wpseo_social", "a:21:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"76d460a871b46584804e993d307132eb\";s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:10:\"googleplus\";b:0;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("27307", "wpseo_rss", "a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";}", "yes");
INSERT INTO `wp_options` VALUES("27308", "wpseo_internallinks", "a:14:{s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;s:26:\"post_types-product-maintax\";i:0;s:29:\"taxonomy-product_cat-ptparent\";i:0;s:29:\"taxonomy-product_tag-ptparent\";i:0;s:40:\"taxonomy-product_shipping_class-ptparent\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("27309", "wpseo_xml", "a:23:{s:22:\"disable_author_sitemap\";b:0;s:22:\"disable_author_noposts\";b:0;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:14:\"excluded-posts\";s:0:\"\";s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:1;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:33:\"user_role-customer-not_in_sitemap\";b:0;s:37:\"user_role-shop_manager-not_in_sitemap\";b:1;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;s:33:\"post_types-product-not_in_sitemap\";b:0;s:37:\"post_types-testimonial-not_in_sitemap\";b:0;s:37:\"taxonomies-product_cat-not_in_sitemap\";b:1;s:37:\"taxonomies-product_tag-not_in_sitemap\";b:1;s:48:\"taxonomies-product_shipping_class-not_in_sitemap\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("27517", "wpseo_onpage", "a:2:{s:6:\"status\";i:0;s:10:\"last_fetch\";i:1487229081;}", "yes");
INSERT INTO `wp_options` VALUES("31077", "_transient_timeout_external_ip_address_10.35.1.82", "1454026685", "no");
INSERT INTO `wp_options` VALUES("31078", "_transient_external_ip_address_10.35.1.82", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("32844", "wpseo_taxonomy_meta", "a:1:{s:11:\"product_cat\";a:6:{i:131;a:5:{s:11:\"wpseo_title\";s:57:\"Best Hard Body Armor Plates,Hard Armor Plate Manufacturer\";s:13:\"wpseo_metakey\";s:52:\"Lightweight Body Armor Plates,Best Body Armor Plates\";s:13:\"wpseo_noindex\";s:5:\"index\";s:13:\"wpseo_focuskw\";s:52:\"Lightweight Body Armor Plates,Best Body Armor Plates\";s:21:\"wpseo_opengraph-title\";s:52:\"Lightweight Body Armor Plates,Best Body Armor Plates\";}i:124;a:2:{s:11:\"wpseo_title\";s:59:\"Ballistic Helmet Level 3A,Ballistic Helmet Manufacturer USA\";s:13:\"wpseo_focuskw\";s:59:\"Ballistic Helmet Level 3A,Ballistic Helmet Manufacturer USA\";}i:167;a:2:{s:11:\"wpseo_title\";s:44:\"Ballistic Body Armor,Advanced Body Armor USA\";s:13:\"wpseo_focuskw\";s:48:\"Ballistic Body Armor,Body Armor Manufacturer USA\";}i:168;a:1:{s:13:\"wpseo_focuskw\";s:36:\"Ballistic Body Armor, Body Armor USA\";}i:107;a:1:{s:13:\"wpseo_focuskw\";s:42:\"ICW Hard Armor Plates,ICW Ballistic Plates\";}i:132;a:2:{s:13:\"wpseo_metakey\";s:54:\"stand alone body armor plates ,stand alone hard plates\";s:13:\"wpseo_focuskw\";s:53:\"Stand Alone Hard Plates,Stand Alone Body Armor Plates\";}}}", "yes");
INSERT INTO `wp_options` VALUES("33676", "_transient_timeout_external_ip_address_202.133.73.10", "1454585649", "no");
INSERT INTO `wp_options` VALUES("33677", "_transient_external_ip_address_202.133.73.10", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("34801", "_transient_timeout_external_ip_address_250.47.18.180", "1454993976", "no");
INSERT INTO `wp_options` VALUES("34802", "_transient_external_ip_address_250.47.18.180", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("37855", "_transient_timeout_external_ip_address_192.168.1.141", "1455740122", "no");
INSERT INTO `wp_options` VALUES("37856", "_transient_external_ip_address_192.168.1.141", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("42470", "_transient_timeout_wc_product_children_1994", "1459146045", "no");
INSERT INTO `wp_options` VALUES("42471", "_transient_wc_product_children_1994", "a:1:{s:7:\"visible\";a:2:{i:0;i:2110;i:1;i:2111;}}", "no");
INSERT INTO `wp_options` VALUES("45540", "wpseo_dismiss_recalculate", "1", "yes");
INSERT INTO `wp_options` VALUES("45567", "_transient_timeout_external_ip_address_172.17.100.217", "1457688947", "no");
INSERT INTO `wp_options` VALUES("45568", "_transient_external_ip_address_172.17.100.217", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("48080", "_transient_timeout_external_ip_address_192.168.98.4", "1459006706", "no");
INSERT INTO `wp_options` VALUES("48081", "_transient_external_ip_address_192.168.98.4", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("48293", "_transient_timeout_external_ip_address_10.9.71.1", "1459152927", "no");
INSERT INTO `wp_options` VALUES("48294", "_transient_external_ip_address_10.9.71.1", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("48321", "_transient_timeout_external_ip_address_10.100.6.210", "1459166550", "no");
INSERT INTO `wp_options` VALUES("48322", "_transient_external_ip_address_10.100.6.210", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("48938", "_transient_timeout_wc_product_children_2516", "1461481412", "no");
INSERT INTO `wp_options` VALUES("48939", "_transient_wc_product_children_2516", "a:1:{s:7:\"visible\";a:2:{i:0;i:2517;i:1;i:2518;}}", "no");
INSERT INTO `wp_options` VALUES("49337", "_site_transient_timeout_popular_importers_en_US", "1459079933", "yes");
INSERT INTO `wp_options` VALUES("49338", "_site_transient_popular_importers_en_US", "a:2:{s:9:\"importers\";a:8:{s:7:\"blogger\";a:4:{s:4:\"name\";s:7:\"Blogger\";s:11:\"description\";s:86:\"Install the Blogger importer to import posts, comments, and users from a Blogger blog.\";s:11:\"plugin-slug\";s:16:\"blogger-importer\";s:11:\"importer-id\";s:7:\"blogger\";}s:9:\"wpcat2tag\";a:4:{s:4:\"name\";s:29:\"Categories and Tags Converter\";s:11:\"description\";s:109:\"Install the category/tag converter to convert existing categories to tags or tags to categories, selectively.\";s:11:\"plugin-slug\";s:18:\"wpcat2tag-importer\";s:11:\"importer-id\";s:9:\"wpcat2tag\";}s:11:\"livejournal\";a:4:{s:4:\"name\";s:11:\"LiveJournal\";s:11:\"description\";s:82:\"Install the LiveJournal importer to import posts from LiveJournal using their API.\";s:11:\"plugin-slug\";s:20:\"livejournal-importer\";s:11:\"importer-id\";s:11:\"livejournal\";}s:11:\"movabletype\";a:4:{s:4:\"name\";s:24:\"Movable Type and TypePad\";s:11:\"description\";s:99:\"Install the Movable Type importer to import posts and comments from a Movable Type or TypePad blog.\";s:11:\"plugin-slug\";s:20:\"movabletype-importer\";s:11:\"importer-id\";s:2:\"mt\";}s:4:\"opml\";a:4:{s:4:\"name\";s:8:\"Blogroll\";s:11:\"description\";s:61:\"Install the blogroll importer to import links in OPML format.\";s:11:\"plugin-slug\";s:13:\"opml-importer\";s:11:\"importer-id\";s:4:\"opml\";}s:3:\"rss\";a:4:{s:4:\"name\";s:3:\"RSS\";s:11:\"description\";s:58:\"Install the RSS importer to import posts from an RSS feed.\";s:11:\"plugin-slug\";s:12:\"rss-importer\";s:11:\"importer-id\";s:3:\"rss\";}s:6:\"tumblr\";a:4:{s:4:\"name\";s:6:\"Tumblr\";s:11:\"description\";s:84:\"Install the Tumblr importer to import posts &amp; media from Tumblr using their API.\";s:11:\"plugin-slug\";s:15:\"tumblr-importer\";s:11:\"importer-id\";s:6:\"tumblr\";}s:9:\"wordpress\";a:4:{s:4:\"name\";s:9:\"WordPress\";s:11:\"description\";s:130:\"Install the WordPress importer to import posts, pages, comments, custom fields, categories, and tags from a WordPress export file.\";s:11:\"plugin-slug\";s:18:\"wordpress-importer\";s:11:\"importer-id\";s:9:\"wordpress\";}}s:10:\"translated\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("49350", "_transient_timeout_wc_tax_rates_058ddcd2907235fa0293e8cdf2d9b43c", "1459515566", "no");
INSERT INTO `wp_options` VALUES("49351", "_transient_wc_tax_rates_058ddcd2907235fa0293e8cdf2d9b43c", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("53640", "wpseo-gsc-refresh_token", "1/3_wYSTAcOUw4owOqvw9BghWSUFSRpnucSRSqpHPHv9EMEudVrK5jSpoR30zcRFq6", "yes");
INSERT INTO `wp_options` VALUES("53641", "wpseo-gsc-access_token", "a:5:{s:13:\"refresh_token\";s:66:\"1/3_wYSTAcOUw4owOqvw9BghWSUFSRpnucSRSqpHPHv9EMEudVrK5jSpoR30zcRFq6\";s:12:\"access_token\";s:72:\"ya29..xQIxhnLLcS9AEPuUmM6Rihy1WFKilOxz7FpP7Z-zKaB2RnfmBKz4juSJ10rrj3Qjpg\";s:7:\"expires\";i:1460705904;s:10:\"expires_in\";i:3600;s:7:\"created\";i:1460702304;}", "yes");
INSERT INTO `wp_options` VALUES("53643", "wpseo-gsc", "a:1:{s:7:\"profile\";s:24:\"http://www.hardshell.com/\";}", "yes");
INSERT INTO `wp_options` VALUES("53647", "wpseo_gsc_issues_counts", "a:3:{s:3:\"web\";a:6:{s:9:\"not_found\";a:2:{s:5:\"count\";i:6;s:10:\"last_fetch\";i:1460702343;}s:12:\"not_followed\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:13:\"access_denied\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:12:\"server_error\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:8:\"soft_404\";a:2:{s:5:\"count\";s:1:\"1\";s:10:\"last_fetch\";N;}s:5:\"other\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}}s:6:\"mobile\";a:5:{s:9:\"not_found\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:12:\"not_followed\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:13:\"access_denied\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:12:\"server_error\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:5:\"other\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}}s:15:\"smartphone_only\";a:9:{s:9:\"not_found\";a:2:{s:5:\"count\";i:2;s:10:\"last_fetch\";i:1460702331;}s:12:\"not_followed\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:13:\"access_denied\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:12:\"server_error\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:8:\"soft_404\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:7:\"roboted\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:16:\"faulty_redirects\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}i:0;a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}s:5:\"other\";a:2:{s:5:\"count\";s:1:\"0\";s:10:\"last_fetch\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("53648", "wpseo_gsc_last_fetch", "1460702321", "no");
INSERT INTO `wp_options` VALUES("53650", "wpseo-gsc-issues-smartphone_only-not_found", "a:2:{i:0;a:6:{s:3:\"url\";s:55:\"/product-category/body-armor/page/2/?orderby=popularity\";s:14:\"first_detected\";s:8:\"03/21/16\";s:18:\"first_detected_raw\";s:10:\"1458586984\";s:12:\"last_crawled\";s:8:\"03/23/16\";s:16:\"last_crawled_raw\";s:10:\"1458769463\";s:13:\"response_code\";i:404;}i:1;a:6:{s:3:\"url\";s:48:\"/wp-content/uploads/2015/03/hppe-1.5kg-level.pdf\";s:14:\"first_detected\";s:8:\"04/11/16\";s:18:\"first_detected_raw\";s:10:\"1460390325\";s:12:\"last_crawled\";s:8:\"04/11/16\";s:16:\"last_crawled_raw\";s:10:\"1460390325\";s:13:\"response_code\";i:404;}}", "no");
INSERT INTO `wp_options` VALUES("53652", "wpseo-gsc-issues-web-not_found", "a:6:{i:0;a:6:{s:3:\"url\";s:32:\"/shop/page/2/?orderby=price-desc\";s:14:\"first_detected\";s:8:\"03/20/16\";s:18:\"first_detected_raw\";s:10:\"1458446863\";s:12:\"last_crawled\";s:8:\"04/08/16\";s:16:\"last_crawled_raw\";s:10:\"1460115031\";s:13:\"response_code\";i:404;}i:1;a:6:{s:3:\"url\";s:44:\"/product-category/stand-alone/?orderby=price\";s:14:\"first_detected\";s:8:\"04/10/16\";s:18:\"first_detected_raw\";s:10:\"1460288931\";s:12:\"last_crawled\";s:8:\"04/10/16\";s:16:\"last_crawled_raw\";s:10:\"1460288931\";s:13:\"response_code\";i:404;}i:2;a:6:{s:3:\"url\";s:19:\"/shop/?orderby=date\";s:14:\"first_detected\";s:8:\"03/27/16\";s:18:\"first_detected_raw\";s:10:\"1459082458\";s:12:\"last_crawled\";s:8:\"04/09/16\";s:16:\"last_crawled_raw\";s:10:\"1460178931\";s:13:\"response_code\";i:404;}i:3;a:6:{s:3:\"url\";s:24:\"/category/uncategorized/\";s:14:\"first_detected\";s:8:\"03/22/16\";s:18:\"first_detected_raw\";s:10:\"1458632148\";s:12:\"last_crawled\";s:8:\"04/12/16\";s:16:\"last_crawled_raw\";s:10:\"1460419330\";s:13:\"response_code\";i:404;}i:4;a:6:{s:3:\"url\";s:51:\"/product-category/body-armor/page/2/?orderby=rating\";s:14:\"first_detected\";s:8:\"03/19/16\";s:18:\"first_detected_raw\";s:10:\"1458402913\";s:12:\"last_crawled\";s:8:\"04/08/16\";s:16:\"last_crawled_raw\";s:10:\"1460149889\";s:13:\"response_code\";i:404;}i:5;a:6:{s:3:\"url\";s:40:\"/product-category/helmets/?orderby=price\";s:14:\"first_detected\";s:8:\"04/08/16\";s:18:\"first_detected_raw\";s:10:\"1460141531\";s:12:\"last_crawled\";s:8:\"04/14/16\";s:16:\"last_crawled_raw\";s:10:\"1460595070\";s:13:\"response_code\";i:404;}}", "no");
INSERT INTO `wp_options` VALUES("54343", "_transient_timeout_external_ip_address_10.1.1.51", "1461765828", "no");
INSERT INTO `wp_options` VALUES("54344", "_transient_external_ip_address_10.1.1.51", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("55775", "_transient_timeout_external_ip_address_10.15.156.76", "1462546896", "no");
INSERT INTO `wp_options` VALUES("55776", "_transient_external_ip_address_10.15.156.76", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("56468", "_transient_timeout_external_ip_address_10.255.242.36", "1462819854", "no");
INSERT INTO `wp_options` VALUES("56469", "_transient_external_ip_address_10.255.242.36", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("57689", "_transient_timeout_external_ip_address_172.30.65.148", "1463662425", "no");
INSERT INTO `wp_options` VALUES("57690", "_transient_external_ip_address_172.30.65.148", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("57970", "_transient_timeout_external_ip_address_246.229.185.65", "1463794441", "no");
INSERT INTO `wp_options` VALUES("57971", "_transient_external_ip_address_246.229.185.65", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("58258", "_transient_timeout_wc_tax_rates_7eac49d8e611610eaf77f6f2c611cf93", "1463953040", "no");
INSERT INTO `wp_options` VALUES("58259", "_transient_wc_tax_rates_7eac49d8e611610eaf77f6f2c611cf93", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("58423", "_transient_timeout_external_ip_address_172.16.3.3", "1464071620", "no");
INSERT INTO `wp_options` VALUES("58424", "_transient_external_ip_address_172.16.3.3", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("59497", "_transient_timeout_external_ip_address_10.16.192.216", "1464746887", "no");
INSERT INTO `wp_options` VALUES("59498", "_transient_external_ip_address_10.16.192.216", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("61349", "_transient_timeout_external_ip_address_192.168.60.82", "1465396834", "no");
INSERT INTO `wp_options` VALUES("61350", "_transient_external_ip_address_192.168.60.82", "69.167.168.100", "no");
INSERT INTO `wp_options` VALUES("62148", "woocommerce_permalinks", "a:4:{s:13:\"category_base\";s:0:\"\";s:8:\"tag_base\";s:0:\"\";s:14:\"attribute_base\";s:0:\"\";s:12:\"product_base\";s:8:\"/product\";}", "yes");
INSERT INTO `wp_options` VALUES("62874", "_site_transient_timeout_wporg_theme_feature_list", "1465545458", "yes");
INSERT INTO `wp_options` VALUES("62875", "_site_transient_wporg_theme_feature_list", "a:4:{s:6:\"Colors\";a:15:{i:0;s:5:\"black\";i:1;s:4:\"blue\";i:2;s:5:\"brown\";i:3;s:4:\"gray\";i:4;s:5:\"green\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:3:\"red\";i:9;s:6:\"silver\";i:10;s:3:\"tan\";i:11;s:5:\"white\";i:12;s:6:\"yellow\";i:13;s:4:\"dark\";i:14;s:5:\"light\";}s:6:\"Layout\";a:9:{i:0;s:12:\"fixed-layout\";i:1;s:12:\"fluid-layout\";i:2;s:17:\"responsive-layout\";i:3;s:10:\"one-column\";i:4;s:11:\"two-columns\";i:5;s:13:\"three-columns\";i:6;s:12:\"four-columns\";i:7;s:12:\"left-sidebar\";i:8;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:8:\"blavatar\";i:2;s:10:\"buddypress\";i:3;s:17:\"custom-background\";i:4;s:13:\"custom-colors\";i:5;s:13:\"custom-header\";i:6;s:11:\"custom-menu\";i:7;s:12:\"editor-style\";i:8;s:21:\"featured-image-header\";i:9;s:15:\"featured-images\";i:10;s:15:\"flexible-header\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:3:{i:0;s:7:\"holiday\";i:1;s:13:\"photoblogging\";i:2;s:8:\"seasonal\";}}", "yes");
INSERT INTO `wp_options` VALUES("63403", "_transient_timeout_wc_rating_count_1871465535784", "1468128063", "no");
INSERT INTO `wp_options` VALUES("63404", "_transient_wc_rating_count_1871465535784", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("63405", "_transient_timeout_wc_average_rating_1871465535784", "1468128064", "no");
INSERT INTO `wp_options` VALUES("63406", "_transient_wc_average_rating_1871465535784", "0", "no");
INSERT INTO `wp_options` VALUES("63407", "_transient_timeout_wc_var_pricesd4035f095214d5a659d7351465535784", "1468128064", "no");
INSERT INTO `wp_options` VALUES("63408", "_transient_wc_var_pricesd4035f095214d5a659d7351465535784", "a:3:{s:5:\"price\";a:1:{i:1948;i:260;}s:13:\"regular_price\";a:1:{i:1948;i:260;}s:10:\"sale_price\";a:1:{i:1948;i:260;}}", "no");
INSERT INTO `wp_options` VALUES("63409", "_transient_timeout_wc_var_prices633119821cdd60d583b6111465535784", "1468128064", "no");
INSERT INTO `wp_options` VALUES("63410", "_transient_wc_var_prices633119821cdd60d583b6111465535784", "a:3:{s:5:\"price\";a:1:{i:1954;s:6:\"418.20\";}s:13:\"regular_price\";a:1:{i:1954;s:6:\"418.20\";}s:10:\"sale_price\";a:1:{i:1954;s:6:\"418.20\";}}", "no");
INSERT INTO `wp_options` VALUES("63411", "_transient_timeout_wc_rating_count_1851465535784", "1468128064", "no");
INSERT INTO `wp_options` VALUES("63412", "_transient_wc_rating_count_1851465535784", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("63413", "_transient_timeout_wc_average_rating_1851465535784", "1468128064", "no");
INSERT INTO `wp_options` VALUES("63414", "_transient_wc_average_rating_1851465535784", "0", "no");
INSERT INTO `wp_options` VALUES("63415", "_transient_timeout_wc_var_prices91a10bd4ae0b45920a6c3f1465535784", "1468128064", "no");
INSERT INTO `wp_options` VALUES("63416", "_transient_wc_var_prices91a10bd4ae0b45920a6c3f1465535784", "a:3:{s:5:\"price\";a:1:{i:1954;d:418.19999999999998863131622783839702606201171875;}s:13:\"regular_price\";a:1:{i:1954;d:418.19999999999998863131622783839702606201171875;}s:10:\"sale_price\";a:1:{i:1954;d:418.19999999999998863131622783839702606201171875;}}", "no");
INSERT INTO `wp_options` VALUES("63417", "_transient_timeout_wc_var_prices1d90330a9d4642abe5a2031465535784", "1468128064", "no");
INSERT INTO `wp_options` VALUES("63418", "_transient_wc_var_prices1d90330a9d4642abe5a2031465535784", "a:3:{s:5:\"price\";a:2:{i:1961;s:6:\"260.00\";i:1960;s:6:\"260.00\";}s:13:\"regular_price\";a:2:{i:1961;s:6:\"260.00\";i:1960;s:6:\"260.00\";}s:10:\"sale_price\";a:2:{i:1961;s:6:\"260.00\";i:1960;s:6:\"260.00\";}}", "no");
INSERT INTO `wp_options` VALUES("63419", "_transient_timeout_wc_rating_count_1881465535784", "1468128064", "no");
INSERT INTO `wp_options` VALUES("63420", "_transient_wc_rating_count_1881465535784", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("63421", "_transient_timeout_wc_average_rating_1881465535784", "1468128065", "no");
INSERT INTO `wp_options` VALUES("63422", "_transient_wc_average_rating_1881465535784", "0", "no");
INSERT INTO `wp_options` VALUES("63423", "_transient_timeout_wc_var_pricesd066263a739a60885ca6ab1465535784", "1468128065", "no");
INSERT INTO `wp_options` VALUES("63424", "_transient_wc_var_pricesd066263a739a60885ca6ab1465535784", "a:3:{s:5:\"price\";a:2:{i:1961;d:260;i:1960;d:260;}s:13:\"regular_price\";a:2:{i:1961;d:260;i:1960;d:260;}s:10:\"sale_price\";a:2:{i:1961;d:260;i:1960;d:260;}}", "no");
INSERT INTO `wp_options` VALUES("63425", "_transient_timeout_wc_var_pricesd23f559393fa60de0b7efc1465535784", "1468128065", "no");
INSERT INTO `wp_options` VALUES("63426", "_transient_wc_var_pricesd23f559393fa60de0b7efc1465535784", "a:3:{s:5:\"price\";a:1:{i:1974;s:6:\"200.00\";}s:13:\"regular_price\";a:1:{i:1974;s:6:\"200.00\";}s:10:\"sale_price\";a:1:{i:1974;s:6:\"200.00\";}}", "no");
INSERT INTO `wp_options` VALUES("63427", "_transient_timeout_wc_rating_count_1911465535784", "1468128065", "no");
INSERT INTO `wp_options` VALUES("63428", "_transient_wc_rating_count_1911465535784", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("63429", "_transient_timeout_wc_average_rating_1911465535784", "1468128065", "no");
INSERT INTO `wp_options` VALUES("63430", "_transient_wc_average_rating_1911465535784", "0", "no");
INSERT INTO `wp_options` VALUES("63431", "_transient_timeout_wc_var_prices424fcfb034ecd382fce57f1465535784", "1468128065", "no");
INSERT INTO `wp_options` VALUES("63432", "_transient_wc_var_prices424fcfb034ecd382fce57f1465535784", "a:3:{s:5:\"price\";a:1:{i:1974;d:200;}s:13:\"regular_price\";a:1:{i:1974;d:200;}s:10:\"sale_price\";a:1:{i:1974;d:200;}}", "no");
INSERT INTO `wp_options` VALUES("63433", "_transient_timeout_wc_var_prices51bb073085c80cebccaa801465535784", "1468128065", "no");
INSERT INTO `wp_options` VALUES("63434", "_transient_wc_var_prices51bb073085c80cebccaa801465535784", "a:3:{s:5:\"price\";a:1:{i:1971;s:3:\"200\";}s:13:\"regular_price\";a:1:{i:1971;s:3:\"200\";}s:10:\"sale_price\";a:1:{i:1971;s:3:\"200\";}}", "no");
INSERT INTO `wp_options` VALUES("63435", "_transient_timeout_wc_rating_count_1901465535784", "1468128065", "no");
INSERT INTO `wp_options` VALUES("63436", "_transient_wc_rating_count_1901465535784", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("63437", "_transient_timeout_wc_average_rating_1901465535784", "1468128066", "no");
INSERT INTO `wp_options` VALUES("63438", "_transient_wc_average_rating_1901465535784", "0", "no");
INSERT INTO `wp_options` VALUES("63439", "_transient_timeout_wc_var_prices98cfc2622c98524cc251ee1465535784", "1468128066", "no");
INSERT INTO `wp_options` VALUES("63440", "_transient_wc_var_prices98cfc2622c98524cc251ee1465535784", "a:3:{s:5:\"price\";a:1:{i:1971;i:200;}s:13:\"regular_price\";a:1:{i:1971;i:200;}s:10:\"sale_price\";a:1:{i:1971;i:200;}}", "no");
INSERT INTO `wp_options` VALUES("63441", "_transient_timeout_wc_var_pricesf89d09d9e5729dbae839011465535784", "1468128066", "no");
INSERT INTO `wp_options` VALUES("63442", "_transient_wc_var_pricesf89d09d9e5729dbae839011465535784", "a:3:{s:5:\"price\";a:1:{i:1967;s:5:\"418.2\";}s:13:\"regular_price\";a:1:{i:1967;s:5:\"418.2\";}s:10:\"sale_price\";a:1:{i:1967;s:5:\"418.2\";}}", "no");
INSERT INTO `wp_options` VALUES("63443", "_transient_timeout_wc_rating_count_631465535784", "1468128066", "no");
INSERT INTO `wp_options` VALUES("63444", "_transient_wc_rating_count_631465535784", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("63445", "_transient_timeout_wc_average_rating_631465535784", "1468128067", "no");
INSERT INTO `wp_options` VALUES("63446", "_transient_wc_average_rating_631465535784", "0", "no");
INSERT INTO `wp_options` VALUES("63447", "_transient_timeout_wc_var_prices6d7dba9f8213164f8479971465535784", "1468128067", "no");
INSERT INTO `wp_options` VALUES("63448", "_transient_wc_var_prices6d7dba9f8213164f8479971465535784", "a:3:{s:5:\"price\";a:1:{i:1967;d:418.19999999999998863131622783839702606201171875;}s:13:\"regular_price\";a:1:{i:1967;d:418.19999999999998863131622783839702606201171875;}s:10:\"sale_price\";a:1:{i:1967;d:418.19999999999998863131622783839702606201171875;}}", "no");
INSERT INTO `wp_options` VALUES("63449", "_transient_timeout_wc_var_pricesb46432f98384c46111e88a1465535784", "1468128068", "no");
INSERT INTO `wp_options` VALUES("63450", "_transient_wc_var_pricesb46432f98384c46111e88a1465535784", "a:3:{s:5:\"price\";a:1:{i:1968;s:6:\"445.50\";}s:13:\"regular_price\";a:1:{i:1968;s:6:\"445.50\";}s:10:\"sale_price\";a:1:{i:1968;s:6:\"445.50\";}}", "no");
INSERT INTO `wp_options` VALUES("63451", "_transient_timeout_wc_rating_count_1891465535784", "1468128068", "no");
INSERT INTO `wp_options` VALUES("63452", "_transient_wc_rating_count_1891465535784", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("63453", "_transient_timeout_wc_average_rating_1891465535784", "1468128068", "no");
INSERT INTO `wp_options` VALUES("63454", "_transient_wc_average_rating_1891465535784", "0", "no");
INSERT INTO `wp_options` VALUES("63455", "_transient_timeout_wc_var_pricese409b0fb97bc0ea79ded361465535784", "1468128068", "no");
INSERT INTO `wp_options` VALUES("63456", "_transient_wc_var_pricese409b0fb97bc0ea79ded361465535784", "a:3:{s:5:\"price\";a:1:{i:1968;d:445.5;}s:13:\"regular_price\";a:1:{i:1968;d:445.5;}s:10:\"sale_price\";a:1:{i:1968;d:445.5;}}", "no");
INSERT INTO `wp_options` VALUES("64728", "_transient_timeout_external_ip_address_192.168.1.150", "1466373266", "no");
INSERT INTO `wp_options` VALUES("64729", "_transient_external_ip_address_192.168.1.150", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("65096", "_transient_timeout_external_ip_address_10.2.31.166", "1466611012", "no");
INSERT INTO `wp_options` VALUES("65097", "_transient_external_ip_address_10.2.31.166", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("66766", "_transient_timeout_external_ip_address_10.80.25.160", "1467313403", "no");
INSERT INTO `wp_options` VALUES("66767", "_transient_external_ip_address_10.80.25.160", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("68310", "_transient_timeout_wc_tax_rates_1d715bf89a7e858393545349b5438b53", "1468303233", "no");
INSERT INTO `wp_options` VALUES("68311", "_transient_wc_tax_rates_1d715bf89a7e858393545349b5438b53", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("68487", "_transient_timeout_external_ip_address_}__test|O:21:\\\"JDatabaseDriverMysqli\\\":3:{s:2:\\\"fc\\\";O:17:\\\"JSimplepieFactory\\\":0:{}s:21:\\\"\\\\0\\\\0\\\\0disconnectHandlers\\\";a:1:{i:0;a:2:{i:0;O:9:\\\"SimpleP", "1469130658", "no");
INSERT INTO `wp_options` VALUES("68488", "_transient_external_ip_address_}__test|O:21:\\\"JDatabaseDriverMysqli\\\":3:{s:2:\\\"fc\\\";O:17:\\\"JSimplepieFactory\\\":0:{}s:21:\\\"\\\\0\\\\0\\\\0disconnectHandlers\\\";a:1:{i:0;a:2:{i:0;O:9:\\\"SimplePie\\\":5:{", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("70158", "_transient_timeout_wc_tax_rates_1950a451e1d2d14a6af6ff7c80f19cb1", "1469032699", "no");
INSERT INTO `wp_options` VALUES("70159", "_transient_wc_tax_rates_1950a451e1d2d14a6af6ff7c80f19cb1", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("70874", "_transient_timeout_external_ip_address_172.28.73.67", "1469462814", "no");
INSERT INTO `wp_options` VALUES("70875", "_transient_external_ip_address_172.28.73.67", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("70904", "_transient_timeout_wc_tax_rates_cd41861341c4d86a8324d91c06e17475", "1469484200", "no");
INSERT INTO `wp_options` VALUES("70905", "_transient_wc_tax_rates_cd41861341c4d86a8324d91c06e17475", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("71027", "_transient_timeout_external_ip_address_10.80.26.75", "1469550163", "no");
INSERT INTO `wp_options` VALUES("71028", "_transient_external_ip_address_10.80.26.75", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("71139", "_transient_timeout_external_ip_address_10.80.46.155", "1469622159", "no");
INSERT INTO `wp_options` VALUES("71140", "_transient_external_ip_address_10.80.46.155", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("71728", "_transient_timeout_external_ip_address_10.136.16.102", "1469970269", "no");
INSERT INTO `wp_options` VALUES("71729", "_transient_external_ip_address_10.136.16.102", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("72456", "_transient_timeout_external_ip_address_10.120.40.169", "1470401614", "no");
INSERT INTO `wp_options` VALUES("72457", "_transient_external_ip_address_10.120.40.169", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("72856", "_transient_timeout_external_ip_address_192.168.5.105", "1470654025", "no");
INSERT INTO `wp_options` VALUES("72857", "_transient_external_ip_address_192.168.5.105", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("72915", "_transient_timeout_external_ip_address_103.66.235.157", "1470666451", "no");
INSERT INTO `wp_options` VALUES("72916", "_transient_external_ip_address_103.66.235.157", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("72920", "_transient_timeout_external_ip_address_10.0.0.10", "1470668546", "no");
INSERT INTO `wp_options` VALUES("72921", "_transient_external_ip_address_10.0.0.10", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("73005", "_transient_timeout_external_ip_address_172.16.3.100", "1470713525", "no");
INSERT INTO `wp_options` VALUES("73006", "_transient_external_ip_address_172.16.3.100", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("73024", "_transient_timeout_external_ip_address_172.16.1.193", "1470724203", "no");
INSERT INTO `wp_options` VALUES("73025", "_transient_external_ip_address_172.16.1.193", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("73087", "_transient_timeout_external_ip_address_192.168.3.94", "1470732651", "no");
INSERT INTO `wp_options` VALUES("73088", "_transient_external_ip_address_192.168.3.94", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("73783", "_transient_timeout_external_ip_address_10.222.126.112", "1470756036", "no");
INSERT INTO `wp_options` VALUES("73784", "_transient_external_ip_address_10.222.126.112", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("73785", "_transient_timeout_external_ip_address_10.222.82.146", "1470756052", "no");
INSERT INTO `wp_options` VALUES("73786", "_transient_external_ip_address_10.222.82.146", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("73841", "_transient_timeout_external_ip_address_10.24.115.163", "1470788943", "no");
INSERT INTO `wp_options` VALUES("73842", "_transient_external_ip_address_10.24.115.163", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("73848", "_transient_timeout_external_ip_address_10.119.155.182", "1470792767", "no");
INSERT INTO `wp_options` VALUES("73849", "_transient_external_ip_address_10.119.155.182", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("74999", "_transient_timeout_external_ip_address_192.168.88.204", "1471121913", "no");
INSERT INTO `wp_options` VALUES("75000", "_transient_external_ip_address_192.168.88.204", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("75189", "_transient_timeout_external_ip_address_10.100.6.72", "1471241650", "no");
INSERT INTO `wp_options` VALUES("75190", "_transient_external_ip_address_10.100.6.72", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("75230", "_transient_timeout_wc_var_prices2895235a09c915ca6ab0961470216442", "1473231213", "no");
INSERT INTO `wp_options` VALUES("75231", "_transient_wc_var_prices2895235a09c915ca6ab0961470216442", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("75232", "_transient_timeout_wc_rating_count_23441470216442", "1473231213", "no");
INSERT INTO `wp_options` VALUES("75233", "_transient_wc_rating_count_23441470216442", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("75234", "_transient_timeout_wc_review_count_23441470216442", "1473231214", "no");
INSERT INTO `wp_options` VALUES("75235", "_transient_wc_review_count_23441470216442", "0", "no");
INSERT INTO `wp_options` VALUES("75236", "_transient_timeout_wc_average_rating_23441470216442", "1473231214", "no");
INSERT INTO `wp_options` VALUES("75237", "_transient_wc_average_rating_23441470216442", "0", "no");
INSERT INTO `wp_options` VALUES("75238", "_transient_timeout_wc_var_prices0a64788bb7b54ab256cd1b1470216442", "1473231214", "no");
INSERT INTO `wp_options` VALUES("75239", "_transient_wc_var_prices0a64788bb7b54ab256cd1b1470216442", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("75240", "_transient_timeout_wc_related_4_23441470216442", "1473231215", "no");
INSERT INTO `wp_options` VALUES("75241", "_transient_wc_related_4_23441470216442", "a:2:{i:0;s:4:\"2003\";i:1;s:4:\"2365\";}", "no");
INSERT INTO `wp_options` VALUES("75242", "_transient_timeout_wc_var_prices4aaf2444b326783ae2f5c11470216442", "1473231215", "no");
INSERT INTO `wp_options` VALUES("75243", "_transient_wc_var_prices4aaf2444b326783ae2f5c11470216442", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("75244", "_transient_timeout_wc_rating_count_23651470216442", "1473231215", "no");
INSERT INTO `wp_options` VALUES("75245", "_transient_wc_rating_count_23651470216442", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("75246", "_transient_timeout_wc_average_rating_23651470216442", "1473231215", "no");
INSERT INTO `wp_options` VALUES("75247", "_transient_wc_average_rating_23651470216442", "0", "no");
INSERT INTO `wp_options` VALUES("75248", "_transient_timeout_wc_var_pricese7cf3f30d03abd154b13c71470216442", "1473231216", "no");
INSERT INTO `wp_options` VALUES("75249", "_transient_wc_var_pricese7cf3f30d03abd154b13c71470216442", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("75250", "_transient_timeout_wc_var_prices9bb67b91b5fd48c9aa87581470216442", "1473231216", "no");
INSERT INTO `wp_options` VALUES("75251", "_transient_wc_var_prices9bb67b91b5fd48c9aa87581470216442", "a:3:{s:5:\"price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}s:13:\"regular_price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}s:10:\"sale_price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("75252", "_transient_timeout_wc_rating_count_20031470216442", "1473231217", "no");
INSERT INTO `wp_options` VALUES("75253", "_transient_wc_rating_count_20031470216442", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("75254", "_transient_timeout_wc_average_rating_20031470216442", "1473231218", "no");
INSERT INTO `wp_options` VALUES("75255", "_transient_wc_average_rating_20031470216442", "0", "no");
INSERT INTO `wp_options` VALUES("76629", "_transient_timeout_external_ip_address_192.168.222.165", "1471314165", "no");
INSERT INTO `wp_options` VALUES("76630", "_transient_external_ip_address_192.168.222.165", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("76688", "_transient_timeout_wc_tax_rates_a6b87ff4a38f759a5989ce81ecb187ac", "1471340685", "no");
INSERT INTO `wp_options` VALUES("76689", "_transient_wc_tax_rates_a6b87ff4a38f759a5989ce81ecb187ac", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("76925", "_transient_timeout_wc_tax_rates_1c16960147bbdb04d6c9d830a284de39", "1471459309", "no");
INSERT INTO `wp_options` VALUES("76926", "_transient_wc_tax_rates_1c16960147bbdb04d6c9d830a284de39", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("77125", "_transient_timeout_wc_tax_rates_f946fb7a125491dda157d259bffb6cee", "1471543901", "no");
INSERT INTO `wp_options` VALUES("77126", "_transient_wc_tax_rates_f946fb7a125491dda157d259bffb6cee", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("77251", "_transient_timeout_wc_tax_rates_a0c4b3dd6dcf283e90f95cdd7326daa2", "1471611706", "no");
INSERT INTO `wp_options` VALUES("77252", "_transient_wc_tax_rates_a0c4b3dd6dcf283e90f95cdd7326daa2", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("77428", "_transient_timeout_external_ip_address_10.250.177.227", "1471720970", "no");
INSERT INTO `wp_options` VALUES("77429", "_transient_external_ip_address_10.250.177.227", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("77539", "_transient_timeout_external_ip_address_10.4.206.201", "1471786340", "no");
INSERT INTO `wp_options` VALUES("77540", "_transient_external_ip_address_10.4.206.201", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("78207", "_transient_timeout_external_ip_address_10.22.50.144", "1472146715", "no");
INSERT INTO `wp_options` VALUES("78208", "_transient_external_ip_address_10.22.50.144", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("78602", "_transient_timeout_external_ip_address_192.168.88.193", "1472385736", "no");
INSERT INTO `wp_options` VALUES("78603", "_transient_external_ip_address_192.168.88.193", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("78638", "_transient_timeout_external_ip_address_10.0.160.101", "1472407463", "no");
INSERT INTO `wp_options` VALUES("78639", "_transient_external_ip_address_10.0.160.101", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("79088", "_transient_timeout_external_ip_address_192.168.100.27", "1472675868", "no");
INSERT INTO `wp_options` VALUES("79089", "_transient_external_ip_address_192.168.100.27", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("80521", "_transient_timeout_wc_tax_rates_fdcb403c4d98308cc75edc74a3288f0f", "1473535948", "no");
INSERT INTO `wp_options` VALUES("80522", "_transient_wc_tax_rates_fdcb403c4d98308cc75edc74a3288f0f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80765", "_transient_timeout_wc_tax_rates_61a5106823a60b20f5c175c3963309bd", "1473683729", "no");
INSERT INTO `wp_options` VALUES("80766", "_transient_wc_tax_rates_61a5106823a60b20f5c175c3963309bd", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80950", "_transient_timeout_external_ip_address_10.0.44.164", "1473792585", "no");
INSERT INTO `wp_options` VALUES("80951", "_transient_external_ip_address_10.0.44.164", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("81552", "_transient_timeout_external_ip_address_10.195.31.11", "1473916292", "no");
INSERT INTO `wp_options` VALUES("81553", "_transient_external_ip_address_10.195.31.11", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("81578", "_transient_timeout_wc_tax_rates_b34188eff4432ef8de1545c0fdc6690d", "1473928433", "no");
INSERT INTO `wp_options` VALUES("81579", "_transient_wc_tax_rates_b34188eff4432ef8de1545c0fdc6690d", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("81971", "_transient_timeout_external_ip_address_192.168.192.237", "1474137134", "no");
INSERT INTO `wp_options` VALUES("81972", "_transient_external_ip_address_192.168.192.237", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("83132", "_transient_timeout_wc_tax_rates_9e341bed1447cbd651ab4104a601c026", "1474414622", "no");
INSERT INTO `wp_options` VALUES("83133", "_transient_wc_tax_rates_9e341bed1447cbd651ab4104a601c026", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("83167", "_transient_timeout_wc_tax_rates_134173d252d7cbfe9351e1e63391cf08", "1474434132", "no");
INSERT INTO `wp_options` VALUES("83168", "_transient_wc_tax_rates_134173d252d7cbfe9351e1e63391cf08", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("83421", "_transient_timeout_wpseo_sitemap_cache_1_1", "1474020681", "no");
INSERT INTO `wp_options` VALUES("83422", "_transient_wpseo_sitemap_cache_1_1", "<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n<sitemap>\n<loc>http://www.hardshell.com/post-sitemap.xml</loc>\n<lastmod>2016-08-04T07:47:06+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://www.hardshell.com/page-sitemap.xml</loc>\n<lastmod>2016-09-12T12:04:14+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://www.hardshell.com/product-sitemap.xml</loc>\n<lastmod>2016-09-12T11:25:08+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://www.hardshell.com/category-sitemap.xml</loc>\n<lastmod>2016-08-04T07:47:06+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://www.hardshell.com/post_tag-sitemap.xml</loc>\n<lastmod>2016-08-04T07:47:06+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://www.hardshell.com/author-sitemap.xml</loc>\n<lastmod>2016-04-08T11:11:15+00:00</lastmod>\n</sitemap>\n</sitemapindex>", "no");
INSERT INTO `wp_options` VALUES("83435", "_transient_timeout_external_ip_address_10.100.6.94", "1474542542", "no");
INSERT INTO `wp_options` VALUES("83436", "_transient_external_ip_address_10.100.6.94", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("83557", "_transient_timeout_external_ip_address_10.100.6.103", "1474618016", "no");
INSERT INTO `wp_options` VALUES("83558", "_transient_external_ip_address_10.100.6.103", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("83688", "_transient_timeout_external_ip_address_226.136.200.134", "1474658654", "no");
INSERT INTO `wp_options` VALUES("83689", "_transient_external_ip_address_226.136.200.134", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("83690", "_transient_timeout_external_ip_address_237.178.35.181", "1474658820", "no");
INSERT INTO `wp_options` VALUES("83691", "_transient_external_ip_address_237.178.35.181", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("83734", "_transient_timeout_wpseo_sitemap_cache_category_1", "1474165320", "no");
INSERT INTO `wp_options` VALUES("83735", "_transient_wpseo_sitemap_cache_category_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://www.hardshell.com/category/blog/</loc>\n		<lastmod>2016-04-05T04:37:22+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://www.hardshell.com/category/blog/body-armor/</loc>\n		<lastmod>2016-08-04T07:47:06+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `wp_options` VALUES("83738", "_transient_timeout_wpseo_sitemap_cache_author_1", "1474167793", "no");
INSERT INTO `wp_options` VALUES("83739", "_transient_wpseo_sitemap_cache_author_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://www.hardshell.com/author/hardshell/</loc>\n		<lastmod>2016-04-08T11:11:15+00:00</lastmod>\n		<changefreq>daily</changefreq>\n		<priority>0.8</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `wp_options` VALUES("83809", "aioseop_options", "a:102:{s:12:\"aiosp_donate\";s:0:\"\";s:16:\"aiosp_home_title\";s:0:\"\";s:22:\"aiosp_home_description\";s:0:\"\";s:20:\"aiosp_togglekeywords\";s:1:\"1\";s:19:\"aiosp_home_keywords\";s:0:\"\";s:26:\"aiosp_use_static_home_info\";s:1:\"0\";s:9:\"aiosp_can\";s:2:\"on\";s:30:\"aiosp_no_paged_canonical_links\";s:0:\"\";s:31:\"aiosp_customize_canonical_links\";s:0:\"\";s:22:\"aiosp_can_set_protocol\";s:4:\"auto\";s:20:\"aiosp_rewrite_titles\";s:1:\"1\";s:20:\"aiosp_force_rewrites\";s:1:\"1\";s:24:\"aiosp_use_original_title\";s:1:\"0\";s:16:\"aiosp_cap_titles\";s:2:\"on\";s:14:\"aiosp_cap_cats\";s:2:\"on\";s:28:\"aiosp_home_page_title_format\";s:12:\"%page_title%\";s:23:\"aiosp_page_title_format\";s:27:\"%page_title% | %blog_title%\";s:23:\"aiosp_post_title_format\";s:27:\"%post_title% | %blog_title%\";s:27:\"aiosp_category_title_format\";s:31:\"%category_title% | %blog_title%\";s:26:\"aiosp_archive_title_format\";s:30:\"%archive_title% | %blog_title%\";s:23:\"aiosp_date_title_format\";s:21:\"%date% | %blog_title%\";s:25:\"aiosp_author_title_format\";s:23:\"%author% | %blog_title%\";s:22:\"aiosp_tag_title_format\";s:20:\"%tag% | %blog_title%\";s:25:\"aiosp_search_title_format\";s:23:\"%search% | %blog_title%\";s:24:\"aiosp_description_format\";s:13:\"%description%\";s:22:\"aiosp_404_title_format\";s:33:\"Nothing found for %request_words%\";s:18:\"aiosp_paged_format\";s:14:\" - Part %page%\";s:17:\"aiosp_enablecpost\";s:2:\"on\";s:17:\"aiosp_cpostactive\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"aiosp_cpostadvanced\";s:1:\"0\";s:18:\"aiosp_cpostnoindex\";s:0:\"\";s:19:\"aiosp_cpostnofollow\";s:0:\"\";s:16:\"aiosp_cpostnoodp\";s:0:\"\";s:17:\"aiosp_cpostnoydir\";s:0:\"\";s:17:\"aiosp_cposttitles\";s:0:\"\";s:21:\"aiosp_posttypecolumns\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:15:\"aiosp_admin_bar\";s:2:\"on\";s:23:\"aiosp_custom_menu_order\";s:2:\"on\";s:19:\"aiosp_google_verify\";s:0:\"\";s:17:\"aiosp_bing_verify\";s:0:\"\";s:22:\"aiosp_pinterest_verify\";s:0:\"\";s:22:\"aiosp_google_publisher\";s:0:\"\";s:28:\"aiosp_google_disable_profile\";s:0:\"\";s:29:\"aiosp_google_sitelinks_search\";s:0:\"\";s:26:\"aiosp_google_set_site_name\";s:0:\"\";s:30:\"aiosp_google_specify_site_name\";s:0:\"\";s:28:\"aiosp_google_author_advanced\";s:1:\"0\";s:28:\"aiosp_google_author_location\";a:1:{i:0;s:3:\"all\";}s:29:\"aiosp_google_enable_publisher\";s:2:\"on\";s:30:\"aiosp_google_specify_publisher\";s:0:\"\";s:25:\"aiosp_google_analytics_id\";s:0:\"\";s:25:\"aiosp_ga_advanced_options\";s:2:\"on\";s:15:\"aiosp_ga_domain\";s:0:\"\";s:21:\"aiosp_ga_multi_domain\";s:0:\"\";s:21:\"aiosp_ga_addl_domains\";s:0:\"\";s:21:\"aiosp_ga_anonymize_ip\";s:0:\"\";s:28:\"aiosp_ga_display_advertising\";s:0:\"\";s:22:\"aiosp_ga_exclude_users\";s:0:\"\";s:29:\"aiosp_ga_track_outbound_links\";s:0:\"\";s:25:\"aiosp_ga_link_attribution\";s:0:\"\";s:27:\"aiosp_ga_enhanced_ecommerce\";s:0:\"\";s:20:\"aiosp_use_categories\";s:0:\"\";s:26:\"aiosp_use_tags_as_keywords\";s:2:\"on\";s:32:\"aiosp_dynamic_postspage_keywords\";s:2:\"on\";s:22:\"aiosp_category_noindex\";s:0:\"\";s:26:\"aiosp_archive_date_noindex\";s:0:\"\";s:28:\"aiosp_archive_author_noindex\";s:2:\"on\";s:18:\"aiosp_tags_noindex\";s:0:\"\";s:20:\"aiosp_search_noindex\";s:0:\"\";s:17:\"aiosp_404_noindex\";s:0:\"\";s:17:\"aiosp_tax_noindex\";s:0:\"\";s:23:\"aiosp_paginated_noindex\";s:0:\"\";s:24:\"aiosp_paginated_nofollow\";s:0:\"\";s:11:\"aiosp_noodp\";s:0:\"\";s:12:\"aiosp_noydir\";s:0:\"\";s:18:\"aiosp_skip_excerpt\";s:0:\"\";s:27:\"aiosp_generate_descriptions\";s:2:\"on\";s:20:\"aiosp_run_shortcodes\";s:0:\"\";s:33:\"aiosp_hide_paginated_descriptions\";s:0:\"\";s:32:\"aiosp_dont_truncate_descriptions\";s:0:\"\";s:19:\"aiosp_schema_markup\";s:2:\"on\";s:20:\"aiosp_unprotect_meta\";s:0:\"\";s:33:\"aiosp_redirect_attachement_parent\";s:0:\"\";s:14:\"aiosp_ex_pages\";s:0:\"\";s:20:\"aiosp_post_meta_tags\";s:0:\"\";s:20:\"aiosp_page_meta_tags\";s:0:\"\";s:21:\"aiosp_front_meta_tags\";s:0:\"\";s:20:\"aiosp_home_meta_tags\";s:0:\"\";s:12:\"aiosp_do_log\";s:0:\"\";s:19:\"last_active_version\";s:7:\"2.3.9.2\";s:7:\"modules\";a:2:{s:29:\"aiosp_feature_manager_options\";a:7:{s:36:\"aiosp_feature_manager_enable_sitemap\";s:2:\"on\";s:38:\"aiosp_feature_manager_enable_opengraph\";s:0:\"\";s:35:\"aiosp_feature_manager_enable_robots\";s:0:\"\";s:40:\"aiosp_feature_manager_enable_file_editor\";s:2:\"on\";s:46:\"aiosp_feature_manager_enable_importer_exporter\";s:0:\"\";s:39:\"aiosp_feature_manager_enable_bad_robots\";s:0:\"\";s:40:\"aiosp_feature_manager_enable_performance\";s:2:\"on\";}s:21:\"aiosp_sitemap_options\";a:50:{s:22:\"aiosp_sitemap_filename\";s:7:\"sitemap\";s:20:\"aiosp_sitemap_google\";s:0:\"\";s:18:\"aiosp_sitemap_bing\";s:0:\"\";s:24:\"aiosp_sitemap_daily_cron\";s:1:\"0\";s:21:\"aiosp_sitemap_indexes\";s:0:\"\";s:22:\"aiosp_sitemap_paginate\";s:0:\"\";s:23:\"aiosp_sitemap_max_posts\";s:5:\"50000\";s:23:\"aiosp_sitemap_posttypes\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"product\";}s:24:\"aiosp_sitemap_taxonomies\";a:4:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"product_cat\";i:3;s:22:\"product_shipping_class\";}s:21:\"aiosp_sitemap_archive\";s:0:\"\";s:20:\"aiosp_sitemap_author\";s:0:\"\";s:21:\"aiosp_sitemap_gzipped\";s:2:\"on\";s:20:\"aiosp_sitemap_robots\";s:2:\"on\";s:21:\"aiosp_sitemap_rewrite\";s:2:\"on\";s:24:\"aiosp_sitemap_addl_pages\";a:0:{}s:29:\"aiosp_sitemap_excl_categories\";s:0:\"\";s:24:\"aiosp_sitemap_excl_pages\";s:0:\"\";s:27:\"aiosp_sitemap_prio_homepage\";s:2:\"no\";s:23:\"aiosp_sitemap_prio_post\";s:2:\"no\";s:35:\"aiosp_sitemap_prio_post_testimonial\";s:2:\"no\";s:31:\"aiosp_sitemap_prio_post_product\";s:2:\"no\";s:34:\"aiosp_sitemap_prio_post_attachment\";s:2:\"no\";s:28:\"aiosp_sitemap_prio_post_page\";s:2:\"no\";s:28:\"aiosp_sitemap_prio_post_post\";s:2:\"no\";s:29:\"aiosp_sitemap_prio_taxonomies\";s:2:\"no\";s:52:\"aiosp_sitemap_prio_taxonomies_product_shipping_class\";s:2:\"no\";s:41:\"aiosp_sitemap_prio_taxonomies_product_tag\";s:2:\"no\";s:41:\"aiosp_sitemap_prio_taxonomies_product_cat\";s:2:\"no\";s:41:\"aiosp_sitemap_prio_taxonomies_post_format\";s:2:\"no\";s:38:\"aiosp_sitemap_prio_taxonomies_post_tag\";s:2:\"no\";s:38:\"aiosp_sitemap_prio_taxonomies_category\";s:2:\"no\";s:26:\"aiosp_sitemap_prio_archive\";s:2:\"no\";s:25:\"aiosp_sitemap_prio_author\";s:2:\"no\";s:27:\"aiosp_sitemap_freq_homepage\";s:2:\"no\";s:23:\"aiosp_sitemap_freq_post\";s:2:\"no\";s:35:\"aiosp_sitemap_freq_post_testimonial\";s:2:\"no\";s:31:\"aiosp_sitemap_freq_post_product\";s:2:\"no\";s:34:\"aiosp_sitemap_freq_post_attachment\";s:2:\"no\";s:28:\"aiosp_sitemap_freq_post_page\";s:2:\"no\";s:28:\"aiosp_sitemap_freq_post_post\";s:2:\"no\";s:29:\"aiosp_sitemap_freq_taxonomies\";s:2:\"no\";s:52:\"aiosp_sitemap_freq_taxonomies_product_shipping_class\";s:2:\"no\";s:41:\"aiosp_sitemap_freq_taxonomies_product_tag\";s:2:\"no\";s:41:\"aiosp_sitemap_freq_taxonomies_product_cat\";s:2:\"no\";s:41:\"aiosp_sitemap_freq_taxonomies_post_format\";s:2:\"no\";s:38:\"aiosp_sitemap_freq_taxonomies_post_tag\";s:2:\"no\";s:38:\"aiosp_sitemap_freq_taxonomies_category\";s:2:\"no\";s:26:\"aiosp_sitemap_freq_archive\";s:2:\"no\";s:25:\"aiosp_sitemap_freq_author\";s:2:\"no\";s:19:\"aiosp_sitemap_debug\";s:780:\"2016-09-20 10:44:37  0.06 MB memory used generating the dynamic sitemap in 0.470 seconds, 49.07 MB total memory used.\n2016-09-19 17:57:35  0.06 MB memory used generating the dynamic sitemap in 0.437 seconds, 47.09 MB total memory used.\n2016-09-17 09:31:22  0.82 MB memory used generating the dynamic sitemap in 2.737 seconds, 48.12 MB total memory used.\n2016-09-17 08:51:54  0.82 MB memory used generating the dynamic sitemap in 0.641 seconds, 48.11 MB total memory used.\n2016-09-17 08:51:53 Updated sitemap settings.\n2016-09-17 08:51:53 Did not notify bing about changes to your sitemap.\n2016-09-17 08:51:53 Did not notify google about changes to your sitemap.\n2016-09-17 08:09:14  2.73 MB memory used generating the dynamic sitemap in 1.154 seconds, 49.95 MB total memory used.\n\";}}s:29:\"aiosp_attachment_title_format\";s:27:\"%post_title% | %blog_title%\";s:22:\"aiosp_acf_title_format\";s:27:\"%post_title% | %blog_title%\";s:26:\"aiosp_product_title_format\";s:27:\"%post_title% | %blog_title%\";s:36:\"aiosp_product_variation_title_format\";s:27:\"%post_title% | %blog_title%\";s:29:\"aiosp_shop_order_title_format\";s:27:\"%post_title% | %blog_title%\";s:36:\"aiosp_shop_order_refund_title_format\";s:27:\"%post_title% | %blog_title%\";s:30:\"aiosp_shop_coupon_title_format\";s:27:\"%post_title% | %blog_title%\";s:31:\"aiosp_shop_webhook_title_format\";s:27:\"%post_title% | %blog_title%\";s:37:\"aiosp_wpcf7_contact_form_title_format\";s:27:\"%post_title% | %blog_title%\";s:31:\"aiosp_vc_grid_item_title_format\";s:27:\"%post_title% | %blog_title%\";s:30:\"aiosp_testimonial_title_format\";s:27:\"%post_title% | %blog_title%\";}", "yes");
INSERT INTO `wp_options` VALUES("84081", "_transient_timeout_external_ip_address_192.168.88.21", "1474852062", "no");
INSERT INTO `wp_options` VALUES("84082", "_transient_external_ip_address_192.168.88.21", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("84157", "_transient_timeout_wc_tax_rates_c39a2713bf8e597935fc9f45d7b6df3d", "1474895112", "no");
INSERT INTO `wp_options` VALUES("84158", "_transient_wc_tax_rates_c39a2713bf8e597935fc9f45d7b6df3d", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("84365", "_transient_timeout_external_ip_address_10.101.3.221", "1474989545", "no");
INSERT INTO `wp_options` VALUES("84366", "_transient_external_ip_address_10.101.3.221", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("84445", "_site_transient_timeout_aioseop_update_check_time", "1474455975", "yes");
INSERT INTO `wp_options` VALUES("84446", "_site_transient_aioseop_update_check_time", "1474434375", "yes");
INSERT INTO `wp_options` VALUES("84480", "_transient_timeout_wc_var_prices397d82e130ff99c23689d21473679509", "1477028825", "no");
INSERT INTO `wp_options` VALUES("84481", "_transient_wc_var_prices397d82e130ff99c23689d21473679509", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("84482", "_transient_timeout_wc_rating_count_24791473679509", "1477028825", "no");
INSERT INTO `wp_options` VALUES("84483", "_transient_wc_rating_count_24791473679509", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("84484", "_transient_timeout_wc_review_count_24791473679509", "1477028825", "no");
INSERT INTO `wp_options` VALUES("84485", "_transient_wc_review_count_24791473679509", "0", "no");
INSERT INTO `wp_options` VALUES("84486", "_transient_timeout_wc_average_rating_24791473679509", "1477028825", "no");
INSERT INTO `wp_options` VALUES("84487", "_transient_wc_average_rating_24791473679509", "0", "no");
INSERT INTO `wp_options` VALUES("84488", "_transient_timeout_wc_var_pricescb14473a19ef0e1b80d6fc1473679509", "1477028825", "no");
INSERT INTO `wp_options` VALUES("84489", "_transient_wc_var_pricescb14473a19ef0e1b80d6fc1473679509", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("84490", "_transient_timeout_wc_related_4_24791473679509", "1477028825", "no");
INSERT INTO `wp_options` VALUES("84491", "_transient_wc_related_4_24791473679509", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("84650", "yst_ga", "a:1:{s:10:\"ga_general\";a:6:{s:14:\"manual_ua_code\";i:1;s:20:\"manual_ua_code_field\";s:0:\"\";s:16:\"enable_universal\";i:0;s:14:\"track_outbound\";i:0;s:12:\"ignore_users\";a:1:{i:0;s:0:\"\";}s:13:\"anonymize_ips\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("84684", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("84686", "wpseo_sitemap_cache_validator_global", "2jHiB", "no");
INSERT INTO `wp_options` VALUES("84687", "wpseo_sitemap_1_cache_validator", "2MBGM", "no");
INSERT INTO `wp_options` VALUES("84688", "wpseo_sitemap_product_cache_validator", "3e2Tl", "no");
INSERT INTO `wp_options` VALUES("84740", "wpseo_sitemap_product_cat_cache_validator", "3e2RQ", "no");
INSERT INTO `wp_options` VALUES("84751", "wpseo_sitemap_page_cache_validator", "3hxmS", "no");
INSERT INTO `wp_options` VALUES("84752", "wpseo_sitemap_revision_cache_validator", "3hxnY", "no");
INSERT INTO `wp_options` VALUES("84816", "wpseo_sitemap_product_type_cache_validator", "48EmR", "no");
INSERT INTO `wp_options` VALUES("84817", "wpseo_sitemap_pa_sizes_cache_validator", "3OylA", "no");
INSERT INTO `wp_options` VALUES("84818", "wpseo_sitemap_pa_color_cache_validator", "3Oymg", "no");
INSERT INTO `wp_options` VALUES("85121", "wpseo_sitemap_author_cache_validator", "2L641", "no");
INSERT INTO `wp_options` VALUES("85124", "wpseo_sitemap_category_cache_validator", "2q1Ak", "no");
INSERT INTO `wp_options` VALUES("85129", "wpseo_sitemap_post_cache_validator", "2MBJf", "no");
INSERT INTO `wp_options` VALUES("85132", "wpseo_sitemap_post_tag_cache_validator", "2QgoR", "no");
INSERT INTO `wp_options` VALUES("85605", "wpseo_sitemap_pa_product_type_cache_validator", "3tJ61", "no");
INSERT INTO `wp_options` VALUES("86750", "_transient_timeout_external_ip_address_245.23.48.27", "1475057418", "no");
INSERT INTO `wp_options` VALUES("86751", "_transient_external_ip_address_245.23.48.27", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("86850", "_transient_timeout_external_ip_address_192.168.88.81", "1475076606", "no");
INSERT INTO `wp_options` VALUES("86851", "_transient_external_ip_address_192.168.88.81", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("86859", "_transient_timeout_external_ip_address_192.168.22.210", "1475079857", "no");
INSERT INTO `wp_options` VALUES("86860", "_transient_external_ip_address_192.168.22.210", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("87413", "wpseo_sitemap_pa_protection-level_cache_validator", "3vPyC", "no");
INSERT INTO `wp_options` VALUES("88464", "wpseo_sitemap_nav_menu_cache_validator", "8AvL", "no");
INSERT INTO `wp_options` VALUES("88465", "wpseo_sitemap_nav_menu_item_cache_validator", "2fOSh", "no");
INSERT INTO `wp_options` VALUES("88598", "_transient_timeout_external_ip_address_10.80.249.40", "1475259597", "no");
INSERT INTO `wp_options` VALUES("88599", "_transient_external_ip_address_10.80.249.40", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("88729", "wpseo_sitemap_attachment_cache_validator", "3hiyH", "no");
INSERT INTO `wp_options` VALUES("88732", "wpseo_sitemap_2646_cache_validator", "aQiK", "no");
INSERT INTO `wp_options` VALUES("89042", "_transient_timeout_external_ip_address_10.100.6.86", "1475478640", "no");
INSERT INTO `wp_options` VALUES("89043", "_transient_external_ip_address_10.100.6.86", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("89135", "_transient_timeout_external_ip_address_234.187.142.52", "1475525164", "no");
INSERT INTO `wp_options` VALUES("89136", "_transient_external_ip_address_234.187.142.52", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("89137", "_transient_timeout_external_ip_address_242.239.127.250", "1475525179", "no");
INSERT INTO `wp_options` VALUES("89138", "_transient_external_ip_address_242.239.127.250", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("89662", "_transient_timeout_external_ip_address_10.2.8.58", "1475757868", "no");
INSERT INTO `wp_options` VALUES("89663", "_transient_external_ip_address_10.2.8.58", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("89695", "_transient_timeout_external_ip_address_241.2.188.124", "1475778943", "no");
INSERT INTO `wp_options` VALUES("89696", "_transient_external_ip_address_241.2.188.124", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("89697", "_transient_timeout_external_ip_address_232.188.114.222", "1475779016", "no");
INSERT INTO `wp_options` VALUES("89698", "_transient_external_ip_address_232.188.114.222", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("89699", "_transient_timeout_external_ip_address_224.43.227.117", "1475779125", "no");
INSERT INTO `wp_options` VALUES("89700", "_transient_external_ip_address_224.43.227.117", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("89701", "_transient_timeout_external_ip_address_246.7.111.13", "1475779134", "no");
INSERT INTO `wp_options` VALUES("89702", "_transient_external_ip_address_246.7.111.13", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("89757", "_transient_timeout_external_ip_address_237.229.127.173", "1475805812", "no");
INSERT INTO `wp_options` VALUES("89758", "_transient_external_ip_address_237.229.127.173", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("89773", "_transient_timeout_wc_tax_rates_ef002e3c8a4cbec187fc6c3475e73c0a", "1475817399", "no");
INSERT INTO `wp_options` VALUES("89774", "_transient_wc_tax_rates_ef002e3c8a4cbec187fc6c3475e73c0a", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("89825", "_transient_timeout_external_ip_address_10.126.132.218", "1475825378", "no");
INSERT INTO `wp_options` VALUES("89826", "_transient_external_ip_address_10.126.132.218", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("90355", "_transient_timeout_external_ip_address_172.20.1.75", "1476123289", "no");
INSERT INTO `wp_options` VALUES("90356", "_transient_external_ip_address_172.20.1.75", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("90471", "_transient_timeout_external_ip_address_192.168.88.162", "1476190751", "no");
INSERT INTO `wp_options` VALUES("90472", "_transient_external_ip_address_192.168.88.162", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("90512", "_transient_timeout_external_ip_address_10.3.205.168", "1476217820", "no");
INSERT INTO `wp_options` VALUES("90513", "_transient_external_ip_address_10.3.205.168", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("91338", "_transient_timeout_external_ip_address_192.168.122.131", "1476735766", "no");
INSERT INTO `wp_options` VALUES("91339", "_transient_external_ip_address_192.168.122.131", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("91396", "_transient_timeout_external_ip_address_10.222.34.136", "1476778306", "no");
INSERT INTO `wp_options` VALUES("91397", "_transient_external_ip_address_10.222.34.136", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("91873", "_transient_timeout_external_ip_address_10.100.6.109", "1477029601", "no");
INSERT INTO `wp_options` VALUES("91874", "_transient_external_ip_address_10.100.6.109", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("91910", "wpseo_sitemap_2653_cache_validator", "2MkAF", "no");
INSERT INTO `wp_options` VALUES("92001", "_transient_timeout_external_ip_address_", "1477072681", "no");
INSERT INTO `wp_options` VALUES("92002", "_transient_external_ip_address_", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("92530", "_transient_timeout_wc_rating_count_23701476526433", "1479118454", "no");
INSERT INTO `wp_options` VALUES("92531", "_transient_wc_var_pricescd84a642def863bb7849cd1476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92532", "_transient_wc_rating_count_23701476526433", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("92533", "_transient_timeout_wc_average_rating_23701476526433", "1479118457", "no");
INSERT INTO `wp_options` VALUES("92535", "_transient_wc_average_rating_23701476526433", "0", "no");
INSERT INTO `wp_options` VALUES("92537", "_transient_timeout_wc_var_prices4addb3add475b0e4a701701476526433", "1479118454", "no");
INSERT INTO `wp_options` VALUES("92538", "_transient_wc_var_prices4addb3add475b0e4a701701476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92540", "_transient_timeout_wc_var_prices4aaf2444b326783ae2f5c11476526433", "1479118454", "no");
INSERT INTO `wp_options` VALUES("92541", "_transient_wc_var_prices4aaf2444b326783ae2f5c11476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92543", "_transient_timeout_wc_rating_count_23651476526433", "1479118455", "no");
INSERT INTO `wp_options` VALUES("92545", "_transient_wc_rating_count_23651476526433", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("92546", "_transient_timeout_wc_average_rating_23651476526433", "1479118457", "no");
INSERT INTO `wp_options` VALUES("92548", "_transient_wc_average_rating_23651476526433", "0", "no");
INSERT INTO `wp_options` VALUES("92550", "_transient_timeout_wc_var_pricese7cf3f30d03abd154b13c71476526433", "1479118455", "no");
INSERT INTO `wp_options` VALUES("92551", "_transient_wc_var_pricese7cf3f30d03abd154b13c71476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92553", "_transient_timeout_wc_var_prices83492a152fc3c016001b581476526433", "1479118455", "no");
INSERT INTO `wp_options` VALUES("92554", "_transient_wc_var_prices83492a152fc3c016001b581476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92556", "_transient_timeout_wc_rating_count_23601476526433", "1479118455", "no");
INSERT INTO `wp_options` VALUES("92558", "_transient_wc_rating_count_23601476526433", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("92559", "_transient_timeout_wc_average_rating_23601476526433", "1479118457", "no");
INSERT INTO `wp_options` VALUES("92561", "_transient_wc_average_rating_23601476526433", "0", "no");
INSERT INTO `wp_options` VALUES("92563", "_transient_timeout_wc_var_pricesf28f3d0af5e88483ac3ba21476526433", "1479118455", "no");
INSERT INTO `wp_options` VALUES("92564", "_transient_wc_var_pricesf28f3d0af5e88483ac3ba21476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92567", "_transient_timeout_wc_var_pricesa3e5f3f20973f1e0c7d1371476526433", "1479118456", "no");
INSERT INTO `wp_options` VALUES("92569", "_transient_wc_var_pricesa3e5f3f20973f1e0c7d1371476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92571", "_transient_timeout_wc_rating_count_23481476526433", "1479118456", "no");
INSERT INTO `wp_options` VALUES("92573", "_transient_wc_rating_count_23481476526433", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("92575", "_transient_timeout_wc_average_rating_23481476526433", "1479118456", "no");
INSERT INTO `wp_options` VALUES("92577", "_transient_wc_average_rating_23481476526433", "0", "no");
INSERT INTO `wp_options` VALUES("92579", "_transient_timeout_wc_var_prices238701ffcfc3872b94ed881476526433", "1479118457", "no");
INSERT INTO `wp_options` VALUES("92580", "_transient_wc_var_prices238701ffcfc3872b94ed881476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92582", "_transient_wc_var_pricescb14473a19ef0e1b80d6fc1476526433", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("92589", "_transient_timeout_wc_average_rating_24791476526433", "1479118457", "no");
INSERT INTO `wp_options` VALUES("92591", "_transient_wc_average_rating_24791476526433", "0", "no");
INSERT INTO `wp_options` VALUES("92592", "_transient_wc_rating_count_23861476526433", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("92593", "_transient_timeout_wc_average_rating_23861476526433", "1479118457", "no");
INSERT INTO `wp_options` VALUES("92594", "_transient_wc_average_rating_23861476526433", "0", "no");
INSERT INTO `wp_options` VALUES("94001", "_transient_timeout_wc_tax_rates_71bc7f6652cfd512f085e782db8cc7aa", "1477319253", "no");
INSERT INTO `wp_options` VALUES("94002", "_transient_wc_tax_rates_71bc7f6652cfd512f085e782db8cc7aa", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("94212", "_transient_timeout_wc_tax_rates_ccc5f95f582498b87c0ce2133287f294", "1477428010", "no");
INSERT INTO `wp_options` VALUES("94213", "_transient_wc_tax_rates_ccc5f95f582498b87c0ce2133287f294", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95241", "wpseo_sitemap_2672_cache_validator", "hvWm", "no");
INSERT INTO `wp_options` VALUES("95881", "wpseo_sitemap_2415_cache_validator", "3CCSw", "no");
INSERT INTO `wp_options` VALUES("95882", "wpseo_sitemap_2416_cache_validator", "3CCTK", "no");
INSERT INTO `wp_options` VALUES("95883", "wpseo_sitemap_2420_cache_validator", "3CCZC", "no");
INSERT INTO `wp_options` VALUES("95885", "wpseo_sitemap_2422_cache_validator", "3Df5J", "no");
INSERT INTO `wp_options` VALUES("95887", "_transient_timeout_wc_var_prices548d70f2d8bcdf624496641477046755", "1479722867", "no");
INSERT INTO `wp_options` VALUES("95888", "_transient_wc_var_prices548d70f2d8bcdf624496641477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("95889", "_transient_timeout_wc_rating_count_23801477046755", "1479722867", "no");
INSERT INTO `wp_options` VALUES("95890", "_transient_wc_rating_count_23801477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95891", "_transient_timeout_wc_average_rating_23801477046755", "1479722868", "no");
INSERT INTO `wp_options` VALUES("95892", "_transient_wc_average_rating_23801477046755", "0", "no");
INSERT INTO `wp_options` VALUES("95895", "_transient_timeout_wc_var_prices6aabe0f4ad61508b6817e81477046755", "1479722868", "no");
INSERT INTO `wp_options` VALUES("95896", "_transient_wc_var_prices6aabe0f4ad61508b6817e81477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("95897", "_transient_timeout_wc_rating_count_23751477046755", "1479722868", "no");
INSERT INTO `wp_options` VALUES("95898", "_transient_wc_rating_count_23751477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95899", "_transient_timeout_wc_average_rating_23751477046755", "1479722868", "no");
INSERT INTO `wp_options` VALUES("95900", "_transient_wc_average_rating_23751477046755", "0", "no");
INSERT INTO `wp_options` VALUES("95903", "_transient_timeout_wc_var_prices63729425d5d8ecaa7493471477046755", "1479722868", "no");
INSERT INTO `wp_options` VALUES("95904", "_transient_wc_var_prices63729425d5d8ecaa7493471477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("95905", "_transient_timeout_wc_rating_count_23551477046755", "1479722868", "no");
INSERT INTO `wp_options` VALUES("95906", "_transient_wc_rating_count_23551477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95907", "_transient_timeout_wc_average_rating_23551477046755", "1479722868", "no");
INSERT INTO `wp_options` VALUES("95908", "_transient_wc_average_rating_23551477046755", "0", "no");
INSERT INTO `wp_options` VALUES("95915", "_transient_timeout_wc_uf_pid_2c2a5233a680c3080b1546d5c69e4e74", "1479723085", "no");
INSERT INTO `wp_options` VALUES("95916", "_transient_wc_uf_pid_2c2a5233a680c3080b1546d5c69e4e74", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95920", "wpseo_sitemap_1602_cache_validator", "3FGkh", "no");
INSERT INTO `wp_options` VALUES("95964", "_transient_timeout_external_ip_address_10.50.50.155", "1477751146", "no");
INSERT INTO `wp_options` VALUES("95965", "_transient_external_ip_address_10.50.50.155", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("95966", "_transient_timeout_external_ip_address_10.50.50.204", "1477751147", "no");
INSERT INTO `wp_options` VALUES("95967", "_transient_external_ip_address_10.50.50.204", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96206", "_transient_timeout_wc_tax_rates_1140c5f48029d85d5175d1e55ad2e5be", "1477884387", "no");
INSERT INTO `wp_options` VALUES("96207", "_transient_wc_tax_rates_1140c5f48029d85d5175d1e55ad2e5be", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("96285", "_transient_timeout_external_ip_address_243.181.33.214", "1477926828", "no");
INSERT INTO `wp_options` VALUES("96286", "_transient_external_ip_address_243.181.33.214", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96416", "_transient_timeout_external_ip_address_192.168.4.55", "1477995087", "no");
INSERT INTO `wp_options` VALUES("96417", "_transient_external_ip_address_192.168.4.55", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96521", "_transient_timeout_external_ip_address_172.16.0.85", "1478053374", "no");
INSERT INTO `wp_options` VALUES("96522", "_transient_external_ip_address_172.16.0.85", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96545", "_transient_timeout_external_ip_address_192.168.0.100", "1478068625", "no");
INSERT INTO `wp_options` VALUES("96546", "_transient_external_ip_address_192.168.0.100", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96656", "_transient_timeout_external_ip_address_229.180.134.99", "1478127223", "no");
INSERT INTO `wp_options` VALUES("96657", "_transient_external_ip_address_229.180.134.99", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96658", "_transient_timeout_external_ip_address_10.246.161.41", "1478127287", "no");
INSERT INTO `wp_options` VALUES("96659", "_transient_external_ip_address_10.246.161.41", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96660", "_transient_timeout_external_ip_address_250.35.217.164", "1478127367", "no");
INSERT INTO `wp_options` VALUES("96661", "_transient_external_ip_address_250.35.217.164", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("96662", "_transient_timeout_external_ip_address_228.239.79.194", "1478127685", "no");
INSERT INTO `wp_options` VALUES("96663", "_transient_external_ip_address_228.239.79.194", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96664", "_transient_timeout_external_ip_address_253.209.73.82", "1478127727", "no");
INSERT INTO `wp_options` VALUES("96665", "_transient_external_ip_address_253.209.73.82", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96666", "_transient_timeout_external_ip_address_237.186.78.84", "1478127750", "no");
INSERT INTO `wp_options` VALUES("96667", "_transient_external_ip_address_237.186.78.84", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96668", "_transient_timeout_external_ip_address_255.163.193.176", "1478127773", "no");
INSERT INTO `wp_options` VALUES("96669", "_transient_external_ip_address_255.163.193.176", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96670", "_transient_timeout_external_ip_address_231.248.44.71", "1478127826", "no");
INSERT INTO `wp_options` VALUES("96671", "_transient_external_ip_address_231.248.44.71", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96672", "_transient_timeout_external_ip_address_238.10.13.222", "1478127947", "no");
INSERT INTO `wp_options` VALUES("96673", "_transient_external_ip_address_238.10.13.222", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("96674", "_transient_timeout_external_ip_address_245.27.228.254", "1478128021", "no");
INSERT INTO `wp_options` VALUES("96675", "_transient_external_ip_address_245.27.228.254", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("96715", "_transient_timeout_wc_tax_rates_7b10466df5f1d515b1f5a0ecc68f4af1", "1478149042", "no");
INSERT INTO `wp_options` VALUES("96716", "_transient_wc_tax_rates_7b10466df5f1d515b1f5a0ecc68f4af1", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("96818", "_transient_timeout_external_ip_address_10.0.100.217", "1478208037", "no");
INSERT INTO `wp_options` VALUES("96819", "_transient_external_ip_address_10.0.100.217", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("97087", "_transient_timeout_external_ip_address_10.5.218.103", "1478375124", "no");
INSERT INTO `wp_options` VALUES("97088", "_transient_external_ip_address_10.5.218.103", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("97240", "_transient_timeout_external_ip_address_10.1.189.169", "1478478485", "no");
INSERT INTO `wp_options` VALUES("97241", "_transient_external_ip_address_10.1.189.169", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("97265", "_transient_timeout_external_ip_address_234.168.25.168", "1478495195", "no");
INSERT INTO `wp_options` VALUES("97266", "_transient_external_ip_address_234.168.25.168", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("97446", "_transient_timeout_external_ip_address_226.10.248.249", "1478605032", "no");
INSERT INTO `wp_options` VALUES("97447", "_transient_external_ip_address_226.10.248.249", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("97686", "_transient_timeout_wc_tax_rates_5bcf89ca2635f93fac98cb1126bbbc72", "1478730114", "no");
INSERT INTO `wp_options` VALUES("97687", "_transient_wc_tax_rates_5bcf89ca2635f93fac98cb1126bbbc72", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("97736", "_transient_timeout_external_ip_address_172.16.16.20", "1478762246", "no");
INSERT INTO `wp_options` VALUES("97737", "_transient_external_ip_address_172.16.16.20", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("97809", "_transient_timeout_external_ip_address_10.31.49.171", "1478807655", "no");
INSERT INTO `wp_options` VALUES("97810", "_transient_external_ip_address_10.31.49.171", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("98100", "_transient_timeout_external_ip_address_10.192.103.154", "1478995271", "no");
INSERT INTO `wp_options` VALUES("98101", "_transient_external_ip_address_10.192.103.154", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("98103", "_transient_timeout_external_ip_address_10.192.148.35", "1478995458", "no");
INSERT INTO `wp_options` VALUES("98104", "_transient_external_ip_address_10.192.148.35", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("98648", "_transient_timeout_external_ip_address_254.83.237.71", "1479343201", "no");
INSERT INTO `wp_options` VALUES("98649", "_transient_external_ip_address_254.83.237.71", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("98650", "_transient_timeout_external_ip_address_249.209.148.19", "1479343211", "no");
INSERT INTO `wp_options` VALUES("98651", "_transient_external_ip_address_249.209.148.19", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("98991", "category_children", "a:1:{i:1;a:1:{i:0;i:171;}}", "yes");
INSERT INTO `wp_options` VALUES("98994", "wpseo_sitemap_2680_cache_validator", "2Umpe", "no");
INSERT INTO `wp_options` VALUES("99315", "_transient_timeout_external_ip_address_10.28.0.148", "1479738695", "no");
INSERT INTO `wp_options` VALUES("99316", "_transient_external_ip_address_10.28.0.148", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("99443", "_transient_timeout_external_ip_address_10.192.151.24", "1479819493", "no");
INSERT INTO `wp_options` VALUES("99444", "_transient_external_ip_address_10.192.151.24", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("99806", "_transient_timeout_external_ip_address_234.34.144.1", "1480038702", "no");
INSERT INTO `wp_options` VALUES("99807", "_transient_external_ip_address_234.34.144.1", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("100187", "_transient_timeout_wc_tax_rates_ebefb0f2337facf7b03bdc2f7c4689ed", "1480231398", "no");
INSERT INTO `wp_options` VALUES("100188", "_transient_wc_tax_rates_ebefb0f2337facf7b03bdc2f7c4689ed", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("100351", "wpseo_sitemap_2661_cache_validator", "48Em4", "no");
INSERT INTO `wp_options` VALUES("100580", "_transient_timeout_external_ip_address_192.168.200.238", "1480296612", "no");
INSERT INTO `wp_options` VALUES("100581", "_transient_external_ip_address_192.168.200.238", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("100603", "_transient_timeout_wc_tax_rates_8e384c1422751777cde9722b64d9e13a", "1480306646", "no");
INSERT INTO `wp_options` VALUES("100604", "_transient_wc_tax_rates_8e384c1422751777cde9722b64d9e13a", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("100636", "wpseo_sitemap_2684_cache_validator", "2mAOw", "no");
INSERT INTO `wp_options` VALUES("100986", "_transient_timeout_external_ip_address_10.100.6.123", "1480400872", "no");
INSERT INTO `wp_options` VALUES("100987", "_transient_external_ip_address_10.100.6.123", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("101018", "_transient_timeout_external_ip_address_10.100.6.77", "1480402678", "no");
INSERT INTO `wp_options` VALUES("101019", "_transient_external_ip_address_10.100.6.77", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("101030", "_transient_timeout_external_ip_address_10.100.6.104", "1480406284", "no");
INSERT INTO `wp_options` VALUES("101031", "_transient_external_ip_address_10.100.6.104", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("101490", "_transient_timeout_external_ip_address_127.0.0.1", "1480656074", "no");
INSERT INTO `wp_options` VALUES("101491", "_transient_external_ip_address_127.0.0.1", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("101774", "wpseo_sitemap_2540_cache_validator", "2fOTC", "no");
INSERT INTO `wp_options` VALUES("102060", "_transient_timeout_external_ip_address_253.58.13.25", "1480904924", "no");
INSERT INTO `wp_options` VALUES("102061", "_transient_external_ip_address_253.58.13.25", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("102320", "_transient_timeout_external_ip_address_10.3.5.126", "1481023555", "no");
INSERT INTO `wp_options` VALUES("102321", "_transient_external_ip_address_10.3.5.126", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102373", "_transient_timeout_external_ip_address_10.130.43.14", "1481057801", "no");
INSERT INTO `wp_options` VALUES("102374", "_transient_external_ip_address_10.130.43.14", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102472", "_transient_timeout_external_ip_address_10.3.5.121", "1481111963", "no");
INSERT INTO `wp_options` VALUES("102473", "_transient_external_ip_address_10.3.5.121", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102677", "_transient_timeout_external_ip_address_10.70.28.99", "1481234366", "no");
INSERT INTO `wp_options` VALUES("102678", "_transient_external_ip_address_10.70.28.99", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102788", "_transient_timeout_external_ip_address_235.133.207.56", "1481299641", "no");
INSERT INTO `wp_options` VALUES("102789", "_transient_external_ip_address_235.133.207.56", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("102790", "_transient_timeout_external_ip_address_228.46.187.91", "1481299728", "no");
INSERT INTO `wp_options` VALUES("102791", "_transient_external_ip_address_228.46.187.91", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102792", "_transient_timeout_external_ip_address_243.48.246.230", "1481299755", "no");
INSERT INTO `wp_options` VALUES("102793", "_transient_external_ip_address_243.48.246.230", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102794", "_transient_timeout_external_ip_address_252.18.145.196", "1481299785", "no");
INSERT INTO `wp_options` VALUES("102795", "_transient_external_ip_address_252.18.145.196", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102796", "_transient_timeout_external_ip_address_226.67.218.108", "1481299843", "no");
INSERT INTO `wp_options` VALUES("102797", "_transient_external_ip_address_226.67.218.108", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("102798", "_transient_timeout_external_ip_address_232.154.40.44", "1481299959", "no");
INSERT INTO `wp_options` VALUES("102799", "_transient_external_ip_address_232.154.40.44", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102800", "_transient_timeout_external_ip_address_127.64.15.40", "1481300105", "no");
INSERT INTO `wp_options` VALUES("102801", "_transient_external_ip_address_127.64.15.40", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102802", "_transient_timeout_external_ip_address_241.140.204.68", "1481300270", "no");
INSERT INTO `wp_options` VALUES("102803", "_transient_external_ip_address_241.140.204.68", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("102804", "_transient_timeout_external_ip_address_247.235.83.179", "1481300349", "no");
INSERT INTO `wp_options` VALUES("102805", "_transient_external_ip_address_247.235.83.179", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("103079", "_transient_timeout_external_ip_address_192.168.12.50", "1481451071", "no");
INSERT INTO `wp_options` VALUES("103080", "_transient_external_ip_address_192.168.12.50", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("103159", "_transient_timeout_wc_tax_rates_799ea846eb5643adc8cd044985e87f4b", "1481499820", "no");
INSERT INTO `wp_options` VALUES("103160", "_transient_wc_tax_rates_799ea846eb5643adc8cd044985e87f4b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("103502", "_transient_timeout_wc_tax_rates_b02dae3850f058c758f0902b663a821f", "1481772105", "no");
INSERT INTO `wp_options` VALUES("103503", "_transient_wc_tax_rates_b02dae3850f058c758f0902b663a821f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("103549", "_transient_timeout_external_ip_address_10.11.252.53", "1481800717", "no");
INSERT INTO `wp_options` VALUES("103550", "_transient_external_ip_address_10.11.252.53", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("103665", "_transient_timeout_external_ip_address_172.16.1.20", "1481859019", "no");
INSERT INTO `wp_options` VALUES("103666", "_transient_external_ip_address_172.16.1.20", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("104415", "_transient_timeout_wc_tax_rates_15dc7d511f98cd9f77d5fb54a710d870", "1482319932", "no");
INSERT INTO `wp_options` VALUES("104416", "_transient_wc_tax_rates_15dc7d511f98cd9f77d5fb54a710d870", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("104501", "_transient_timeout_wc_tax_rates_7764a7ac3151cb7b2086a2e5e8093c18", "1482369493", "no");
INSERT INTO `wp_options` VALUES("104502", "_transient_wc_tax_rates_7764a7ac3151cb7b2086a2e5e8093c18", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("104707", "_transient_timeout_wc_tax_rates_6bc22e05da2f76285a28d789672bd333", "1482493679", "no");
INSERT INTO `wp_options` VALUES("104708", "_transient_wc_tax_rates_6bc22e05da2f76285a28d789672bd333", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("104857", "_transient_timeout_external_ip_address_10.18.143.247", "1482587863", "no");
INSERT INTO `wp_options` VALUES("104858", "_transient_external_ip_address_10.18.143.247", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("104993", "_transient_timeout_wc_tax_rates_dd8b935333bd71886d37df2d22818425", "1482673146", "no");
INSERT INTO `wp_options` VALUES("104994", "_transient_wc_tax_rates_dd8b935333bd71886d37df2d22818425", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("105016", "_transient_timeout_wc_tax_rates_6dc534c4fa0f76a34db314b912d26da7", "1482687552", "no");
INSERT INTO `wp_options` VALUES("105017", "_transient_wc_tax_rates_6dc534c4fa0f76a34db314b912d26da7", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("105102", "wpseo_sitemap_2704_cache_validator", "9zT9", "no");
INSERT INTO `wp_options` VALUES("105172", "_transient_timeout_wc_tax_rates_67f5ad743351cb30ea9da535b3b434b6", "1482762420", "no");
INSERT INTO `wp_options` VALUES("105173", "_transient_wc_tax_rates_67f5ad743351cb30ea9da535b3b434b6", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("105186", "_transient_timeout_wc_tax_rates_1383f0e52a5a0f484afa179dc70591a0", "1482769448", "no");
INSERT INTO `wp_options` VALUES("105187", "_transient_wc_tax_rates_1383f0e52a5a0f484afa179dc70591a0", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("105297", "_transient_timeout_wc_tax_rates_2ca3ce61aae1785bd5020b6dfdfbd73b", "1482835000", "no");
INSERT INTO `wp_options` VALUES("105298", "_transient_wc_tax_rates_2ca3ce61aae1785bd5020b6dfdfbd73b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("105909", "_transient_timeout_wc_tax_rates_1166ab245d5afa8a8de7da8b478f8d7a", "1482930822", "no");
INSERT INTO `wp_options` VALUES("105910", "_transient_wc_tax_rates_1166ab245d5afa8a8de7da8b478f8d7a", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("106223", "_transient_timeout_wc_tax_rates_17d30e2e51cdbd7da46216055654ab91", "1483094379", "no");
INSERT INTO `wp_options` VALUES("106224", "_transient_wc_tax_rates_17d30e2e51cdbd7da46216055654ab91", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("106232", "_transient_timeout_external_ip_address_250.145.214.204", "1483096175", "no");
INSERT INTO `wp_options` VALUES("106233", "_transient_external_ip_address_250.145.214.204", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("106508", "_transient_timeout_wc_tax_rates_f93c571fb4d6327122a0b4763579f530", "1483262794", "no");
INSERT INTO `wp_options` VALUES("106509", "_transient_wc_tax_rates_f93c571fb4d6327122a0b4763579f530", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("106720", "_transient_timeout_wc_tax_rates_92010e72924c3de05219c2431a3fd58b", "1483383712", "no");
INSERT INTO `wp_options` VALUES("106721", "_transient_wc_tax_rates_92010e72924c3de05219c2431a3fd58b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("106918", "_transient_timeout_wc_tax_rates_8bccacd7c6dbb31b88f368ee0d2d7b83", "1483498777", "no");
INSERT INTO `wp_options` VALUES("106919", "_transient_wc_tax_rates_8bccacd7c6dbb31b88f368ee0d2d7b83", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("106992", "_transient_timeout_wc_tax_rates_559717caf2f41911b4ba7274d00502e3", "1483542685", "no");
INSERT INTO `wp_options` VALUES("106993", "_transient_wc_tax_rates_559717caf2f41911b4ba7274d00502e3", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107100", "_transient_timeout_external_ip_address_192.168.1.80", "1483609131", "no");
INSERT INTO `wp_options` VALUES("107101", "_transient_external_ip_address_192.168.1.80", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("107145", "_transient_timeout_wc_tax_rates_4e68899d92ff253f0c89033384fe56ef", "1483634335", "no");
INSERT INTO `wp_options` VALUES("107146", "_transient_wc_tax_rates_4e68899d92ff253f0c89033384fe56ef", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107152", "_transient_timeout_external_ip_address_192.168.111.247", "1483637949", "no");
INSERT INTO `wp_options` VALUES("107153", "_transient_external_ip_address_192.168.111.247", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("107165", "_transient_timeout_wc_tax_rates_ca52943240882c8ece0e5b84e2afad9e", "1483646532", "no");
INSERT INTO `wp_options` VALUES("107166", "_transient_wc_tax_rates_ca52943240882c8ece0e5b84e2afad9e", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107195", "_transient_timeout_wc_tax_rates_c25cec328f7c4a4bf0de92ad53164831", "1483665576", "no");
INSERT INTO `wp_options` VALUES("107196", "_transient_wc_tax_rates_c25cec328f7c4a4bf0de92ad53164831", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107200", "_transient_timeout_external_ip_address_192.168.10.84", "1483667624", "no");
INSERT INTO `wp_options` VALUES("107201", "_transient_external_ip_address_192.168.10.84", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("107228", "_transient_timeout_wc_tax_rates_d8750ba3d354dc9d81872e2cadc3370c", "1483686690", "no");
INSERT INTO `wp_options` VALUES("107229", "_transient_wc_tax_rates_d8750ba3d354dc9d81872e2cadc3370c", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107252", "_transient_timeout_external_ip_address_172.17.71.9", "1483701154", "no");
INSERT INTO `wp_options` VALUES("107253", "_transient_external_ip_address_172.17.71.9", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("107361", "_transient_timeout_wc_tax_rates_f4aed2875e33eedec2bbf53931ca1850", "1483764112", "no");
INSERT INTO `wp_options` VALUES("107362", "_transient_wc_tax_rates_f4aed2875e33eedec2bbf53931ca1850", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107408", "_transient_timeout_wc_tax_rates_2581d660e69c5450a8ebedca65e7f107", "1483794478", "no");
INSERT INTO `wp_options` VALUES("107409", "_transient_wc_tax_rates_2581d660e69c5450a8ebedca65e7f107", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107440", "_transient_timeout_wc_tax_rates_68f6fea14b86330ce4de91b4a3f342d2", "1483813884", "no");
INSERT INTO `wp_options` VALUES("107441", "_transient_wc_tax_rates_68f6fea14b86330ce4de91b4a3f342d2", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107464", "_transient_timeout_external_ip_address_10.3.13.60", "1483825381", "no");
INSERT INTO `wp_options` VALUES("107465", "_transient_external_ip_address_10.3.13.60", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("107590", "_transient_timeout_wc_tax_rates_cc381c04643a456b236d1160dda1912f", "1483908848", "no");
INSERT INTO `wp_options` VALUES("107591", "_transient_wc_tax_rates_cc381c04643a456b236d1160dda1912f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107754", "_transient_timeout_wc_tax_rates_425450bc920e47d2ce166049a86abe6c", "1484019615", "no");
INSERT INTO `wp_options` VALUES("107755", "_transient_wc_tax_rates_425450bc920e47d2ce166049a86abe6c", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("107888", "_transient_timeout_wc_tax_rates_39fb0b3a6c559dd98f7b36c2dea2c571", "1484056253", "no");
INSERT INTO `wp_options` VALUES("107889", "_transient_wc_tax_rates_39fb0b3a6c559dd98f7b36c2dea2c571", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("108020", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("108138", "_transient_timeout_external_ip_address_192.168.1.124", "1484175860", "no");
INSERT INTO `wp_options` VALUES("108139", "_transient_external_ip_address_192.168.1.124", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("108182", "_transient_timeout_external_ip_address_10.8.176.93", "1484204163", "no");
INSERT INTO `wp_options` VALUES("108183", "_transient_external_ip_address_10.8.176.93", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("108364", "_transient_timeout_wc_tax_rates_c0b2f2d6b5c3aaa436abd6200687aae2", "1484303512", "no");
INSERT INTO `wp_options` VALUES("108365", "_transient_wc_tax_rates_c0b2f2d6b5c3aaa436abd6200687aae2", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("108465", "_transient_timeout_wc_tax_rates_661a67669843f46e738c91adba25ecc0", "1484355483", "no");
INSERT INTO `wp_options` VALUES("108466", "_transient_wc_tax_rates_661a67669843f46e738c91adba25ecc0", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("108911", "_transient_timeout_external_ip_address_10.8.75.9", "1484643960", "no");
INSERT INTO `wp_options` VALUES("108912", "_transient_external_ip_address_10.8.75.9", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("108982", "_transient_timeout_external_ip_address_10.2.218.11", "1484687568", "no");
INSERT INTO `wp_options` VALUES("108983", "_transient_external_ip_address_10.2.218.11", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("108992", "_transient_timeout_external_ip_address_172.16.52.213", "1484695346", "no");
INSERT INTO `wp_options` VALUES("108993", "_transient_external_ip_address_172.16.52.213", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("109031", "_transient_timeout_wc_tax_rates_c15f006f038fbef6475815f0c9a48d77", "1484720762", "no");
INSERT INTO `wp_options` VALUES("109032", "_transient_wc_tax_rates_c15f006f038fbef6475815f0c9a48d77", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109138", "_transient_timeout_wc_tax_rates_15b8fdbc5ca552a8e2bdd0f3bdd978c3", "1484782845", "no");
INSERT INTO `wp_options` VALUES("109139", "_transient_wc_tax_rates_15b8fdbc5ca552a8e2bdd0f3bdd978c3", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109446", "_transient_timeout_wc_tax_rates_bf94295b13a02d57e2bcd34b95b58249", "1484921996", "no");
INSERT INTO `wp_options` VALUES("109447", "_transient_wc_tax_rates_bf94295b13a02d57e2bcd34b95b58249", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109448", "_transient_timeout_external_ip_address_10.2.83.135", "1484922764", "no");
INSERT INTO `wp_options` VALUES("109449", "_transient_external_ip_address_10.2.83.135", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("109562", "_transient_timeout_wc_tax_rates_0f454542d6f3c84433202a17ffd942be", "1484993649", "no");
INSERT INTO `wp_options` VALUES("109563", "_transient_wc_tax_rates_0f454542d6f3c84433202a17ffd942be", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109672", "_transient_timeout_external_ip_address_248.89.116.7", "1485048897", "no");
INSERT INTO `wp_options` VALUES("109673", "_transient_external_ip_address_248.89.116.7", "503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.", "no");
INSERT INTO `wp_options` VALUES("109674", "_transient_timeout_wc_tax_rates_c5dd611a9aa6e16e40a46110cc20233f", "1485048898", "no");
INSERT INTO `wp_options` VALUES("109675", "_transient_wc_tax_rates_c5dd611a9aa6e16e40a46110cc20233f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109715", "_transient_timeout_wc_uf_pid_801fd9c61b4d0bc1ac99da56245f0743", "1487064004", "no");
INSERT INTO `wp_options` VALUES("109716", "_transient_wc_uf_pid_801fd9c61b4d0bc1ac99da56245f0743", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109724", "_transient_timeout_wc_tax_rates_18e7749b1cf3ee70412d2f550eebe94d", "1485081415", "no");
INSERT INTO `wp_options` VALUES("109725", "_transient_wc_tax_rates_18e7749b1cf3ee70412d2f550eebe94d", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109810", "_transient_timeout_wc_tax_rates_eeb35300aad6c046094402976fdb6328", "1485133702", "no");
INSERT INTO `wp_options` VALUES("109811", "_transient_wc_tax_rates_eeb35300aad6c046094402976fdb6328", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109817", "_transient_timeout_wc_tax_rates_1bc47f4052a7f1a49e8ad992d5fd29dc", "1485137933", "no");
INSERT INTO `wp_options` VALUES("109818", "_transient_wc_tax_rates_1bc47f4052a7f1a49e8ad992d5fd29dc", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109875", "rewrite_rules", "a:238:{s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:47:\"(([^/]+/)*wishlist)(/(.*))?/page/([0-9]{1,})/?$\";s:76:\"index.php?pagename=$matches[1]&wishlist-action=$matches[4]&paged=$matches[5]\";s:30:\"(([^/]+/)*wishlist)(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&wishlist-action=$matches[4]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"products/?$\";s:27:\"index.php?post_type=product\";s:41:\"products/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:36:\"products/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:28:\"products/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:14:\"testimonial/?$\";s:31:\"index.php?post_type=testimonial\";s:44:\"testimonial/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=testimonial&feed=$matches[1]\";s:39:\"testimonial/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=testimonial&feed=$matches[1]\";s:31:\"testimonial/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=testimonial&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"product_variation/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"product_variation/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"product_variation/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"product_variation/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"product_variation/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"product_variation/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"product_variation/([^/]+)/embed/?$\";s:50:\"index.php?product_variation=$matches[1]&embed=true\";s:38:\"product_variation/([^/]+)/trackback/?$\";s:44:\"index.php?product_variation=$matches[1]&tb=1\";s:46:\"product_variation/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?product_variation=$matches[1]&paged=$matches[2]\";s:53:\"product_variation/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?product_variation=$matches[1]&cpage=$matches[2]\";s:43:\"product_variation/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?product_variation=$matches[1]&wc-api=$matches[3]\";s:49:\"product_variation/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:60:\"product_variation/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"product_variation/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?product_variation=$matches[1]&page=$matches[2]\";s:34:\"product_variation/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"product_variation/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"product_variation/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"product_variation/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"product_variation/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"product_variation/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"shop_order_refund/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"shop_order_refund/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"shop_order_refund/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"shop_order_refund/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"shop_order_refund/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"shop_order_refund/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"shop_order_refund/([^/]+)/embed/?$\";s:50:\"index.php?shop_order_refund=$matches[1]&embed=true\";s:38:\"shop_order_refund/([^/]+)/trackback/?$\";s:44:\"index.php?shop_order_refund=$matches[1]&tb=1\";s:46:\"shop_order_refund/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?shop_order_refund=$matches[1]&paged=$matches[2]\";s:53:\"shop_order_refund/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?shop_order_refund=$matches[1]&cpage=$matches[2]\";s:43:\"shop_order_refund/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?shop_order_refund=$matches[1]&wc-api=$matches[3]\";s:49:\"shop_order_refund/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:60:\"shop_order_refund/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"shop_order_refund/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?shop_order_refund=$matches[1]&page=$matches[2]\";s:34:\"shop_order_refund/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"shop_order_refund/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"shop_order_refund/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"shop_order_refund/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"shop_order_refund/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"shop_order_refund/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:38:\"vc_grid_item/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&wc-api=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:52:\"testimonial/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?testimonial=$matches[1]&feed=$matches[2]\";s:47:\"testimonial/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?testimonial=$matches[1]&feed=$matches[2]\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:37:\"testimonial/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?testimonial=$matches[1]&wc-api=$matches[3]\";s:43:\"testimonial/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"testimonial/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=897&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:20:\"order-pay(/(.*))?/?$\";s:32:\"index.php?&order-pay=$matches[2]\";s:25:\"order-received(/(.*))?/?$\";s:37:\"index.php?&order-received=$matches[2]\";s:21:\"view-order(/(.*))?/?$\";s:33:\"index.php?&view-order=$matches[2]\";s:23:\"edit-account(/(.*))?/?$\";s:35:\"index.php?&edit-account=$matches[2]\";s:23:\"edit-address(/(.*))?/?$\";s:35:\"index.php?&edit-address=$matches[2]\";s:24:\"lost-password(/(.*))?/?$\";s:36:\"index.php?&lost-password=$matches[2]\";s:26:\"customer-logout(/(.*))?/?$\";s:38:\"index.php?&customer-logout=$matches[2]\";s:29:\"add-payment-method(/(.*))?/?$\";s:41:\"index.php?&add-payment-method=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("109877", "_site_transient_timeout_available_translations", "1484561445", "yes");
INSERT INTO `wp_options` VALUES("109878", "_site_transient_available_translations", "a:73:{s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 10:15:45\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/4.4/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-30 08:58:25\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 20:53:51\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 08:50:29\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2015-09-16 05:09:40\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.7/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2015-08-18 21:20:44\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.7/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 16:27:03\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.3.6\";s:7:\"updated\";s:19:\"2016-02-16 15:35:45\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.6/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 16:20:56\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 22:48:20\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2016-01-04 21:25:27\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/4.4/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 14:19:21\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2016-01-03 15:02:45\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2016-01-05 22:02:12\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-15 11:52:35\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 04:39:48\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-06 23:10:59\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 13:34:17\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 10:23:11\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 12:35:15\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 13:19:37\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2015-08-19 14:33:57\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.7/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-04 06:10:33\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.3-RC/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-29 19:19:47\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-23 00:46:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 17:35:10\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2016-11-14 13:43:46\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.7/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 05:14:35\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 21:19:15\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2015-08-20 13:36:08\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.7/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-23 06:49:15\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 02:16:19\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 13:47:35\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-22 14:45:38\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2015-09-24 15:25:30\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.7/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 11:44:09\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.1.14\";s:7:\"updated\";s:19:\"2015-03-26 15:20:27\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.1.14/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 18:10:01\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 05:11:43\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 22:05:31\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 18:07:25\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2015-08-17 13:36:47\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.7/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-21 16:17:50\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 00:20:24\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-21 08:04:30\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-25 07:46:19\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 07:35:25\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 20:07:24\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-15 05:49:00\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.14\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.14/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 10:01:09\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2016-01-01 12:07:02\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-14 12:19:44\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2016-09-23 13:46:27\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.7/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-19 13:20:56\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.14\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.14/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-10 18:05:56\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-30 22:40:18\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 18:41:28\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2016-01-02 00:04:31\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-30 10:37:54\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2016-07-29 21:17:46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.7/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-07 09:13:24\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-09 09:09:51\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 23:28:56\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-08 03:22:55\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2016-08-30 11:44:05\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.7/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-17 23:12:27\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.1.14\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.14/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2016-01-03 22:04:41\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.4/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.3.7\";s:7:\"updated\";s:19:\"2015-11-27 09:19:03\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.7/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-12 22:55:08\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"4.4\";s:7:\"updated\";s:19:\"2015-12-11 18:51:41\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "yes");
INSERT INTO `wp_options` VALUES("109903", "_transient_timeout_wc_tax_rates_0b8ca54e0344cc3078676f6c35f58a9b", "1485167560", "no");
INSERT INTO `wp_options` VALUES("109904", "_transient_wc_tax_rates_0b8ca54e0344cc3078676f6c35f58a9b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109913", "_transient_timeout_wc_tax_rates_a35da64140cf616dd795d91ad1d765b9", "1485172189", "no");
INSERT INTO `wp_options` VALUES("109914", "_transient_wc_tax_rates_a35da64140cf616dd795d91ad1d765b9", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("109928", "_transient_timeout_external_ip_address_10.8.60.139", "1485175899", "no");
INSERT INTO `wp_options` VALUES("109929", "_transient_external_ip_address_10.8.60.139", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("110178", "_transient_timeout_external_ip_address_192.168.5.18", "1485344608", "no");
INSERT INTO `wp_options` VALUES("110179", "_transient_external_ip_address_192.168.5.18", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("110180", "_transient_timeout_external_ip_address_192.168.5.10", "1485345005", "no");
INSERT INTO `wp_options` VALUES("110181", "_transient_external_ip_address_192.168.5.10", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("110183", "_transient_timeout_external_ip_address_192.168.5.14", "1485346122", "no");
INSERT INTO `wp_options` VALUES("110184", "_transient_external_ip_address_192.168.5.14", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("110202", "_transient_timeout_wc_tax_rates_4e5e8cb4458159719c4aa84d97dd68ff", "1485354847", "no");
INSERT INTO `wp_options` VALUES("110203", "_transient_wc_tax_rates_4e5e8cb4458159719c4aa84d97dd68ff", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110247", "_transient_timeout_wc_tax_rates_6a4a8ca9148ab858a64592e9114ea7eb", "1485380275", "no");
INSERT INTO `wp_options` VALUES("110248", "_transient_wc_tax_rates_6a4a8ca9148ab858a64592e9114ea7eb", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110278", "_transient_timeout_external_ip_address_192.168.5.16", "1485407791", "no");
INSERT INTO `wp_options` VALUES("110279", "_transient_external_ip_address_192.168.5.16", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("110307", "_transient_timeout_wc_tax_rates_c477a88ac83e16fd9d9fb75f7fae63c6", "1485422716", "no");
INSERT INTO `wp_options` VALUES("110308", "_transient_wc_tax_rates_c477a88ac83e16fd9d9fb75f7fae63c6", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110503", "_transient_timeout_wc_tax_rates_c12d05af88b6f74a86a8df4bf87f6b89", "1485444169", "no");
INSERT INTO `wp_options` VALUES("110504", "_transient_wc_tax_rates_c12d05af88b6f74a86a8df4bf87f6b89", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110587", "_transient_timeout_wc_tax_rates_7fd443f6a1dc4caa2ee5b64522a27a59", "1485460388", "no");
INSERT INTO `wp_options` VALUES("110588", "_transient_wc_tax_rates_7fd443f6a1dc4caa2ee5b64522a27a59", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110632", "_transient_timeout_wc_tax_rates_f4a1129ba067729292fc6c9ecb762a43", "1485482939", "no");
INSERT INTO `wp_options` VALUES("110633", "_transient_wc_tax_rates_f4a1129ba067729292fc6c9ecb762a43", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110664", "_transient_timeout_external_ip_address_192.168.5.17", "1485493032", "no");
INSERT INTO `wp_options` VALUES("110665", "_transient_external_ip_address_192.168.5.17", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("110730", "_transient_timeout_wc_tax_rates_c29cbc40d19f32fe9309a9a06c8a46bc", "1485505915", "no");
INSERT INTO `wp_options` VALUES("110731", "_transient_wc_tax_rates_c29cbc40d19f32fe9309a9a06c8a46bc", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110732", "_transient_timeout_wc_uf_pid_164276a203e33aa5cf48375474efbfb8", "1487493311", "no");
INSERT INTO `wp_options` VALUES("110733", "_transient_wc_uf_pid_164276a203e33aa5cf48375474efbfb8", "a:3:{i:0;i:101;i:1;i:94;i:2;i:98;}", "no");
INSERT INTO `wp_options` VALUES("110756", "_transient_timeout_wc_uf_pid_d007d1390607c3179a70b64b274ce378", "1487493978", "no");
INSERT INTO `wp_options` VALUES("110757", "_transient_wc_uf_pid_d007d1390607c3179a70b64b274ce378", "a:3:{i:0;i:2386;i:1;i:202;i:2;i:200;}", "no");
INSERT INTO `wp_options` VALUES("110760", "_transient_timeout_wc_uf_pid_a09b78d618461715b105ddaa69e3727d", "1487494312", "no");
INSERT INTO `wp_options` VALUES("110761", "_transient_wc_uf_pid_a09b78d618461715b105ddaa69e3727d", "a:3:{i:0;i:191;i:1;i:190;i:2;i:189;}", "no");
INSERT INTO `wp_options` VALUES("110763", "_transient_timeout_wc_review_count_1861477046755", "1487495627", "no");
INSERT INTO `wp_options` VALUES("110764", "_transient_wc_review_count_1861477046755", "0", "no");
INSERT INTO `wp_options` VALUES("110765", "_transient_timeout_wc_related_4_1861477046755", "1487495627", "no");
INSERT INTO `wp_options` VALUES("110766", "_transient_wc_related_4_1861477046755", "a:4:{i:0;s:2:\"63\";i:1;s:3:\"185\";i:2;s:3:\"187\";i:3;s:3:\"188\";}", "no");
INSERT INTO `wp_options` VALUES("110775", "_transient_timeout_wc_review_count_1901477046755", "1487495746", "no");
INSERT INTO `wp_options` VALUES("110776", "_transient_wc_review_count_1901477046755", "0", "no");
INSERT INTO `wp_options` VALUES("110777", "_transient_timeout_wc_related_4_1901477046755", "1487495746", "no");
INSERT INTO `wp_options` VALUES("110778", "_transient_wc_related_4_1901477046755", "a:4:{i:0;s:2:\"63\";i:1;s:3:\"185\";i:2;s:3:\"186\";i:3;s:3:\"187\";}", "no");
INSERT INTO `wp_options` VALUES("110813", "_transient_timeout_wc_review_count_20091477046755", "1487496199", "no");
INSERT INTO `wp_options` VALUES("110814", "_transient_wc_review_count_20091477046755", "0", "no");
INSERT INTO `wp_options` VALUES("110815", "_transient_timeout_wc_related_4_20091477046755", "1487496200", "no");
INSERT INTO `wp_options` VALUES("110816", "_transient_wc_related_4_20091477046755", "a:4:{i:0;s:2:\"68\";i:1;s:3:\"900\";i:2;s:4:\"1999\";i:3;s:4:\"2005\";}", "no");
INSERT INTO `wp_options` VALUES("110829", "_transient_timeout_wc_review_count_23701477046755", "1487496322", "no");
INSERT INTO `wp_options` VALUES("110830", "_transient_wc_review_count_23701477046755", "0", "no");
INSERT INTO `wp_options` VALUES("110831", "_transient_timeout_wc_related_4_23701477046755", "1487496323", "no");
INSERT INTO `wp_options` VALUES("110832", "_transient_wc_related_4_23701477046755", "a:4:{i:0;s:2:\"68\";i:1;s:3:\"900\";i:2;s:4:\"1999\";i:3;s:4:\"2005\";}", "no");
INSERT INTO `wp_options` VALUES("110873", "_transient_timeout_wc_tax_rates_57cedd5eef3be743bae7f780281517f0", "1485528888", "no");
INSERT INTO `wp_options` VALUES("110874", "_transient_wc_tax_rates_57cedd5eef3be743bae7f780281517f0", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110888", "_transient_timeout_wc_review_count_1911477046755", "1487524783", "no");
INSERT INTO `wp_options` VALUES("110889", "_transient_wc_review_count_1911477046755", "0", "no");
INSERT INTO `wp_options` VALUES("110890", "_transient_timeout_wc_related_4_1911477046755", "1487524783", "no");
INSERT INTO `wp_options` VALUES("110891", "_transient_wc_related_4_1911477046755", "a:4:{i:0;s:2:\"63\";i:1;s:3:\"185\";i:2;s:3:\"186\";i:3;s:3:\"187\";}", "no");
INSERT INTO `wp_options` VALUES("110892", "_transient_timeout_wc_uf_pid_bf173ac011b0737564f97e693830318d", "1487525485", "no");
INSERT INTO `wp_options` VALUES("110893", "_transient_wc_uf_pid_bf173ac011b0737564f97e693830318d", "a:3:{i:0;i:191;i:1;i:190;i:2;i:189;}", "no");
INSERT INTO `wp_options` VALUES("110904", "_transient_timeout_wc_tax_rates_e3c691cd56f1fb5d8b90b70510c3ede5", "1485545136", "no");
INSERT INTO `wp_options` VALUES("110905", "_transient_wc_tax_rates_e3c691cd56f1fb5d8b90b70510c3ede5", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110914", "_transient_timeout_wc_uf_pid_4f7dd635876a852396bf8a54e751986c", "1487535217", "no");
INSERT INTO `wp_options` VALUES("110915", "_transient_wc_uf_pid_4f7dd635876a852396bf8a54e751986c", "a:2:{i:0;i:2365;i:1;i:2003;}", "no");
INSERT INTO `wp_options` VALUES("110952", "_transient_timeout_wc_uf_pid_8a9d109d63eba8c76e3b2252cc4e2595", "1487561179", "no");
INSERT INTO `wp_options` VALUES("110953", "_transient_wc_uf_pid_8a9d109d63eba8c76e3b2252cc4e2595", "a:2:{i:0;i:2365;i:1;i:2003;}", "no");
INSERT INTO `wp_options` VALUES("110966", "_transient_timeout_wc_uf_pid_0dc8ac7e50694edf7b4541a0473584dd", "1487570106", "no");
INSERT INTO `wp_options` VALUES("110967", "_transient_wc_uf_pid_0dc8ac7e50694edf7b4541a0473584dd", "a:3:{i:0;i:191;i:1;i:190;i:2;i:189;}", "no");
INSERT INTO `wp_options` VALUES("110971", "_transient_timeout_wc_uf_pid_f40f193131a8a2eb9137e5c4d47bcd14", "1487572730", "no");
INSERT INTO `wp_options` VALUES("110972", "_transient_wc_uf_pid_f40f193131a8a2eb9137e5c4d47bcd14", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("110973", "_transient_timeout_wc_uf_pid_294848664b837bf0a68ffc7d851a25e3", "1487572757", "no");
INSERT INTO `wp_options` VALUES("110974", "_transient_wc_uf_pid_294848664b837bf0a68ffc7d851a25e3", "a:3:{i:0;i:101;i:1;i:94;i:2;i:98;}", "no");
INSERT INTO `wp_options` VALUES("110982", "_transient_timeout_wc_uf_pid_9930de6ed20cd8216df2c20713cf7cbb", "1487575701", "no");
INSERT INTO `wp_options` VALUES("110983", "_transient_wc_uf_pid_9930de6ed20cd8216df2c20713cf7cbb", "a:3:{i:0;i:101;i:1;i:94;i:2;i:98;}", "no");
INSERT INTO `wp_options` VALUES("110984", "_transient_timeout_wc_uf_pid_8e4935584b9362680a7c8898ab5a5c67", "1487575798", "no");
INSERT INTO `wp_options` VALUES("110985", "_transient_wc_uf_pid_8e4935584b9362680a7c8898ab5a5c67", "a:2:{i:0;i:2669;i:1;i:2664;}", "no");
INSERT INTO `wp_options` VALUES("110988", "_transient_timeout_wc_uf_pid_eeddeb39c338c52580aefce798f05bd4", "1487575926", "no");
INSERT INTO `wp_options` VALUES("110989", "_transient_wc_uf_pid_eeddeb39c338c52580aefce798f05bd4", "a:3:{i:0;i:2386;i:1;i:202;i:2;i:200;}", "no");
INSERT INTO `wp_options` VALUES("110990", "_transient_timeout_wc_uf_pid_e8ef86e6f0f74aeae6c6f2dc0949b07a", "1487575942", "no");
INSERT INTO `wp_options` VALUES("110991", "_transient_wc_uf_pid_e8ef86e6f0f74aeae6c6f2dc0949b07a", "a:3:{i:0;i:2386;i:1;i:202;i:2;i:200;}", "no");
INSERT INTO `wp_options` VALUES("110993", "_transient_timeout_wc_uf_pid_bf51937b47561f332a1028f6c4601013", "1487575959", "no");
INSERT INTO `wp_options` VALUES("110994", "_transient_wc_uf_pid_bf51937b47561f332a1028f6c4601013", "a:3:{i:0;i:2386;i:1;i:202;i:2;i:200;}", "no");
INSERT INTO `wp_options` VALUES("110995", "_transient_timeout_wc_uf_pid_b760687d33ef40317294014439f47832", "1487575976", "no");
INSERT INTO `wp_options` VALUES("110996", "_transient_wc_uf_pid_b760687d33ef40317294014439f47832", "a:3:{i:0;i:2386;i:1;i:202;i:2;i:200;}", "no");
INSERT INTO `wp_options` VALUES("110997", "_transient_timeout_wc_uf_pid_eaa1c03866d5cc0e61e4af8e3420f50e", "1487576029", "no");
INSERT INTO `wp_options` VALUES("110998", "_transient_wc_uf_pid_eaa1c03866d5cc0e61e4af8e3420f50e", "a:3:{i:0;i:190;i:1;i:191;i:2;i:189;}", "no");
INSERT INTO `wp_options` VALUES("110999", "_transient_timeout_wc_uf_pid_c517c130bb99871f7cf84835e6147a9a", "1487576061", "no");
INSERT INTO `wp_options` VALUES("111000", "_transient_wc_uf_pid_c517c130bb99871f7cf84835e6147a9a", "a:3:{i:0;i:191;i:1;i:190;i:2;i:189;}", "no");
INSERT INTO `wp_options` VALUES("111001", "_transient_timeout_wc_uf_pid_fb89348dee9eb5a5ece3aab4712f367e", "1487576451", "no");
INSERT INTO `wp_options` VALUES("111002", "_transient_wc_uf_pid_fb89348dee9eb5a5ece3aab4712f367e", "a:28:{i:0;i:2669;i:1;i:2664;i:2;i:2479;i:3;i:2386;i:4;i:2370;i:5;i:2365;i:6;i:2360;i:7;i:2348;i:8;i:2012;i:9;i:2009;i:10;i:2005;i:11;i:2003;i:12;i:1999;i:13;i:900;i:14;i:202;i:15;i:200;i:16;i:191;i:17;i:190;i:18;i:189;i:19;i:188;i:20;i:187;i:21;i:186;i:22;i:185;i:23;i:101;i:24;i:94;i:25;i:68;i:26;i:63;i:27;i:98;}", "no");
INSERT INTO `wp_options` VALUES("111015", "_transient_timeout_wc_uf_pid_dc73ad84a3fb20b319024e2700592d04", "1487584950", "no");
INSERT INTO `wp_options` VALUES("111016", "_transient_wc_uf_pid_dc73ad84a3fb20b319024e2700592d04", "a:28:{i:0;i:2669;i:1;i:2664;i:2;i:2479;i:3;i:2386;i:4;i:2370;i:5;i:2365;i:6;i:2360;i:7;i:2348;i:8;i:2012;i:9;i:2009;i:10;i:2005;i:11;i:2003;i:12;i:1999;i:13;i:900;i:14;i:202;i:15;i:200;i:16;i:191;i:17;i:190;i:18;i:189;i:19;i:188;i:20;i:187;i:21;i:186;i:22;i:185;i:23;i:101;i:24;i:94;i:25;i:68;i:26;i:63;i:27;i:98;}", "no");
INSERT INTO `wp_options` VALUES("111021", "_transient_timeout_wc_tax_rates_9562308bc2431f4c021e1ecd26e69030", "1485599725", "no");
INSERT INTO `wp_options` VALUES("111022", "_transient_wc_tax_rates_9562308bc2431f4c021e1ecd26e69030", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111030", "_transient_timeout_wc_tax_rates_f787c01bd8c2c9535b61ec246c628469", "1485601908", "no");
INSERT INTO `wp_options` VALUES("111031", "_transient_wc_tax_rates_f787c01bd8c2c9535b61ec246c628469", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111037", "_transient_timeout_external_ip_address_unknown", "1485605471", "no");
INSERT INTO `wp_options` VALUES("111038", "_transient_external_ip_address_unknown", "173.254.202.145", "no");
INSERT INTO `wp_options` VALUES("111047", "_transient_timeout_wc_tax_rates_1777d3bc15035cd961d3635e9ad7d208", "1485612333", "no");
INSERT INTO `wp_options` VALUES("111048", "_transient_wc_tax_rates_1777d3bc15035cd961d3635e9ad7d208", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111065", "_transient_timeout_wc_tax_rates_c2d8f36840003f22c696a804a60c1b77", "1485620094", "no");
INSERT INTO `wp_options` VALUES("111066", "_transient_wc_tax_rates_c2d8f36840003f22c696a804a60c1b77", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111067", "_transient_timeout_wc_uf_pid_9708bd3936cf05f16a685653fd00dfcf", "1487607434", "no");
INSERT INTO `wp_options` VALUES("111068", "_transient_wc_uf_pid_9708bd3936cf05f16a685653fd00dfcf", "a:28:{i:0;i:2669;i:1;i:2664;i:2;i:2479;i:3;i:2386;i:4;i:2370;i:5;i:2365;i:6;i:2360;i:7;i:2348;i:8;i:2012;i:9;i:2009;i:10;i:2005;i:11;i:2003;i:12;i:1999;i:13;i:900;i:14;i:202;i:15;i:200;i:16;i:191;i:17;i:190;i:18;i:189;i:19;i:188;i:20;i:187;i:21;i:186;i:22;i:185;i:23;i:101;i:24;i:94;i:25;i:68;i:26;i:63;i:27;i:98;}", "no");
INSERT INTO `wp_options` VALUES("111074", "_transient_timeout_wc_tax_rates_c9b1c3e6c3fbc2c490c761d5e6678f30", "1485623207", "no");
INSERT INTO `wp_options` VALUES("111075", "_transient_wc_tax_rates_c9b1c3e6c3fbc2c490c761d5e6678f30", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111103", "_transient_timeout_wc_uf_pid_f6ca3a2a8e4154b9632d5306b3fe0ace", "1487626299", "no");
INSERT INTO `wp_options` VALUES("111104", "_transient_wc_uf_pid_f6ca3a2a8e4154b9632d5306b3fe0ace", "a:2:{i:0;i:2669;i:1;i:2664;}", "no");
INSERT INTO `wp_options` VALUES("111112", "_transient_timeout_wc_review_count_1871477046755", "1487632612", "no");
INSERT INTO `wp_options` VALUES("111113", "_transient_wc_review_count_1871477046755", "0", "no");
INSERT INTO `wp_options` VALUES("111114", "_transient_timeout_wc_related_4_1871477046755", "1487632613", "no");
INSERT INTO `wp_options` VALUES("111115", "_transient_wc_related_4_1871477046755", "a:4:{i:0;s:2:\"63\";i:1;s:3:\"185\";i:2;s:3:\"186\";i:3;s:3:\"188\";}", "no");
INSERT INTO `wp_options` VALUES("111116", "_transient_timeout_wc_uf_pid_0af6e8283ac68db7f893b20935c41e5a", "1487633621", "no");
INSERT INTO `wp_options` VALUES("111117", "_transient_wc_uf_pid_0af6e8283ac68db7f893b20935c41e5a", "a:2:{i:0;i:2365;i:1;i:2003;}", "no");
INSERT INTO `wp_options` VALUES("111122", "_transient_timeout_wc_uf_pid_0d30174e062f7a7f278b2c80eaef45f4", "1487635875", "no");
INSERT INTO `wp_options` VALUES("111123", "_transient_wc_uf_pid_0d30174e062f7a7f278b2c80eaef45f4", "a:28:{i:0;i:2669;i:1;i:2664;i:2;i:2479;i:3;i:2386;i:4;i:2370;i:5;i:2365;i:6;i:2360;i:7;i:2348;i:8;i:2012;i:9;i:2009;i:10;i:2005;i:11;i:2003;i:12;i:1999;i:13;i:900;i:14;i:202;i:15;i:200;i:16;i:191;i:17;i:190;i:18;i:189;i:19;i:188;i:20;i:187;i:21;i:186;i:22;i:185;i:23;i:101;i:24;i:94;i:25;i:68;i:26;i:63;i:27;i:98;}", "no");
INSERT INTO `wp_options` VALUES("111140", "_transient_timeout_wc_uf_pid_978d6e1a5a33e6432f59dbdcfde08995", "1487645214", "no");
INSERT INTO `wp_options` VALUES("111141", "_transient_wc_uf_pid_978d6e1a5a33e6432f59dbdcfde08995", "a:9:{i:0;i:2370;i:1;i:2360;i:2;i:2348;i:3;i:2012;i:4;i:2009;i:5;i:2005;i:6;i:1999;i:7;i:900;i:8;i:68;}", "no");
INSERT INTO `wp_options` VALUES("111142", "_transient_timeout_wc_uf_pid_112b286ed9e4bc50dc8a4a94cf666d84", "1487645240", "no");
INSERT INTO `wp_options` VALUES("111143", "_transient_wc_uf_pid_112b286ed9e4bc50dc8a4a94cf666d84", "a:9:{i:0;i:2370;i:1;i:2360;i:2;i:2348;i:3;i:2012;i:4;i:2009;i:5;i:2005;i:6;i:1999;i:7;i:900;i:8;i:68;}", "no");
INSERT INTO `wp_options` VALUES("111144", "_transient_timeout_wc_uf_pid_ff6f8775c1ac07220e6162cec3daf568", "1487645440", "no");
INSERT INTO `wp_options` VALUES("111145", "_transient_wc_uf_pid_ff6f8775c1ac07220e6162cec3daf568", "a:2:{i:0;i:2669;i:1;i:2664;}", "no");
INSERT INTO `wp_options` VALUES("111146", "_transient_timeout_wc_uf_pid_8b60caf58f5d104419700dbde2c77c0d", "1487645539", "no");
INSERT INTO `wp_options` VALUES("111147", "_transient_wc_uf_pid_8b60caf58f5d104419700dbde2c77c0d", "a:3:{i:0;i:2386;i:1;i:202;i:2;i:200;}", "no");
INSERT INTO `wp_options` VALUES("111188", "_transient_timeout_wc_uf_pid_0b14c2a173e3d39774167f260ffd1713", "1487667711", "no");
INSERT INTO `wp_options` VALUES("111189", "_transient_wc_uf_pid_0b14c2a173e3d39774167f260ffd1713", "a:3:{i:0;i:101;i:1;i:94;i:2;i:98;}", "no");
INSERT INTO `wp_options` VALUES("111190", "_transient_timeout_wc_uf_pid_cce2e12fcbf27a8aee751eb7785414e2", "1487669331", "no");
INSERT INTO `wp_options` VALUES("111191", "_transient_wc_uf_pid_cce2e12fcbf27a8aee751eb7785414e2", "a:28:{i:0;i:2669;i:1;i:2664;i:2;i:2479;i:3;i:2386;i:4;i:2370;i:5;i:2365;i:6;i:2360;i:7;i:2348;i:8;i:2012;i:9;i:2009;i:10;i:2005;i:11;i:2003;i:12;i:1999;i:13;i:900;i:14;i:202;i:15;i:200;i:16;i:191;i:17;i:190;i:18;i:189;i:19;i:188;i:20;i:187;i:21;i:186;i:22;i:185;i:23;i:101;i:24;i:94;i:25;i:68;i:26;i:63;i:27;i:98;}", "no");
INSERT INTO `wp_options` VALUES("111194", "_transient_timeout_wc_uf_pid_854cdaa7066f20882ff488506f4fd367", "1487669973", "no");
INSERT INTO `wp_options` VALUES("111195", "_transient_wc_uf_pid_854cdaa7066f20882ff488506f4fd367", "a:28:{i:0;i:1999;i:1;i:63;i:2;i:2003;i:3;i:68;i:4;i:2005;i:5;i:94;i:6;i:2009;i:7;i:98;i:8;i:2012;i:9;i:101;i:10;i:2348;i:11;i:185;i:12;i:2360;i:13;i:186;i:14;i:2365;i:15;i:187;i:16;i:2370;i:17;i:188;i:18;i:2386;i:19;i:189;i:20;i:2479;i:21;i:190;i:22;i:2664;i:23;i:191;i:24;i:2669;i:25;i:200;i:26;i:202;i:27;i:900;}", "no");
INSERT INTO `wp_options` VALUES("111210", "_transient_timeout_wc_uf_pid_0155f22892baabb3759131edb21cef58", "1487678800", "no");
INSERT INTO `wp_options` VALUES("111211", "_transient_wc_uf_pid_0155f22892baabb3759131edb21cef58", "a:3:{i:0;i:94;i:1;i:98;i:2;i:101;}", "no");
INSERT INTO `wp_options` VALUES("111212", "_transient_timeout_wc_uf_pid_62f49a853363b8261c9a6d0625c0f16a", "1487678963", "no");
INSERT INTO `wp_options` VALUES("111213", "_transient_wc_uf_pid_62f49a853363b8261c9a6d0625c0f16a", "a:3:{i:0;i:101;i:1;i:94;i:2;i:98;}", "no");
INSERT INTO `wp_options` VALUES("111219", "_transient_timeout_wc_tax_rates_011058435a05ab62deee2f0667c0c181", "1485694512", "no");
INSERT INTO `wp_options` VALUES("111220", "_transient_wc_tax_rates_011058435a05ab62deee2f0667c0c181", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111248", "_transient_timeout_wc_tax_rates_ba239d8101230a125c77df6a0153497b", "1485715812", "no");
INSERT INTO `wp_options` VALUES("111249", "_transient_wc_tax_rates_ba239d8101230a125c77df6a0153497b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111274", "_transient_timeout_wc_tax_rates_af7efcf2b4079e066ee63504c45ab030", "1485734575", "no");
INSERT INTO `wp_options` VALUES("111275", "_transient_wc_tax_rates_af7efcf2b4079e066ee63504c45ab030", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111280", "_transient_timeout_wc_uf_pid_460a3a0fb0ea887a0580c47735b807cc", "1487725309", "no");
INSERT INTO `wp_options` VALUES("111281", "_transient_wc_uf_pid_460a3a0fb0ea887a0580c47735b807cc", "a:9:{i:0;i:2370;i:1;i:2360;i:2;i:2348;i:3;i:2012;i:4;i:2009;i:5;i:2005;i:6;i:1999;i:7;i:900;i:8;i:68;}", "no");
INSERT INTO `wp_options` VALUES("111300", "_transient_timeout_wc_uf_pid_601f449f5d9e99c8e3db673efcfcb4bc", "1487738134", "no");
INSERT INTO `wp_options` VALUES("111301", "_transient_wc_uf_pid_601f449f5d9e99c8e3db673efcfcb4bc", "a:1:{i:0;i:2479;}", "no");
INSERT INTO `wp_options` VALUES("111322", "_transient_timeout_wc_uf_pid_5d2880f1a162183cf1d28af6591928c0", "1487752076", "no");
INSERT INTO `wp_options` VALUES("111323", "_transient_wc_uf_pid_5d2880f1a162183cf1d28af6591928c0", "a:3:{i:0;i:101;i:1;i:94;i:2;i:98;}", "no");
INSERT INTO `wp_options` VALUES("111329", "_transient_timeout_wc_uf_pid_93a8198671c345fa5f1e983a49d1d33c", "1487756563", "no");
INSERT INTO `wp_options` VALUES("111330", "_transient_wc_uf_pid_93a8198671c345fa5f1e983a49d1d33c", "a:3:{i:0;i:191;i:1;i:190;i:2;i:189;}", "no");
INSERT INTO `wp_options` VALUES("111331", "_transient_timeout_wc_uf_pid_ebbb95245bd8d9e34721e1da2215004b", "1487756626", "no");
INSERT INTO `wp_options` VALUES("111332", "_transient_wc_uf_pid_ebbb95245bd8d9e34721e1da2215004b", "a:3:{i:0;i:191;i:1;i:190;i:2;i:189;}", "no");
INSERT INTO `wp_options` VALUES("111359", "_transient_timeout_wc_uf_pid_12d01db0e8015a4a245dff21fad9e5a3", "1487774148", "no");
INSERT INTO `wp_options` VALUES("111360", "_transient_wc_uf_pid_12d01db0e8015a4a245dff21fad9e5a3", "a:2:{i:0;i:2003;i:1;i:2365;}", "no");
INSERT INTO `wp_options` VALUES("111364", "_transient_timeout_wc_uf_pid_a74992d3f32b44ffafa6daa29699215b", "1487775303", "no");
INSERT INTO `wp_options` VALUES("111365", "_transient_wc_uf_pid_a74992d3f32b44ffafa6daa29699215b", "a:2:{i:0;i:2365;i:1;i:2003;}", "no");
INSERT INTO `wp_options` VALUES("111371", "_transient_timeout_wc_tax_rates_85779289ccb20d2686c3557fb4fcbe52", "1485791053", "no");
INSERT INTO `wp_options` VALUES("111372", "_transient_wc_tax_rates_85779289ccb20d2686c3557fb4fcbe52", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111375", "_transient_timeout_wc_tax_rates_195722a4b1a36ed4363ec27092c95f82", "1485793695", "no");
INSERT INTO `wp_options` VALUES("111376", "_transient_wc_tax_rates_195722a4b1a36ed4363ec27092c95f82", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111417", "_transient_timeout_wc_uf_pid_deadd4ce308e750c7a6f89e699285e8f", "1487805790", "no");
INSERT INTO `wp_options` VALUES("111418", "_transient_wc_uf_pid_deadd4ce308e750c7a6f89e699285e8f", "a:3:{i:0;i:2386;i:1;i:202;i:2;i:200;}", "no");
INSERT INTO `wp_options` VALUES("111428", "_transient_timeout_wc_uf_pid_a2f74e25413576c8e7cf933eb8d7b341", "1487812094", "no");
INSERT INTO `wp_options` VALUES("111429", "_transient_wc_uf_pid_a2f74e25413576c8e7cf933eb8d7b341", "a:8:{i:0;i:191;i:1;i:190;i:2;i:189;i:3;i:188;i:4;i:187;i:5;i:186;i:6;i:185;i:7;i:63;}", "no");
INSERT INTO `wp_options` VALUES("111432", "_transient_timeout_wc_uf_pid_fb4ebd876edfc330662bb9eb2c7e6672", "1487812161", "no");
INSERT INTO `wp_options` VALUES("111433", "_transient_wc_uf_pid_fb4ebd876edfc330662bb9eb2c7e6672", "a:5:{i:0;i:188;i:1;i:187;i:2;i:186;i:3;i:185;i:4;i:63;}", "no");
INSERT INTO `wp_options` VALUES("111473", "_transient_timeout_wc_uf_pid_dcb8f6c77e55c1e097393dcf37250df7", "1487841490", "no");
INSERT INTO `wp_options` VALUES("111474", "_transient_wc_uf_pid_dcb8f6c77e55c1e097393dcf37250df7", "a:2:{i:0;i:2669;i:1;i:2664;}", "no");
INSERT INTO `wp_options` VALUES("111491", "_transient_timeout_wc_tax_rates_d9512540b63e35280acd6d7ccc27b6bc", "1485864284", "no");
INSERT INTO `wp_options` VALUES("111492", "_transient_wc_tax_rates_d9512540b63e35280acd6d7ccc27b6bc", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111545", "_transient_timeout_wc_tax_rates_11f246caba3014d7f238c0bde8c02371", "1485902640", "no");
INSERT INTO `wp_options` VALUES("111546", "_transient_wc_tax_rates_11f246caba3014d7f238c0bde8c02371", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111580", "_transient_timeout_wc_uf_pid_2fff6f2cbda143721b80dc36af18f60f", "1487915272", "no");
INSERT INTO `wp_options` VALUES("111581", "_transient_wc_uf_pid_2fff6f2cbda143721b80dc36af18f60f", "a:3:{i:0;i:2386;i:1;i:200;i:2;i:202;}", "no");
INSERT INTO `wp_options` VALUES("111601", "_transient_timeout_wc_tax_rates_9b333bd65fc314354803f78bc7b505a3", "1485938085", "no");
INSERT INTO `wp_options` VALUES("111602", "_transient_wc_tax_rates_9b333bd65fc314354803f78bc7b505a3", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111649", "_transient_timeout_wc_tax_rates_7ba68f0b8a684bcfdbd7c3aa73c7549f", "1485966264", "no");
INSERT INTO `wp_options` VALUES("111650", "_transient_wc_tax_rates_7ba68f0b8a684bcfdbd7c3aa73c7549f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111660", "_transient_timeout_wc_tax_rates_adafed018f1f90574bf646adb751fc19", "1485970440", "no");
INSERT INTO `wp_options` VALUES("111661", "_transient_wc_tax_rates_adafed018f1f90574bf646adb751fc19", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111672", "_transient_timeout_wc_tax_rates_d5cce93fdfd35bf9405eedb7945bc3f2", "1485976137", "no");
INSERT INTO `wp_options` VALUES("111673", "_transient_wc_tax_rates_d5cce93fdfd35bf9405eedb7945bc3f2", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111716", "_transient_timeout_wc_uf_pid_7d61e783314b01aa26b534c4e16b687c", "1487990968", "no");
INSERT INTO `wp_options` VALUES("111717", "_transient_wc_uf_pid_7d61e783314b01aa26b534c4e16b687c", "a:9:{i:0;i:2012;i:1;i:2348;i:2;i:2360;i:3;i:2370;i:4;i:68;i:5;i:900;i:6;i:1999;i:7;i:2005;i:8;i:2009;}", "no");
INSERT INTO `wp_options` VALUES("111757", "_transient_timeout_wc_tax_rates_27671238efcb8b9d9e88d4a66058c35f", "1486035225", "no");
INSERT INTO `wp_options` VALUES("111758", "_transient_wc_tax_rates_27671238efcb8b9d9e88d4a66058c35f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111761", "_transient_timeout_yst_sm_product_cat_1:2jHiB_3e2RQ", "1485517110", "no");
INSERT INTO `wp_options` VALUES("111762", "_transient_yst_sm_product_cat_1:2jHiB_3e2RQ", "C:24:\"WPSEO_Sitemap_Cache_Data\":48:{a:2:{s:6:\"status\";s:5:\"error\";s:3:\"xml\";s:0:\"\";}}", "no");
INSERT INTO `wp_options` VALUES("111780", "_transient_timeout_wc_uf_pid_ca7cd44686ef611c5ecfd768f9acff2f", "1488031696", "no");
INSERT INTO `wp_options` VALUES("111781", "_transient_wc_uf_pid_ca7cd44686ef611c5ecfd768f9acff2f", "a:9:{i:0;i:2370;i:1;i:2360;i:2;i:2348;i:3;i:2012;i:4;i:2009;i:5;i:2005;i:6;i:1999;i:7;i:900;i:8;i:68;}", "no");
INSERT INTO `wp_options` VALUES("111782", "_transient_timeout_wc_uf_pid_e424bf8ac3fd128ea8a0116af57e849a", "1488033489", "no");
INSERT INTO `wp_options` VALUES("111783", "_transient_wc_uf_pid_e424bf8ac3fd128ea8a0116af57e849a", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111789", "_transient_timeout_wc_uf_pid_6e0ac1c011df0e49f1ecfa4a4c263ad9", "1488036051", "no");
INSERT INTO `wp_options` VALUES("111790", "_transient_wc_uf_pid_6e0ac1c011df0e49f1ecfa4a4c263ad9", "a:8:{i:0;i:191;i:1;i:190;i:2;i:189;i:3;i:188;i:4;i:187;i:5;i:186;i:6;i:185;i:7;i:63;}", "no");
INSERT INTO `wp_options` VALUES("111791", "_transient_timeout_wc_tax_rates_72c38ec4f4bde0390ddca12beba21c68", "1486048903", "no");
INSERT INTO `wp_options` VALUES("111792", "_transient_wc_tax_rates_72c38ec4f4bde0390ddca12beba21c68", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111795", "_transient_timeout_wc_uf_pid_a14965ef34f357ae71872149dc1668a6", "1488038338", "no");
INSERT INTO `wp_options` VALUES("111796", "_transient_wc_uf_pid_a14965ef34f357ae71872149dc1668a6", "a:8:{i:0;i:191;i:1;i:190;i:2;i:189;i:3;i:188;i:4;i:187;i:5;i:186;i:6;i:185;i:7;i:63;}", "no");
INSERT INTO `wp_options` VALUES("111797", "_transient_timeout_wc_uf_pid_8e7c01472a85eeeb9c243f08fc149ee1", "1488038879", "no");
INSERT INTO `wp_options` VALUES("111798", "_transient_wc_uf_pid_8e7c01472a85eeeb9c243f08fc149ee1", "a:2:{i:0;i:2664;i:1;i:2669;}", "no");
INSERT INTO `wp_options` VALUES("111799", "_transient_timeout_wc_uf_pid_36941f1f5d909962cffade119ebf757b", "1488038890", "no");
INSERT INTO `wp_options` VALUES("111800", "_transient_wc_uf_pid_36941f1f5d909962cffade119ebf757b", "a:2:{i:0;i:2669;i:1;i:2664;}", "no");
INSERT INTO `wp_options` VALUES("111804", "_transient_timeout_wc_uf_pid_dae4d21432a299785c80850555df6164", "1488040554", "no");
INSERT INTO `wp_options` VALUES("111805", "_transient_wc_uf_pid_dae4d21432a299785c80850555df6164", "a:8:{i:0;i:63;i:1;i:185;i:2;i:186;i:3;i:187;i:4;i:188;i:5;i:189;i:6;i:190;i:7;i:191;}", "no");
INSERT INTO `wp_options` VALUES("111816", "_transient_timeout_wc_tax_rates_53786b15011dca2c8b0750c8d2cba85a", "1486061513", "no");
INSERT INTO `wp_options` VALUES("111817", "_transient_wc_tax_rates_53786b15011dca2c8b0750c8d2cba85a", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111872", "_transient_timeout_wc_tax_rates_9f73f10c83fd91841e71cdec1d1f361b", "1486097882", "no");
INSERT INTO `wp_options` VALUES("111873", "_transient_wc_tax_rates_9f73f10c83fd91841e71cdec1d1f361b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111877", "_transient_timeout_wc_uf_pid_39c5b9d63c54d2c35c66cde1f07b84d1", "1488086928", "no");
INSERT INTO `wp_options` VALUES("111878", "_transient_wc_uf_pid_39c5b9d63c54d2c35c66cde1f07b84d1", "a:5:{i:0;i:188;i:1;i:187;i:2;i:186;i:3;i:185;i:4;i:63;}", "no");
INSERT INTO `wp_options` VALUES("111883", "_transient_timeout_wc_tax_rates_8208645a31efc71f3532ca68b1007c2c", "1486104655", "no");
INSERT INTO `wp_options` VALUES("111884", "_transient_wc_tax_rates_8208645a31efc71f3532ca68b1007c2c", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111929", "_transient_timeout_wc_tax_rates_46e23b4194612f9f91bc38ab957ed46b", "1486137174", "no");
INSERT INTO `wp_options` VALUES("111930", "_transient_wc_tax_rates_46e23b4194612f9f91bc38ab957ed46b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("111973", "_transient_timeout_wc_tax_rates_164153e3e09c0cabf91e89c73bea08f9", "1486166275", "no");
INSERT INTO `wp_options` VALUES("111974", "_transient_wc_tax_rates_164153e3e09c0cabf91e89c73bea08f9", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112000", "_transient_timeout_wc_uf_pid_d0ddc5094065e07c3422b769c0c83375", "1488175817", "no");
INSERT INTO `wp_options` VALUES("112001", "_transient_wc_uf_pid_d0ddc5094065e07c3422b769c0c83375", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112002", "_transient_timeout_wc_uf_pid_41f65e0c3da6612228ca36850aae852e", "1488175850", "no");
INSERT INTO `wp_options` VALUES("112003", "_transient_wc_uf_pid_41f65e0c3da6612228ca36850aae852e", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112004", "_transient_timeout_wc_uf_pid_9460e98b81c3db2dfdaa2d5b448fd281", "1488175882", "no");
INSERT INTO `wp_options` VALUES("112005", "_transient_wc_uf_pid_9460e98b81c3db2dfdaa2d5b448fd281", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112183", "_transient_timeout_wc_uf_pid_bc43e1d10be4453feba79754c0dd141e", "1488298402", "no");
INSERT INTO `wp_options` VALUES("112184", "_transient_wc_uf_pid_bc43e1d10be4453feba79754c0dd141e", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112185", "_transient_timeout_wc_uf_pid_cc04eaaf9fbce857f3e6608dd0718bc9", "1488298421", "no");
INSERT INTO `wp_options` VALUES("112186", "_transient_wc_uf_pid_cc04eaaf9fbce857f3e6608dd0718bc9", "a:5:{i:0;i:188;i:1;i:187;i:2;i:186;i:3;i:185;i:4;i:63;}", "no");
INSERT INTO `wp_options` VALUES("112187", "_transient_timeout_wc_uf_pid_be04df52b28fdc80f324432f854b53c1", "1488298456", "no");
INSERT INTO `wp_options` VALUES("112188", "_transient_wc_uf_pid_be04df52b28fdc80f324432f854b53c1", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112189", "_transient_timeout_wc_uf_pid_d97209f2a1cd99091fd35eef619c0feb", "1488298486", "no");
INSERT INTO `wp_options` VALUES("112190", "_transient_wc_uf_pid_d97209f2a1cd99091fd35eef619c0feb", "a:8:{i:0;i:191;i:1;i:190;i:2;i:189;i:3;i:188;i:4;i:187;i:5;i:186;i:6;i:185;i:7;i:63;}", "no");
INSERT INTO `wp_options` VALUES("112191", "_transient_timeout_wc_uf_pid_529b64460c3e8b2146baa04aac28d9b1", "1488298862", "no");
INSERT INTO `wp_options` VALUES("112192", "_transient_wc_uf_pid_529b64460c3e8b2146baa04aac28d9b1", "a:2:{i:0;i:2365;i:1;i:2003;}", "no");
INSERT INTO `wp_options` VALUES("112238", "_transient_timeout_wc_tax_rates_8f761d84bc0ac5cbe2e2e5caa4fba2d0", "1486345582", "no");
INSERT INTO `wp_options` VALUES("112239", "_transient_wc_tax_rates_8f761d84bc0ac5cbe2e2e5caa4fba2d0", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112258", "_transient_timeout_wc_uf_pid_365408d19664ff822e49104f214601fb", "1488348335", "no");
INSERT INTO `wp_options` VALUES("112259", "_transient_wc_uf_pid_365408d19664ff822e49104f214601fb", "a:5:{i:0;i:188;i:1;i:187;i:2;i:186;i:3;i:185;i:4;i:63;}", "no");
INSERT INTO `wp_options` VALUES("112308", "_transient_timeout_wc_uf_pid_cb2151cb8e46adda1abe01a0f37921c0", "1488379056", "no");
INSERT INTO `wp_options` VALUES("112309", "_transient_wc_uf_pid_cb2151cb8e46adda1abe01a0f37921c0", "a:5:{i:0;i:63;i:1;i:185;i:2;i:186;i:3;i:187;i:4;i:188;}", "no");
INSERT INTO `wp_options` VALUES("112406", "_transient_timeout_wc_tax_rates_c7208c68c35c736ac00a02fdf445a580", "1486460296", "no");
INSERT INTO `wp_options` VALUES("112407", "_transient_wc_tax_rates_c7208c68c35c736ac00a02fdf445a580", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112429", "_transient_timeout_wc_tax_rates_9fef7525a8838fc6b2946d3e12d37103", "1486474333", "no");
INSERT INTO `wp_options` VALUES("112430", "_transient_wc_tax_rates_9fef7525a8838fc6b2946d3e12d37103", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112553", "_transient_timeout_wc_uf_pid_e57f6673731b5ff5c9cc9c731fb74943", "1488548777", "no");
INSERT INTO `wp_options` VALUES("112554", "_transient_wc_uf_pid_e57f6673731b5ff5c9cc9c731fb74943", "a:5:{i:0;i:188;i:1;i:187;i:2;i:186;i:3;i:185;i:4;i:63;}", "no");
INSERT INTO `wp_options` VALUES("112620", "_transient_timeout_wc_tax_rates_bd3d6c05afb7fd8be914ba1b119acda6", "1486603623", "no");
INSERT INTO `wp_options` VALUES("112621", "_transient_wc_tax_rates_bd3d6c05afb7fd8be914ba1b119acda6", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112658", "_transient_timeout_wc_tax_rates_e3d564d1a550fd15957f6fffcfb68c2d", "1486625171", "no");
INSERT INTO `wp_options` VALUES("112659", "_transient_wc_tax_rates_e3d564d1a550fd15957f6fffcfb68c2d", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112723", "_transient_timeout_wc_uf_pid_c7f4dac633fe733f27d6aa50a9fc2690", "1488655177", "no");
INSERT INTO `wp_options` VALUES("112724", "_transient_wc_uf_pid_c7f4dac633fe733f27d6aa50a9fc2690", "a:5:{i:0;i:188;i:1;i:187;i:2;i:186;i:3;i:185;i:4;i:63;}", "no");
INSERT INTO `wp_options` VALUES("112742", "_transient_timeout_wc_tax_rates_082917f4c8f995a0de19b7b787bdaf3f", "1486680073", "no");
INSERT INTO `wp_options` VALUES("112743", "_transient_wc_tax_rates_082917f4c8f995a0de19b7b787bdaf3f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112835", "_transient_timeout_wc_uf_pid_0da7a39b64d2b1148185a7ca7d9b562f", "1488732248", "no");
INSERT INTO `wp_options` VALUES("112836", "_transient_wc_uf_pid_0da7a39b64d2b1148185a7ca7d9b562f", "a:8:{i:0;i:191;i:1;i:190;i:2;i:189;i:3;i:188;i:4;i:187;i:5;i:186;i:6;i:185;i:7;i:63;}", "no");
INSERT INTO `wp_options` VALUES("112868", "_transient_timeout_wc_uf_pid_6f680b4841e9e3b502255916cd49e63a", "1488756571", "no");
INSERT INTO `wp_options` VALUES("112869", "_transient_wc_uf_pid_6f680b4841e9e3b502255916cd49e63a", "a:9:{i:0;i:2370;i:1;i:2360;i:2;i:2348;i:3;i:2012;i:4;i:2009;i:5;i:2005;i:6;i:1999;i:7;i:900;i:8;i:68;}", "no");
INSERT INTO `wp_options` VALUES("112874", "_transient_timeout_wc_tax_rates_7626a35871d2a0b88065b8605a44f7cd", "1486772144", "no");
INSERT INTO `wp_options` VALUES("112875", "_transient_wc_tax_rates_7626a35871d2a0b88065b8605a44f7cd", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112928", "_transient_timeout_wc_uf_pid_78e99b5ebf355a380e6ced653f5bc955", "1488800450", "no");
INSERT INTO `wp_options` VALUES("112929", "_transient_wc_uf_pid_78e99b5ebf355a380e6ced653f5bc955", "a:10:{i:0;i:2669;i:1;i:2664;i:2;i:2479;i:3;i:2386;i:4;i:2370;i:5;i:2365;i:6;i:2360;i:7;i:2348;i:8;i:2012;i:9;i:2009;}", "no");
INSERT INTO `wp_options` VALUES("112952", "_transient_timeout_wc_tax_rates_d4f5bec114f2849efacacdf4f03e0e90", "1486828471", "no");
INSERT INTO `wp_options` VALUES("112953", "_transient_wc_tax_rates_d4f5bec114f2849efacacdf4f03e0e90", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112978", "_transient_timeout_wc_tax_rates_a6be365af85100f52cea4599a2b15688", "1486845323", "no");
INSERT INTO `wp_options` VALUES("112979", "_transient_wc_tax_rates_a6be365af85100f52cea4599a2b15688", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112991", "_transient_timeout_wc_tax_rates_a692b6e7b167828ec17d6c9e8b46a9f3", "1486854700", "no");
INSERT INTO `wp_options` VALUES("112992", "_transient_wc_tax_rates_a692b6e7b167828ec17d6c9e8b46a9f3", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("112993", "_transient_timeout_wc_tax_rates_5a7e15a03131077201debaecff7675cc", "1486855458", "no");
INSERT INTO `wp_options` VALUES("112994", "_transient_wc_tax_rates_5a7e15a03131077201debaecff7675cc", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113019", "_transient_timeout_wc_uf_pid_524e0fe8b0c6b7326ac400a1e8055996", "1488861334", "no");
INSERT INTO `wp_options` VALUES("113020", "_transient_wc_uf_pid_524e0fe8b0c6b7326ac400a1e8055996", "a:3:{i:0;i:101;i:1;i:94;i:2;i:98;}", "no");
INSERT INTO `wp_options` VALUES("113041", "_transient_timeout_wc_tax_rates_5314050b34dce507f3ff993d8e471501", "1486888108", "no");
INSERT INTO `wp_options` VALUES("113042", "_transient_wc_tax_rates_5314050b34dce507f3ff993d8e471501", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113067", "_transient_timeout_wc_tax_rates_176784726b7c3f56320e101836ec64cd", "1486903287", "no");
INSERT INTO `wp_options` VALUES("113068", "_transient_wc_tax_rates_176784726b7c3f56320e101836ec64cd", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113093", "_transient_timeout_wc_tax_rates_13a3524d95c6bf4cd088d6cf8a5ddf23", "1486918698", "no");
INSERT INTO `wp_options` VALUES("113094", "_transient_wc_tax_rates_13a3524d95c6bf4cd088d6cf8a5ddf23", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113143", "_transient_timeout_wc_uf_pid_e14a9a88f570a1e50ffbe2cc3a17ffaa", "1488938045", "no");
INSERT INTO `wp_options` VALUES("113144", "_transient_wc_uf_pid_e14a9a88f570a1e50ffbe2cc3a17ffaa", "a:2:{i:0;i:2365;i:1;i:2003;}", "no");
INSERT INTO `wp_options` VALUES("113207", "_transient_timeout_wc_tax_rates_98508b55373a188bb6309e7542649a09", "1486989895", "no");
INSERT INTO `wp_options` VALUES("113208", "_transient_wc_tax_rates_98508b55373a188bb6309e7542649a09", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113241", "_transient_timeout_wc_tax_rates_3615cab1bc9755e708ab9243651979d5", "1487013762", "no");
INSERT INTO `wp_options` VALUES("113242", "_transient_wc_tax_rates_3615cab1bc9755e708ab9243651979d5", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113275", "_transient_timeout_wc_uf_pid_cbf8339c5698016e8b7f757edf17acf2", "1489021348", "no");
INSERT INTO `wp_options` VALUES("113276", "_transient_wc_uf_pid_cbf8339c5698016e8b7f757edf17acf2", "a:8:{i:0;i:191;i:1;i:190;i:2;i:189;i:3;i:188;i:4;i:187;i:5;i:186;i:6;i:185;i:7;i:63;}", "no");
INSERT INTO `wp_options` VALUES("113356", "_transient_timeout_wc_tax_rates_daa19b10bc3b47b6fd0c259424053e48", "1487090080", "no");
INSERT INTO `wp_options` VALUES("113357", "_transient_wc_tax_rates_daa19b10bc3b47b6fd0c259424053e48", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113368", "_transient_timeout_wc_tax_rates_d239e748d7a34f6eca7477e44837b900", "1487097178", "no");
INSERT INTO `wp_options` VALUES("113369", "_transient_wc_tax_rates_d239e748d7a34f6eca7477e44837b900", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113422", "_transient_timeout_wc_tax_rates_e7973c610b4debc77d6d556565a9463f", "1487136697", "no");
INSERT INTO `wp_options` VALUES("113423", "_transient_wc_tax_rates_e7973c610b4debc77d6d556565a9463f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113460", "_transient_timeout_wc_low_stock_count", "1489145280", "no");
INSERT INTO `wp_options` VALUES("113461", "_transient_wc_low_stock_count", "0", "no");
INSERT INTO `wp_options` VALUES("113462", "_transient_timeout_wc_outofstock_count", "1489145280", "no");
INSERT INTO `wp_options` VALUES("113463", "_transient_wc_outofstock_count", "0", "no");
INSERT INTO `wp_options` VALUES("113486", "_transient_timeout_wc_product_children_2380", "1489145706", "no");
INSERT INTO `wp_options` VALUES("113487", "_transient_wc_product_children_2380", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("113488", "_transient_timeout_wc_var_pricesf9cdde26e349f0d06523051477046755", "1489145706", "no");
INSERT INTO `wp_options` VALUES("113489", "_transient_wc_var_pricesf9cdde26e349f0d06523051477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("113490", "_transient_timeout_wc_product_children_2375", "1489145707", "no");
INSERT INTO `wp_options` VALUES("113491", "_transient_wc_product_children_2375", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("113492", "_transient_timeout_wc_var_pricese66facc04cc37dda27b9d11477046755", "1489145707", "no");
INSERT INTO `wp_options` VALUES("113493", "_transient_wc_var_pricese66facc04cc37dda27b9d11477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("113496", "_transient_timeout_wc_product_children_2355", "1489145708", "no");
INSERT INTO `wp_options` VALUES("113497", "_transient_wc_product_children_2355", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("113498", "_transient_timeout_wc_product_children_2344", "1489145708", "no");
INSERT INTO `wp_options` VALUES("113499", "_transient_wc_product_children_2344", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("113500", "_transient_timeout_wc_var_prices261e03490f55370e1dda1b1477046755", "1489145709", "no");
INSERT INTO `wp_options` VALUES("113501", "_transient_timeout_wc_var_prices0a64788bb7b54ab256cd1b1477046755", "1489145709", "no");
INSERT INTO `wp_options` VALUES("113502", "_transient_wc_var_prices261e03490f55370e1dda1b1477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("113503", "_transient_wc_var_prices0a64788bb7b54ab256cd1b1477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("113521", "_transient_timeout_wc_tax_rates_dedd1dbcd7e492c587c7f815daba891a", "1487165842", "no");
INSERT INTO `wp_options` VALUES("113522", "_transient_wc_tax_rates_dedd1dbcd7e492c587c7f815daba891a", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113560", "_transient_timeout_wc_tax_rates_3dee4b4d8b518b0fcfd9ff0d518b8e31", "1487190261", "no");
INSERT INTO `wp_options` VALUES("113561", "_transient_wc_tax_rates_3dee4b4d8b518b0fcfd9ff0d518b8e31", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113604", "_transient_timeout_wc_uf_pid_0f9bfa4d49725e36ac76cb0d2c1b22f1", "1489209609", "no");
INSERT INTO `wp_options` VALUES("113605", "_transient_wc_uf_pid_0f9bfa4d49725e36ac76cb0d2c1b22f1", "a:3:{i:0;i:191;i:1;i:190;i:2;i:189;}", "no");
INSERT INTO `wp_options` VALUES("113694", "_transient_timeout_wc_tax_rates_f616d60196c2e725eb2bad65b57afea6", "1487283816", "no");
INSERT INTO `wp_options` VALUES("113695", "_transient_wc_tax_rates_f616d60196c2e725eb2bad65b57afea6", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113780", "_transient_timeout_wc_tax_rates_084523900f6445287e141f04880497f6", "1487345964", "no");
INSERT INTO `wp_options` VALUES("113781", "_transient_wc_tax_rates_084523900f6445287e141f04880497f6", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113802", "_transient_timeout_wc_tax_rates_3333a181bb2e922c35de7971f9b5c08b", "1487357123", "no");
INSERT INTO `wp_options` VALUES("113803", "_transient_wc_tax_rates_3333a181bb2e922c35de7971f9b5c08b", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113804", "_transient_timeout_wc_tax_rates_24c83b1733973f5277c8435d21e796b2", "1487357813", "no");
INSERT INTO `wp_options` VALUES("113805", "_transient_wc_tax_rates_24c83b1733973f5277c8435d21e796b2", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113806", "_transient_timeout_wc_tax_rates_d2418c05862f9ad9302ce46d302bc481", "1487357930", "no");
INSERT INTO `wp_options` VALUES("113807", "_transient_wc_tax_rates_d2418c05862f9ad9302ce46d302bc481", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113824", "_transient_timeout_wc_tax_rates_11fc5d01d820cf9040c5800b5f52a355", "1487368547", "no");
INSERT INTO `wp_options` VALUES("113825", "_transient_wc_tax_rates_11fc5d01d820cf9040c5800b5f52a355", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("113909", "_transient_timeout_wc_tax_rates_00282fb87d01eefb2ba8126a49a4599c", "1487429755", "no");
INSERT INTO `wp_options` VALUES("113910", "_transient_wc_tax_rates_00282fb87d01eefb2ba8126a49a4599c", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114005", "_transient_timeout_wc_uf_pid_d7b06201501f060ddf629dd56eba6208", "1489488222", "no");
INSERT INTO `wp_options` VALUES("114006", "_transient_wc_uf_pid_d7b06201501f060ddf629dd56eba6208", "a:9:{i:0;i:2370;i:1;i:2360;i:2;i:2348;i:3;i:2012;i:4;i:2009;i:5;i:2005;i:6;i:1999;i:7;i:900;i:8;i:68;}", "no");
INSERT INTO `wp_options` VALUES("114027", "_transient_timeout_wc_tax_rates_73539390e49e888701a529b67d9a1165", "1487514892", "no");
INSERT INTO `wp_options` VALUES("114028", "_transient_wc_tax_rates_73539390e49e888701a529b67d9a1165", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114112", "_transient_timeout_wc_tax_rates_5bf9639845138870b2839fc61d82f58c", "1487571593", "no");
INSERT INTO `wp_options` VALUES("114113", "_transient_wc_tax_rates_5bf9639845138870b2839fc61d82f58c", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114143", "_transient_timeout_wc_tax_rates_a2d319e7a02f40b271f174c06e6c9d2f", "1487592959", "no");
INSERT INTO `wp_options` VALUES("114144", "_transient_wc_tax_rates_a2d319e7a02f40b271f174c06e6c9d2f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114156", "_transient_timeout_wc_tax_rates_cb16ade9f4dd3c03ead1e2d92360a10f", "1487601599", "no");
INSERT INTO `wp_options` VALUES("114157", "_transient_wc_tax_rates_cb16ade9f4dd3c03ead1e2d92360a10f", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114171", "_transient_timeout_wc_tax_rates_51f9bbf21a14d0a54bc42347bad6c787", "1487611245", "no");
INSERT INTO `wp_options` VALUES("114172", "_transient_wc_tax_rates_51f9bbf21a14d0a54bc42347bad6c787", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114180", "_transient_timeout_wc_tax_rates_c5a1a14c7d0602fd5a856b9c7d85a069", "1487615856", "no");
INSERT INTO `wp_options` VALUES("114181", "_transient_wc_tax_rates_c5a1a14c7d0602fd5a856b9c7d85a069", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114184", "_transient_timeout_wc_tax_rates_ac82b7220b7edb00859f14dd04a48078", "1487616437", "no");
INSERT INTO `wp_options` VALUES("114185", "_transient_wc_tax_rates_ac82b7220b7edb00859f14dd04a48078", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114189", "_transient_timeout_wc_tax_rates_2b978337eabc1ad30bf7e4ca4437bb92", "1487617928", "no");
INSERT INTO `wp_options` VALUES("114190", "_transient_wc_tax_rates_2b978337eabc1ad30bf7e4ca4437bb92", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114198", "_transient_timeout_wc_tax_rates_6bb0ac620d15a38c23835746ebd0598a", "1487623672", "no");
INSERT INTO `wp_options` VALUES("114199", "_transient_wc_tax_rates_6bb0ac620d15a38c23835746ebd0598a", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114247", "_transient_timeout_wc_tax_rates_ae56bab6d6ceb34a9d8b7e3d5912b224", "1487658900", "no");
INSERT INTO `wp_options` VALUES("114248", "_transient_wc_tax_rates_ae56bab6d6ceb34a9d8b7e3d5912b224", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114280", "_transient_timeout_wc_tax_rates_4e3fe32f1b4a9befe1c259d7958dc38e", "1487684875", "no");
INSERT INTO `wp_options` VALUES("114281", "_transient_wc_tax_rates_4e3fe32f1b4a9befe1c259d7958dc38e", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114287", "_transient_timeout_wc_tax_rates_833a800940fe1f5857ea5d56e8408449", "1487688447", "no");
INSERT INTO `wp_options` VALUES("114288", "_transient_wc_tax_rates_833a800940fe1f5857ea5d56e8408449", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114307", "_transient_timeout_wc_tax_rates_7325bb344f45f73e79116bf3d5421ade", "1487702980", "no");
INSERT INTO `wp_options` VALUES("114308", "_transient_wc_tax_rates_7325bb344f45f73e79116bf3d5421ade", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114309", "_transient_timeout_wc_uf_pid_5536a35ded16bd3732e48adfb0976912", "1489690359", "no");
INSERT INTO `wp_options` VALUES("114310", "_transient_wc_uf_pid_5536a35ded16bd3732e48adfb0976912", "a:2:{i:0;i:2669;i:1;i:2664;}", "no");
INSERT INTO `wp_options` VALUES("114314", "_transient_timeout_wc_tax_rates_383055967600173818c1261ce0d509d7", "1487705614", "no");
INSERT INTO `wp_options` VALUES("114315", "_transient_wc_tax_rates_383055967600173818c1261ce0d509d7", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114369", "_transient_timeout_wc_tax_rates_acc172a035085a14d070845eef013be0", "1487745505", "no");
INSERT INTO `wp_options` VALUES("114370", "_transient_wc_tax_rates_acc172a035085a14d070845eef013be0", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114394", "_transient_timeout_wc_tax_rates_fddc025432a1307a6a9ad0b7bd408b7d", "1487764204", "no");
INSERT INTO `wp_options` VALUES("114395", "_transient_wc_tax_rates_fddc025432a1307a6a9ad0b7bd408b7d", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114403", "_transient_timeout_wc_tax_rates_4c061c0818eb16e397c7515433a4e30a", "1487769023", "no");
INSERT INTO `wp_options` VALUES("114404", "_transient_wc_tax_rates_4c061c0818eb16e397c7515433a4e30a", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114409", "_transient_timeout_wc_tax_rates_b608c9dcf76aaae151dd85284c1810d0", "1487773526", "no");
INSERT INTO `wp_options` VALUES("114410", "_transient_wc_tax_rates_b608c9dcf76aaae151dd85284c1810d0", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114425", "_transient_timeout_wc_tax_rates_1e44e5d9aa48f69f22d1b23757a7c351", "1487781083", "no");
INSERT INTO `wp_options` VALUES("114426", "_transient_wc_tax_rates_1e44e5d9aa48f69f22d1b23757a7c351", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114444", "_transient_timeout_wc_tax_rates_e7a125b7b31a9759437704028dac2a26", "1487793184", "no");
INSERT INTO `wp_options` VALUES("114445", "_transient_wc_tax_rates_e7a125b7b31a9759437704028dac2a26", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114461", "_transient_timeout_wc_tax_rates_ada75eb35f7ff909b628b29474965446", "1487805957", "no");
INSERT INTO `wp_options` VALUES("114462", "_transient_wc_tax_rates_ada75eb35f7ff909b628b29474965446", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114494", "_transient_timeout_wc_tax_rates_c4a763c6c41ba1f6470b4ce7843e37f3", "1487828187", "no");
INSERT INTO `wp_options` VALUES("114495", "_transient_wc_tax_rates_c4a763c6c41ba1f6470b4ce7843e37f3", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114512", "_transient_timeout_wc_tax_rates_943b88869c9a2a038c3edf36b6b0aeaa", "1487841550", "no");
INSERT INTO `wp_options` VALUES("114513", "_transient_wc_tax_rates_943b88869c9a2a038c3edf36b6b0aeaa", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114529", "_transient_timeout_wc_uf_pid_5dc30af23cf584f2531d617913f91bd7", "1489840397", "no");
INSERT INTO `wp_options` VALUES("114530", "_transient_wc_uf_pid_5dc30af23cf584f2531d617913f91bd7", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114533", "_transient_timeout_wc_tax_rates_5f6512e32157891f4c28b648994b6a59", "1487855495", "no");
INSERT INTO `wp_options` VALUES("114534", "_transient_wc_tax_rates_5f6512e32157891f4c28b648994b6a59", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114546", "_transient_timeout_wc_tax_rates_a9d1fb6a416831c66981bc2a7fcc34ee", "1487863496", "no");
INSERT INTO `wp_options` VALUES("114547", "_transient_wc_tax_rates_a9d1fb6a416831c66981bc2a7fcc34ee", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114562", "_transient_timeout_wc_uf_pid_3138a636371a431742fa86d40fbe3e57", "1489863557", "no");
INSERT INTO `wp_options` VALUES("114563", "_transient_wc_uf_pid_3138a636371a431742fa86d40fbe3e57", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114612", "_transient_timeout_wc_tax_rates_fd3d3384804e2c421351428459b0da9e", "1487913943", "no");
INSERT INTO `wp_options` VALUES("114613", "_transient_wc_tax_rates_fd3d3384804e2c421351428459b0da9e", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114619", "_transient_timeout_yst_sm_author_1:2jHiB_2L641", "1487400723", "no");
INSERT INTO `wp_options` VALUES("114620", "_transient_yst_sm_author_1:2jHiB_2L641", "C:24:\"WPSEO_Sitemap_Cache_Data\":473:{a:2:{s:6:\"status\";s:2:\"ok\";s:3:\"xml\";s:426:\"<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://www.hardshell.com/author/hardshell/</loc>\n		<lastmod>2016-04-08T11:11:15+00:00</lastmod>\n	</url>\n</urlset>\";}}", "no");
INSERT INTO `wp_options` VALUES("114629", "_transient_timeout_wc_tax_rates_fc6a5c8301641e7b7449cfcfac3b80a9", "1487923846", "no");
INSERT INTO `wp_options` VALUES("114630", "_transient_wc_tax_rates_fc6a5c8301641e7b7449cfcfac3b80a9", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114649", "_transient_timeout_wc_tax_rates_b9187fd3209e36148307556be7b1f0d2", "1487937762", "no");
INSERT INTO `wp_options` VALUES("114650", "_transient_wc_tax_rates_b9187fd3209e36148307556be7b1f0d2", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114657", "_transient_timeout_yst_sm_post_tag_1:2jHiB_2QgoR", "1487423401", "no");
INSERT INTO `wp_options` VALUES("114658", "_transient_yst_sm_post_tag_1:2jHiB_2QgoR", "C:24:\"WPSEO_Sitemap_Cache_Data\":1850:{a:2:{s:6:\"status\";s:2:\"ok\";s:3:\"xml\";s:1802:\"<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://www.hardshell.com/tag/ballistic-helmet-manufacturer/</loc>\n		<lastmod>2016-04-05T04:37:22+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/ballistic-helmet-u-s-a/</loc>\n		<lastmod>2016-04-05T04:37:22+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/ballistic-helmets/</loc>\n		<lastmod>2016-10-14T06:49:45+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/body-armor/</loc>\n		<lastmod>2016-08-04T07:47:06+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/body-armor-vest/</loc>\n		<lastmod>2016-09-24T06:14:45+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/body-armor-vest-k9/</loc>\n		<lastmod>2016-11-29T06:04:33-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/bulleproof-vest-for-dog/</loc>\n		<lastmod>2016-11-29T06:04:33-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/bullet-proof-vest/</loc>\n		<lastmod>2016-09-24T06:14:45+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/bullet-resistant-body-armor/</loc>\n		<lastmod>2016-08-04T07:47:06+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/helmet/</loc>\n		<lastmod>2016-10-14T06:49:45+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/k9-vest/</loc>\n		<lastmod>2016-11-29T06:04:33-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/tag/price-of-body-armmor/</loc>\n		<lastmod>2016-09-24T06:14:45+00:00</lastmod>\n	</url>\n</urlset>\";}}", "no");
INSERT INTO `wp_options` VALUES("114661", "_transient_timeout_wc_tax_rates_1f911e0081989353e874396194b2c7af", "1487944229", "no");
INSERT INTO `wp_options` VALUES("114662", "_transient_wc_tax_rates_1f911e0081989353e874396194b2c7af", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114663", "_transient_timeout_wc_tax_rates_a13b48c30ff778f6fc526fbcd131d99d", "1487944661", "no");
INSERT INTO `wp_options` VALUES("114664", "_transient_wc_tax_rates_a13b48c30ff778f6fc526fbcd131d99d", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114670", "_transient_timeout_wc_tax_rates_3e13993f044fcb24c2751875a2eb90ae", "1487948605", "no");
INSERT INTO `wp_options` VALUES("114671", "_transient_wc_tax_rates_3e13993f044fcb24c2751875a2eb90ae", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114690", "_transient_timeout_wc_tax_rates_e6fd2040dc6a8cb09200b1c06d28e2cd", "1487961011", "no");
INSERT INTO `wp_options` VALUES("114691", "_transient_wc_tax_rates_e6fd2040dc6a8cb09200b1c06d28e2cd", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114702", "_transient_timeout_wc_tax_rates_74fcd62e17ca78681d2f0d69b54bccb4", "1487966903", "no");
INSERT INTO `wp_options` VALUES("114703", "_transient_wc_tax_rates_74fcd62e17ca78681d2f0d69b54bccb4", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114728", "_transient_timeout_wc_tax_rates_4a8e424c39972021b61e291d61fdcba6", "1487986167", "no");
INSERT INTO `wp_options` VALUES("114729", "_transient_wc_tax_rates_4a8e424c39972021b61e291d61fdcba6", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114740", "_transient_timeout_yst_sm_page_1:2jHiB_3hxmS", "1487477893", "no");
INSERT INTO `wp_options` VALUES("114741", "_transient_yst_sm_page_1:2jHiB_3hxmS", "C:24:\"WPSEO_Sitemap_Cache_Data\":4826:{a:2:{s:6:\"status\";s:2:\"ok\";s:3:\"xml\";s:4778:\"<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://www.hardshell.com/</loc>\n		<lastmod>2017-01-04T07:44:02-01:00</lastmod>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/registration.png</image:loc>\n			<image:caption><![CDATA[return]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/bulk-order.png</image:loc>\n			<image:caption><![CDATA[bulk-order]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/warrenty.png</image:loc>\n			<image:caption><![CDATA[warrenty]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/nij-certified.png</image:loc>\n			<image:caption><![CDATA[nij-certified]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/blog/</loc>\n		<lastmod>2016-09-21T05:54:25+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/terms-conditions/</loc>\n		<lastmod>2014-05-17T13:13:47+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/warranty-terms/</loc>\n		<lastmod>2015-12-19T06:27:15-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/care-and-cleaning-instructions/</loc>\n		<lastmod>2015-12-19T06:36:12-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/return-and-refund-policy/</loc>\n		<lastmod>2015-12-19T06:38:47-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/manufacturing-facilities/</loc>\n		<lastmod>2015-12-19T06:52:24-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/checkout/</loc>\n		<lastmod>2015-12-19T07:16:05-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/cart/</loc>\n		<lastmod>2015-12-19T07:16:40-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/wishlist/</loc>\n		<lastmod>2015-12-19T07:18:19-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/products/</loc>\n		<lastmod>2015-12-23T05:53:03-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product-registration/</loc>\n		<lastmod>2015-12-24T05:20:55-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/bulk-order/</loc>\n		<lastmod>2015-12-28T05:05:02-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/my-account/</loc>\n		<lastmod>2015-12-28T07:04:39-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/place-an-order/</loc>\n		<lastmod>2015-12-28T11:10:45-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/disclaimer/</loc>\n		<lastmod>2015-12-28T11:12:06-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/about-us/</loc>\n		<lastmod>2015-12-29T05:29:34-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product-enquiry/</loc>\n		<lastmod>2016-01-14T10:01:07-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/research-development/</loc>\n		<lastmod>2016-02-22T10:53:27-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/thank-you/</loc>\n		<lastmod>2016-04-05T08:12:31+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/home-copy/</loc>\n		<lastmod>2016-09-21T06:26:49+00:00</lastmod>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/registration.png</image:loc>\n			<image:caption><![CDATA[return]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/blog.png</image:loc>\n			<image:caption><![CDATA[warrenty]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/bulk-order.png</image:loc>\n			<image:caption><![CDATA[bulk-order]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/track-order.png</image:loc>\n			<image:caption><![CDATA[track-order]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/warrenty.png</image:loc>\n			<image:caption><![CDATA[warrenty]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://www.hardshell.com/wp-content/uploads/2014/05/return.png</image:loc>\n			<image:caption><![CDATA[return]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/under-construction/</loc>\n		<lastmod>2016-10-22T09:57:30+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/contact-us/</loc>\n		<lastmod>2016-12-14T05:50:45-01:00</lastmod>\n	</url>\n</urlset>\";}}", "no");
INSERT INTO `wp_options` VALUES("114753", "_wc_session_2", "a:1:{s:10:\"wc_notices\";N;}", "no");
INSERT INTO `wp_options` VALUES("114754", "_wc_session_expires_2", "1487569827", "no");
INSERT INTO `wp_options` VALUES("114763", "_transient_timeout_wc_tax_rates_0135469e24603113defb0f19b36ae5a5", "1488007934", "no");
INSERT INTO `wp_options` VALUES("114764", "_transient_wc_tax_rates_0135469e24603113defb0f19b36ae5a5", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114767", "_transient_timeout_wc_tax_rates_a622384c6aff7656642f60ad76c96571", "1488008477", "no");
INSERT INTO `wp_options` VALUES("114768", "_transient_wc_tax_rates_a622384c6aff7656642f60ad76c96571", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114784", "_transient_timeout_wc_product_children_2012", "1490008857", "no");
INSERT INTO `wp_options` VALUES("114785", "_transient_wc_product_children_2012", "a:1:{s:7:\"visible\";a:2:{i:0;i:2112;i:1;i:2113;}}", "no");
INSERT INTO `wp_options` VALUES("114786", "_transient_timeout_wc_var_pricesd88a3f01c127092b0548851477046755", "1490008857", "no");
INSERT INTO `wp_options` VALUES("114787", "_transient_wc_var_pricesd88a3f01c127092b0548851477046755", "a:3:{s:5:\"price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}s:13:\"regular_price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}s:10:\"sale_price\";a:2:{i:2112;s:3:\"515\";i:2113;s:4:\"1065\";}}", "no");
INSERT INTO `wp_options` VALUES("114788", "_transient_timeout_wc_rating_count_20121477046755", "1490008857", "no");
INSERT INTO `wp_options` VALUES("114789", "_transient_wc_rating_count_20121477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114790", "_transient_timeout_wc_average_rating_20121477046755", "1490008857", "no");
INSERT INTO `wp_options` VALUES("114791", "_transient_wc_average_rating_20121477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114792", "_transient_timeout_wc_var_prices835a053f96e2e85748b2c51477046755", "1490008857", "no");
INSERT INTO `wp_options` VALUES("114793", "_transient_wc_var_prices835a053f96e2e85748b2c51477046755", "a:3:{s:5:\"price\";a:2:{i:2112;i:515;i:2113;i:1065;}s:13:\"regular_price\";a:2:{i:2112;i:515;i:2113;i:1065;}s:10:\"sale_price\";a:2:{i:2112;i:515;i:2113;i:1065;}}", "no");
INSERT INTO `wp_options` VALUES("114794", "_transient_timeout_wc_product_children_2009", "1490008857", "no");
INSERT INTO `wp_options` VALUES("114795", "_transient_wc_product_children_2009", "a:1:{s:7:\"visible\";a:2:{i:0;i:2120;i:1;i:2121;}}", "no");
INSERT INTO `wp_options` VALUES("114796", "_transient_timeout_wc_var_prices3a88fa3fbf3e091533aafa1477046755", "1490008857", "no");
INSERT INTO `wp_options` VALUES("114797", "_transient_wc_var_prices3a88fa3fbf3e091533aafa1477046755", "a:3:{s:5:\"price\";a:2:{i:2121;s:1:\"0\";i:2120;s:1:\"0\";}s:13:\"regular_price\";a:2:{i:2121;s:1:\"0\";i:2120;s:1:\"0\";}s:10:\"sale_price\";a:2:{i:2121;s:1:\"0\";i:2120;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("114798", "_transient_timeout_wc_rating_count_20091477046755", "1490008858", "no");
INSERT INTO `wp_options` VALUES("114799", "_transient_wc_rating_count_20091477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114800", "_transient_timeout_wc_average_rating_20091477046755", "1490008858", "no");
INSERT INTO `wp_options` VALUES("114801", "_transient_wc_average_rating_20091477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114802", "_transient_timeout_wc_var_prices878e559915a7734f60a94d1477046755", "1490008858", "no");
INSERT INTO `wp_options` VALUES("114803", "_transient_wc_var_prices878e559915a7734f60a94d1477046755", "a:3:{s:5:\"price\";a:2:{i:2121;i:0;i:2120;i:0;}s:13:\"regular_price\";a:2:{i:2121;i:0;i:2120;i:0;}s:10:\"sale_price\";a:2:{i:2121;i:0;i:2120;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("114804", "_transient_timeout_wc_product_children_2005", "1490008858", "no");
INSERT INTO `wp_options` VALUES("114805", "_transient_wc_product_children_2005", "a:1:{s:7:\"visible\";a:2:{i:0;i:2122;i:1;i:2123;}}", "no");
INSERT INTO `wp_options` VALUES("114806", "_transient_timeout_wc_var_prices498294ebc8f0e6002122231477046755", "1490008858", "no");
INSERT INTO `wp_options` VALUES("114807", "_transient_wc_var_prices498294ebc8f0e6002122231477046755", "a:3:{s:5:\"price\";a:2:{i:2123;s:2:\"00\";i:2122;s:2:\"00\";}s:13:\"regular_price\";a:2:{i:2123;s:2:\"00\";i:2122;s:2:\"00\";}s:10:\"sale_price\";a:2:{i:2123;s:2:\"00\";i:2122;s:2:\"00\";}}", "no");
INSERT INTO `wp_options` VALUES("114808", "_transient_timeout_wc_rating_count_20051477046755", "1490008858", "no");
INSERT INTO `wp_options` VALUES("114809", "_transient_wc_rating_count_20051477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114810", "_transient_timeout_wc_average_rating_20051477046755", "1490008858", "no");
INSERT INTO `wp_options` VALUES("114811", "_transient_wc_average_rating_20051477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114812", "_transient_timeout_wc_var_prices05691ac6ea37574095d4c31477046755", "1490008858", "no");
INSERT INTO `wp_options` VALUES("114813", "_transient_wc_var_prices05691ac6ea37574095d4c31477046755", "a:3:{s:5:\"price\";a:2:{i:2123;i:0;i:2122;i:0;}s:13:\"regular_price\";a:2:{i:2123;i:0;i:2122;i:0;}s:10:\"sale_price\";a:2:{i:2123;i:0;i:2122;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("114814", "_transient_timeout_wc_product_children_2003", "1490008859", "no");
INSERT INTO `wp_options` VALUES("114815", "_transient_wc_product_children_2003", "a:1:{s:7:\"visible\";a:2:{i:0;i:2125;i:1;i:2126;}}", "no");
INSERT INTO `wp_options` VALUES("114816", "_transient_timeout_wc_var_prices9bb67b91b5fd48c9aa87581477046755", "1490008859", "no");
INSERT INTO `wp_options` VALUES("114817", "_transient_wc_var_prices9bb67b91b5fd48c9aa87581477046755", "a:3:{s:5:\"price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}s:13:\"regular_price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}s:10:\"sale_price\";a:2:{i:2126;s:1:\"0\";i:2125;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("114818", "_transient_timeout_wc_rating_count_20031477046755", "1490008859", "no");
INSERT INTO `wp_options` VALUES("114819", "_transient_wc_rating_count_20031477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114820", "_transient_timeout_wc_average_rating_20031477046755", "1490008860", "no");
INSERT INTO `wp_options` VALUES("114821", "_transient_wc_average_rating_20031477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114822", "_transient_timeout_wc_var_pricesf9a7c5d60164944357dc021477046755", "1490008860", "no");
INSERT INTO `wp_options` VALUES("114823", "_transient_wc_var_pricesf9a7c5d60164944357dc021477046755", "a:3:{s:5:\"price\";a:2:{i:2126;i:0;i:2125;i:0;}s:13:\"regular_price\";a:2:{i:2126;i:0;i:2125;i:0;}s:10:\"sale_price\";a:2:{i:2126;i:0;i:2125;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("114824", "_transient_timeout_wc_product_children_202", "1490008860", "no");
INSERT INTO `wp_options` VALUES("114825", "_transient_wc_product_children_202", "a:1:{s:7:\"visible\";a:6:{i:0;i:1883;i:1;i:1765;i:2;i:1882;i:3;i:1886;i:4;i:1885;i:5;i:1884;}}", "no");
INSERT INTO `wp_options` VALUES("114826", "_transient_timeout_wc_var_prices26206dbd471a7420c8c0811477046755", "1490008860", "no");
INSERT INTO `wp_options` VALUES("114827", "_transient_wc_var_prices26206dbd471a7420c8c0811477046755", "a:3:{s:5:\"price\";a:6:{i:1885;s:4:\"1325\";i:1884;s:4:\"1325\";i:1886;s:4:\"1325\";i:1882;s:4:\"1325\";i:1765;s:4:\"1325\";i:1883;s:4:\"1325\";}s:13:\"regular_price\";a:6:{i:1885;s:4:\"1325\";i:1884;s:4:\"1325\";i:1886;s:4:\"1325\";i:1882;s:4:\"1325\";i:1765;s:4:\"1325\";i:1883;s:4:\"1325\";}s:10:\"sale_price\";a:6:{i:1885;s:4:\"1325\";i:1884;s:4:\"1325\";i:1886;s:4:\"1325\";i:1882;s:4:\"1325\";i:1765;s:4:\"1325\";i:1883;s:4:\"1325\";}}", "no");
INSERT INTO `wp_options` VALUES("114828", "_transient_timeout_wc_rating_count_2021477046755", "1490008861", "no");
INSERT INTO `wp_options` VALUES("114829", "_transient_wc_rating_count_2021477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114830", "_transient_timeout_wc_average_rating_2021477046755", "1490008861", "no");
INSERT INTO `wp_options` VALUES("114831", "_transient_wc_average_rating_2021477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114832", "_transient_timeout_wc_var_pricesa5f172fcbe8f0ac145055f1477046755", "1490008861", "no");
INSERT INTO `wp_options` VALUES("114833", "_transient_wc_var_pricesa5f172fcbe8f0ac145055f1477046755", "a:3:{s:5:\"price\";a:6:{i:1885;i:1325;i:1884;i:1325;i:1886;i:1325;i:1882;i:1325;i:1765;i:1325;i:1883;i:1325;}s:13:\"regular_price\";a:6:{i:1885;i:1325;i:1884;i:1325;i:1886;i:1325;i:1882;i:1325;i:1765;i:1325;i:1883;i:1325;}s:10:\"sale_price\";a:6:{i:1885;i:1325;i:1884;i:1325;i:1886;i:1325;i:1882;i:1325;i:1765;i:1325;i:1883;i:1325;}}", "no");
INSERT INTO `wp_options` VALUES("114834", "_transient_timeout_wc_product_children_200", "1490008861", "no");
INSERT INTO `wp_options` VALUES("114835", "_transient_wc_product_children_200", "a:1:{s:7:\"visible\";a:24:{i:0;i:1879;i:1;i:2204;i:2;i:1860;i:3;i:2205;i:4;i:1861;i:5;i:2206;i:6;i:1862;i:7;i:2207;i:8;i:1863;i:9;i:2208;i:10;i:1864;i:11;i:2209;i:12;i:1866;i:13;i:2210;i:14;i:1867;i:15;i:2211;i:16;i:1869;i:17;i:2212;i:18;i:1870;i:19;i:1871;i:20;i:1872;i:21;i:1874;i:22;i:1876;i:23;i:1877;}}", "no");
INSERT INTO `wp_options` VALUES("114836", "_transient_timeout_wc_var_prices2552832357a1e1451c34fb1477046755", "1490008861", "no");
INSERT INTO `wp_options` VALUES("114837", "_transient_wc_var_prices2552832357a1e1451c34fb1477046755", "a:3:{s:5:\"price\";a:24:{i:2205;s:4:\"1900\";i:2209;s:4:\"1900\";i:2204;s:4:\"1900\";i:2210;s:4:\"2250\";i:1860;s:4:\"2280\";i:2206;s:4:\"2280\";i:1863;s:4:\"2505\";i:1874;s:4:\"2505\";i:1869;s:4:\"2505\";i:2211;s:4:\"2850\";i:2207;s:4:\"2850\";i:1861;s:4:\"2850\";i:1870;s:4:\"3006\";i:1876;s:4:\"3006\";i:1864;s:4:\"3006\";i:1862;s:4:\"3424\";i:2212;s:4:\"3424\";i:2208;s:4:\"3424\";i:1877;s:4:\"3757\";i:1866;s:4:\"3757\";i:1871;s:4:\"3757\";i:1879;s:4:\"4509\";i:1867;s:4:\"4509\";i:1872;s:4:\"4509\";}s:13:\"regular_price\";a:24:{i:2205;s:4:\"1900\";i:2209;s:4:\"1900\";i:2204;s:4:\"1900\";i:2210;s:4:\"2250\";i:1860;s:4:\"2280\";i:2206;s:4:\"2280\";i:1863;s:4:\"2505\";i:1874;s:4:\"2505\";i:1869;s:4:\"2505\";i:2211;s:4:\"2850\";i:2207;s:4:\"2850\";i:1861;s:4:\"2850\";i:1870;s:4:\"3006\";i:1876;s:4:\"3006\";i:1864;s:4:\"3006\";i:1862;s:4:\"3424\";i:2212;s:4:\"3424\";i:2208;s:4:\"3424\";i:1877;s:4:\"3757\";i:1866;s:4:\"3757\";i:1871;s:4:\"3757\";i:1879;s:4:\"4509\";i:1867;s:4:\"4509\";i:1872;s:4:\"4509\";}s:10:\"sale_price\";a:24:{i:2205;s:4:\"1900\";i:2209;s:4:\"1900\";i:2204;s:4:\"1900\";i:2210;s:4:\"2250\";i:1860;s:4:\"2280\";i:2206;s:4:\"2280\";i:1863;s:4:\"2505\";i:1874;s:4:\"2505\";i:1869;s:4:\"2505\";i:2211;s:4:\"2850\";i:2207;s:4:\"2850\";i:1861;s:4:\"2850\";i:1870;s:4:\"3006\";i:1876;s:4:\"3006\";i:1864;s:4:\"3006\";i:1862;s:4:\"3424\";i:2212;s:4:\"3424\";i:2208;s:4:\"3424\";i:1877;s:4:\"3757\";i:1866;s:4:\"3757\";i:1871;s:4:\"3757\";i:1879;s:4:\"4509\";i:1867;s:4:\"4509\";i:1872;s:4:\"4509\";}}", "no");
INSERT INTO `wp_options` VALUES("114838", "_transient_timeout_wc_rating_count_2001477046755", "1490008861", "no");
INSERT INTO `wp_options` VALUES("114839", "_transient_wc_rating_count_2001477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114840", "_transient_timeout_wc_average_rating_2001477046755", "1490008861", "no");
INSERT INTO `wp_options` VALUES("114841", "_transient_wc_average_rating_2001477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114842", "_transient_timeout_wc_var_pricesb50077d9ae4f525c8dfd401477046755", "1490008862", "no");
INSERT INTO `wp_options` VALUES("114843", "_transient_wc_var_pricesb50077d9ae4f525c8dfd401477046755", "a:3:{s:5:\"price\";a:24:{i:2205;i:1900;i:2209;i:1900;i:2204;i:1900;i:2210;i:2250;i:1860;i:2280;i:2206;i:2280;i:1863;i:2505;i:1874;i:2505;i:1869;i:2505;i:2211;i:2850;i:2207;i:2850;i:1861;i:2850;i:1870;i:3006;i:1876;i:3006;i:1864;i:3006;i:1862;i:3424;i:2212;i:3424;i:2208;i:3424;i:1877;i:3757;i:1866;i:3757;i:1871;i:3757;i:1879;i:4509;i:1867;i:4509;i:1872;i:4509;}s:13:\"regular_price\";a:24:{i:2205;i:1900;i:2209;i:1900;i:2204;i:1900;i:2210;i:2250;i:1860;i:2280;i:2206;i:2280;i:1863;i:2505;i:1874;i:2505;i:1869;i:2505;i:2211;i:2850;i:2207;i:2850;i:1861;i:2850;i:1870;i:3006;i:1876;i:3006;i:1864;i:3006;i:1862;i:3424;i:2212;i:3424;i:2208;i:3424;i:1877;i:3757;i:1866;i:3757;i:1871;i:3757;i:1879;i:4509;i:1867;i:4509;i:1872;i:4509;}s:10:\"sale_price\";a:24:{i:2205;i:1900;i:2209;i:1900;i:2204;i:1900;i:2210;i:2250;i:1860;i:2280;i:2206;i:2280;i:1863;i:2505;i:1874;i:2505;i:1869;i:2505;i:2211;i:2850;i:2207;i:2850;i:1861;i:2850;i:1870;i:3006;i:1876;i:3006;i:1864;i:3006;i:1862;i:3424;i:2212;i:3424;i:2208;i:3424;i:1877;i:3757;i:1866;i:3757;i:1871;i:3757;i:1879;i:4509;i:1867;i:4509;i:1872;i:4509;}}", "no");
INSERT INTO `wp_options` VALUES("114844", "_transient_timeout_wc_product_children_191", "1490008862", "no");
INSERT INTO `wp_options` VALUES("114845", "_transient_wc_product_children_191", "a:1:{s:7:\"visible\";a:1:{i:0;i:1974;}}", "no");
INSERT INTO `wp_options` VALUES("114846", "_transient_timeout_wc_var_pricesd23f559393fa60de0b7efc1477046755", "1490008862", "no");
INSERT INTO `wp_options` VALUES("114847", "_transient_wc_var_pricesd23f559393fa60de0b7efc1477046755", "a:3:{s:5:\"price\";a:1:{i:1974;s:6:\"200.00\";}s:13:\"regular_price\";a:1:{i:1974;s:6:\"200.00\";}s:10:\"sale_price\";a:1:{i:1974;s:6:\"200.00\";}}", "no");
INSERT INTO `wp_options` VALUES("114848", "_transient_timeout_wc_rating_count_1911477046755", "1490008862", "no");
INSERT INTO `wp_options` VALUES("114849", "_transient_wc_rating_count_1911477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114850", "_transient_timeout_wc_average_rating_1911477046755", "1490008862", "no");
INSERT INTO `wp_options` VALUES("114851", "_transient_wc_average_rating_1911477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114852", "_transient_timeout_wc_var_prices424fcfb034ecd382fce57f1477046755", "1490008862", "no");
INSERT INTO `wp_options` VALUES("114853", "_transient_wc_var_prices424fcfb034ecd382fce57f1477046755", "a:3:{s:5:\"price\";a:1:{i:1974;d:200;}s:13:\"regular_price\";a:1:{i:1974;d:200;}s:10:\"sale_price\";a:1:{i:1974;d:200;}}", "no");
INSERT INTO `wp_options` VALUES("114854", "_transient_timeout_wc_product_children_190", "1490008863", "no");
INSERT INTO `wp_options` VALUES("114855", "_transient_wc_product_children_190", "a:1:{s:7:\"visible\";a:1:{i:0;i:1971;}}", "no");
INSERT INTO `wp_options` VALUES("114856", "_transient_timeout_wc_var_prices51bb073085c80cebccaa801477046755", "1490008863", "no");
INSERT INTO `wp_options` VALUES("114857", "_transient_wc_var_prices51bb073085c80cebccaa801477046755", "a:3:{s:5:\"price\";a:1:{i:1971;s:3:\"200\";}s:13:\"regular_price\";a:1:{i:1971;s:3:\"200\";}s:10:\"sale_price\";a:1:{i:1971;s:3:\"200\";}}", "no");
INSERT INTO `wp_options` VALUES("114858", "_transient_timeout_wc_rating_count_1901477046755", "1490008863", "no");
INSERT INTO `wp_options` VALUES("114859", "_transient_wc_rating_count_1901477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114860", "_transient_timeout_wc_average_rating_1901477046755", "1490008863", "no");
INSERT INTO `wp_options` VALUES("114861", "_transient_wc_average_rating_1901477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114862", "_transient_timeout_wc_var_prices98cfc2622c98524cc251ee1477046755", "1490008863", "no");
INSERT INTO `wp_options` VALUES("114863", "_transient_wc_var_prices98cfc2622c98524cc251ee1477046755", "a:3:{s:5:\"price\";a:1:{i:1971;i:200;}s:13:\"regular_price\";a:1:{i:1971;i:200;}s:10:\"sale_price\";a:1:{i:1971;i:200;}}", "no");
INSERT INTO `wp_options` VALUES("114864", "_transient_timeout_wc_rating_count_26691477046755", "1490008864", "no");
INSERT INTO `wp_options` VALUES("114865", "_transient_wc_rating_count_26691477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114866", "_transient_timeout_wc_average_rating_26691477046755", "1490008864", "no");
INSERT INTO `wp_options` VALUES("114867", "_transient_wc_average_rating_26691477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114868", "_transient_timeout_wc_rating_count_26641477046755", "1490008864", "no");
INSERT INTO `wp_options` VALUES("114869", "_transient_wc_rating_count_26641477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114870", "_transient_timeout_wc_average_rating_26641477046755", "1490008864", "no");
INSERT INTO `wp_options` VALUES("114871", "_transient_wc_average_rating_26641477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114872", "_transient_timeout_wc_product_children_2479", "1490008865", "no");
INSERT INTO `wp_options` VALUES("114873", "_transient_wc_product_children_2479", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114874", "_transient_timeout_wc_var_prices397d82e130ff99c23689d21477046755", "1490008865", "no");
INSERT INTO `wp_options` VALUES("114875", "_transient_wc_var_prices397d82e130ff99c23689d21477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114876", "_transient_timeout_wc_rating_count_24791477046755", "1490008865", "no");
INSERT INTO `wp_options` VALUES("114877", "_transient_wc_rating_count_24791477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114878", "_transient_timeout_wc_average_rating_24791477046755", "1490008865", "no");
INSERT INTO `wp_options` VALUES("114879", "_transient_wc_average_rating_24791477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114880", "_transient_timeout_wc_var_pricescb14473a19ef0e1b80d6fc1477046755", "1490008865", "no");
INSERT INTO `wp_options` VALUES("114881", "_transient_wc_var_pricescb14473a19ef0e1b80d6fc1477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114882", "_transient_timeout_wc_rating_count_23861477046755", "1490008865", "no");
INSERT INTO `wp_options` VALUES("114883", "_transient_wc_rating_count_23861477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114884", "_transient_timeout_wc_average_rating_23861477046755", "1490008865", "no");
INSERT INTO `wp_options` VALUES("114885", "_transient_wc_average_rating_23861477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114886", "_transient_timeout_wc_product_children_2370", "1490008865", "no");
INSERT INTO `wp_options` VALUES("114887", "_transient_wc_product_children_2370", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114888", "_transient_timeout_wc_var_pricescd84a642def863bb7849cd1477046755", "1490008866", "no");
INSERT INTO `wp_options` VALUES("114889", "_transient_wc_var_pricescd84a642def863bb7849cd1477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114890", "_transient_timeout_wc_rating_count_23701477046755", "1490008866", "no");
INSERT INTO `wp_options` VALUES("114891", "_transient_wc_rating_count_23701477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114892", "_transient_timeout_wc_average_rating_23701477046755", "1490008866", "no");
INSERT INTO `wp_options` VALUES("114893", "_transient_wc_average_rating_23701477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114894", "_transient_timeout_wc_var_prices4addb3add475b0e4a701701477046755", "1490008866", "no");
INSERT INTO `wp_options` VALUES("114895", "_transient_wc_var_prices4addb3add475b0e4a701701477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114896", "_transient_timeout_wc_product_children_2365", "1490008866", "no");
INSERT INTO `wp_options` VALUES("114897", "_transient_wc_product_children_2365", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114898", "_transient_timeout_wc_var_prices4aaf2444b326783ae2f5c11477046755", "1490008866", "no");
INSERT INTO `wp_options` VALUES("114899", "_transient_wc_var_prices4aaf2444b326783ae2f5c11477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114900", "_transient_timeout_wc_rating_count_23651477046755", "1490008866", "no");
INSERT INTO `wp_options` VALUES("114901", "_transient_wc_rating_count_23651477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114902", "_transient_timeout_wc_average_rating_23651477046755", "1490008867", "no");
INSERT INTO `wp_options` VALUES("114903", "_transient_wc_average_rating_23651477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114904", "_transient_timeout_wc_var_pricese7cf3f30d03abd154b13c71477046755", "1490008867", "no");
INSERT INTO `wp_options` VALUES("114905", "_transient_wc_var_pricese7cf3f30d03abd154b13c71477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114912", "_transient_timeout_wc_term_counts", "1490011979", "no");
INSERT INTO `wp_options` VALUES("114913", "_transient_wc_term_counts", "a:9:{i:168;s:1:\"2\";i:169;s:1:\"2\";i:131;s:1:\"8\";i:124;s:1:\"3\";i:107;s:1:\"5\";i:170;s:1:\"1\";i:138;s:1:\"3\";i:132;s:1:\"3\";i:167;s:1:\"9\";}", "no");
INSERT INTO `wp_options` VALUES("114922", "_transient_timeout_wc_product_children_1999", "1490019222", "no");
INSERT INTO `wp_options` VALUES("114923", "_transient_wc_product_children_1999", "a:1:{s:7:\"visible\";a:1:{i:0;i:2129;}}", "no");
INSERT INTO `wp_options` VALUES("114924", "_transient_timeout_wc_var_prices2c207d5468e429484a1e871477046755", "1490019222", "no");
INSERT INTO `wp_options` VALUES("114925", "_transient_wc_var_prices2c207d5468e429484a1e871477046755", "a:3:{s:5:\"price\";a:1:{i:2129;s:1:\"0\";}s:13:\"regular_price\";a:1:{i:2129;s:1:\"0\";}s:10:\"sale_price\";a:1:{i:2129;s:1:\"0\";}}", "no");
INSERT INTO `wp_options` VALUES("114926", "_transient_timeout_wc_rating_count_19991477046755", "1490019222", "no");
INSERT INTO `wp_options` VALUES("114927", "_transient_wc_rating_count_19991477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114928", "_transient_timeout_wc_average_rating_19991477046755", "1490019222", "no");
INSERT INTO `wp_options` VALUES("114929", "_transient_wc_average_rating_19991477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114930", "_transient_timeout_wc_var_prices988869ad4a22232c07e90f1477046755", "1490019222", "no");
INSERT INTO `wp_options` VALUES("114931", "_transient_wc_var_prices988869ad4a22232c07e90f1477046755", "a:3:{s:5:\"price\";a:1:{i:2129;i:0;}s:13:\"regular_price\";a:1:{i:2129;i:0;}s:10:\"sale_price\";a:1:{i:2129;i:0;}}", "no");
INSERT INTO `wp_options` VALUES("114932", "_transient_timeout_wc_product_children_900", "1490019223", "no");
INSERT INTO `wp_options` VALUES("114933", "_transient_wc_product_children_900", "a:1:{s:7:\"visible\";a:2:{i:0;i:1770;i:1;i:1771;}}", "no");
INSERT INTO `wp_options` VALUES("114934", "_transient_timeout_wc_var_prices3d6e74621fe9edd88bc7071477046755", "1490019223", "no");
INSERT INTO `wp_options` VALUES("114935", "_transient_wc_var_prices3d6e74621fe9edd88bc7071477046755", "a:3:{s:5:\"price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}s:13:\"regular_price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}s:10:\"sale_price\";a:2:{i:1771;s:3:\"418\";i:1770;s:3:\"968\";}}", "no");
INSERT INTO `wp_options` VALUES("114936", "_transient_timeout_wc_rating_count_9001477046755", "1490019223", "no");
INSERT INTO `wp_options` VALUES("114937", "_transient_wc_rating_count_9001477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114938", "_transient_timeout_wc_average_rating_9001477046755", "1490019223", "no");
INSERT INTO `wp_options` VALUES("114939", "_transient_wc_average_rating_9001477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114940", "_transient_timeout_wc_var_prices14bc62b689f5c1de50263f1477046755", "1490019224", "no");
INSERT INTO `wp_options` VALUES("114941", "_transient_wc_var_prices14bc62b689f5c1de50263f1477046755", "a:3:{s:5:\"price\";a:2:{i:1771;i:418;i:1770;i:968;}s:13:\"regular_price\";a:2:{i:1771;i:418;i:1770;i:968;}s:10:\"sale_price\";a:2:{i:1771;i:418;i:1770;i:968;}}", "no");
INSERT INTO `wp_options` VALUES("114942", "_transient_timeout_wc_product_children_68", "1490019922", "no");
INSERT INTO `wp_options` VALUES("114943", "_transient_wc_product_children_68", "a:1:{s:7:\"visible\";a:2:{i:0;i:1764;i:1;i:1763;}}", "no");
INSERT INTO `wp_options` VALUES("114944", "_transient_timeout_wc_var_pricesdc2a0e08dd7c08a62cffae1477046755", "1490019922", "no");
INSERT INTO `wp_options` VALUES("114945", "_transient_wc_var_pricesdc2a0e08dd7c08a62cffae1477046755", "a:3:{s:5:\"price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:13:\"regular_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}s:10:\"sale_price\";a:2:{i:1764;s:3:\"465\";i:1763;s:4:\"1015\";}}", "no");
INSERT INTO `wp_options` VALUES("114946", "_transient_timeout_wc_rating_count_681477046755", "1490019922", "no");
INSERT INTO `wp_options` VALUES("114947", "_transient_wc_rating_count_681477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114948", "_transient_timeout_wc_average_rating_681477046755", "1490019922", "no");
INSERT INTO `wp_options` VALUES("114949", "_transient_wc_average_rating_681477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114950", "_transient_timeout_wc_var_pricesd6990a7b2f37804631e5641477046755", "1490019922", "no");
INSERT INTO `wp_options` VALUES("114951", "_transient_wc_var_pricesd6990a7b2f37804631e5641477046755", "a:3:{s:5:\"price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:13:\"regular_price\";a:2:{i:1764;i:465;i:1763;i:1015;}s:10:\"sale_price\";a:2:{i:1764;i:465;i:1763;i:1015;}}", "no");
INSERT INTO `wp_options` VALUES("114955", "_transient_timeout_yst_sm_category_1:2jHiB_2q1Ak", "1487517468", "no");
INSERT INTO `wp_options` VALUES("114956", "_transient_yst_sm_category_1:2jHiB_2q1Ak", "C:24:\"WPSEO_Sitemap_Cache_Data\":848:{a:2:{s:6:\"status\";s:2:\"ok\";s:3:\"xml\";s:801:\"<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://www.hardshell.com/category/ballistic-helmets/</loc>\n		<lastmod>2016-10-14T06:49:45+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/category/blog/</loc>\n		<lastmod>2016-11-29T06:04:33-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/category/blog/body-armor/</loc>\n		<lastmod>2016-12-19T04:25:21-01:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/category/hard-armor/</loc>\n		<lastmod>2016-11-12T06:20:08-01:00</lastmod>\n	</url>\n</urlset>\";}}", "no");
INSERT INTO `wp_options` VALUES("114957", "_transient_timeout_yst_sm_product_1:2jHiB_3e2Tl", "1487517668", "no");
INSERT INTO `wp_options` VALUES("114958", "_transient_yst_sm_product_1:2jHiB_3e2Tl", "C:24:\"WPSEO_Sitemap_Cache_Data\":9264:{a:2:{s:6:\"status\";s:2:\"ok\";s:3:\"xml\";s:9216:\"<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://www.hardshell.com/products/</loc>\n		<lastmod>2016-10-21T10:45:54+00:00</lastmod>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/hppe-1-5-kg-level-iii/</loc>\n		<lastmod>2016-01-21T06:35:33-01:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/ICW.jpg</image:loc>\n			<image:title><![CDATA[ICW]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/2-9kg-level-iii/</loc>\n		<lastmod>2016-01-21T06:36:32-01:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/ICW.jpg</image:loc>\n			<image:title><![CDATA[ICW]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/2-2kg-level-iii/</loc>\n		<lastmod>2016-01-21T06:37:34-01:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/ICW.jpg</image:loc>\n			<image:title><![CDATA[ICW]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/2-5kg-level-iv/</loc>\n		<lastmod>2016-01-21T06:38:32-01:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/ICW.jpg</image:loc>\n			<image:title><![CDATA[ICW]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/3-2kg-level-iv/</loc>\n		<lastmod>2016-01-21T06:39:16-01:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/ICW.jpg</image:loc>\n			<image:title><![CDATA[ICW]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/hppe-1-8kg-level-iii/</loc>\n		<lastmod>2016-01-21T06:43:40-01:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/02/Stand-Alone1.jpg</image:loc>\n			<image:title><![CDATA[Stand-Alone1]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/3kg-level-iv/</loc>\n		<lastmod>2016-01-21T06:44:16-01:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/02/Stand-Alone1.jpg</image:loc>\n			<image:title><![CDATA[Stand-Alone1]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/3-6kg-level-iv/</loc>\n		<lastmod>2016-01-21T06:45:32-01:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/02/Stand-Alone1.jpg</image:loc>\n			<image:title><![CDATA[Stand-Alone1]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/quick-release-vest/</loc>\n		<lastmod>2016-05-26T12:56:59+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/12/Quick-Release-Vest.jpg</image:loc>\n			<image:title><![CDATA[Quick Release Vest]]></image:title>\n			<image:caption><![CDATA[Quick Release Vest]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/mrap-carrier/</loc>\n		<lastmod>2016-05-26T12:57:59+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/MRAP-Carrier-Front.jpg</image:loc>\n			<image:title><![CDATA[MRAP-Carrier-Front]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/concealable-endorser-vest/</loc>\n		<lastmod>2016-05-26T12:59:30+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/12/Endorser.jpg</image:loc>\n			<image:title><![CDATA[Endorser]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/mich-helmet/</loc>\n		<lastmod>2016-09-21T06:33:47+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/02/mich-helmet.jpg</image:loc>\n			<image:title><![CDATA[mich-helmet]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/pasgt-helmet/</loc>\n		<lastmod>2016-09-21T06:36:19+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/01/personal_armor_system_ground_troops.jpg</image:loc>\n			<image:title><![CDATA[personal_armor_system_ground_troops]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/special-force-helmet/</loc>\n		<lastmod>2016-09-21T06:56:14+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/02/special-forces.jpg</image:loc>\n			<image:title><![CDATA[special-forces]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/guardian-vest/</loc>\n		<lastmod>2016-09-21T07:08:47+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/02/Guardian.jpg</image:loc>\n			<image:title><![CDATA[Guardian]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/hi-viz-vest/</loc>\n		<lastmod>2016-09-21T07:16:25+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/12/Hi-viz-jacket.jpg</image:loc>\n			<image:title><![CDATA[Hi--viz-jacket]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/operator-vest/</loc>\n		<lastmod>2016-09-21T07:29:05+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/03/Tactical-Vest-Operator.jpg</image:loc>\n			<image:title><![CDATA[Tactical-Vest-Operator]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/spear-balcs/</loc>\n		<lastmod>2016-09-21T07:33:07+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/Spear-Balcs-Front.jpg</image:loc>\n			<image:title><![CDATA[Spear-Balcs-Front]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/rescuer-vest/</loc>\n		<lastmod>2016-09-21T07:36:28+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/12/Recuer-Side.jpg</image:loc>\n			<image:title><![CDATA[Recuer--Side]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/bullet-resistant-patron-vest/</loc>\n		<lastmod>2016-09-22T09:30:08+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/12/Patron-Vest-1.jpg</image:loc>\n			<image:title><![CDATA[Patron-Vest]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/ballistic-blanket/</loc>\n		<lastmod>2016-09-22T09:38:07+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/02/ballistic-blanket.jpg</image:loc>\n			<image:title><![CDATA[ballistic-blanket]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/demining-suit/</loc>\n		<lastmod>2016-09-22T09:39:49+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2015/02/demining-suit.jpg</image:loc>\n			<image:title><![CDATA[demining-suit]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/k9-vest-ballistic/</loc>\n		<lastmod>2016-09-22T09:44:33+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/02/K9-Front1.jpg</image:loc>\n			<image:title><![CDATA[K9-Front1]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/tru-vent-concealed/</loc>\n		<lastmod>2016-09-22T09:57:46+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/Tru-Vent-Concealed-Front.jpg</image:loc>\n			<image:title><![CDATA[Tru-Vent-Concealed-Front]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/versa-operational-system/</loc>\n		<lastmod>2016-09-22T10:01:17+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/Versa-Operational-Front.jpg</image:loc>\n			<image:title><![CDATA[Versa-Operational-Front]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/tac-pac/</loc>\n		<lastmod>2016-09-22T10:04:07+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/01/Tac-Pac-Front.jpg</image:loc>\n			<image:title><![CDATA[Tac-Pac-Front]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/steller-vest/</loc>\n		<lastmod>2016-10-21T09:57:13+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/10/pocho-imgs-2.png</image:loc>\n			<image:title><![CDATA[pocho imgs]]></image:title>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://www.hardshell.com/product/poncho/</loc>\n		<lastmod>2016-10-21T10:45:54+00:00</lastmod>\n		<image:image>\n			<image:loc>https://www.hardshell.com/wp-content/uploads/2016/10/pocho-imgs-1.png</image:loc>\n			<image:title><![CDATA[pocho imgs]]></image:title>\n		</image:image>\n	</url>\n</urlset>\";}}", "no");
INSERT INTO `wp_options` VALUES("114964", "_transient_timeout_wc_tax_rates_3be9ea374aeeb5ad0c1135c239a7f6ed", "1488039367", "no");
INSERT INTO `wp_options` VALUES("114965", "_transient_wc_tax_rates_3be9ea374aeeb5ad0c1135c239a7f6ed", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114977", "_transient_timeout_wc_product_children_98", "1490035791", "no");
INSERT INTO `wp_options` VALUES("114978", "_transient_wc_product_children_98", "a:1:{s:7:\"visible\";a:16:{i:0;i:1906;i:1;i:1907;i:2;i:1908;i:3;i:1909;i:4;i:1910;i:5;i:1911;i:6;i:1912;i:7;i:1913;i:8;i:1914;i:9;i:1915;i:10;i:1916;i:11;i:1917;i:12;i:1902;i:13;i:1903;i:14;i:1904;i:15;i:1905;}}", "no");
INSERT INTO `wp_options` VALUES("114979", "_transient_timeout_wc_var_prices77315792d97a90c74547981477046755", "1490035791", "no");
INSERT INTO `wp_options` VALUES("114980", "_transient_wc_var_prices77315792d97a90c74547981477046755", "a:3:{s:5:\"price\";a:16:{i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1915;s:3:\"409\";i:1902;s:3:\"409\";i:1903;s:3:\"409\";i:1905;s:3:\"409\";i:1904;s:3:\"409\";i:1914;s:3:\"409\";i:1913;s:3:\"409\";i:1908;s:3:\"409\";i:1907;s:3:\"409\";i:1909;s:3:\"409\";i:1910;s:3:\"409\";i:1912;s:3:\"409\";i:1911;s:3:\"409\";i:1906;s:3:\"409\";}s:13:\"regular_price\";a:16:{i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1915;s:3:\"409\";i:1902;s:3:\"409\";i:1903;s:3:\"409\";i:1905;s:3:\"409\";i:1904;s:3:\"409\";i:1914;s:3:\"409\";i:1913;s:3:\"409\";i:1908;s:3:\"409\";i:1907;s:3:\"409\";i:1909;s:3:\"409\";i:1910;s:3:\"409\";i:1912;s:3:\"409\";i:1911;s:3:\"409\";i:1906;s:3:\"409\";}s:10:\"sale_price\";a:16:{i:1917;s:3:\"409\";i:1916;s:3:\"409\";i:1915;s:3:\"409\";i:1902;s:3:\"409\";i:1903;s:3:\"409\";i:1905;s:3:\"409\";i:1904;s:3:\"409\";i:1914;s:3:\"409\";i:1913;s:3:\"409\";i:1908;s:3:\"409\";i:1907;s:3:\"409\";i:1909;s:3:\"409\";i:1910;s:3:\"409\";i:1912;s:3:\"409\";i:1911;s:3:\"409\";i:1906;s:3:\"409\";}}", "no");
INSERT INTO `wp_options` VALUES("114981", "_transient_timeout_wc_rating_count_981477046755", "1490035792", "no");
INSERT INTO `wp_options` VALUES("114982", "_transient_wc_rating_count_981477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114983", "_transient_timeout_wc_average_rating_981477046755", "1490035792", "no");
INSERT INTO `wp_options` VALUES("114984", "_transient_wc_average_rating_981477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114985", "_transient_timeout_wc_var_pricesd4bde988b01523bff59a671477046755", "1490035792", "no");
INSERT INTO `wp_options` VALUES("114986", "_transient_wc_var_pricesd4bde988b01523bff59a671477046755", "a:3:{s:5:\"price\";a:16:{i:1917;i:409;i:1916;i:409;i:1915;i:409;i:1902;i:409;i:1903;i:409;i:1905;i:409;i:1904;i:409;i:1914;i:409;i:1913;i:409;i:1908;i:409;i:1907;i:409;i:1909;i:409;i:1910;i:409;i:1912;i:409;i:1911;i:409;i:1906;i:409;}s:13:\"regular_price\";a:16:{i:1917;i:409;i:1916;i:409;i:1915;i:409;i:1902;i:409;i:1903;i:409;i:1905;i:409;i:1904;i:409;i:1914;i:409;i:1913;i:409;i:1908;i:409;i:1907;i:409;i:1909;i:409;i:1910;i:409;i:1912;i:409;i:1911;i:409;i:1906;i:409;}s:10:\"sale_price\";a:16:{i:1917;i:409;i:1916;i:409;i:1915;i:409;i:1902;i:409;i:1903;i:409;i:1905;i:409;i:1904;i:409;i:1914;i:409;i:1913;i:409;i:1908;i:409;i:1907;i:409;i:1909;i:409;i:1910;i:409;i:1912;i:409;i:1911;i:409;i:1906;i:409;}}", "no");
INSERT INTO `wp_options` VALUES("114990", "_transient_timeout_wc_product_children_94", "1490036563", "no");
INSERT INTO `wp_options` VALUES("114991", "_transient_wc_product_children_94", "a:1:{s:7:\"visible\";a:20:{i:0;i:1694;i:1;i:1695;i:2;i:1696;i:3;i:1697;i:4;i:1698;i:5;i:1699;i:6;i:1684;i:7;i:1700;i:8;i:1685;i:9;i:1701;i:10;i:1686;i:11;i:1702;i:12;i:1687;i:13;i:1703;i:14;i:1688;i:15;i:1689;i:16;i:1690;i:17;i:1691;i:18;i:1692;i:19;i:1693;}}", "no");
INSERT INTO `wp_options` VALUES("114992", "_transient_timeout_wc_var_prices2a86c658d2bca1db535cbe1477046755", "1490036563", "no");
INSERT INTO `wp_options` VALUES("114993", "_transient_wc_var_prices2a86c658d2bca1db535cbe1477046755", "a:3:{s:5:\"price\";a:20:{i:1688;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1689;s:3:\"427\";i:1690;s:3:\"427\";i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1686;s:3:\"427\";i:1701;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1699;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1694;s:3:\"427\";}s:13:\"regular_price\";a:20:{i:1688;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1689;s:3:\"427\";i:1690;s:3:\"427\";i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1686;s:3:\"427\";i:1701;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1699;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1694;s:3:\"427\";}s:10:\"sale_price\";a:20:{i:1688;s:3:\"427\";i:1703;s:3:\"427\";i:1687;s:3:\"427\";i:1702;s:3:\"427\";i:1689;s:3:\"427\";i:1690;s:3:\"427\";i:1693;s:3:\"427\";i:1692;s:3:\"427\";i:1691;s:3:\"427\";i:1686;s:3:\"427\";i:1701;s:3:\"427\";i:1697;s:3:\"427\";i:1696;s:3:\"427\";i:1695;s:3:\"427\";i:1698;s:3:\"427\";i:1699;s:3:\"427\";i:1685;s:3:\"427\";i:1700;s:3:\"427\";i:1684;s:3:\"427\";i:1694;s:3:\"427\";}}", "no");
INSERT INTO `wp_options` VALUES("114994", "_transient_timeout_wc_rating_count_941477046755", "1490036563", "no");
INSERT INTO `wp_options` VALUES("114995", "_transient_wc_rating_count_941477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("114996", "_transient_timeout_wc_average_rating_941477046755", "1490036563", "no");
INSERT INTO `wp_options` VALUES("114997", "_transient_wc_average_rating_941477046755", "0", "no");
INSERT INTO `wp_options` VALUES("114998", "_transient_timeout_wc_var_prices508ed4445f00ea7945b36b1477046755", "1490036563", "no");
INSERT INTO `wp_options` VALUES("114999", "_transient_wc_var_prices508ed4445f00ea7945b36b1477046755", "a:3:{s:5:\"price\";a:20:{i:1688;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1689;i:427;i:1690;i:427;i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1686;i:427;i:1701;i:427;i:1697;i:427;i:1696;i:427;i:1695;i:427;i:1698;i:427;i:1699;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1694;i:427;}s:13:\"regular_price\";a:20:{i:1688;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1689;i:427;i:1690;i:427;i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1686;i:427;i:1701;i:427;i:1697;i:427;i:1696;i:427;i:1695;i:427;i:1698;i:427;i:1699;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1694;i:427;}s:10:\"sale_price\";a:20:{i:1688;i:427;i:1703;i:427;i:1687;i:427;i:1702;i:427;i:1689;i:427;i:1690;i:427;i:1693;i:427;i:1692;i:427;i:1691;i:427;i:1686;i:427;i:1701;i:427;i:1697;i:427;i:1696;i:427;i:1695;i:427;i:1698;i:427;i:1699;i:427;i:1685;i:427;i:1700;i:427;i:1684;i:427;i:1694;i:427;}}", "no");
INSERT INTO `wp_options` VALUES("115000", "_transient_timeout_wc_product_children_101", "1490036563", "no");
INSERT INTO `wp_options` VALUES("115001", "_transient_wc_product_children_101", "a:1:{s:7:\"visible\";a:16:{i:0;i:1933;i:1;i:1934;i:2;i:1935;i:3;i:1936;i:4;i:1937;i:5;i:1938;i:6;i:1759;i:7;i:1924;i:8;i:1925;i:9;i:1926;i:10;i:1927;i:11;i:1928;i:12;i:1929;i:13;i:1930;i:14;i:1931;i:15;i:1932;}}", "no");
INSERT INTO `wp_options` VALUES("115002", "_transient_timeout_wc_var_pricesbd7c4712ac18a0ed9afe491477046755", "1490036564", "no");
INSERT INTO `wp_options` VALUES("115003", "_transient_wc_var_pricesbd7c4712ac18a0ed9afe491477046755", "a:3:{s:5:\"price\";a:16:{i:1928;s:3:\"449\";i:1927;s:3:\"449\";i:1926;s:3:\"449\";i:1929;s:3:\"449\";i:1930;s:3:\"449\";i:1932;s:3:\"449\";i:1931;s:3:\"449\";i:1925;s:3:\"449\";i:1924;s:3:\"449\";i:1935;s:3:\"449\";i:1934;s:3:\"449\";i:1936;s:3:\"449\";i:1937;s:3:\"449\";i:1759;s:3:\"449\";i:1938;s:3:\"449\";i:1933;s:3:\"449\";}s:13:\"regular_price\";a:16:{i:1928;s:3:\"449\";i:1927;s:3:\"449\";i:1926;s:3:\"449\";i:1929;s:3:\"449\";i:1930;s:3:\"449\";i:1932;s:3:\"449\";i:1931;s:3:\"449\";i:1925;s:3:\"449\";i:1924;s:3:\"449\";i:1935;s:3:\"449\";i:1934;s:3:\"449\";i:1936;s:3:\"449\";i:1937;s:3:\"449\";i:1759;s:3:\"449\";i:1938;s:3:\"449\";i:1933;s:3:\"449\";}s:10:\"sale_price\";a:16:{i:1928;s:3:\"449\";i:1927;s:3:\"449\";i:1926;s:3:\"449\";i:1929;s:3:\"449\";i:1930;s:3:\"449\";i:1932;s:3:\"449\";i:1931;s:3:\"449\";i:1925;s:3:\"449\";i:1924;s:3:\"449\";i:1935;s:3:\"449\";i:1934;s:3:\"449\";i:1936;s:3:\"449\";i:1937;s:3:\"449\";i:1759;s:3:\"449\";i:1938;s:3:\"449\";i:1933;s:3:\"449\";}}", "no");
INSERT INTO `wp_options` VALUES("115004", "_transient_timeout_wc_rating_count_1011477046755", "1490036564", "no");
INSERT INTO `wp_options` VALUES("115005", "_transient_wc_rating_count_1011477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115006", "_transient_timeout_wc_average_rating_1011477046755", "1490036564", "no");
INSERT INTO `wp_options` VALUES("115007", "_transient_wc_average_rating_1011477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115008", "_transient_timeout_wc_var_pricese5e3a7ec74d543849a65931477046755", "1490036564", "no");
INSERT INTO `wp_options` VALUES("115009", "_transient_wc_var_pricese5e3a7ec74d543849a65931477046755", "a:3:{s:5:\"price\";a:16:{i:1928;i:449;i:1927;i:449;i:1926;i:449;i:1929;i:449;i:1930;i:449;i:1932;i:449;i:1931;i:449;i:1925;i:449;i:1924;i:449;i:1935;i:449;i:1934;i:449;i:1936;i:449;i:1937;i:449;i:1759;i:449;i:1938;i:449;i:1933;i:449;}s:13:\"regular_price\";a:16:{i:1928;i:449;i:1927;i:449;i:1926;i:449;i:1929;i:449;i:1930;i:449;i:1932;i:449;i:1931;i:449;i:1925;i:449;i:1924;i:449;i:1935;i:449;i:1934;i:449;i:1936;i:449;i:1937;i:449;i:1759;i:449;i:1938;i:449;i:1933;i:449;}s:10:\"sale_price\";a:16:{i:1928;i:449;i:1927;i:449;i:1926;i:449;i:1929;i:449;i:1930;i:449;i:1932;i:449;i:1931;i:449;i:1925;i:449;i:1924;i:449;i:1935;i:449;i:1934;i:449;i:1936;i:449;i:1937;i:449;i:1759;i:449;i:1938;i:449;i:1933;i:449;}}", "no");
INSERT INTO `wp_options` VALUES("115013", "_transient_timeout_wc_product_children_187", "1490039558", "no");
INSERT INTO `wp_options` VALUES("115014", "_transient_wc_product_children_187", "a:1:{s:7:\"visible\";a:1:{i:0;i:1948;}}", "no");
INSERT INTO `wp_options` VALUES("115015", "_transient_timeout_wc_var_prices69b94d3d1c7aa668620c9d1477046755", "1490039558", "no");
INSERT INTO `wp_options` VALUES("115016", "_transient_wc_var_prices69b94d3d1c7aa668620c9d1477046755", "a:3:{s:5:\"price\";a:1:{i:1948;s:3:\"260\";}s:13:\"regular_price\";a:1:{i:1948;s:3:\"260\";}s:10:\"sale_price\";a:1:{i:1948;s:3:\"260\";}}", "no");
INSERT INTO `wp_options` VALUES("115017", "_transient_timeout_wc_rating_count_1871477046755", "1490039558", "no");
INSERT INTO `wp_options` VALUES("115018", "_transient_wc_rating_count_1871477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115019", "_transient_timeout_wc_average_rating_1871477046755", "1490039558", "no");
INSERT INTO `wp_options` VALUES("115020", "_transient_wc_average_rating_1871477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115021", "_transient_timeout_wc_var_pricesd4035f095214d5a659d7351477046755", "1490039559", "no");
INSERT INTO `wp_options` VALUES("115022", "_transient_wc_var_pricesd4035f095214d5a659d7351477046755", "a:3:{s:5:\"price\";a:1:{i:1948;i:260;}s:13:\"regular_price\";a:1:{i:1948;i:260;}s:10:\"sale_price\";a:1:{i:1948;i:260;}}", "no");
INSERT INTO `wp_options` VALUES("115023", "_transient_timeout_wc_product_children_188", "1490039559", "no");
INSERT INTO `wp_options` VALUES("115024", "_transient_wc_product_children_188", "a:1:{s:7:\"visible\";a:2:{i:0;i:1961;i:1;i:1960;}}", "no");
INSERT INTO `wp_options` VALUES("115025", "_transient_timeout_wc_var_prices1d90330a9d4642abe5a2031477046755", "1490039559", "no");
INSERT INTO `wp_options` VALUES("115026", "_transient_wc_var_prices1d90330a9d4642abe5a2031477046755", "a:3:{s:5:\"price\";a:2:{i:1960;s:6:\"260.00\";i:1961;s:6:\"260.00\";}s:13:\"regular_price\";a:2:{i:1960;s:6:\"260.00\";i:1961;s:6:\"260.00\";}s:10:\"sale_price\";a:2:{i:1960;s:6:\"260.00\";i:1961;s:6:\"260.00\";}}", "no");
INSERT INTO `wp_options` VALUES("115027", "_transient_timeout_wc_rating_count_1881477046755", "1490039559", "no");
INSERT INTO `wp_options` VALUES("115028", "_transient_wc_rating_count_1881477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115029", "_transient_timeout_wc_average_rating_1881477046755", "1490039559", "no");
INSERT INTO `wp_options` VALUES("115030", "_transient_wc_average_rating_1881477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115031", "_transient_timeout_wc_var_pricesd066263a739a60885ca6ab1477046755", "1490039559", "no");
INSERT INTO `wp_options` VALUES("115032", "_transient_wc_var_pricesd066263a739a60885ca6ab1477046755", "a:3:{s:5:\"price\";a:2:{i:1960;d:260;i:1961;d:260;}s:13:\"regular_price\";a:2:{i:1960;d:260;i:1961;d:260;}s:10:\"sale_price\";a:2:{i:1960;d:260;i:1961;d:260;}}", "no");
INSERT INTO `wp_options` VALUES("115033", "_transient_timeout_wc_product_children_186", "1490039560", "no");
INSERT INTO `wp_options` VALUES("115034", "_transient_wc_product_children_186", "a:1:{s:7:\"visible\";a:1:{i:0;i:1945;}}", "no");
INSERT INTO `wp_options` VALUES("115035", "_transient_timeout_wc_var_prices78e12551dda16c6fea9fdf1477046755", "1490039560", "no");
INSERT INTO `wp_options` VALUES("115036", "_transient_wc_var_prices78e12551dda16c6fea9fdf1477046755", "a:3:{s:5:\"price\";a:1:{i:1945;s:5:\"400.0\";}s:13:\"regular_price\";a:1:{i:1945;s:5:\"400.0\";}s:10:\"sale_price\";a:1:{i:1945;s:5:\"400.0\";}}", "no");
INSERT INTO `wp_options` VALUES("115037", "_transient_timeout_wc_rating_count_1861477046755", "1490039561", "no");
INSERT INTO `wp_options` VALUES("115038", "_transient_wc_rating_count_1861477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115039", "_transient_timeout_wc_average_rating_1861477046755", "1490039561", "no");
INSERT INTO `wp_options` VALUES("115040", "_transient_wc_average_rating_1861477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115041", "_transient_timeout_wc_var_prices764374b4011a3f747d56ef1477046755", "1490039561", "no");
INSERT INTO `wp_options` VALUES("115042", "_transient_wc_var_prices764374b4011a3f747d56ef1477046755", "a:3:{s:5:\"price\";a:1:{i:1945;d:400;}s:13:\"regular_price\";a:1:{i:1945;d:400;}s:10:\"sale_price\";a:1:{i:1945;d:400;}}", "no");
INSERT INTO `wp_options` VALUES("115058", "_transient_timeout_wc_product_children_2360", "1490052694", "no");
INSERT INTO `wp_options` VALUES("115059", "_transient_wc_product_children_2360", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("115060", "_transient_timeout_wc_var_prices83492a152fc3c016001b581477046755", "1490052694", "no");
INSERT INTO `wp_options` VALUES("115061", "_transient_wc_var_prices83492a152fc3c016001b581477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("115062", "_transient_timeout_wc_rating_count_23601477046755", "1490052695", "no");
INSERT INTO `wp_options` VALUES("115063", "_transient_wc_rating_count_23601477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115064", "_transient_timeout_wc_average_rating_23601477046755", "1490052695", "no");
INSERT INTO `wp_options` VALUES("115065", "_transient_wc_average_rating_23601477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115066", "_transient_timeout_wc_var_pricesf28f3d0af5e88483ac3ba21477046755", "1490052696", "no");
INSERT INTO `wp_options` VALUES("115067", "_transient_wc_var_pricesf28f3d0af5e88483ac3ba21477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("115086", "_transient_timeout_wc_product_children_189", "1490069661", "no");
INSERT INTO `wp_options` VALUES("115087", "_transient_wc_product_children_189", "a:1:{s:7:\"visible\";a:1:{i:0;i:1968;}}", "no");
INSERT INTO `wp_options` VALUES("115088", "_transient_timeout_wc_var_pricesb46432f98384c46111e88a1477046755", "1490069661", "no");
INSERT INTO `wp_options` VALUES("115089", "_transient_wc_var_pricesb46432f98384c46111e88a1477046755", "a:3:{s:5:\"price\";a:1:{i:1968;s:6:\"445.50\";}s:13:\"regular_price\";a:1:{i:1968;s:6:\"445.50\";}s:10:\"sale_price\";a:1:{i:1968;s:6:\"445.50\";}}", "no");
INSERT INTO `wp_options` VALUES("115090", "_transient_timeout_wc_rating_count_1891477046755", "1490069661", "no");
INSERT INTO `wp_options` VALUES("115091", "_transient_wc_rating_count_1891477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115092", "_transient_timeout_wc_average_rating_1891477046755", "1490069662", "no");
INSERT INTO `wp_options` VALUES("115093", "_transient_wc_average_rating_1891477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115094", "_transient_timeout_wc_var_pricese409b0fb97bc0ea79ded361477046755", "1490069662", "no");
INSERT INTO `wp_options` VALUES("115095", "_transient_wc_var_pricese409b0fb97bc0ea79ded361477046755", "a:3:{s:5:\"price\";a:1:{i:1968;d:445.5;}s:13:\"regular_price\";a:1:{i:1968;d:445.5;}s:10:\"sale_price\";a:1:{i:1968;d:445.5;}}", "no");
INSERT INTO `wp_options` VALUES("115101", "_transient_timeout_wc_tax_rates_d75a81b0715864704bacbc5f131d1899", "1488084857", "no");
INSERT INTO `wp_options` VALUES("115102", "_transient_wc_tax_rates_d75a81b0715864704bacbc5f131d1899", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115108", "_transient_timeout_wc_uf_pid_cf86ab61bd35b6a6d0abdeb407377803", "1490077266", "no");
INSERT INTO `wp_options` VALUES("115109", "_transient_wc_uf_pid_cf86ab61bd35b6a6d0abdeb407377803", "a:2:{i:0;i:2669;i:1;i:2664;}", "no");
INSERT INTO `wp_options` VALUES("115112", "_transient_timeout_wc_product_children_2348", "1490078508", "no");
INSERT INTO `wp_options` VALUES("115113", "_transient_wc_product_children_2348", "a:1:{s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("115114", "_transient_timeout_wc_var_pricesa3e5f3f20973f1e0c7d1371477046755", "1490078508", "no");
INSERT INTO `wp_options` VALUES("115115", "_transient_wc_var_pricesa3e5f3f20973f1e0c7d1371477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("115116", "_transient_timeout_wc_rating_count_23481477046755", "1490078509", "no");
INSERT INTO `wp_options` VALUES("115117", "_transient_wc_rating_count_23481477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115118", "_transient_timeout_wc_average_rating_23481477046755", "1490078509", "no");
INSERT INTO `wp_options` VALUES("115119", "_transient_wc_average_rating_23481477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115120", "_transient_timeout_wc_var_prices238701ffcfc3872b94ed881477046755", "1490078510", "no");
INSERT INTO `wp_options` VALUES("115121", "_transient_wc_var_prices238701ffcfc3872b94ed881477046755", "a:3:{s:5:\"price\";a:0:{}s:13:\"regular_price\";a:0:{}s:10:\"sale_price\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("115122", "_transient_timeout_wc_review_count_9001477046755", "1490078526", "no");
INSERT INTO `wp_options` VALUES("115123", "_transient_wc_review_count_9001477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115124", "_transient_timeout_wc_related_4_9001477046755", "1490078527", "no");
INSERT INTO `wp_options` VALUES("115125", "_transient_wc_related_4_9001477046755", "a:4:{i:0;s:2:\"68\";i:1;s:4:\"1999\";i:2;s:4:\"2005\";i:3;s:4:\"2009\";}", "no");
INSERT INTO `wp_options` VALUES("115126", "_transient_timeout_wc_review_count_26641477046755", "1490078542", "no");
INSERT INTO `wp_options` VALUES("115127", "_transient_wc_review_count_26641477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115128", "_transient_timeout_wc_related_4_26641477046755", "1490078542", "no");
INSERT INTO `wp_options` VALUES("115129", "_transient_wc_related_4_26641477046755", "a:1:{i:0;s:4:\"2669\";}", "no");
INSERT INTO `wp_options` VALUES("115130", "_transient_timeout_wc_review_count_26691477046755", "1490078683", "no");
INSERT INTO `wp_options` VALUES("115131", "_transient_wc_review_count_26691477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115132", "_transient_timeout_wc_related_4_26691477046755", "1490078684", "no");
INSERT INTO `wp_options` VALUES("115133", "_transient_wc_related_4_26691477046755", "a:1:{i:0;s:4:\"2664\";}", "no");
INSERT INTO `wp_options` VALUES("115140", "_transient_timeout_wc_review_count_941477046755", "1490081377", "no");
INSERT INTO `wp_options` VALUES("115141", "_transient_wc_review_count_941477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115142", "_transient_timeout_wc_related_4_941477046755", "1490081378", "no");
INSERT INTO `wp_options` VALUES("115143", "_transient_wc_related_4_941477046755", "a:2:{i:0;s:2:\"98\";i:1;s:3:\"101\";}", "no");
INSERT INTO `wp_options` VALUES("115149", "_transient_timeout_wc_product_children_185", "1490085765", "no");
INSERT INTO `wp_options` VALUES("115150", "_transient_wc_product_children_185", "a:1:{s:7:\"visible\";a:1:{i:0;i:1954;}}", "no");
INSERT INTO `wp_options` VALUES("115151", "_transient_timeout_wc_var_prices633119821cdd60d583b6111477046755", "1490085765", "no");
INSERT INTO `wp_options` VALUES("115152", "_transient_wc_var_prices633119821cdd60d583b6111477046755", "a:3:{s:5:\"price\";a:1:{i:1954;s:6:\"418.20\";}s:13:\"regular_price\";a:1:{i:1954;s:6:\"418.20\";}s:10:\"sale_price\";a:1:{i:1954;s:6:\"418.20\";}}", "no");
INSERT INTO `wp_options` VALUES("115153", "_transient_timeout_wc_rating_count_1851477046755", "1490085765", "no");
INSERT INTO `wp_options` VALUES("115154", "_transient_wc_rating_count_1851477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115155", "_transient_timeout_wc_average_rating_1851477046755", "1490085766", "no");
INSERT INTO `wp_options` VALUES("115156", "_transient_wc_average_rating_1851477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115157", "_transient_timeout_wc_var_prices91a10bd4ae0b45920a6c3f1477046755", "1490085767", "no");
INSERT INTO `wp_options` VALUES("115158", "_transient_wc_var_prices91a10bd4ae0b45920a6c3f1477046755", "a:3:{s:5:\"price\";a:1:{i:1954;d:418.19999999999998863131622783839702606201171875;}s:13:\"regular_price\";a:1:{i:1954;d:418.19999999999998863131622783839702606201171875;}s:10:\"sale_price\";a:1:{i:1954;d:418.19999999999998863131622783839702606201171875;}}", "no");
INSERT INTO `wp_options` VALUES("115159", "_transient_timeout_wc_product_children_63", "1490085768", "no");
INSERT INTO `wp_options` VALUES("115160", "_transient_wc_product_children_63", "a:1:{s:7:\"visible\";a:1:{i:0;i:1967;}}", "no");
INSERT INTO `wp_options` VALUES("115161", "_transient_timeout_wc_var_pricesf89d09d9e5729dbae839011477046755", "1490085768", "no");
INSERT INTO `wp_options` VALUES("115162", "_transient_wc_var_pricesf89d09d9e5729dbae839011477046755", "a:3:{s:5:\"price\";a:1:{i:1967;s:5:\"418.2\";}s:13:\"regular_price\";a:1:{i:1967;s:5:\"418.2\";}s:10:\"sale_price\";a:1:{i:1967;s:5:\"418.2\";}}", "no");
INSERT INTO `wp_options` VALUES("115163", "_transient_timeout_wc_rating_count_631477046755", "1490085769", "no");
INSERT INTO `wp_options` VALUES("115164", "_transient_wc_rating_count_631477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115165", "_transient_timeout_wc_average_rating_631477046755", "1490085769", "no");
INSERT INTO `wp_options` VALUES("115166", "_transient_wc_average_rating_631477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115167", "_transient_timeout_wc_var_prices6d7dba9f8213164f8479971477046755", "1490085770", "no");
INSERT INTO `wp_options` VALUES("115168", "_transient_wc_var_prices6d7dba9f8213164f8479971477046755", "a:3:{s:5:\"price\";a:1:{i:1967;d:418.19999999999998863131622783839702606201171875;}s:13:\"regular_price\";a:1:{i:1967;d:418.19999999999998863131622783839702606201171875;}s:10:\"sale_price\";a:1:{i:1967;d:418.19999999999998863131622783839702606201171875;}}", "no");
INSERT INTO `wp_options` VALUES("115169", "_transient_timeout_wc_review_count_20031477046755", "1490085816", "no");
INSERT INTO `wp_options` VALUES("115170", "_transient_wc_review_count_20031477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115171", "_transient_timeout_wc_related_4_20031477046755", "1490085816", "no");
INSERT INTO `wp_options` VALUES("115172", "_transient_wc_related_4_20031477046755", "a:1:{i:0;s:4:\"2365\";}", "no");
INSERT INTO `wp_options` VALUES("115173", "_transient_timeout_wc_review_count_24791477046755", "1490085896", "no");
INSERT INTO `wp_options` VALUES("115174", "_transient_wc_review_count_24791477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115175", "_transient_timeout_wc_related_4_24791477046755", "1490085897", "no");
INSERT INTO `wp_options` VALUES("115176", "_transient_wc_related_4_24791477046755", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115177", "_transient_timeout_wc_review_count_23651477046755", "1490086004", "no");
INSERT INTO `wp_options` VALUES("115178", "_transient_wc_review_count_23651477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115179", "_transient_timeout_wc_related_4_23651477046755", "1490086005", "no");
INSERT INTO `wp_options` VALUES("115180", "_transient_wc_related_4_23651477046755", "a:1:{i:0;s:4:\"2003\";}", "no");
INSERT INTO `wp_options` VALUES("115186", "_transient_timeout_wc_review_count_23601477046755", "1490089200", "no");
INSERT INTO `wp_options` VALUES("115187", "_transient_wc_review_count_23601477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115188", "_transient_timeout_wc_related_4_23601477046755", "1490089201", "no");
INSERT INTO `wp_options` VALUES("115189", "_transient_wc_related_4_23601477046755", "a:4:{i:0;s:2:\"68\";i:1;s:3:\"900\";i:2;s:4:\"1999\";i:3;s:4:\"2005\";}", "no");
INSERT INTO `wp_options` VALUES("115193", "_transient_timeout_wc_review_count_2001477046755", "1490091454", "no");
INSERT INTO `wp_options` VALUES("115194", "_transient_wc_review_count_2001477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115195", "_transient_timeout_wc_related_4_2001477046755", "1490091454", "no");
INSERT INTO `wp_options` VALUES("115196", "_transient_wc_related_4_2001477046755", "a:2:{i:0;s:3:\"202\";i:1;s:4:\"2386\";}", "no");
INSERT INTO `wp_options` VALUES("115205", "_transient_timeout_wc_review_count_20121477046755", "1490099365", "no");
INSERT INTO `wp_options` VALUES("115206", "_transient_wc_review_count_20121477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115207", "_transient_timeout_wc_related_4_20121477046755", "1490099365", "no");
INSERT INTO `wp_options` VALUES("115208", "_transient_wc_related_4_20121477046755", "a:4:{i:0;s:2:\"68\";i:1;s:3:\"900\";i:2;s:4:\"1999\";i:3;s:4:\"2005\";}", "no");
INSERT INTO `wp_options` VALUES("115211", "_transient_timeout_wc_uf_pid_da00de0fe1550aaa3c2d002bc8ca1576", "1490101525", "no");
INSERT INTO `wp_options` VALUES("115212", "_transient_wc_uf_pid_da00de0fe1550aaa3c2d002bc8ca1576", "a:8:{i:0;i:191;i:1;i:190;i:2;i:189;i:3;i:188;i:4;i:187;i:5;i:186;i:6;i:185;i:7;i:63;}", "no");
INSERT INTO `wp_options` VALUES("115215", "_transient_timeout_wc_review_count_981477046755", "1490101818", "no");
INSERT INTO `wp_options` VALUES("115216", "_transient_wc_review_count_981477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115217", "_transient_timeout_wc_related_4_981477046755", "1490101818", "no");
INSERT INTO `wp_options` VALUES("115218", "_transient_wc_related_4_981477046755", "a:2:{i:0;s:2:\"94\";i:1;s:3:\"101\";}", "no");
INSERT INTO `wp_options` VALUES("115220", "_transient_timeout_wc_uf_pid_2192e7467fde24771066ca8e3e5fb7d9", "1490102954", "no");
INSERT INTO `wp_options` VALUES("115221", "_transient_wc_uf_pid_2192e7467fde24771066ca8e3e5fb7d9", "a:1:{i:0;i:2479;}", "no");
INSERT INTO `wp_options` VALUES("115234", "_transient_timeout_wc_review_count_19991477046755", "1490112449", "no");
INSERT INTO `wp_options` VALUES("115235", "_transient_wc_review_count_19991477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115236", "_transient_timeout_wc_related_4_19991477046755", "1490112450", "no");
INSERT INTO `wp_options` VALUES("115237", "_transient_wc_related_4_19991477046755", "a:4:{i:0;s:2:\"68\";i:1;s:3:\"900\";i:2;s:4:\"2005\";i:3;s:4:\"2009\";}", "no");
INSERT INTO `wp_options` VALUES("115243", "_transient_timeout_wc_uf_pid_a1e7d3becae72f6cc49f1fd76d12d763", "1490116943", "no");
INSERT INTO `wp_options` VALUES("115244", "_transient_wc_uf_pid_a1e7d3becae72f6cc49f1fd76d12d763", "a:28:{i:0;i:2669;i:1;i:2664;i:2;i:2479;i:3;i:2386;i:4;i:2370;i:5;i:2365;i:6;i:2360;i:7;i:2348;i:8;i:2012;i:9;i:2009;i:10;i:2005;i:11;i:2003;i:12;i:1999;i:13;i:900;i:14;i:202;i:15;i:200;i:16;i:191;i:17;i:190;i:18;i:189;i:19;i:188;i:20;i:187;i:21;i:186;i:22;i:185;i:23;i:101;i:24;i:94;i:25;i:68;i:26;i:63;i:27;i:98;}", "no");
INSERT INTO `wp_options` VALUES("115248", "_transient_timeout_wc_review_count_2021477046755", "1490118626", "no");
INSERT INTO `wp_options` VALUES("115249", "_transient_wc_review_count_2021477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115250", "_transient_timeout_wc_related_4_2021477046755", "1490118626", "no");
INSERT INTO `wp_options` VALUES("115251", "_transient_wc_related_4_2021477046755", "a:2:{i:0;s:3:\"200\";i:1;s:4:\"2386\";}", "no");
INSERT INTO `wp_options` VALUES("115255", "_transient_timeout_wc_tax_rates_e5b1e240a037662143a4964ec39afff4", "1488133286", "no");
INSERT INTO `wp_options` VALUES("115256", "_transient_wc_tax_rates_e5b1e240a037662143a4964ec39afff4", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115260", "_transient_timeout_wc_tax_rates_ef89968104b2edcadaa5fbadf0d41dcd", "1488136187", "no");
INSERT INTO `wp_options` VALUES("115261", "_transient_wc_tax_rates_ef89968104b2edcadaa5fbadf0d41dcd", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115265", "_transient_timeout_wc_review_count_681477046755", "1490126890", "no");
INSERT INTO `wp_options` VALUES("115266", "_transient_wc_review_count_681477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115267", "_transient_timeout_wc_related_4_681477046755", "1490126890", "no");
INSERT INTO `wp_options` VALUES("115268", "_transient_wc_related_4_681477046755", "a:4:{i:0;s:3:\"900\";i:1;s:4:\"1999\";i:2;s:4:\"2005\";i:3;s:4:\"2009\";}", "no");
INSERT INTO `wp_options` VALUES("115269", "_transient_timeout_wc_uf_pid_66c0aeb86f35d88ec3ce7f960958a5f0", "1490127203", "no");
INSERT INTO `wp_options` VALUES("115270", "_transient_wc_uf_pid_66c0aeb86f35d88ec3ce7f960958a5f0", "a:9:{i:0;i:2370;i:1;i:2360;i:2;i:2348;i:3;i:2012;i:4;i:2009;i:5;i:2005;i:6;i:1999;i:7;i:900;i:8;i:68;}", "no");
INSERT INTO `wp_options` VALUES("115281", "_transient_timeout_wc_tax_rates_ff768ce0b9f3948e3e982a4ab01f4047", "1488148916", "no");
INSERT INTO `wp_options` VALUES("115282", "_transient_wc_tax_rates_ff768ce0b9f3948e3e982a4ab01f4047", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115290", "_transient_timeout_wc_review_count_1011477046755", "1490138206", "no");
INSERT INTO `wp_options` VALUES("115291", "_transient_wc_review_count_1011477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115292", "_transient_timeout_wc_related_4_1011477046755", "1490138207", "no");
INSERT INTO `wp_options` VALUES("115293", "_transient_wc_related_4_1011477046755", "a:2:{i:0;s:2:\"94\";i:1;s:2:\"98\";}", "no");
INSERT INTO `wp_options` VALUES("115299", "_transient_timeout_wc_review_count_1851477046755", "1490142472", "no");
INSERT INTO `wp_options` VALUES("115300", "_transient_wc_review_count_1851477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115301", "_transient_timeout_wc_related_4_1851477046755", "1490142473", "no");
INSERT INTO `wp_options` VALUES("115302", "_transient_wc_related_4_1851477046755", "a:4:{i:0;s:2:\"63\";i:1;s:3:\"186\";i:2;s:3:\"187\";i:3;s:3:\"188\";}", "no");
INSERT INTO `wp_options` VALUES("115305", "_transient_timeout_wc_review_count_23481477046755", "1490143862", "no");
INSERT INTO `wp_options` VALUES("115306", "_transient_wc_review_count_23481477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115307", "_transient_timeout_wc_related_4_23481477046755", "1490143862", "no");
INSERT INTO `wp_options` VALUES("115308", "_transient_wc_related_4_23481477046755", "a:4:{i:0;s:2:\"68\";i:1;s:3:\"900\";i:2;s:4:\"1999\";i:3;s:4:\"2005\";}", "no");
INSERT INTO `wp_options` VALUES("115314", "_transient_timeout_wc_tax_rates_213ed17fea9cbab148261f06454c1ff8", "1488161423", "no");
INSERT INTO `wp_options` VALUES("115315", "_transient_wc_tax_rates_213ed17fea9cbab148261f06454c1ff8", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115319", "_transient_timeout_wc_review_count_631477046755", "1490150637", "no");
INSERT INTO `wp_options` VALUES("115320", "_transient_wc_review_count_631477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115321", "_transient_timeout_wc_related_4_631477046755", "1490150638", "no");
INSERT INTO `wp_options` VALUES("115322", "_transient_wc_related_4_631477046755", "a:4:{i:0;s:3:\"185\";i:1;s:3:\"186\";i:2;s:3:\"187\";i:3;s:3:\"188\";}", "no");
INSERT INTO `wp_options` VALUES("115325", "_transient_timeout_wc_tax_rates_5cde913238c44c1b7a425ae1d52033cd", "1488164833", "no");
INSERT INTO `wp_options` VALUES("115326", "_transient_wc_tax_rates_5cde913238c44c1b7a425ae1d52033cd", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115329", "_transient_timeout_wc_uf_pid_964a1e6f5509a94bd0380f0f82ea3a00", "1490154536", "no");
INSERT INTO `wp_options` VALUES("115330", "_transient_wc_uf_pid_964a1e6f5509a94bd0380f0f82ea3a00", "a:5:{i:0;i:188;i:1;i:187;i:2;i:186;i:3;i:185;i:4;i:63;}", "no");
INSERT INTO `wp_options` VALUES("115332", "_transient_timeout_wc_review_count_23861477046755", "1490154785", "no");
INSERT INTO `wp_options` VALUES("115333", "_transient_wc_review_count_23861477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115334", "_transient_timeout_wc_related_4_23861477046755", "1490154785", "no");
INSERT INTO `wp_options` VALUES("115335", "_transient_wc_related_4_23861477046755", "a:2:{i:0;s:3:\"200\";i:1;s:3:\"202\";}", "no");
INSERT INTO `wp_options` VALUES("115344", "_transient_timeout_wc_review_count_1891477046755", "1490160818", "no");
INSERT INTO `wp_options` VALUES("115345", "_transient_wc_review_count_1891477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115346", "_transient_timeout_wc_related_4_1891477046755", "1490160818", "no");
INSERT INTO `wp_options` VALUES("115347", "_transient_wc_related_4_1891477046755", "a:4:{i:0;s:2:\"63\";i:1;s:3:\"185\";i:2;s:3:\"186\";i:3;s:3:\"187\";}", "no");
INSERT INTO `wp_options` VALUES("115348", "_transient_timeout_wc_tax_rates_327567dddd261d38ce55f34849757944", "1488173790", "no");
INSERT INTO `wp_options` VALUES("115349", "_transient_wc_tax_rates_327567dddd261d38ce55f34849757944", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("115353", "_transient_timeout_wc_uf_pid_654b81daa139e694d3c0aa754d462534", "1490162804", "no");
INSERT INTO `wp_options` VALUES("115354", "_transient_wc_uf_pid_654b81daa139e694d3c0aa754d462534", "a:2:{i:0;i:2365;i:1;i:2003;}", "no");
INSERT INTO `wp_options` VALUES("115358", "_transient_timeout_wc_review_count_1881477046755", "1490164804", "no");
INSERT INTO `wp_options` VALUES("115359", "_transient_wc_review_count_1881477046755", "0", "no");
INSERT INTO `wp_options` VALUES("115360", "_transient_timeout_wc_related_4_1881477046755", "1490164808", "no");
INSERT INTO `wp_options` VALUES("115361", "_transient_wc_related_4_1881477046755", "a:4:{i:0;s:2:\"63\";i:1;s:3:\"185\";i:2;s:3:\"186\";i:3;s:3:\"187\";}", "no");
INSERT INTO `wp_options` VALUES("115362", "_site_transient_timeout_ewt_readme", "1487577042", "yes");
INSERT INTO `wp_options` VALUES("115363", "_site_transient_ewt_readme", "== Deprecation ==\n\nThis plugin is deprecated in favour of a newer version. Please update to using\nhttps://github.com/envato/wp-envato-market as there will no longer be any\nbugfixes or support for this version.\n\n=== Envato WordPress Toolkit ===\nContributors: envato, valendesigns\nTags: install, update, api, envato, theme, upgrade\nRequires at least: 3.7\nTested up to: 4.5\nStable tag: 1.7.3\n\nWordPress toolkit for Envato Marketplace hosted items. Currently supports the following theme functionality: install, upgrade, & backups during upgrade.\n\n== Description ==\n\nThis toolkit plugin establishes an Envato Marketplace API connection to take advantage of the new `wp-list-themes` & `wp-download` methods created specifically for this plugin. These API methods grants access to information about your purchased themes and create temporary download URL\'s for installing and upgrading those themes. Basically, users that have purchased themes from ThemeForest.net can now install and upgrade any theme that takes advantage of these new methods.\n\nFor end users, all that\'s required to get started is an Envato Marketplace username & API key, and to have purchased one of the many WordPress themes found on ThemeForest.net.\n\nFor theme authors, navigate to your theme\'s admin page on ThemeForest.net and click edit; you\'ll need to upload the `Optional WordPress Theme` ZIP which contains your installable WordPress Theme. Once you\'ve got an installable ZIP uploaded and approved, users can install & update directly from within WordPress. Also, to take advantage of the update functionality you\'ll need to increment your themes version in the style.css every time a new version is available for download and repeat the process above of uploading an installable ZIP.\n\nBelow is a description of the new api-key protected Envato Marketplace API methods or sets. For full documentation on how to use the API go to http://marketplace.envato.com/api/documentation and have a look at the examples.\n\n`wp-list-themes`\n* Details of all WordPress themes you have purchased. Contains the item ID, item name, theme name, author name & version.\n\n`wp-download`\n* Temporary download URL to a WordPress item you have purchased. Requires the item ID, e.g. wp-download:1234.\n\n== Installation ==\n\n1. Upload the `envato-wordpress-toolkit` folder to the `/wp-content/plugins/` directory.\n2. Activate the plugin through the `Plugins` menu in WordPress.\n3. To establish an Envato Marketplace API connection navigate to the `Envato Toolkit` page and insert your Marketplace username and secret API key in the designated input fields. To obtain your API Key, visit your \"My Settings\" page on any of the Envato Marketplaces.\n4. Once the API connection has been established you will see a list of themes that can be auto installed. If you don\'t see any themes and are certain you\'ve done everything correct, there is a good chance the theme author has not updated their theme to be available for auto install and update. If that\'s the case, please contact the theme author and ask them to update their theme\'s information.\n\n== Changelog ==\n\n= 1.7.3 =\n* Added a custom user agent to all API requests so a connection is once again possible.\n* Added the option to turn sslverify on and off.\n* Envato API requests are now using HTTPS endpoints.\n* Replace `wp_remote_request` with `wp_safe_remote_request`, which will validated the API url.\n* Lowered the API request timeout to something more reasonable.\n\n= 1.7.2 =\n* Added checks to stop PHP from throwing redeclare class errors.\n* Fix an issue where the `ZipArchive` class was called before the `class_exists` check.\n* Fixed the Github Updater class so it now shows updates on `update-core.php`.\n* Changed the Github Updater class to pull in the contents of `readme.txt` to build the config array.\n* Changed the `raw_url` in `_admin_update_check` to use `raw.githubusercontent`, because `raw.github` causes a second `http` request.\n\n= 1.7.1 =\n* Fixed: Stop Mojo Marketplace from tracking your movements and causing long or hanging page loads.\n* Fixed: Fix an issue that caused the timeout to be set high globally.\n* Added: Ability to deactivate the Github Updater.\n* Fixed: Stopped `wp_list_themes` from making an API request before credentials have been entered into WordPress.\n* Fixed: Changed the menu position and load priority to stop Mojo Marketplace from hiding the Envato Toolkit menu item.\n* Fixed: Switched from `.png` to a font icon, which makes it Admin Color Scheme compatible.\n* Added: New i18n file and changed the domain from `envato` to `envato-wordpress-toolkit` to avoid potential conflicts.\n* Fixed: Changed the UI so it now has tabs for better content separation.\n* Fixed: Now uses the Customizer to preview installed themes.\n\n= 1.7.0 =\n* Fixed: Converted transient names into hashes to comply with character limits.\n* Fixed: Invalid argument supplied foreach warning.\n* Fixed: Call to undefined function wp_create_nonce.\n* Fixed: Changed the WP_GitHub_Updater class so it will properly name the directory.\n* Fixed: Decompression error caused by gzinflate().\n\n= 1.6.3 =\n* Fixed: Conflict with the WP-Compatibility Installer plugin.\n\n= 1.6.2 =\n* Fixed: Conflict with other plugins using the GitHub updater.\n\n= 1.6.1 =\n* set_time_limit errors are now hidden in favor of a more user-friendly message.\n* Make error notices dismissible.\n\n= 1.6 =\n* Fixed: Bug that prevented updating if backups were enabled.\n* Added auto-updating.\n* Various bug fixes.\n\n= 1.5 =\n* Changed use of cURL to the WordPress HTTP API\n* Removed ini_set usage\n\n= 1.4 =\n* Added support for theme backups during upgrade.\n* Allow backups to be turned off from within the UI.\n\n= 1.3 =\n* Added caching to the Envato Marketplace API requests.\n* Added support for Multisite.\n\n= 1.2 =\n* Updated register_setting group ID bug.\n\n= 1.1 =\n* Gutted the unnecessary files and classes.\n* Renamed the plugin and moved functions into a single class.\n* Updated strings for future Internationalization.\n\n= 1.0 =\n* Initial release with auto theme install and update.\n* Force an increase on \'max_execution_time\' to ensure large themes finish downloading.\n", "yes");
INSERT INTO `wp_options` VALUES("115364", "_site_transient_timeout_ewt_github_data", "1487577044", "yes");
INSERT INTO `wp_options` VALUES("115365", "_site_transient_ewt_github_data", "O:8:\"stdClass\":71:{s:2:\"id\";i:2558893;s:4:\"name\";s:24:\"envato-wordpress-toolkit\";s:9:\"full_name\";s:31:\"envato/envato-wordpress-toolkit\";s:5:\"owner\";O:8:\"stdClass\":17:{s:5:\"login\";s:6:\"envato\";s:2:\"id\";i:14786;s:10:\"avatar_url\";s:49:\"https://avatars.githubusercontent.com/u/14786?v=3\";s:11:\"gravatar_id\";s:0:\"\";s:3:\"url\";s:35:\"https://api.github.com/users/envato\";s:8:\"html_url\";s:25:\"https://github.com/envato\";s:13:\"followers_url\";s:45:\"https://api.github.com/users/envato/followers\";s:13:\"following_url\";s:58:\"https://api.github.com/users/envato/following{/other_user}\";s:9:\"gists_url\";s:51:\"https://api.github.com/users/envato/gists{/gist_id}\";s:11:\"starred_url\";s:58:\"https://api.github.com/users/envato/starred{/owner}{/repo}\";s:17:\"subscriptions_url\";s:49:\"https://api.github.com/users/envato/subscriptions\";s:17:\"organizations_url\";s:40:\"https://api.github.com/users/envato/orgs\";s:9:\"repos_url\";s:41:\"https://api.github.com/users/envato/repos\";s:10:\"events_url\";s:52:\"https://api.github.com/users/envato/events{/privacy}\";s:19:\"received_events_url\";s:51:\"https://api.github.com/users/envato/received_events\";s:4:\"type\";s:12:\"Organization\";s:10:\"site_admin\";b:0;}s:7:\"private\";b:0;s:8:\"html_url\";s:50:\"https://github.com/envato/envato-wordpress-toolkit\";s:11:\"description\";s:78:\"Wordpress toolkit for authors of items available from the Envato Market sites.\";s:4:\"fork\";b:0;s:3:\"url\";s:60:\"https://api.github.com/repos/envato/envato-wordpress-toolkit\";s:9:\"forks_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/forks\";s:8:\"keys_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/keys{/key_id}\";s:17:\"collaborators_url\";s:89:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/collaborators{/collaborator}\";s:9:\"teams_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/teams\";s:9:\"hooks_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/hooks\";s:16:\"issue_events_url\";s:83:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues/events{/number}\";s:10:\"events_url\";s:67:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/events\";s:13:\"assignees_url\";s:77:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/assignees{/user}\";s:12:\"branches_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/branches{/branch}\";s:8:\"tags_url\";s:65:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/tags\";s:9:\"blobs_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/blobs{/sha}\";s:12:\"git_tags_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/tags{/sha}\";s:12:\"git_refs_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/refs{/sha}\";s:9:\"trees_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/trees{/sha}\";s:12:\"statuses_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/statuses/{sha}\";s:13:\"languages_url\";s:70:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/languages\";s:14:\"stargazers_url\";s:71:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/stargazers\";s:16:\"contributors_url\";s:73:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/contributors\";s:15:\"subscribers_url\";s:72:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/subscribers\";s:16:\"subscription_url\";s:73:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/subscription\";s:11:\"commits_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/commits{/sha}\";s:15:\"git_commits_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/commits{/sha}\";s:12:\"comments_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/comments{/number}\";s:17:\"issue_comment_url\";s:85:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues/comments{/number}\";s:12:\"contents_url\";s:77:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/contents/{+path}\";s:11:\"compare_url\";s:84:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/compare/{base}...{head}\";s:10:\"merges_url\";s:67:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/merges\";s:11:\"archive_url\";s:83:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/{archive_format}{/ref}\";s:13:\"downloads_url\";s:70:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/downloads\";s:10:\"issues_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues{/number}\";s:9:\"pulls_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/pulls{/number}\";s:14:\"milestones_url\";s:80:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/milestones{/number}\";s:17:\"notifications_url\";s:100:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/notifications{?since,all,participating}\";s:10:\"labels_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/labels{/name}\";s:12:\"releases_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/releases{/id}\";s:15:\"deployments_url\";s:72:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/deployments\";s:10:\"created_at\";s:20:\"2011-10-11T22:58:26Z\";s:10:\"updated_at\";s:20:\"2017-02-13T17:37:56Z\";s:9:\"pushed_at\";s:20:\"2016-05-25T19:59:38Z\";s:7:\"git_url\";s:52:\"git://github.com/envato/envato-wordpress-toolkit.git\";s:7:\"ssh_url\";s:50:\"git@github.com:envato/envato-wordpress-toolkit.git\";s:9:\"clone_url\";s:54:\"https://github.com/envato/envato-wordpress-toolkit.git\";s:7:\"svn_url\";s:50:\"https://github.com/envato/envato-wordpress-toolkit\";s:8:\"homepage\";s:0:\"\";s:4:\"size\";i:237;s:16:\"stargazers_count\";i:362;s:14:\"watchers_count\";i:362;s:8:\"language\";s:3:\"PHP\";s:10:\"has_issues\";b:1;s:13:\"has_downloads\";b:1;s:8:\"has_wiki\";b:1;s:9:\"has_pages\";b:0;s:11:\"forks_count\";i:165;s:10:\"mirror_url\";N;s:17:\"open_issues_count\";i:83;s:5:\"forks\";i:165;s:11:\"open_issues\";i:83;s:8:\"watchers\";i:362;s:14:\"default_branch\";s:6:\"master\";s:12:\"organization\";O:8:\"stdClass\":17:{s:5:\"login\";s:6:\"envato\";s:2:\"id\";i:14786;s:10:\"avatar_url\";s:49:\"https://avatars.githubusercontent.com/u/14786?v=3\";s:11:\"gravatar_id\";s:0:\"\";s:3:\"url\";s:35:\"https://api.github.com/users/envato\";s:8:\"html_url\";s:25:\"https://github.com/envato\";s:13:\"followers_url\";s:45:\"https://api.github.com/users/envato/followers\";s:13:\"following_url\";s:58:\"https://api.github.com/users/envato/following{/other_user}\";s:9:\"gists_url\";s:51:\"https://api.github.com/users/envato/gists{/gist_id}\";s:11:\"starred_url\";s:58:\"https://api.github.com/users/envato/starred{/owner}{/repo}\";s:17:\"subscriptions_url\";s:49:\"https://api.github.com/users/envato/subscriptions\";s:17:\"organizations_url\";s:40:\"https://api.github.com/users/envato/orgs\";s:9:\"repos_url\";s:41:\"https://api.github.com/users/envato/repos\";s:10:\"events_url\";s:52:\"https://api.github.com/users/envato/events{/privacy}\";s:19:\"received_events_url\";s:51:\"https://api.github.com/users/envato/received_events\";s:4:\"type\";s:12:\"Organization\";s:10:\"site_admin\";b:0;}s:13:\"network_count\";i:165;s:17:\"subscribers_count\";i:99;}", "yes");
INSERT INTO `wp_options` VALUES("115368", "_transient_timeout_wc_admin_report", "1487659848", "no");
INSERT INTO `wp_options` VALUES("115369", "_transient_wc_admin_report", "a:1:{s:32:\"3e1df4eb44df228f8307bdc2f8af1aa3\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("115371", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1487616676", "no");
INSERT INTO `wp_options` VALUES("115372", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Feb 2017 15:58:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.8-alpha-40080\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.7.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jan 2017 19:34:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4676\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"WordPress 4.7.2 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7.1 and earlier are affected by three security issues: The user interface for assigning taxonomy terms in Press This is shown to users who do not have permissions to use it. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2142:\"<p>WordPress 4.7.2 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7.1 and earlier are affected by three security issues:</p>\n<ol>\n<li>The user interface for assigning taxonomy terms in Press This is shown to users who do not have permissions to use it. Reported by David Herrera of <a href=\"https://www.alleyinteractive.com/\">Alley Interactive</a>.</li>\n<li><code>WP_Query</code> is vulnerable to a SQL injection (SQLi) when passing unsafe data. WordPress core is not directly vulnerable to this issue, but we&#8217;ve added hardening to prevent plugins and themes from accidentally causing a vulnerability. Reported by <a href=\"https://github.com/mjangda\">Mo Jangda</a> (batmoo).</li>\n<li>A cross-site scripting (XSS) vulnerability was discovered in the posts list table. Reported by <a href=\"https://iandunn.name/\">Ian Dunn</a> of the WordPress Security Team.</li>\n<li>An unauthenticated privilege escalation vulnerability was discovered in a REST API endpoint. Reported by <a href=\"https://twitter.com/MarcS0h\">Marc-Alexandre Montpas</a> of Sucuri Security. *</li>\n</ol>\n<p>Thank you to the reporters of these issues for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.2.</p>\n<p>Thanks to everyone who contributed to 4.7.2.</p>\n<p>* Update: An additional serious vulnerability was fixed in this release and public disclosure was delayed. For more information on this vulnerability, additional mitigation steps taken, and an explanation for why disclosure was delayed, please read <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\">Disclosure of Additional Security Fix in WordPress 4.7.2</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4676\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 4.7 has been downloaded over 10 million times since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7 and earlier are affected by eight security issues: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6520:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n	\n\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 4.7 “Vaughan”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2016/12/vaughan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 19:27:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4596\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah \"Sassy\" Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2016/12/starter-content.mp4\";s:6:\"length\";s:7:\"3736020\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\";s:6:\"length\";s:7:\"1127483\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://wordpress.org/news/files/2016/12/video-headers.mp4\";s:6:\"length\";s:7:\"1549803\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:45498:\"<p>Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah &#8220;Sassy&#8221; Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.</p>\n<div id=\"v-AHz0Ca46-1\" class=\"video-player\"><video id=\"v-AHz0Ca46-1-video\" width=\"632\" height=\"354\" poster=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg\" controls=\"true\" preload=\"metadata\" dir=\"ltr\" lang=\"en\"><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_dvd.mp4\" type=\"video/mp4; codecs=&quot;avc1.64001E, mp4a.40.2&quot;\" /><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_fmt1.ogv\" type=\"video/ogg; codecs=&quot;theora, vorbis&quot;\" /><div><img alt=\"Introducing WordPress 4.7\" src=\"https://i1.wp.com/videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg?resize=632%2C354&#038;ssl=1\" data-recalc-dims=\"1\" /></div><p>Introducing WordPress 4.7</p></video></div>\n<hr />\n<h2 style=\"text-align:center\">Presenting Twenty Seventeen</h2>\n<p>A brand new default theme brings your site to life with immersive featured images and video headers.</p>\n<p><img class=\"alignnone wp-image-4618 size-large\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=632%2C356&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1600&amp;ssl=1 1600w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Twenty Seventeen focuses on business sites and features a customizable front page with multiple sections. Personalize it with widgets, navigation, social menus, a logo, custom colors, and more. Our default theme for 2017 works great in many languages, on any device, and for a wide range of users.</p>\n<hr />\n<h2 style=\"text-align:center\">Your Site, Your Way</h2>\n<p>WordPress 4.7 adds new features to the customizer to help take you through the initial setup of a theme, with non-destructive live previews of all your changes in one uninterrupted workflow.</p>\n<h3>Theme Starter Content</h3>\n<div style=\"width: 632px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-4596-1\" width=\"632\" height=\"346\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/starter-content.mp4?_=1\" /><a href=\"https://wordpress.org/news/files/2016/12/starter-content.mp4\">https://wordpress.org/news/files/2016/12/starter-content.mp4</a></video></div>\n<p>To help give you a solid base to build from, individual themes can provide starter content that appears when you go to customize your brand new site. This can range from placing a business information widget in the best location to providing a sample menu with social icon links to a static front page complete with beautiful images. Don’t worry &#8211; nothing new will appear on the live site until you’re ready to save and publish your initial theme setup.</p>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Edit Shortcuts</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-2\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Edit-Shortcuts.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4?_=2\" /><a href=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\">https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4</a></video></div>\n<p>Visible icons appear to show you which parts of your site can be customized while live previewing. Click on a shortcut and get straight to editing. Paired with starter content, getting started with customizing your site is faster than ever.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Video Headers</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-3\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Header-Video.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/video-headers.mp4?_=3\" /><a href=\"https://wordpress.org/news/files/2016/12/video-headers.mp4\">https://wordpress.org/news/files/2016/12/video-headers.mp4</a></video></div>\n<p>Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</p>\n</div>\n<div style=\"clear: both\"></div>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Smoother Menu Building</h3>\n<p><img class=\"wp-image-4606 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Many menus for sites contain links to the pages of your site, but what happens when you don’t have any pages yet? Now you can add new pages while building menus instead of leaving the customizer and abandoning your changes. Once you’ve published your customizations, you’ll have new pages ready for you to fill with content.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Custom CSS</h3>\n<p><img class=\"wp-image-4607 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Sometimes you just need a few visual tweaks to make your site perfect. WordPress 4.7 allows you to add custom CSS and instantly see how your changes affect your site. The live preview allows you to work quickly without page refreshes slowing you down.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>PDF Thumbnail Previews</h3>\n<p><img class=\"wp-image-4609 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Managing your document collection is easier with WordPress 4.7. Uploading PDFs will generate thumbnail images so you can more easily distinguish between all your documents.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Dashboard in your language</h3>\n<p><img class=\"wp-image-4608 size-medium alignright\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Just because your site is in one language doesn’t mean that everybody helping manage it prefers that language for their admin. Add more languages to your site and a user language option will show up in your user’s profiles.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<h2 style=\"text-align:center\">Introducing REST API Content Endpoints</h2>\n<p>WordPress 4.7 comes with REST API endpoints for posts, comments, terms, users, meta, and settings.</p>\n<p><img class=\"size-large wp-image-4600 alignnone\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=632%2C205&#038;ssl=1\" alt=\"\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=1024%2C332&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=300%2C97&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=768%2C249&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Content endpoints provide machine-readable external access to your WordPress site with a clear, standards-driven interface, paving the way for new and innovative methods of interacting with sites through plugins, themes, apps, and beyond. Ready to get started with development? <a href=\"https://developer.wordpress.org/rest-api/reference/\">Check out the REST API reference.</a></p>\n<hr />\n<h2 style=\"text-align:center\">Even More Developer Happiness <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post Type Templates</a></h3>\n<p>By opening up the page template functionality to all post types, theme developers have even more flexibility with the WordPress template hierarchy.</p>\n<h3>More Theme API Goodies</h3>\n<p>WordPress 4.7 includes <a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">new functions, hooks, and behavior</a> for theme developers.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\">Custom Bulk Actions</a></h3>\n<p>List tables, now with more than bulk edit and delete.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\"><code>WP_Hook</code></a></h3>\n<p>The code that lies beneath actions and filters has been overhauled and modernized, fixing bugs along the way.</p>\n<h3>Settings Registration API</h3>\n<p>register_setting() <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\">has been enhanced</a> to include type, description, and REST API visibility.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Customize Changesets</a></h3>\n<p>Customize changesets make changes in the customizer persistent, like autosave drafts. They also make exciting new features like starter content possible.</p>\n<hr />\n<h2 style=\"text-align:center\">The Squad</h2>\n<p>This release was led by <a href=\"https://helen.blog\">Helen Hou-Sandí</a>, backed up by <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a> and <a href=\"http://aaron.jorb.in/\">Aaron Jorbin</a> as Release Deputies, and with the help of these fine individuals. There are 482 contributors with props in this release—the most ever—with 205 of them contributing for the first time. Pull up some sassy Sarah Vaughan on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/abrightclearweb\">abrightclearweb</a>, <a href=\"https://profiles.wordpress.org/ibachal\">Achal Jain</a>, <a href=\"https://profiles.wordpress.org/achbed\">achbed</a>, <a href=\"https://profiles.wordpress.org/acmethemes\">Acme Themes</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adammacias\">adammacias</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ahmadawais\">ahmadawais</a>, <a href=\"https://profiles.wordpress.org/airesvsg\">airesvsg</a>, <a href=\"https://profiles.wordpress.org/ajoah\">ajoah</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bj&#246;rklund</a>, <a href=\"https://profiles.wordpress.org/akshayvinchurkar\">akshayvinchurkar</a>, <a href=\"https://profiles.wordpress.org/schlessera\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/xavortm\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/ironpaperweight\">Alex Hon</a>, <a href=\"https://profiles.wordpress.org/alex27\">alex27</a>, <a href=\"https://profiles.wordpress.org/allancole\">allancole</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrewp-2\">Andreas Panag</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/kelderic\">Andy Mercer</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/aniketpant\">Aniket Pant</a>, <a href=\"https://profiles.wordpress.org/anilbasnet\">Anil Basnet</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/antisilent\">antisilent</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/zuige\">Antti Kuosmanen</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/artoliukkonen\">artoliukkonen</a>, <a href=\"https://profiles.wordpress.org/ideag\">Arunas Liuiza</a>, <a href=\"https://profiles.wordpress.org/attitude\">attitude</a>, <a href=\"https://profiles.wordpress.org/backermann\">backermann</a>, <a href=\"https://profiles.wordpress.org/b-07\">Bappi</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/binarymoon\">BinaryMoon</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw\">BjornW</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boblinthorst\">boblinthorst</a>, <a href=\"https://profiles.wordpress.org/boboudreau\">boboudreau</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/brainstormforce\">Brainstorm Force</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brianhogg\">Brian Hogg</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/bronsonquick\">Bronson Quick</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/caseypatrickdriscoll\">Casey Driscoll</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chaos-engine\">Chaos Engine</a>, <a href=\"https://profiles.wordpress.org/cheeserolls\">cheeserolls</a>, <a href=\"https://profiles.wordpress.org/chesio\">chesio</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/choongsavvii\">choong</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chredd\">chredd</a>, <a href=\"https://profiles.wordpress.org/chrisjean\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/chris_d2d\">Chris Smith</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriswiegman\">Chris Wiegman</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chriseverson\">chriseverson</a>, <a href=\"https://profiles.wordpress.org/christian1012\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/cwpnolen\">Christian Nolen</a>, <a href=\"https://profiles.wordpress.org/needle\">Christian Wach</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/clarionwpdeveloper\">Clarion Technologies</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiosmweb\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiolabarbera\">ClaudioLaBarbera</a>, <a href=\"https://profiles.wordpress.org/codemovementpk\">codemovement.pk</a>, <a href=\"https://profiles.wordpress.org/coderkevin\">coderkevin</a>, <a href=\"https://profiles.wordpress.org/codfish\">codfish</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/curdin\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/cgrymala\">Curtiss Grymala</a>, <a href=\"https://profiles.wordpress.org/cdog\">Cătălin Dogaru</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber </a>, <a href=\"https://profiles.wordpress.org/danielkanchev\">Daniel Kanchev</a>, <a href=\"https://profiles.wordpress.org/danielpietrasik\">Daniel Pietrasik</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davepullig\">Dave Pullig</a>, <a href=\"https://profiles.wordpress.org/goto10\">Dave Romsey (goto10)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/turtlepod\">David Chandra Purnama</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dglingren\">David Lingren</a>, <a href=\"https://profiles.wordpress.org/davidmosterd\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/davidbhayes\">davidbhayes</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/deeptiboddapati\">deeptiboddapati</a>, <a href=\"https://profiles.wordpress.org/delphinus\">delphinus</a>, <a href=\"https://profiles.wordpress.org/deltafactory\">deltafactory</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/pcfreak30\">Derrick Hammer</a>, <a href=\"https://profiles.wordpress.org/derrickkoo\">Derrick Koo</a>, <a href=\"https://profiles.wordpress.org/dimchik\">dimchik</a>, <a href=\"https://profiles.wordpress.org/dineshc\">Dinesh Chouhan</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipeshkakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/doughamlin\">doughamlin</a>, <a href=\"https://profiles.wordpress.org/dreamon11\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duncanjbrown\">duncanjbrown</a>, <a href=\"https://profiles.wordpress.org/dungengronovius\">dungengronovius</a>, <a href=\"https://profiles.wordpress.org/dylanauty\">DylanAuty</a>, <a href=\"https://profiles.wordpress.org/hurtige\">Eddie Hurtig</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/chopinbach\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/electricfeet\">ElectricFeet</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elyobo\">elyobo</a>, <a href=\"https://profiles.wordpress.org/enodekciw\">enodekciw</a>, <a href=\"https://profiles.wordpress.org/enshrined\">enshrined</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/pushred\">Eric Lanehart</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fencer04\">Fencer04</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/mista-flo\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/foliovision\">FolioVision</a>, <a href=\"https://profiles.wordpress.org/fomenkoandrey\">fomenkoandrey</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/frankiet\">frankiet</a>, <a href=\"https://profiles.wordpress.org/akeif\">Fred</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fuscata\">fuscata</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/geekysoft\">Geeky Software</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/goranseric\">Goran &#352;erić</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/grantderepas\">Grant Derepas</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hiddenpearls\">hiddenpearls</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hristo-sg\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/iamjolly\">iamjolly</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianedington\">Ian Edington</a>, <a href=\"https://profiles.wordpress.org/idealien\">idealien</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/imnok\">Imnok</a>, <a href=\"https://profiles.wordpress.org/implenton\">implenton</a>, <a href=\"https://profiles.wordpress.org/ionutst\">Ionut Stanciu</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/krstarica\">Ivan</a>, <a href=\"https://profiles.wordpress.org/ivdimova\">ivdimova</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakept\">Jacob Peattie</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamesacero\">jamesacero</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jaredcobb\">Jared Cobb</a>, <a href=\"https://profiles.wordpress.org/jayarjo\">jayarjo</a>, <a href=\"https://profiles.wordpress.org/jdolan\">jdolan</a>, <a href=\"https://profiles.wordpress.org/jdoubleu\">jdoubleu</a>, <a href=\"https://profiles.wordpress.org/jblz\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jimt\">jimt</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/jmusal\">jmusal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelcj91\">Joel James</a>, <a href=\"https://profiles.wordpress.org/johanmynhardt\">johanmynhardt</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/zyphonic\">John Dittmar</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"https://profiles.wordpress.org/johnregan3\">John Regan</a>, <a href=\"https://profiles.wordpress.org/johnpgreen\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/kenshino\">Jon (Kenshino)</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/daggerhart\">Jonathan Daggerhart</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>, <a href=\"https://profiles.wordpress.org/jorritschippers\">JorritSchippers</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joshcummingsdesign\">joshcummingsdesign</a>, <a href=\"https://profiles.wordpress.org/joshkadis\">joshkadis</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jrgould\">JRGould</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/nukaga\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinbusa\">Justin Busa</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jshreve\">Justin Shreve</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/kacperszurek\">kacperszurek</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kalenjohnson\">KalenJohnson</a>, <a href=\"https://profiles.wordpress.org/codebykat\">Kat Hagan</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/kellbot\">kellbot</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/koenschipper\">koenschipper</a>, <a href=\"https://profiles.wordpress.org/kokarn\">kokarn</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/kuchenundkakao\">kuchenundkakao</a>, <a href=\"https://profiles.wordpress.org/kuldipem\">kuldipem</a>, <a href=\"https://profiles.wordpress.org/laurelfulford\">Laurel Fulford</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leobaiano\">Leo Baiano</a>, <a href=\"https://profiles.wordpress.org/littlebigthing\">LittleBigThings (Csaba)</a>, <a href=\"https://profiles.wordpress.org/lucasstark\">Lucas Stark</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/lukepettway\">lukepettway</a>, <a href=\"https://profiles.wordpress.org/lyubomir_popov\">lyubomir_popov</a>, <a href=\"https://profiles.wordpress.org/mageshp\">mageshp</a>, <a href=\"https://profiles.wordpress.org/mahesh901122\">Mahesh Waghmare</a>, <a href=\"https://profiles.wordpress.org/mangeshp\">Mangesh Parte</a>, <a href=\"https://profiles.wordpress.org/manishsongirkar36\">Manish Songirkar</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/mbootsman\">Marcel Bootsman</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mariovalney\">Mario Valney</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">Mark Root-Wiley</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/markshep\">markshep</a>, <a href=\"https://profiles.wordpress.org/matrixik\">matrixik</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/jaworskimatt\">Matt Jaworski</a>, <a href=\"https://profiles.wordpress.org/mattking5000\">Matt King</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"https://profiles.wordpress.org/maximeculea\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mbelchev\">mbelchev</a>, <a href=\"https://profiles.wordpress.org/mckernanin\">mckernanin</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mhowell\">mhowell</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeviele\">Mike Viele</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/modemlooper\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/deremohan\">Mohan Dere</a>, <a href=\"https://profiles.wordpress.org/monikarao\">monikarao</a>, <a href=\"https://profiles.wordpress.org/morettigeorgiev\">morettigeorgiev</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/mrbobbybryant\">mrbobbybryant</a>, <a href=\"https://profiles.wordpress.org/nnaimov\">Naim Naimov</a>, <a href=\"https://profiles.wordpress.org/natereist\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/natewr\">NateWr</a>, <a href=\"https://profiles.wordpress.org/nathanrice\">nathanrice</a>, <a href=\"https://profiles.wordpress.org/nazgul\">Nazgul</a>, <a href=\"https://profiles.wordpress.org/greatislander\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/nikeo\">Nicolas GUILLAUME</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nullvariable\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/odie2\">odie2</a>, <a href=\"https://profiles.wordpress.org/odysseygate\">odyssey</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/orvils\">orvils</a>, <a href=\"https://profiles.wordpress.org/oskosk\">oskosk</a>, <a href=\"https://profiles.wordpress.org/ottok\">Otto Kek&#228;l&#228;inen</a>, <a href=\"https://profiles.wordpress.org/ovann86\">ovann86</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patilvikasj\">patilvikasj</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/pdufour\">pdufour</a>, <a href=\"https://profiles.wordpress.org/piewp\">Perdaan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phh\">phh</a>, <a href=\"https://profiles.wordpress.org/php\">php</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pippinsplugins\">pippinsplugins</a>, <a href=\"https://profiles.wordpress.org/pjgalbraith\">pjgalbraith</a>, <a href=\"https://profiles.wordpress.org/pkevan\">pkevan</a>, <a href=\"https://profiles.wordpress.org/pratikchaskar\">Pratik</a>, <a href=\"https://profiles.wordpress.org/pressionate\">Pressionate</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/procodewp\">procodewp</a>, <a href=\"https://profiles.wordpress.org/quasel\">quasel</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahulsprajapati\">Rahul Prajapati</a>, <a href=\"https://profiles.wordpress.org/superpoincare\">Ramanan</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/ranh\">ranh</a>, <a href=\"https://profiles.wordpress.org/redsand\">Red Sand Media Group</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rpayne7264\">Robert D Payne</a>, <a href=\"https://profiles.wordpress.org/rnoakes3rd\">Robert Noakes</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">Rocco Aliberti</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/fronaldaraujo\">Ronald Ara&#250;jo</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/guavaworks\">Roy Sivan</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ryanplas\">Ryan Plas</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/sandesh055\">Sandesh</a>, <a href=\"https://profiles.wordpress.org/smyoon315\">Sang-Min Yoon</a>, <a href=\"https://profiles.wordpress.org/sanketparmar\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/pollyplummer\">Sarah Gooding</a>, <a href=\"https://profiles.wordpress.org/sayedwp\">Sayed Taqui</a>, <a href=\"https://profiles.wordpress.org/schrapel\">schrapel</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scrappyhuborg\">scrappy@hub.org</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seancjones\">seancjones</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sgr33n\">Sergio De Falco</a>, <a href=\"https://profiles.wordpress.org/sfpt\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shayanys\">shayanys</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/shprink\">shprink</a>, <a href=\"https://profiles.wordpress.org/simonlampen\">simonlampen</a>, <a href=\"https://profiles.wordpress.org/skippy\">skippy</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/snacking\">snacking</a>, <a href=\"https://profiles.wordpress.org/soean\">Soeren Wrede</a>, <a href=\"https://profiles.wordpress.org/solal\">solal</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/sharkomatic\">Steph</a>, <a href=\"https://profiles.wordpress.org/sswells\">Steph Wells</a>, <a href=\"https://profiles.wordpress.org/sillybean\">Stephanie Leary</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stevenlinx\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/stubgo\">stubgo</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/patilswapnilv\">Swapnil V. Patil</a>, <a href=\"https://profiles.wordpress.org/swapnild\">swapnild</a>, <a href=\"https://profiles.wordpress.org/szaqal21\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tapsboy\">tapsboy</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/team\">team</a>, <a href=\"https://profiles.wordpress.org/tg29359\">tg29359</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/the\">the</a>, <a href=\"https://profiles.wordpress.org/themeshaper\">themeshaper</a>, <a href=\"https://profiles.wordpress.org/thenbrent\">thenbrent</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tierra\">tierra</a>, <a href=\"https://profiles.wordpress.org/tnash\">Tim Nash</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph\">timph</a>, <a href=\"https://profiles.wordpress.org/tkama\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tnegri\">tnegri</a>, <a href=\"https://profiles.wordpress.org/tomauger\">Tom Auger</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomdxw\">tomdxw</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/traversal\">traversal</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/nmt90\">Triet Minh</a>, <a href=\"https://profiles.wordpress.org/trishasalas\">Trisha Salas</a>, <a href=\"https://profiles.wordpress.org/tristangemus\">tristangemus</a>, <a href=\"https://profiles.wordpress.org/truongwp\">Truong Giang</a>, <a href=\"https://profiles.wordpress.org/tsl143\">tsl143</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/valeriutihai\">Valeriu Tihai</a>, <a href=\"https://profiles.wordpress.org/vishalkakadiya\">Vishal Kakadiya</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/vrundakansara-1\">Vrunda Kansara</a>, <a href=\"https://profiles.wordpress.org/webbgaraget\">webbgaraget</a>, <a href=\"https://profiles.wordpress.org/webmandesign\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/websupporter\">websupporter</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wolly\">Wolly aka Paolo Valenti</a>, <a href=\"https://profiles.wordpress.org/wraithkenny\">WraithKenny</a>, <a href=\"https://profiles.wordpress.org/yale01\">yale01</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/yogasukma\">Yoga Sukma</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, <a href=\"https://profiles.wordpress.org/vanillalounge\">Ze Fontainhas</a>, <a href=\"https://profiles.wordpress.org/zhildzik\">zhildzik</a>, and <a href=\"https://profiles.wordpress.org/zsusag\">zsusag</a>.\n<p>&nbsp;<br />\nSpecial thanks go to <a href=\"https://ramiabraham.com/\">Rami Abraham</a> for producing the release video and the many fine haiku we saw in the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">beta</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\">RC</a> announcement posts.</p>\n<p>Finally, thanks to all the community translators who worked on WordPress 4.7. Their efforts bring WordPress 4.7 fully translated to 52 languages at release time with more on the way. Additionally, the WordPress 4.7 release video has been captioned into 44 languages.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress &#8211; we hope you enjoy!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4596\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Moving Toward SSL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2016/12/moving-toward-ssl/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Dec 2016 17:20:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4588\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:327:\"We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1627:\"<p>We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle our users are going to face.</p>\n<p>SSL basically means the link between your browser and the server is encrypted. SSL used to be difficult to implement, and often expensive or slow. Modern browsers, and the incredible success of projects like <a href=\"https://letsencrypt.org/\">Let&#8217;s Encrypt</a> have made getting a certificate to secure your site fast, free, and something we think every host should support by default, especially in a post-Snowden era. Google also weighs <a href=\"https://security.googleblog.com/2014/08/https-as-ranking-signal_6.html\">SSL as a search engine ranking factor</a> and will begin <a href=\"http://motherboard.vice.com/read/google-will-soon-shame-all-websites-that-are-unencrypted-chrome-https\">flagging unencrypted sites in Chrome</a>.</p>\n<p>First, early in 2017, we will only promote hosting partners that provide a SSL certificate by default in their accounts. Later we will begin to assess which features, such as API authentication, would benefit the most from SSL and make them only enabled when SSL is there.</p>\n<p>Separately, I also think the performance improvements in PHP7 are particularly impressive, and major kudos to everyone who worked on that. We will consider whether hosts use PHP7 by default for new accounts next year as well.</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4588\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.7 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Nov 2016 04:26:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4579\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"The release candidate for WordPress 4.7 is now available. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on Tuesday, December 6, but we need your help to get there. If you haven’t tested 4.7 yet, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4331:\"<p>The release candidate for WordPress 4.7 is now available.</p>\n<p>RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on <strong>Tuesday, December 6</strong>, but we need <em>your</em> help to get there. If you haven’t tested 4.7 yet, now is the time! To test WordPress 4.7, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.7-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>WordPress 4.7 is a jam-packed release, with a number of features focused on getting a theme set up for the first time. Highlights include a <a href=\"http://2017.wordpress.net/\">new default theme</a>, video headers, custom CSS, customizer edit shortcuts, PDF thumbnail previews, user admin languages, REST API content endpoints, post type templates, and more.</p>\n<p>We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39353&amp;stop_rev=39263&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">quite a few refinements</a> since releasing Beta 4 a week ago, including usability and accessibility enhancements for video headers, media and page template support in starter content, and polishing of how custom CSS can be migrated to and extended by plugins and themes. The REST API endpoints saw a number of bugfixes and notably now have anonymous comment off by default.</p>\n<p>Not sure where to start with testing? Try setting up a fresh site on a new installation with Twenty Seventeen (hint: head into customizing your site before touching any pages or widgets) and taking notes on what you enjoyed and what got you stuck. For more details about what&#8217;s new in version 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Think you’ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.7 and update your plugin’s <em>Tested up to</em> version in the readme to 4.7. If you find compatibility problems please be sure to post to the support forums so we can figure those out before the final release – we work hard to avoid breaking things. An in-depth field guide to developer-focused changes is coming soon on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> And if you haven&#8217;t yet done so, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and send it on to your friends.</p>\n<p>Happy testing! And now for another <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a> haiku break.</p>\n<p><em>Select your language</em><br />\n<em>Then let your users choose theirs</em><br />\n<em><code>get_user_locale()</code></em></p>\n<p><em>Theme authors rejoice</em><br />\n<em>Any option may employ</em><br />\n<em>Selective refresh</em></p>\n<p><em>Custom header video</em><br />\n<em>Make sure to <code>add_theme_support</code></em><br />\n<em>Bling above the fold</em></p>\n<p><em>A new template dawns</em><br />\n<em>A hierarchy member</em><br />\n<em>Post-type templates live</em></p>\n<p><em>PDF updates</em><br />\n<em>Pack a parade of polish</em><br />\n<em>Prettier previews</em></p>\n<p><em>Template Post Type: New</em><br />\n<em>Template Post Type: And Useful</em><br />\n<em>Template Post Type: Thing</em></p>\n<p><em>Let lists live lively</em><br />\n<em>Laud <code>wp_list_sort()</code></em><br />\n<em>Less laconic lists</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2016 01:51:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4576\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2019:\"<p>WordPress 4.7 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1,</a> <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth developer guides on make/core</a>. We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39262&amp;stop_rev=39201&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">about 60 changes</a> in the last few days for beta 4, including tweaks to Twenty Seventeen, custom CSS, and the REST API content endpoints.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>We are almost there<br />\nPlease test your plugins and themes<br />\nRC coming soon<br />\n</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4576\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordCamp US 2017-2018 in Nashville\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/11/wordcamp-us-2017-2018-in-nashville/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2016 23:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4571\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:330:\"The title says it all. We had some great applications for cities to host WordCamp US after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is Nashville, Tennessee. Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1022:\"<p><img class=\"aligncenter\" src=\"https://i0.wp.com/wpdotorg.files.wordpress.com/2008/07/27492741871_c6fcebcad3_k-e1479248587522.jpg?resize=632%2C253&#038;ssl=1\" data-recalc-dims=\"1\" /></p>\n<p>The title says it all. We had some great applications for cities to host <a href=\"http://us.wordcamp.org/\">WordCamp US</a> after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is <strong>Nashville, Tennessee</strong>.</p>\n<p>Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future years as WordCamp US travels across the United States and gives us an opportunity to learn and love a new city, as we have with Philadelphia.</p>\n<p>By the way, if you haven&#8217;t yet, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and ask your friends to as well.</p>\n<p><a href=\"https://www.flickr.com/photos/143951935@N07/27492741871\">Photo Credit</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Nov 2016 03:30:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4566\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3120:\"<p>WordPress 4.7 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth field guides on make/core</a>. Some of the changes in Beta 3 include:</p>\n<ul>\n<li><strong>REST API:</strong> The <code>unfiltered_html</code> capability is now respected and <code>rest_base</code> has been added to response objects of <code>wp/v2/taxonomies</code> and <code>wp/v2/types</code>, while <code>get_allowed_query_vars()</code> and the <code>rest_get_post</code> filter have been removed.</li>\n<li><strong>Roles/Capabilities:</strong> Added meta-caps for comment, term, and user meta, which are currently only used in the REST API.</li>\n<li><strong>I18N:</strong> Added the ability to change user&#8217;s locale back to site&#8217;s locale. (<a href=\"https://core.trac.wordpress.org/ticket/38632\">#38632</a>)</li>\n<li><strong>Custom CSS:</strong> Renamed the <code>unfiltered_css</code> meta capability to <code>edit_css</code> and added revisions support to the <code>custom_css</code> post type.</li>\n<li><strong>Edit shortcuts:</strong> Theme authors should take a look at <a href=\"https://make.wordpress.org/core/2016/11/10/visible-edit-shortcuts-in-the-customizer-preview/\">the developer guide to the customizer preview&#8217;s visible edit shortcuts</a> and update their themes to take advantage of them if not already implementing selective refresh.</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39200&amp;stop_rev=39143&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">over 50 changes</a> in the last week.</li>\n</ul>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>Building the future</em><br />\n<em>A global community</em><br />\n<em>Stronger together</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Nov 2016 17:39:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4552\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4240:\"<p>WordPress 4.7 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta2.zip\">download the beta here</a> (zip).</p>\n<p>Notable changes since WordPress 4.7 Beta 1:</p>\n<ul>\n<li><strong>Twenty Seventeen:</strong> The theme wasn&#8217;t being installed on upgrades &#8211; sorry about that! Now you should see it if you&#8217;re upgrading an existing site. There are also plenty of fixes, especially for the header and small screen views.</li>\n<li><strong>Edit shortcuts:</strong> These are always visible while editing (hide them on bigger screens by collapsing the controls) and should now work properly in Firefox. (<a href=\"https://core.trac.wordpress.org/ticket/27403\">#27403</a> and <a href=\"https://core.trac.wordpress.org/ticket/38532\">#38532</a>)</li>\n<li><strong>REST API endpoints:</strong> There have been a number of changes over the past week; your attention is requested on the following:\n<ul>\n<li>The <code>DELETE</code> response format has changed and may need to be accounted for. (<a href=\"https://core.trac.wordpress.org/ticket/38494\">#38494</a>)</li>\n<li>Enabled querying by multiple post statuses. (<a href=\"https://core.trac.wordpress.org/ticket/38420\">#38420</a>)</li>\n<li>Return an error when JSON decoding fails. (<a href=\"https://core.trac.wordpress.org/ticket/38547\">#38547</a>)</li>\n</ul>\n</li>\n<li><strong>More developer notes</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2016/10/28/fine-grained-capabilities-for-taxonomy-terms-in-4-7/\">Fine grained capabilities for taxonomy terms</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/29/wp_taxonomy-in-4-7/\"><code>WP_Taxonomy</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/02/wp_list_sort-and-wp_list_util-in-4-7/\"><code>wp_list_sort()</code> and <code>WP_List_Util</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post type templates</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/new-post-type-labels-in-4-7/\">New post type labels</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/attributes-for-resource-hints-in-4-7/\">Attributes for resource hints</a></li>\n</ul>\n</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39142&amp;stop_rev=38995&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">almost 150 changes</a> in the last week.</li>\n</ul>\n<p>For more of what’s new in version 4.7, <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">check out the Beta 1 blog post</a>.</p>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing!</p>\n<p><em>Ya es la hora</em><br />\n<em> Time for another beta</em><br />\n请您帮下忙!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Oct 2016 04:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4535\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6895:\"<p>WordPress 4.7 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta1.zip\">download the beta here</a> (zip).</p>\n<p>WordPress 4.7 is slated for release on <a href=\"https://make.wordpress.org/core/4-7/\">December 6</a>, but we need your help to get there. We&#8217;ve been working on a lot of things, many of them to make getting your site set up the way you want it much easier. Here are some of the bigger items to test and help us find as many bugs as possible in the coming weeks:</p>\n<ul>\n<li><a href=\"http://2017.wordpress.net/\"><strong>Twenty Seventeen</strong></a> &#8211; A brand new default theme brings your site to life with immersive featured images, video headers, and subtle animations. With a focus on business sites, it features multiple sections on the front page as well as widgets, navigation and social menus, a logo, and more. Personalize its asymmetrical grid with a custom color scheme and showcase your multimedia content with post formats. Our default theme for 2017 works great in many languages, for any abilities, and on any device.</li>\n<li><strong>Video Headers</strong> &#8211; Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</li>\n<li><strong>Set up your site in one flow</strong> &#8211; From finding and installing themes right inside the customizer, to automatically staged theme-specific starter content, to clickable shortcuts that jump directly to editing an item from the preview pane, to adding pages while you&#8217;re building a nav menu or setting a static front page: getting a new site spun up and ready to share with a friend or a coworker is faster and easier than it&#8217;s ever been. Note: starter content appears when live previewing brand new sites and is currently only available in Twenty Seventeen. We&#8217;ll be expanding this to other bundled themes very soon, and perhaps to sites with existing content in future releases of WordPress.</li>\n<li><strong>Custom CSS with live previews</strong> &#8211; Ever needed to hide or tweak the look of something in your theme or from a plugin? Now you can do it with CSS and live preview the results while customizing your site. CSS can be a powerful tool; you may find that you won&#8217;t need the theme editor or child themes anymore.</li>\n<li><strong>User admin languages</strong> &#8211; Just because your site is in one language doesn&#8217;t mean that everybody helping manage it prefers that language for their admin. To try this out, you&#8217;ll need to have more than one language installed, which will make a user language option available in your profile.</li>\n<li><strong>PDF thumbnail previews</strong> &#8211; Uploading PDFs will now generate thumbnail images so you can more easily distinguish between all your documents.</li>\n</ul>\n<p>As always, there have been exciting changes for developers to explore as well, such as:</p>\n<ul>\n<li><strong>REST API content endpoints</strong> &#8211; If you only test one thing as a developer, please test these. This phase is particularly helpful for people building plugins, themes, and in-admin interfaces. Can you build the things you need? Are these ready for release, and is the world ready for them? (<a href=\"https://core.trac.wordpress.org/ticket/38373\">#38373</a>)</li>\n<li><strong><code>WP_Hook</code></strong> &#8211; The code that lies beneath actions and filters has been overhauled. You likely aren&#8217;t affected, but if you&#8217;ve done things to the <code>$wp_filter</code> global or experienced funky recursion bugs in the past, <a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\">please take a moment to read the dev note</a> and test your code.</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\"><strong>Custom bulk actions</strong></a> &#8211; List tables, now with more than bulk edit and delete.</li>\n<li>Expanded <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\"><strong>Settings Registration API</strong></a> via <code>register_setting()</code>.</li>\n<li>For theme developers: <strong>Post type templates</strong> (<a href=\"https://core.trac.wordpress.org/ticket/18375\">#18375</a>)</li>\n<li><strong><a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">More goodies for theme developers!</a></strong></li>\n<li><strong>Locale switching</strong> (<a href=\"https://core.trac.wordpress.org/ticket/26511\">#26511</a>)</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/11/comment-allowed-checks-in-wordpress-4-7/\"><strong>Comment allowed checks</strong></a> have the potential for a back-compat break.</li>\n</ul>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing, and please enjoy this extended haiku break, courtesy of <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a><em>.</em></p>\n<p><em>Exquisite endpoints</em><br />\n<em>Extol epic exabytes</em><br />\n<em>Enabling earthlings</em></p>\n<p><em>Careful interfaces</em><br />\n<em>Considerately conjured</em><br />\n<em>Customizer chic</em></p>\n<p><em>Ring in the new year</em><br />\n<em>With elegance and balance</em><br />\n<em>Twenty Seventeen</em></p>\n<p><em>Hooks hook healthily</em><br />\n<em>17817</em><br />\n<em>Sane iterations</em></p>\n<p><em>Admin in your tongue<br />\nOne site, many languages<br />\nWe all speak WordPress</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 20 Feb 2017 06:51:17 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 01 Feb 2017 15:58:56 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20130911040210\";}", "no");
INSERT INTO `wp_options` VALUES("115373", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1487616679", "no");
INSERT INTO `wp_options` VALUES("115374", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1487573479", "no");
INSERT INTO `wp_options` VALUES("115375", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1487616682", "no");
INSERT INTO `wp_options` VALUES("115376", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"WPTavern: Disqus Hits Sites with Unwanted Advertising, Plans to Charge Large Publishers a Monthly Fee to Remove Ads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66098\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://wptavern.com/disqus-hits-sites-with-unwanted-advertising-plans-to-charge-large-publishers-a-monthly-fee-to-remove-ads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7974:\"<p>When Disqus <a href=\"https://blog.disqus.com/our-plans-for-2017\" target=\"_blank\">announced</a> it would be releasing new, subscription-based versions later this year, users didn&#8217;t expect to have the new advertising model injected into their sites without notice. Disqus CEO Daniel Ha said the company would release finalized pricing and provide more details well in advance of its planned March release, but users are reporting that the advertising has already been forced into their comments without warning.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Why did <a href=\"https://twitter.com/disqus\">@disqus</a> just add a bunch of ads to my site without my permission? <a href=\"https://t.co/CzXTTuGs67\">https://t.co/CzXTTuGs67</a> <a href=\"https://t.co/y2QbFFzM8U\">pic.twitter.com/y2QbFFzM8U</a></p>\n<p>&mdash; Harry Campbell (@TheRideShareGuy) <a href=\"https://twitter.com/TheRideShareGuy/status/826921387273052160\">February 1, 2017</a></p></blockquote>\n<p></p>\n<p>&#8220;We are one of the lucky 5% who now has to pay if we don&#8217;t want really irrelevant and horribly spammy links just plopped on our site with zero warning,&#8221; BabyCenter Social Media Manager Dina Vernon Freeman said. &#8220;Unless our users (mainly millennial parents) should care about overpaying for dentures! We&#8217;re looking for other platforms ASAP.&#8221;</p>\n<p>Brian O&#8217;Neill, who manages Slugger O&#8217;Toole, a site with more than 70,000 readers, was also hit with unwanted advertising on his site.</p>\n<p>&#8220;Disqus has started to put ads into our comments section of our site without even telling us,&#8221; O&#8217;Neill said in a <a href=\"https://sluggerotoole.com/2017/02/02/bear-with-us-as-we-try-to-remove-those-terrible-disqus-ads-from-the-comments-area/\" target=\"_blank\">post</a> explaining the new ads to the site&#8217;s readers. &#8220;As you can imagine I am extremely annoyed at this – I hate crappy online ads as much as you do. Supposedly we can remove the ads if we pay them $10 a month, but as yet there is no mechanism on their site to do this.&#8221; O&#8217;Neill said he is also exploring alternative commenting systems if he is unable to remove the advertising.</p>\n<p>Disqus responded to user complaints with a post to clarify that <a href=\"https://blog.disqus.com/advertising-will-remain-optional-for-over-95-of-sites-on-disqus\" target=\"_blank\">advertising will remain optional for more than 95% of the sites on Disqus</a>.</p>\n<p>&#8220;Larger, commercial, sites that elect to use the free version of Disqus will be supported by configurable advertising and have the option to earn revenue through the Reveal program,&#8221; Disqus Marketing Manager Mario Paganini said. &#8220;For small, non-commercial sites, advertising will be optional. These sites will be able to use Disqus’ ads-optional subscription, free of charge.&#8221;</p>\n<p>Publishers asked in the comments when the option to pay to remove ads will become available, as an option to pay isn&#8217;t currently in place.</p>\n<p>&#8220;Larger sites will be able to run a paid subscription version of Disqus that includes the ability to remove ads along with additional features,&#8221; Paganini said. &#8220;We are aiming to have this available in the next couple of months. We will be making periodic updates on our blog and talking to publishers in the meantime.&#8221;</p>\n<p>Disqus is moving to focus on its larger publishers but has already attracted angry criticism from publishers that were not properly informed of the changes. Over the years the company has experimented with different ways of monetizing the commenting platform, often frustrating users in the process of making important changes.</p>\n<p>In 2014, Disqus began experimenting with advertising in the form of &#8220;Sponsored Comments&#8221; that users could not turn off without contacting support. This move drew <a href=\"https://ma.tt/2014/11/disqus-spam-ads/\" target=\"_blank\">criticism from WordPress co-founder Matt Mullenweg</a> who essentially called out the ads as little more than comment spam. After a negative reaction from its community, Disqus quietly discontinued the Sponsored Comments and scrubbed the <a href=\"https://blog.disqus.com/heads-up-were-testing-a-new-form-of-advertising\" target=\"_blank\">announcement post</a> from the internet.</p>\n<h3>Disqus Delivers Low-Quality Ads</h3>\n<p>Disqus has struggled to land on an effective advertising model that will convince users to get on board. Its <a href=\"https://help.disqus.com/customer/portal/articles/2069645-reveal-f-a-q-\" target=\"_blank\">Reveal advertising program</a> is notorious for serving low-quality ads and has inspired little confidence in users who have tried it. The following is one of the tamer examples:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/02/disqus-ads.png?ssl=1\"><img /></a></p>\n<p>&#8220;I think if you had somewhat decent advertising you might convince people that it&#8217;s worth it, but I had to yank it from one of my sites because it was all &#8216;Ron Paul wants you to buy gold!&#8217; and &#8217;22 times the photos showed too much!\'&#8221; Paul King, an author who writes for multiple publications, commented on Disqus&#8217; most recent advertising announcement. &#8220;Just put in a tier of non-spam advertising that&#8217;s actually relevant or charge based on comments or something.&#8221;</p>\n<p>Twitter is filled with complaints from users who are dissatisfied with the questionable quality of Disqus&#8217; advertising. Many are searching for alternatives.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/disqus\">@disqus</a> We\'ve disabled ads straight away (they are literally ALL scams) &#8211; if you force those ads on us, we\'re dropping you like a hot potato</p>\n<p>&mdash; That\'s Nonsense (@thatsnonsense) <a href=\"https://twitter.com/thatsnonsense/status/828739990486208512\">February 6, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Why <a href=\"https://twitter.com/disqus\">@disqus</a> think it\'s acceptable to serve disgusting, misogynistic ads (OR ANY ADS) on people\'s blogs without asking is beyond me.</p>\n<p>&mdash; Rosie (@RosieLondoner) <a href=\"https://twitter.com/RosieLondoner/status/828642646478426112\">February 6, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">I\'m removing <a href=\"https://twitter.com/hashtag/disqus?src=hash\">#disqus</a> from <a href=\"https://t.co/PSlovlA6Tm\">https://t.co/PSlovlA6Tm</a> since they\'ve suddenly turned on (notably creepy) ads with no warning.</p>\n<p>&mdash; James Britt <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /> (@jamesbritt) <a href=\"https://twitter.com/jamesbritt/status/826922670407172096\">February 1, 2017</a></p></blockquote>\n<p></p>\n<p>This recent move to turn on advertising without publishers&#8217; permission is another communication blunder in the same vein as the previous attempt at Sponsored Comments. Disqus has failed to find a communication strategy that respects users&#8217; content while leading the company towards its goals at the same time. With spam-quality ads deploying network-wide, the company can certainly expect that some users will be willing to pay the $10/month to turn them off. Sadly, the experience of paying to turn off offensive ads feels more like getting mugged on your way to work than upgrading your service.</p>\n<p>The <a href=\"https://wordpress.org/plugins/disqus-comment-system/\" target=\"_blank\">Disqus Comment System</a> plugin has been hovering around 200,000 active sites for the past two years and its ratings continue to plummet on WordPress.org. Unless Disqus is able to dramatically improve its advertising network before its official March release, we may see a mass exodus to other commenting systems.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Feb 2017 00:16:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: How to Check if Installed Plugins Are No Longer in the Plugin Directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66106\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/how-to-check-if-installed-plugins-are-no-longer-in-the-plugin-directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9904:\"<p>When we wrote about <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">why plugins sometimes disappear</a> from the WordPress plugin directory, it generated a healthy discussion in the comments. One of the topics of discussion brought up is whether or not <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory#comment-209733\">users should be notified</a> when a plugin disappears and if so, how?</p>\n<p>Currently, when a plugin is hidden on the directory, users are not notified. If it&#8217;s removed due to a security vulnerability and the author chooses not to fix it or move the plugin somewhere else such as <a href=\"https://github.com/\">GitHub</a>, users are left in the dark.</p>\n<p>Donna Cavalier shared a <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/\">recent example</a> of why users should be notified. Contact Form DB is a popular plugin that saves contact form submissions from many popular Contact Forms plugins to the database. As of <a href=\"https://web.archive.org/web/20161030050515/https://wordpress.org/plugins/contact-form-7-to-database-extension/\">October 30th, 2016</a>, it was actively installed on more than 400K sites.</p>\n<p>Approximately <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/\">one month ago</a>, the plugin was hidden due to a security vulnerability. Instead of releasing a patch, Michael Simpson, creator of Contact Form DB, moved the plugin <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases\">to GitHub</a> and subsequently released a <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">new version</a> that patched the vulnerability. Simpson says the person on the plugin review team that he spoke with was condescending, unprofessional, and rubbed him the wrong way.</p>\n<p>&#8220;I’m happy to address any issues and meet any standards, but I’m at the limit of my patience,&#8221; Simpson said.</p>\n<p>&#8220;I try to be a good citizen and give back to the community. I’ve put in countless hours for close to seven years now. When I’m treated like this, it seems WordPress doesn’t value me or my contribution to its community.</p>\n<p>&#8220;Anyway, I put the code on GitHub and I will continue to support it. But at this point I’m not sure I want to deal with people like this to re-list the plugin on this site. I don’t need the frustration.&#8221;</p>\n<p><strong>If you use Contact Form DB, please <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">update to 2.10.30</a> as soon as possible as it contains the aforementioned security fix.</strong></p>\n<p>It&#8217;s impossible for Contact Form DB users to automatically install updates from GitHub without installing an <a href=\"https://wptavern.com/github-updater-4-1-to-add-remote-installation-for-wordpress-plugins-and-themes\">updater plugin</a>. This leaves thousands of sites at risk.</p>\n<h2>How to Know When Installed Plugins Are No Longer in the Directory</h2>\n<p>In the comments of <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">our article</a>, Tavern reader Central Geek <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory#comment-209776\">shared links</a> to a couple of plugins aimed at providing useful information such as, whether a <a href=\"https://wordpress.org/plugins/vendi-abandoned-plugin-check/\">plugin has been abandoned</a> and <a href=\"https://wordpress.org/plugins/better-plugin-compatibility-control/\">better plugin compatibility information</a>.</p>\n<p>One of the plugins he mentions is called <a href=\"https://wordpress.org/plugins/no-longer-in-directory/\">No Longer in Directory, </a>developed by <a href=\"https://profiles.wordpress.org/whitefirdesign/\">White Fir Design</a>. The plugin adds a page to the WordPress backend that informs users if any of the plugins that are installed are available in the plugin directory. It also separately lists installed plugins that haven&#8217;t been updated in two years or more.</p>\n<p><img /></p>\n<p>The check is performed using the plugin directory&#8217;s folder name. The author notes that this could lead to plugins that have never been in the plugin directory to be flagged if they use the same name as a plugin that was in the directory in the past. If you encounter this situation, you&#8217;re encouraged to create a new thread on the <a href=\"https://wordpress.org/support/plugin/no-longer-in-directory\">plugin&#8217;s support forum</a>.</p>\n<p>So far, No Longer in Directory is actively installed on more than 1K sites. Out of a total of <a href=\"https://wordpress.org/support/plugin/no-longer-in-directory/reviews/\">six reviews</a>, its average rating is 4.8 out of 5 stars. I tested the plugin with WordPress 4.8 alpha and didn&#8217;t encounter any issues.</p>\n<p>If this is a feature you&#8217;d like to see implemented in WordPress, consider <a href=\"https://wordpress.org/ideas/topic/alert-when-installed-plugins-have-been-removed-from-the-plugin-directory\">voting for it</a>. So far, the idea has 43 votes with a five-star average rating. <a href=\"https://profiles.wordpress.org/ipstenu\">Mika Epstein</a>, Plugin Directory Representative, <a href=\"https://wordpress.org/ideas/topic/alert-when-installed-plugins-have-been-removed-from-the-plugin-directory#post-22481\">responded to the idea</a> four years ago noting that it was being worked on.</p>\n<p>As Epstein mentioned in our previous article, explaining WHY a plugin has been closed is complex.</p>\n<p>“Obviously the last thing we want are people getting hacked, but it presents us with a few options and they all have flaws,&#8221; she said.</p>\n<p>&#8220;We’ve not been able to determine a way to tell people ‘This plugin is gone, don’t use it’ and ‘This plugin is gone, but use it if you want.’ without putting users at risk.”</p>\n<h2>If a Plugin Is Permanently Removed From the Directory, Users Should Be Notified</h2>\n<p>I believe users should be informed if a plugin is permanently removed from the directory. It doesn&#8217;t make sense to notify users if it&#8217;s temporarily hidden due to violating a guideline or a security issue. Plus, between upgrade and admin notices, users are receiving enough notifications as it is.</p>\n<p>I&#8217;m unsure if the notification should be an admin notice as we&#8217;ve <a href=\"https://wptavern.com/please-stop-abusing-wordpress-admin-notices\">already documented</a> how plugin authors are using them to advertise. Users are increasingly getting annoyed by them and they&#8217;re usefulness is in decline.</p>\n<p>There&#8217;s also the question as to who is responsible for informing users. This responsibility should fall squarely on the plugin author. If I was a plugin author and not interested in someone <a href=\"https://wptavern.com/adopt-me-plugin-tag-is-now-in-use-on-wordpress-org\">adopting my plugin</a> and wanted it removed from the directory, I&#8217;d do so by pushing out one last update.</p>\n<p>I&#8217;d explain in the plugin&#8217;s description and changelog that support and updates would no longer occur and that users should seek alternatives. I might even suggest a few that come to mind. Then, after about a month, I&#8217;d submit a request to the plugin review team to permanently remove it.</p>\n<p>This would give users a heads up and plenty of time to seek out an alternative. The Post Template plugin is a good example of this idea in action. Here is the notice it displayed on all of its settings pages before it disappeared.</p>\n<blockquote><p><strong>Since version 4.0.0, the plugin has been released under a commercial license. New features such as addition of custom fields to the templates have been added. Furthermore, this version is discontinued, which means that no further bug fixes, new features and compatibility fixes for new WordPress versions will be implemented. If you want to buy the latest version of Post Template, please visit the plugin web page.</strong></p></blockquote>\n<p>By notifying users ahead of time, the responsibility shifts to the user to find an alternative.</p>\n<p><a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/page/2/#post-8726059\">Simpon </a>said he&#8217;ll work to get the plugin re-listed but it may take some time as he&#8217;s swamped with work. At the time of publishing, <a href=\"https://wordpress.org/plugins/contact-form-7-to-database-extension/\">the plugin</a> is not available on WordPress.org.</p>\n<h2>An Unfortunate Situation for Users of Contact Form DB</h2>\n<p>While <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/page/2/\">users sympathized</a> with Simpson over his decision, I think it&#8217;s partly irresponsible. If a plugin has a security vulnerability, patching it and making it available as soon as possible should take precedence over how one feels about a situation.</p>\n<p>Instead of putting aside differences and pushing out an update to patch a security vulnerability, Simpson chose to move the plugin and the patched version to GitHub. The decision not to work with the plugin review team has put thousands of sites at risk with no easy way for users to update.</p>\n<p>Hopefully, Simpson will work with the team to get a patched version of Contact Form DB back onto the directory as soon as possible. Until then, if you use Contact Form DB, please <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">update to 2.10.30</a> manually as it patches the security vulnerability.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Feb 2017 08:52:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: WPWeekly Episode 263 – Plugins Disappearing, WordCamp Miami, and OSTraining\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=66103&preview=true&preview_id=66103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/wpweekly-episode-263-plugins-disappearing-wordcamp-miami-and-ostraining\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3129:\"<p>In this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I discuss the news making headlines including, WordCamp Miami in its 9th year, OSTraining partnering with GoDaddy to release training videos, and why plugins sometimes disappear from the WordPress plugin directory. We also provide an update on the REST API vulnerability that is actively being exploited to deface webpages.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-exploits-continue\">WordPress REST API Vulnerability Exploits Continue</a><br />\n<a href=\"https://wptavern.com/google-changes-the-wording-of-its-wordpress-update-notifications\">Google Webmaster Tools Fixes Confusing Messages About Updating WordPress</a><br />\n<a href=\"https://wptavern.com/wordcamp-miami-2017-to-host-javascript-track-ama-spots-and-2-day-kids-camp\">WordCamp Miami 2017 to Host JavaScript Track, AMA Spots, and 2-Day Kids’ Camp</a><br />\n<a href=\"https://wptavern.com/ostraining-partners-with-godaddy-to-launch-free-wordpress-beginner-course-on-youtube\">OSTraining Partners with GoDaddy to Launch Free WordPress Beginner Course on YouTube</a><br />\n<a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">Why Plugins Sometimes Disappear From the WordPress Plugin Directory</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/mobile-featured-image/\">Mobile Featured Image</a> allows users to add a featured image specifically for mobile devices. The new image can be a resized version of your featured image or an entirely new image targeted especially at mobile viewers.</p>\n<p><a href=\"https://wordpress.org/plugins/fb-messenger-bot/\">FB Messenger Bot for WooCommerce</a> automatically messages clients from your Facebook page, WooCommerce, or Gravity Forms. The plugin creates a &#8216;send to Facebook&#8217; button at the end of the WooCommerce Sales process or on the Gravity Forms thank you page.</p>\n<p><a href=\"https://wordpress.org/plugins/restrict-new-users-by-domain/\">Restrict New Users by Domain </a>makes it easy to whitelist or blacklist email domains that new users can use when registering. If using the whitelist, only new users who enter an email domain on the whitelist will be allowed to create an account. If using the blacklist, a user who enters an email domain on the blacklist will be unable to register.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, February 22nd 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #263:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Feb 2017 23:01:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Post Status: LoopConf in review\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://poststatus.com/?post_type=poststatus_notes&p=33889\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/loopconf/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46039:\"<p><a href=\"https://loopconf.com/\">LoopConf</a> is a developer centric conference, and LoopConf &#8220;2.1&#8221; took place in Salt Lake City in early February. This second iteration of the event was a great one, with informative, diverse talks, a laid back atmosphere, and it was very well organized &#8212; which is especially impressive considering the challenges that mother nature caused. As an added bonus, you can now <a href=\"https://www.youtube.com/playlist?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">watch all the talks for free</a>.</p>\n<p>Originally planned for Miami last year, LoopConf was postponed due to a hurricane in southern Florida &#8212; hence the &#8220;.1&#8221; above &#8212; and rescheduled closer to organizer Ryan Sullivan&#8217;s home in Salt Lake City. Despite the postponement, most attendees were still able to make it, and some folks (like me) could only go to the newly scheduled event.</p>\n<p>Salt Lake City was unseasonably warm, making it a pleasant few days, mixed with great food and company. It was also a pleasure to be able to meet more people from local companies, including the newly minted BlueHost and MOJO headquarters downtown.</p>\n<p>Post Status was at LoopConf as a media partner, and <a href=\"https://poststatus.com/profiles/brian-richards/\">Brian Richards</a> and I took a lot of pictures, as well as several video interviews.</p>\n<h3>What to know about LoopConf</h3>\n<p>In our first video interview, Ryan talked about the origins of LoopConf, and described what he hoped attendees would get out of the event:</p>\n<p></p>\n<p>I hope to see a future LoopConf 3, and I think the venue and atmosphere worked really well in Salt Lake City.</p>\n<h3>A small sampling of valuable talks</h3>\n<p>There were many great talks. I didn&#8217;t attend them all, as I was working on other stuff for much of the two days, but the feedback was pretty universally positive, and every talk I did attend, I found valuable.</p>\n<h4>The competitive landscape for WordPress</h4>\n<p><img /></p>\n<p>The first day kicked off with a great talk by Pantheon co-founder Josh Koenig, who spoke on the <a href=\"https://youtu.be/BsKkFf4vDyw?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">competitive landscape for WordPress</a>, including opportunities and risks. It was a really excellent start to the event.</p>\n<h4>Empathetic communication</h4>\n<p><img /></p>\n<p>I met Sharon Steed prior to her talk, and she spoke about <a href=\"https://www.youtube.com/watch?v=Ke9hfBKebxc\">empathetic communication</a>. And due to her own journey as a communicator, going through life with a stutter, it has impacted how she thinks about communication and how she advises her clients.</p>\n<p>There were two quotes I loved: &#8220;Technology cannot replace the social aspect of face-to-face communication.&#8221; And, &#8220;Silence kills collaboration.&#8221; I think greater empathy in our ecosystem and society in general is pivotal.</p>\n<h3>Put an &#8220;S&#8221; on it</h3>\n<p><img /></p>\n<p>I don&#8217;t know anyone who knows more about HTTPS than Zack Tollman, who directed the effort to make WIRED&#8217;s website fully HTTPS. They learned many lessons, and he <a href=\"https://youtu.be/McAzEj2iXaA?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">shares them in his outstanding talk</a>.</p>\n<h4>Bootstrapping a WordPress business</h4>\n<p><img /></p>\n<p>The <a href=\"https://poststatus.com/jason-cohen-wp-engine-founder/\">most recent podcast</a> episode featured a video interview and extended audio interview with <a href=\"https://wpengine.com\">WP Engine</a> founder and LoopConf keynote speaker Jason Cohen, which I highly recommend you check out. Jason is full of knowledge, and my interview with him pairs well with his keynote talk.</p>\n<p>Jason&#8217;s talk will certainly get you thinking about whether you should raise your prices, that&#8217;s for sure.</p>\n<h4>Watch them all!</h4>\n<p>Don&#8217;t take my word for which talks to see. I just feature these because I got a lot out of them in the moment. However, in general I found this lineup to be one of the most proficient groups of speakers I&#8217;ve seen yet at a WordPress event.</p>\n<p>Check out <a href=\"https://www.youtube.com/playlist?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">the whole playlist</a>.</p>\n<h3>Pictures</h3>\n<p>Here are pictures from the three days of workshops and talks.</p>\n\n<a href=\"https://poststatus.com/loopconf/loopconf2-0004/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0004-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0008/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0008-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0011/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0011-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0017/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0017-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0018/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0018-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0019/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0019-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0021/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0021-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0028/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0028-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0033/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0033-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0036/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0036-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0039/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0039-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0051/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0051-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0052/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0052-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0053/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0053-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0056/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0056-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0057/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0057-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0062/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0062-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0063/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0063-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0068/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0068-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0075/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0075-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0077/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0077-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0079/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0079-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0086/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0086-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0087/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0087-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0088/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0088-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0091/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0091-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0115/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0115-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0129/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0129-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0135/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0135-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0136/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0136-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0146/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0146-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0149/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0149-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1735/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1735-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1746/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1746-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1757/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1757-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1775/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1775-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1778/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1778-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1795/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1795-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1808/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1808-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1809/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1809-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1812/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1812-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1818/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1818-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1819/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1819-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1824/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1824-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1826/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1826-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1831/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1831-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1836/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1836-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1841/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1841-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1854/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1854-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1856/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1856-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1862/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1862-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1868/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1868-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1894/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1894-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1897/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1897-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1911/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1911-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1921/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1921-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1928/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1928-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1936/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1936-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1937/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1937-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1954/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1954-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1968/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1968-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1978/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1978-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1979/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1979-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1983/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1983-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1986/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1986-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1991/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1991-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1996/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1996-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2005/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2005-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2015/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2015-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2030/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2030-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2042/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2042-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2043/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2043-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2049/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2049-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2062/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2062-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2079/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2079-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2080/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2080-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2093/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2093-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2103/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2103-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2106/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2106-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2119/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2119-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2151/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2151-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2163/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2163-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2172/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2172-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2180/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2180-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2194/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2194-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2215/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2215-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2240/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2240-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2253/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2253-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2290/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2290-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2291/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2291-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2293/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2293-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2311/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2311-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2330/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2330-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2334/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2334-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2370/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2370-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2377/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2377-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2380/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2380-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2390/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2390-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2413/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2413-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2447/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2447-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2466/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2466-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2487/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2487-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2511/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2511-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2515/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2515-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2517/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2517-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2521/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2521-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2528/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2528-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2531/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2531-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2532/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2532-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2533/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2533-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2536/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2536-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2538/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2538-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2541/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2541-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2542/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2542-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2546/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2546-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2561/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2561-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2570/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2570-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2590/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2590-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2597/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2597-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2599/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2599-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2615/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2615-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2617/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2617-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2652/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2652-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9825/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9825-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9826/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9826-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9828/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9828-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9830/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9830-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9831/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9831-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9833/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9833-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9835/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9835-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9837/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9837-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9839/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9839-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9846/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9846-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9848/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9848-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9850/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9850-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9851/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9851-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9859/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9859-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9863/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9863-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9866/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9866-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9868/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9868-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9876/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9876-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9879/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9879-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9885/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9885-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9887/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9887-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9888/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9888-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9892/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9892-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9895/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9895-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9904/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9904-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9905/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9905-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9911/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9911-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9914/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9914-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9929/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9929-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9933/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9933-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loop